/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.configuration;

import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.ssaglobal.bdeserver.configuration.ConfigurationException;

public class ServerConfiguration {
    private BusComponentConfiguration m_config;

    public static ServerConfiguration getServerConfiguration(String string) throws ConfigurationException {
        try {
            return new ServerConfiguration(string);
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new ConfigurationException(oWConfigurationException.getMessage());
        }
    }

    public String getEnvironmentControlLibrary() throws ConfigurationException {
        return this.getString("erplx_env_ctrl_lib");
    }

    public String getWebTopURI() throws ConfigurationException {
        return this.getString("erplx_webtop_uri");
    }

    public String getScreenScrapingEngineClasspath() throws ConfigurationException {
        return this.getString("erplx_xmg_classpath");
    }

    public String getWMSSystemId() throws ConfigurationException {
        return this.getString("wms_system_id");
    }

    public int getEventsPollingFrequency() throws ConfigurationException {
        return this.getInt("events_polling_frequency");
    }

    public String getJDBCDriverName() throws ConfigurationException {
        return this.getString("jdbc_driver_name");
    }

    public String getJDBCDatabaseURL() throws ConfigurationException {
        return this.getString("jdbc_database_url");
    }

    public String getJDBCUser() throws ConfigurationException {
        return this.getString("jdbc_user");
    }

    public String getJDBCPassword() throws ConfigurationException {
        return this.getString("jdbc_password");
    }

    public String getErrorHandlerBusComponent() throws ConfigurationException {
        return this.getString("error_handler_buscomponent");
    }

    public String getPersistentQueuePath() throws ConfigurationException {
        return this.getString("persistent_queue_path");
    }

    public int getCompanyNumber() throws ConfigurationException {
        return this.m_config.getCompanyNumber();
    }

    private ServerConfiguration() {
    }

    private ServerConfiguration(String string) throws OWConfigurationException {
        BusComponentContext busComponentContext = BusComponentContext.getInstance();
        this.m_config = new BusComponentConfiguration(busComponentContext, string);
    }

    private String getString(String string) throws ConfigurationException {
        String string2 = this.m_config.getValue(string);
        if (string2 == null || string2.length() == 0) {
            throw new ConfigurationException("property " + string + " (string) not set in BusComponent");
        }
        return string2;
    }

    private int getInt(String string) throws ConfigurationException {
        try {
            return Integer.parseInt(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("property " + string + " (int) not set in BusComponent");
        }
    }
}

