/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.baanerp;

import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.ssaglobal.bdeserver.IReceiverControlListener;
import com.ssaglobal.bdeserver.baanerp.SynchCallToBaan;

public class ControlListener
implements IReceiverControlListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeserver.baanerp", "ControlListener");
    private static final String LOG_PREFIX = "BDE BaanERP ControlListener: ";
    private IBaanVM m_baanVM;
    private SynchCallToBaan m_BaanConnection = null;
    private static final String REPLY_OK = "+";

    public ControlListener(SynchCallToBaan synchCallToBaan) {
        this.m_BaanConnection = synchCallToBaan;
        try {
            this.m_baanVM = BucketUtils.getBaanVMInterface();
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to use Baan JVM integration: " + exception);
        }
    }

    public boolean onClose() {
        s_logger.message("BDE BaanERP ControlListener: onClose called");
        s_logger.message("BDE BaanERP ControlListener: Send ControlRequest 'deactivate' to BaanERP on queue ");
        IBucket iBucket = this.m_BaanConnection.makeCall(this.m_baanVM.createBucket("deactivate", "ControlRequest"));
        s_logger.message("BDE BaanERP ControlListener: Received Answer from BaanERP");
        String string = iBucket.toString();
        String string2 = iBucket.getHeader();
        if (string2.startsWith(REPLY_OK)) {
            s_logger.flowMessage("BDE BaanERP ControlListener: Baan ERP returned OK on deactivate");
            return true;
        }
        s_logger.flowMessage("BDE BaanERP ControlListener: Baan ERP returned not OK on deactivate");
        return false;
    }
}

