/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.baanerp;

import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BaanVMNotInstalledException;
import com.eibus.baanC.BucketUtils;
import com.ssaglobal.bdeserver.LicenseException;
import com.ssaglobal.bdeserver.ReceiverException;
import com.ssaglobal.bdeserver.baanerp.AuthenticationListener;
import com.ssaglobal.bdeserver.baanerp.ControlListener;
import com.ssaglobal.bdeserver.baanerp.Receiver;
import com.ssaglobal.bdeserver.baanerp.StringListener;
import com.ssaglobal.bdeserver.baanerp.SynchCallToBaan;
import com.ssaglobal.bdeserver.configuration.ConfigurationException;
import com.ssaglobal.bdeserver.configuration.ServerConfiguration;
import java.util.StringTokenizer;

public class BucketListener
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeserver.baanerp", "BucketListener");
    private static final String LOG_PREFIX = "BDE BaanERP Listener: ";
    private static final String SEPARATOR = ";";
    private static final String REPLY_OK = "+";
    private static final String REPLY_ERROR = "-;";
    private static final String METHOD_CREATE_RECEIVER = "createReceiver";
    private static final String METHOD_START = "start";
    private static final String METHOD_START_AND_GIVE_REF = "startAndGiveReference";
    private static final String METHOD_STOP = "stop";
    private static final String METHOD_GET_COMPANY_NUMBER = "getCompanyNumber";
    private int m_iToJava;
    private int m_iToBaan;
    private Receiver m_receiver = null;

    public BucketListener(int n, int n2) {
        this.m_iToJava = n;
        this.m_iToBaan = n2;
    }

    public void onReceive(IBucket iBucket) {
        s_logger.flowMessage(LOG_PREFIX + iBucket);
        try {
            Object object;
            String string;
            block18: {
                String string2 = iBucket.getHeader();
                String string3 = iBucket.toString();
                s_logger.flowMessage("BDE BaanERP Listener: message from BaanERP, '" + string2 + "', '" + string3 + "'");
                string = null;
                try {
                    if (string2 == null) break block18;
                    if (METHOD_CREATE_RECEIVER.equals(string2)) {
                        object = new StringTokenizer(string3, SEPARATOR);
                        String string4 = (String)((StringTokenizer)object).nextElement();
                        String string5 = (String)((StringTokenizer)object).nextElement();
                        String string6 = (String)((StringTokenizer)object).nextElement();
                        String string7 = (String)((StringTokenizer)object).nextElement();
                        int n = Integer.parseInt(string5);
                        int n2 = Integer.parseInt(string6);
                        int n3 = Integer.parseInt(string7);
                        string = this.createReceiver(string4, n, n2, n3);
                        break block18;
                    }
                    if (METHOD_START.equals(string2)) {
                        int n = -1;
                        try {
                            n = Integer.parseInt(string3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        string = this.start(n);
                        break block18;
                    }
                    if (METHOD_STOP.equals(string2)) {
                        string = this.stop();
                    } else if (METHOD_START_AND_GIVE_REF.equals(string2)) {
                        string = this.startAndGiveReference();
                    } else if (METHOD_GET_COMPANY_NUMBER.equals(string2)) {
                        String string8 = string3;
                        string = this.getCompanyNumber(string8);
                    } else {
                        string = "-;unknown message from 3GL, '" + string2 + "'";
                    }
                }
                catch (Exception exception) {
                    string = REPLY_ERROR + exception.toString();
                }
            }
            if (string.startsWith(REPLY_ERROR)) {
                s_logger.errorMessage("Returning Error to BaanERP '" + string + "'");
            } else {
                s_logger.message("Returning to BaanERP '" + string + "'");
            }
            try {
                object = BucketUtils.getBaanVMInterface();
                object.putBucket(this.m_iToBaan, object.createBucket(string));
            }
            catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                s_logger.errorMessage(LOG_PREFIX + baanVMNotInstalledException.toString());
            }
        }
        catch (Throwable throwable) {
            String string = "Unexpected error while processing call from BaanERP; " + throwable.toString();
            s_logger.errorMessage(LOG_PREFIX + string);
        }
    }

    public String createReceiver(String string, int n, int n2, int n3) {
        try {
            SynchCallToBaan synchCallToBaan = new SynchCallToBaan(n2, n3);
            StringListener stringListener = new StringListener(synchCallToBaan);
            this.m_receiver = new Receiver(stringListener, string);
            this.m_receiver.setControlListener(new ControlListener(synchCallToBaan));
            this.m_receiver.setAuthenticationListener(new AuthenticationListener(synchCallToBaan));
            this.m_receiver.setLicenseId(n, true);
            return REPLY_OK;
        }
        catch (LicenseException licenseException) {
            return REPLY_ERROR + licenseException.getMessage();
        }
        catch (ReceiverException receiverException) {
            return REPLY_ERROR + receiverException.getMessage();
        }
        catch (Exception exception) {
            return REPLY_ERROR + exception.getMessage();
        }
    }

    public String startAndGiveReference() {
        String string = this.m_receiver.startAndGiveReference();
        return string;
    }

    public String start(int n) {
        try {
            if (n > 0) {
                this.m_receiver.setActivationCallbackPortNr(n);
            }
            this.m_receiver.start();
            return REPLY_OK;
        }
        catch (ReceiverException receiverException) {
            return REPLY_ERROR + receiverException.getMessage();
        }
    }

    public String stop() {
        this.m_receiver.stop();
        return REPLY_OK;
    }

    public String getCompanyNumber(String string) {
        try {
            s_logger.flowMessage("BDE BaanERP Listener: Getting CompanyNumber from BusComponent '" + string + "'");
            ServerConfiguration serverConfiguration = ServerConfiguration.getServerConfiguration(string);
            int n = serverConfiguration.getCompanyNumber();
            return "+;" + n;
        }
        catch (ConfigurationException configurationException) {
            return REPLY_ERROR + configurationException.getMessage();
        }
    }

    static {
        LoggerFactory.setApplicationName("BaanERP_BDE_SERVER");
    }
}

