/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.baanerp;

import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.ssaglobal.bdeserver.IAuthenticationListener;
import com.ssaglobal.bdeserver.baanerp.SynchCallToBaan;

public class AuthenticationListener
implements IAuthenticationListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeserver.baanerp", "AuthenticationListener");
    private static final String LOG_PREFIX = "BDE BaanERP AuthenticationListener: ";
    private static final String REPLY_OK = "+";
    private IBaanVM m_baanVM;
    private SynchCallToBaan m_BaanConnection = null;

    public AuthenticationListener(SynchCallToBaan synchCallToBaan) {
        this.m_BaanConnection = synchCallToBaan;
        try {
            this.m_baanVM = BucketUtils.getBaanVMInterface();
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to use Baan JVM integration: " + exception);
        }
    }

    public boolean checkUserNameAndPassword(String string, String string2) {
        s_logger.message("BDE BaanERP AuthenticationListener: checkUserNameAndPassword called");
        s_logger.message("BDE BaanERP AuthenticationListener: Send CheckRequest for user '" + string + "' to BaanERP");
        IBucket iBucket = this.m_BaanConnection.makeCall(this.m_baanVM.createBucket(string + ";" + string2, "AuthenticationRequest"));
        s_logger.message("BDE BaanERP AuthenticationListener: Received Answer from BaanERP");
        String string3 = iBucket.toString();
        String string4 = iBucket.getHeader();
        if (string4.startsWith(REPLY_OK)) {
            s_logger.flowMessage("BDE BaanERP AuthenticationListener: Baan ERP returned OK on AuthenticationRequest");
            return true;
        }
        s_logger.flowMessage("BDE BaanERP AuthenticationListener: Baan ERP returned not OK on AuthenticationRequest");
        return false;
    }
}

