/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.java;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateParser {
    private static boolean check(StringTokenizer stringTokenizer, String string) throws Exception {
        try {
            if (stringTokenizer.nextToken().equals(string)) {
                return true;
            }
            throw new Exception("Missing [" + string + "]");
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Calendar getCalendar(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-T:.+Z", true);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.clear();
        try {
            int n;
            int n2;
            if (!stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(1, n3);
            if (!DateParser.check(stringTokenizer, "-") || !stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
            gregorianCalendar.set(2, n3);
            if (!DateParser.check(stringTokenizer, "-") || !stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(5, n3);
            if (!DateParser.check(stringTokenizer, "T") || !stringTokenizer.hasMoreTokens()) {
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(11, n3);
            if (!DateParser.check(stringTokenizer, ":") || !stringTokenizer.hasMoreTokens()) {
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(12, n3);
            if (!stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(":")) {
                if (!stringTokenizer.hasMoreTokens()) throw new Exception("No secondes specified");
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                gregorianCalendar.set(13, n2);
                if (!stringTokenizer.hasMoreTokens()) {
                    return gregorianCalendar;
                }
                string2 = stringTokenizer.nextToken();
                if (string2.equals(".")) {
                    String string3 = stringTokenizer.nextToken();
                    while (string3.length() < 3) {
                        string3 = string3 + '0';
                    }
                    string3 = string3.substring(0, 3);
                    n = Integer.parseInt(string3);
                    gregorianCalendar.set(14, n);
                    if (!stringTokenizer.hasMoreTokens()) {
                        return gregorianCalendar;
                    }
                    string2 = stringTokenizer.nextToken();
                } else {
                    gregorianCalendar.set(14, 0);
                }
            } else {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
            }
            if (string2.equals("Z")) return gregorianCalendar;
            if (!string2.equals("+") && !string2.equals("-")) {
                throw new Exception("only Z, + or - allowed");
            }
            n2 = string2.equals("+") ? 1 : 0;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new Exception("Missing hour field");
            }
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            n = 0;
            if (!DateParser.check(stringTokenizer, ":") || !stringTokenizer.hasMoreTokens()) {
                throw new Exception("Missing minute field");
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 != 0) {
                ((Calendar)gregorianCalendar).add(10, n4);
                ((Calendar)gregorianCalendar).add(12, n);
                return gregorianCalendar;
            } else {
                ((Calendar)gregorianCalendar).add(10, -n4);
                ((Calendar)gregorianCalendar).add(12, -n);
            }
            return gregorianCalendar;
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("[" + numberFormatException.getMessage() + "] is not an integer");
        }
    }

    public static Date parse(String string) throws Exception {
        Calendar calendar = DateParser.getCalendar(string);
        return calendar.getTime();
    }

    private static String twoDigit(int n) {
        if (n >= 0 && n < 10) {
            return "0" + String.valueOf(n);
        }
        return String.valueOf(n);
    }

    public static String getIsoDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append("-");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(2) + 1));
        stringBuffer.append("-");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(5)));
        stringBuffer.append("T");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(11)));
        stringBuffer.append(":");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(12)));
        stringBuffer.append(":");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(13)));
        stringBuffer.append(".");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(14) / 10));
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }

    public static String getIsoDateNoMillis(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append("-");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(2) + 1));
        stringBuffer.append("-");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(5)));
        stringBuffer.append("T");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(11)));
        stringBuffer.append(":");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(12)));
        stringBuffer.append(":");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(13)));
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }
}

