/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.java;

import com.ssaglobal.bde.BdeException;
import com.ssaglobal.bde.Date;
import com.ssaglobal.bde.DateTime;
import com.ssaglobal.bde.Time;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeProxy;
import com.ssaglobal.bdeimpl.java.BdeIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Vector;

public abstract class BusinessDataEntity {
    protected static String TYPE_BOOLEAN = "boolean";
    protected static String TYPE_BYTE = "byte";
    protected static String TYPE_SHORT = "short";
    protected static String TYPE_INT = "int";
    protected static String TYPE_LONG = "long";
    protected static String TYPE_FLOAT = "float";
    protected static String TYPE_DOUBLE = "double";
    protected static String TYPE_INTEGER = "integer";
    protected static String TYPE_DECIMAL = "decimal";
    protected static String TYPE_STRING = "string";
    protected static String TYPE_DATETIME = "dateTime";
    protected static String TYPE_BASE64BINARY = "base64Binary";
    protected static String TYPE_HEXBINARY = "hexBinary";
    protected static String TYPE_DURATION = "duration";
    protected static String TYPE_TIME = "time";
    protected static String TYPE_DATE = "date";
    protected static String TYPE_GYEARMONTH = "gYearMonth";
    protected static String TYPE_GYEAR = "gYear";
    protected static String TYPE_GMONTHDAY = "gMonthDay";
    protected static String TYPE_GDAY = "gDay";
    protected static String TYPE_GMONTH = "gMonth";
    protected static String TYPE_ANYURI = "anyURI";
    protected static String TYPE_NOTATION = "NOTATION";
    protected static String TYPE_TOKEN = "token";
    protected static String TYPE_NORMALIZEDSTRING = "normalizedString";
    protected static String TYPE_LANGUAGE = "language";
    protected static String TYPE_NAME = "Name";
    protected static String TYPE_NMTOKEN = "NMTOKEN";
    protected static String TYPE_NCNAME = "NCName";
    protected static String TYPE_NMTOKENS = "NMTOKENS";
    protected static String TYPE_ID = "ID";
    protected static String TYPE_IDREF = "IDREF";
    protected static String TYPE_ENTITY = "ENTITY";
    protected static String TYPE_IDREFS = "IDREFS";
    protected static String TYPE_ENTITIES = "ENTITIES";
    protected static String TYPE_NONPOSITIVEINTEGER = "nonPositiveInteger";
    protected static String TYPE_NONNEGATIVEINTEGER = "nonNegativeInteger";
    protected static String TYPE_NEGATIVEINTEGER = "negativeInteger";
    protected static String TYPE_UNSIGNESLONG = "unsignedLong";
    protected static String TYPE_POSITIVEINTEGER = "positiveInteger";
    protected static String TYPE_UNSIGNESINT = "unsignedInt";
    protected static String TYPE_UNSIGNEDSHORT = "unsignedShort";
    protected static String TYPE_UNSIGNEDBYTE = "unsignedByte";
    protected static String TYPE_QNAME = "Qname";
    protected static String TYPE_CHAR = "char";
    protected static String TYPE_TEXT = "text";
    protected static String TYPE_COMPONENT = "comp";
    protected static String TYPE_COMPLEX = "complex";
    protected static String TYPE_GROUP = "group";
    protected static final int ITEM_NAME = 0;
    private static final int ITEM_TYPE = 1;
    private static final int ITEM_FACET_START = 2;
    private BdeProxy m_impl;

    protected BusinessDataEntity(String string) {
        this.m_impl = new BdeProxy(string);
    }

    public String toString() {
        return this.m_impl.toString();
    }

    protected boolean getBooleanValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        return new Boolean(string);
    }

    protected byte getByteValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("Byte(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected short getShortValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("Short(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected int getIntValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("Float(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected long getLongValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("Long(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected double getDoubleValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("Double(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected float getFloatValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("Float(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected BigInteger getBigIntegerValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("BigInteger(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected BigDecimal getBigDecimalValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.logAndCreateBdeException("BigDecimal(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected char getCharValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        try {
            return string.charAt(0);
        }
        catch (Exception exception) {
            throw this.logAndCreateBdeException("Char(" + string + ") parsing error, for meta index " + n);
        }
    }

    protected String getStringValue(int n) throws BdeException {
        try {
            return this.m_impl.getValue(this.getMetaData(n, 0));
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected String getTextValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        return string;
    }

    protected Date getDateValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        return Date.valueOf(string);
    }

    protected Time getTimeValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        return Time.valueOf(string);
    }

    protected DateTime getDateTimeValue(int n) throws BdeException {
        String string = this.getStringValue(n);
        return DateTime.valueOf(string);
    }

    protected void setBooleanValue(int n, boolean bl) throws BdeException {
        this.setStringValue(n, "" + bl);
    }

    protected void setByteValue(int n, byte by) throws BdeException {
        this.setStringValue(n, "" + by);
    }

    protected void setShortValue(int n, short s) throws BdeException {
        this.setStringValue(n, "" + s);
    }

    protected void setIntValue(int n, int n2) throws BdeException {
        this.setStringValue(n, "" + n2);
    }

    protected void setLongValue(int n, long l) throws BdeException {
        this.setStringValue(n, "" + l);
    }

    protected void setDoubleValue(int n, double d) throws BdeException {
        this.setStringValue(n, "" + d);
    }

    protected void setFloatValue(int n, float f) throws BdeException {
        this.setStringValue(n, "" + f);
    }

    protected void setBigIntegerValue(int n, BigInteger bigInteger) throws BdeException {
        this.setStringValue(n, bigInteger == null ? "" : bigInteger.toString());
    }

    protected void setBigDecimalValue(int n, BigDecimal bigDecimal) throws BdeException {
        this.setStringValue(n, bigDecimal == null ? "" : bigDecimal.toString());
    }

    protected void setCharValue(int n, char c) throws BdeException {
        this.setStringValue(n, "" + c);
    }

    protected void setTextValue(int n, String string) throws BdeException {
        this.setStringValue(n, string);
    }

    protected void setStringValue(int n, String string) throws BdeException {
        String string2 = this.getMetaData(n, 0);
        Object[] objectArray = null;
        try {
            String string3 = null;
            int n2 = 2;
            string3 = this.getMetaData(n, n2++);
            if (string3 != null) {
                Vector<String> vector = null;
                vector = new Vector<String>();
                while (string3 != null) {
                    vector.addElement(string3);
                    string3 = this.getMetaData(n, n2++);
                }
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.m_impl.setValue(string2, this.getMetaData(n, 1), (String[])objectArray, string);
            }
            this.m_impl.setValue(string2, string);
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected void setDateValue(int n, Date date) throws BdeException {
        this.setStringValue(n, date.toString());
    }

    protected void setTimeValue(int n, Time time) throws BdeException {
        this.setStringValue(n, time.toString());
    }

    protected void setDateTimeValue(int n, DateTime dateTime) throws BdeException {
        this.setStringValue(n, dateTime.toString());
    }

    protected void addStringValue(int n, String string) {
        String string2 = this.getMetaData(n, 0);
        this.m_impl.addValue(string2, string);
    }

    protected boolean hasValue(int n) {
        return this.m_impl.hasValue(this.getMetaData(n, 0));
    }

    protected void unsetValue(int n) {
        this.m_impl.unSetValue(this.getMetaData(n, 0));
    }

    protected void getComplexValue(int n, BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            BdeProxy bdeProxy = this.m_impl.getComplexValue(this.getMetaData(n, 0));
            businessDataEntity.setImpl(bdeProxy);
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected void setComplexValue(int n, BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            BdeProxy bdeProxy = businessDataEntity.getImpl();
            this.m_impl.setComplexValue(this.getMetaData(n, 0), bdeProxy);
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected BdeIterator listComponents(int n) {
        BdeIterator bdeIterator = this._createComponentIterator(n);
        bdeIterator.setImpl(this.m_impl.listComponents(this.getMetaData(n, 0)));
        return bdeIterator;
    }

    protected boolean hasComponent(int n) {
        return this.m_impl.hasComponent(this.getMetaData(n, 0));
    }

    protected void getComponent(int n, BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            BdeProxy bdeProxy = this.m_impl.getComponent(this.getMetaData(n, 0));
            businessDataEntity.setImpl(bdeProxy);
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected String getComponentAsString(int n) throws BdeException {
        try {
            return this.m_impl.getComponentAsString(this.getMetaData(n, 0));
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected void createComponent(BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            this.m_impl.createComponent(businessDataEntity.getImpl());
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected void changeComponent(BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            this.m_impl.changeComponent(businessDataEntity.getImpl());
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected void deleteComponent(BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            this.m_impl.deleteComponent(businessDataEntity.getImpl());
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    protected void deleteExistingComponent(BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            this.m_impl.deleteExistingComponent(businessDataEntity.getImpl());
        }
        catch (BdeImplException bdeImplException) {
            throw this.logAndCreateBdeException(bdeImplException.getMessage());
        }
    }

    private BdeException logAndCreateBdeException(String string) {
        BdeProxy.s_logger.errorMessage(string);
        return new BdeException(string);
    }

    void setImpl(BdeProxy bdeProxy) {
        this.m_impl = bdeProxy;
    }

    protected BdeProxy getImpl() {
        return this.m_impl;
    }

    protected abstract String getMetaData(int var1, int var2);

    protected abstract BdeIterator _createComponentIterator(int var1);
}

