/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.java;

import com.baan.b3impl.boi1.UserSession;
import com.ssaglobal.bde.BdeCommunicationException;
import com.ssaglobal.bde.BdeException;
import com.ssaglobal.bde.BdeResultException;
import com.ssaglobal.bde.IBdeFilter;
import com.ssaglobal.bde.IBdeMessageIterator;
import com.ssaglobal.bde.IBdeSelection;
import com.ssaglobal.bdeimpl.generic.BdeFilterImpl;
import com.ssaglobal.bdeimpl.generic.BdeImplCommunicationException;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeImplResultException;
import com.ssaglobal.bdeimpl.generic.BdeProxy;
import com.ssaglobal.bdeimpl.generic.BdeProxyIterator;
import com.ssaglobal.bdeimpl.generic.BdeProxyManager;
import com.ssaglobal.bdeimpl.generic.BdeSelectionImpl;
import com.ssaglobal.bdeimpl.java.BdeFilter;
import com.ssaglobal.bdeimpl.java.BdeIterator;
import com.ssaglobal.bdeimpl.java.BdeMessage;
import com.ssaglobal.bdeimpl.java.BdeMessageIterator;
import com.ssaglobal.bdeimpl.java.BdeSelection;
import com.ssaglobal.bdeimpl.java.BusinessDataEntity;

public abstract class BdeManager {
    public int PROCESSING_SCOPE_REQUEST = 0;
    public int PROCESSING_SCOPE_BDE = 1;
    public int PROCESSING_SCOPE_BDE_COMPONENT = 2;
    public int PROCESSING_SCOPE_NOT_APPLICABLE = 3;
    protected BdeProxyManager m_impl;

    public BdeManager() throws BdeException {
        try {
            this.m_impl = new BdeProxyManager(this._getPrimaryKeys(), this._getBdeName());
        }
        catch (BdeImplCommunicationException bdeImplCommunicationException) {
            throw new BdeException(bdeImplCommunicationException.getMessage());
        }
    }

    public void initialize(String string) throws BdeException {
        try {
            this.m_impl.initialize(string);
        }
        catch (BdeImplCommunicationException bdeImplCommunicationException) {
            throw new BdeException(bdeImplCommunicationException.getMessage());
        }
    }

    public void setTimeOut(long l) {
        this.m_impl.setTimeOut(l);
    }

    public long getTimeOut() {
        return this.m_impl.getTimeOut();
    }

    public int getIteratorFetchSize() {
        return this.m_impl.getIteratorFetchSize();
    }

    public void setIteratorFetchSize(int n) {
        this.m_impl.setIteratorFetchSize(n);
    }

    public void ping() throws BdeException {
        try {
            this.m_impl.ping();
        }
        catch (BdeImplCommunicationException bdeImplCommunicationException) {
            throw new BdeException(bdeImplCommunicationException.getMessage());
        }
    }

    public void close() throws BdeException {
        try {
            this.m_impl.close();
        }
        catch (BdeImplCommunicationException bdeImplCommunicationException) {
            throw new BdeException(bdeImplCommunicationException.getMessage());
        }
    }

    void addToUserSession(UserSession userSession) throws BdeException {
        try {
            this.m_impl.addToUserSession(userSession);
        }
        catch (BdeImplCommunicationException bdeImplCommunicationException) {
            throw new BdeException(bdeImplCommunicationException.getMessage());
        }
    }

    BdeProxyManager getImpl() {
        return this.m_impl;
    }

    public void setSelection(IBdeSelection iBdeSelection) {
        BdeSelectionImpl bdeSelectionImpl = null;
        if (iBdeSelection != null) {
            bdeSelectionImpl = ((BdeSelection)iBdeSelection).getImpl();
        }
        this.m_impl.setSelection(bdeSelectionImpl);
    }

    public void setFilter(IBdeFilter iBdeFilter) {
        BdeFilterImpl bdeFilterImpl = null;
        if (iBdeFilter != null) {
            bdeFilterImpl = ((BdeFilter)iBdeFilter).getImpl();
        }
        this.m_impl.setFilter(bdeFilterImpl);
    }

    public boolean hasInformation() {
        return this.m_impl.hasInformation();
    }

    public void clearInformation() {
        this.m_impl.clearInformation();
    }

    public IBdeMessageIterator getInformation() throws BdeException {
        BdeMessageIterator bdeMessageIterator = new BdeMessageIterator();
        bdeMessageIterator.setImpl(this.m_impl.getInformation());
        return bdeMessageIterator;
    }

    protected BdeIterator list(int n) throws BdeCommunicationException, BdeResultException, BdeException {
        try {
            BdeProxyIterator bdeProxyIterator = new BdeProxyIterator(this.m_impl, n, this._getBdeName());
            BdeIterator bdeIterator = this._createIterator();
            bdeIterator.setImpl(bdeProxyIterator);
            return bdeIterator;
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    protected BusinessDataEntity show(BusinessDataEntity businessDataEntity) throws BdeCommunicationException, BdeResultException, BdeException {
        try {
            BdeProxy bdeProxy = this.m_impl.executeShow(businessDataEntity.getImpl());
            BusinessDataEntity businessDataEntity2 = this._createBde();
            businessDataEntity2.setImpl(bdeProxy);
            return businessDataEntity2;
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    protected void create(BusinessDataEntity businessDataEntity) throws BdeCommunicationException, BdeResultException, BdeException {
        try {
            this.m_impl.executeCreate(businessDataEntity.getImpl());
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    protected void change(BusinessDataEntity businessDataEntity) throws BdeCommunicationException, BdeResultException, BdeException {
        try {
            this.m_impl.executeChange(businessDataEntity.getImpl());
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    protected void delete(BusinessDataEntity businessDataEntity) throws BdeCommunicationException, BdeResultException, BdeException {
        try {
            this.m_impl.executeDelete(businessDataEntity.getImpl());
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    protected void specific(BusinessDataEntity businessDataEntity, String string) throws BdeCommunicationException, BdeResultException, BdeException {
        try {
            this.m_impl.executeSpecific(businessDataEntity.getImpl(), string);
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    private BdeException processBdeImplException(Exception exception) {
        if (exception instanceof BdeImplException) {
            return new BdeException(exception.getMessage());
        }
        if (exception instanceof BdeImplCommunicationException) {
            return new BdeCommunicationException(exception.getMessage());
        }
        if (exception instanceof BdeImplResultException) {
            return BdeMessage.createResultException((BdeImplResultException)exception);
        }
        return new BdeException(exception.getMessage());
    }

    public void setProcessingScope(int n) throws BdeException {
        try {
            this.m_impl.setProcessingScope(n);
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    public boolean supportsProcessingScope(int n) throws BdeException {
        try {
            return this.m_impl.supportsProcessingScope(n);
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    public boolean supportsReferentialIntegrity() throws BdeException {
        try {
            return this.m_impl.supportsReferentialIntegrity();
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    public void automaticReferences(boolean bl) {
        this.m_impl.automaticReferences(bl);
    }

    public void createReference(BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            this.m_impl.createReference(businessDataEntity.getImpl());
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    public void deleteReference(BusinessDataEntity businessDataEntity) throws BdeException {
        try {
            this.m_impl.deleteReference(businessDataEntity.getImpl());
        }
        catch (Exception exception) {
            throw this.processBdeImplException(exception);
        }
    }

    protected abstract BusinessDataEntity _createBde();

    protected abstract BdeIterator _createIterator();

    protected abstract String _getBdeName();

    protected abstract String _getPrimaryKeys();
}

