/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.java;

import com.ssaglobal.bde.IBdeFilter;
import com.ssaglobal.bde.IBdeFilterExpression;
import com.ssaglobal.bdeimpl.generic.BdeFilterImpl;

public class BdeFilter
implements IBdeFilter {
    BdeFilterImpl m_impl;
    private static final String EQUAL = "eq";
    private static final String NOT_EQUAL = "ne";
    private static final String LESS = "lt";
    private static final String LESS_OR_EQUAL = "le";
    private static final String GREATER = "gt";
    private static final String GREATER_OR_EQUAL = "ge";

    public BdeFilter(BdeFilterImpl bdeFilterImpl) {
        this.m_impl = bdeFilterImpl;
    }

    public void setExpression(IBdeFilterExpression iBdeFilterExpression) {
        Expression expression;
        BdeFilterImpl.ExpressionImpl expressionImpl = null;
        if (iBdeFilterExpression instanceof LogicalExpression) {
            expression = (LogicalExpression)iBdeFilterExpression;
            expressionImpl = ((LogicalExpression)expression).getImpl();
        }
        if (iBdeFilterExpression instanceof ComparisonExpression) {
            expression = (ComparisonExpression)iBdeFilterExpression;
            expressionImpl = ((ComparisonExpression)expression).getImpl();
        }
        this.m_impl.setExpression(expressionImpl);
    }

    public IBdeFilterExpression createLogicalExpression(String string, IBdeFilterExpression iBdeFilterExpression, IBdeFilterExpression iBdeFilterExpression2) {
        Expression expression = (Expression)iBdeFilterExpression;
        Expression expression2 = (Expression)iBdeFilterExpression2;
        return new LogicalExpression(this.m_impl.createLogicalExpression(string, expression.getImpl(), expression2.getImpl()));
    }

    public IBdeFilterExpression createComparisonExpression(String string, String string2, String string3) {
        return new ComparisonExpression(this.m_impl.createComparisonExpression(string, string2, string3));
    }

    public IBdeFilterExpression createAttributeComparisonExpression(String string, String string2, String string3) {
        return new AttributeComparisonExpression(this.m_impl.createAttributeComparisonExpression(string, string2, string3));
    }

    public BdeFilterImpl getImpl() {
        return this.m_impl;
    }

    public String toString() {
        return this.m_impl.toString();
    }

    public IBdeFilterExpression createLogicalAnd(IBdeFilterExpression iBdeFilterExpression, IBdeFilterExpression iBdeFilterExpression2) {
        return this.createLogicalExpression("and", iBdeFilterExpression, iBdeFilterExpression2);
    }

    public IBdeFilterExpression createLogicalOr(IBdeFilterExpression iBdeFilterExpression, IBdeFilterExpression iBdeFilterExpression2) {
        return this.createLogicalExpression("or", iBdeFilterExpression, iBdeFilterExpression2);
    }

    public IBdeFilterExpression createComparisonEqual(String string, String string2) {
        return this.createComparisonExpression(EQUAL, string, string2);
    }

    public IBdeFilterExpression createComparisonNotEqual(String string, String string2) {
        return this.createComparisonExpression(NOT_EQUAL, string, string2);
    }

    public IBdeFilterExpression createComparisonLess(String string, String string2) {
        return this.createComparisonExpression(LESS, string, string2);
    }

    public IBdeFilterExpression createComparisonLessOrEqual(String string, String string2) {
        return this.createComparisonExpression(LESS_OR_EQUAL, string, string2);
    }

    public IBdeFilterExpression createComparisonGreater(String string, String string2) {
        return this.createComparisonExpression(GREATER, string, string2);
    }

    public IBdeFilterExpression createComparisonGreaterOrEqual(String string, String string2) {
        return this.createComparisonExpression(GREATER_OR_EQUAL, string, string2);
    }

    public IBdeFilterExpression createAttributeComparisonEqual(String string, String string2) {
        return this.createAttributeComparisonExpression(EQUAL, string, string2);
    }

    public IBdeFilterExpression createAttributeComparisonNotEqual(String string, String string2) {
        return this.createAttributeComparisonExpression(NOT_EQUAL, string, string2);
    }

    public IBdeFilterExpression createAttributeComparisonLess(String string, String string2) {
        return this.createAttributeComparisonExpression(LESS, string, string2);
    }

    public IBdeFilterExpression createAttributeComparisonLessOrEqual(String string, String string2) {
        return this.createAttributeComparisonExpression(LESS_OR_EQUAL, string, string2);
    }

    public IBdeFilterExpression createAttributeComparisonGreater(String string, String string2) {
        return this.createAttributeComparisonExpression(GREATER, string, string2);
    }

    public IBdeFilterExpression createAttributeComparisonGreaterOrEqual(String string, String string2) {
        return this.createAttributeComparisonExpression(GREATER_OR_EQUAL, string, string2);
    }

    public abstract class Expression
    implements IBdeFilterExpression {
        abstract BdeFilterImpl.ExpressionImpl getImpl();
    }

    public class ComparisonExpression
    extends Expression {
        BdeFilterImpl.ComparisonExpressionImpl m_impl;

        public ComparisonExpression(BdeFilterImpl.ComparisonExpressionImpl comparisonExpressionImpl) {
            this.m_impl = comparisonExpressionImpl;
        }

        public final BdeFilterImpl.ExpressionImpl getImpl() {
            return this.m_impl;
        }
    }

    public class AttributeComparisonExpression
    extends Expression {
        BdeFilterImpl.AttributeComparisonExpressionImpl m_impl;

        public AttributeComparisonExpression(BdeFilterImpl.AttributeComparisonExpressionImpl attributeComparisonExpressionImpl) {
            this.m_impl = attributeComparisonExpressionImpl;
        }

        public final BdeFilterImpl.ExpressionImpl getImpl() {
            return this.m_impl;
        }
    }

    public class LogicalExpression
    extends Expression {
        BdeFilterImpl.LogicalExpressionImpl m_impl;

        public LogicalExpression(BdeFilterImpl.LogicalExpressionImpl logicalExpressionImpl) {
            this.m_impl = logicalExpressionImpl;
        }

        public BdeFilterImpl.ExpressionImpl getImpl() {
            return this.m_impl;
        }
    }
}

