/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic.validation;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.bdeimpl.generic.validation.IFacet;
import com.ssaglobal.bdeimpl.generic.validation.enumeration;
import com.ssaglobal.bdeimpl.generic.validation.fractionDigits;
import com.ssaglobal.bdeimpl.generic.validation.length;
import com.ssaglobal.bdeimpl.generic.validation.maxExclusive;
import com.ssaglobal.bdeimpl.generic.validation.maxInclusive;
import com.ssaglobal.bdeimpl.generic.validation.maxLength;
import com.ssaglobal.bdeimpl.generic.validation.minExclusive;
import com.ssaglobal.bdeimpl.generic.validation.minInclusive;
import com.ssaglobal.bdeimpl.generic.validation.minLength;
import com.ssaglobal.bdeimpl.generic.validation.pattern;
import com.ssaglobal.bdeimpl.generic.validation.totalDigits;
import com.ssaglobal.bdeimpl.generic.validation.whiteSpace;
import java.util.Hashtable;

public class DataValidator {
    public static final char DATASEPERATOR = ':';
    public static final String ENUMERATION = "enumeration";
    public static final String FRACTIONDIGITS = "fractionDigits";
    public static final String LENGTH = "length";
    public static final String MAXEXCLUSIVE = "maxExclusive";
    public static final String MAXINCLUSIVE = "maxInclusive";
    public static final String MAXLENGTH = "maxLength";
    public static final String MININCLUSIVE = "minInclusive";
    public static final String MINEXCLUSIVE = "minExclusive";
    public static final String MINLENGTH = "minLength";
    public static final String PATTERN = "pattern";
    public static final String TOTALDIGITS = "totalDigits";
    public static final String WHITESPACE = "whiteSpace";
    public static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeimpl.generic.validation", "DataValidator");
    public static final String LOG_PREFIX = "BDE CLIENT: ";
    public static final String FACET_ERROR = "Facet validation Error, ";
    public static final Hashtable HASH_TYPES = new Hashtable();
    private enumeration m_enumeration = null;
    private whiteSpace m_whiteSpace = null;
    private IFacet[] m_facets = null;
    private int mNrFacets = 0;

    public DataValidator(String string, String[] stringArray) throws Exception {
        this.m_facets = new IFacet[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string2 = this.getFacetData(stringArray[n]);
            if (stringArray[n].startsWith(ENUMERATION)) {
                if (this.m_enumeration == null) {
                    this.m_enumeration = new enumeration(string, this.getTypeNumber(string));
                }
                this.m_enumeration.addEnumValue(string2);
            } else if (stringArray[n].startsWith(WHITESPACE)) {
                this.m_whiteSpace = new whiteSpace(string, this.getTypeNumber(string), string2);
            } else {
                IFacet iFacet = this.getFacetImpl(stringArray[n], string);
                this.m_facets[this.mNrFacets++] = iFacet;
            }
            ++n;
        }
    }

    public boolean hasChangeFacet() {
        return this.m_whiteSpace != null;
    }

    public String changeValue(String string) throws Exception {
        return this.m_whiteSpace.change(string);
    }

    public void checkValue(String string) throws Exception {
        if (this.m_enumeration != null) {
            this.m_enumeration.check(string);
        }
        int n = 0;
        while (n < this.mNrFacets) {
            this.m_facets[n].check(string);
            ++n;
        }
    }

    private String getFacetData(String string) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf(58);
            return string.substring(n + 1, string.length());
        }
        return null;
    }

    private IFacet getFacetImpl(String string, String string2) throws Exception {
        String string3 = this.getFacetData(string);
        int n = this.getTypeNumber(string2);
        if (string.startsWith(LENGTH)) {
            return new length(string2, n, string3);
        }
        if (string.startsWith(FRACTIONDIGITS)) {
            return new fractionDigits(string2, n, string3);
        }
        if (string.startsWith(MAXEXCLUSIVE)) {
            return new maxExclusive(string2, n, string3);
        }
        if (string.startsWith(MAXINCLUSIVE)) {
            return new maxInclusive(string2, n, string3);
        }
        if (string.startsWith(MAXLENGTH)) {
            return new maxLength(string2, n, string3);
        }
        if (string.startsWith(MININCLUSIVE)) {
            return new minInclusive(string2, n, string3);
        }
        if (string.startsWith(MINEXCLUSIVE)) {
            return new minExclusive(string2, n, string3);
        }
        if (string.startsWith(MINLENGTH)) {
            return new minLength(string2, n, string3);
        }
        if (string.startsWith(PATTERN)) {
            return new pattern(string2, n, string3);
        }
        if (string.startsWith(TOTALDIGITS)) {
            return new totalDigits(string2, n, string3);
        }
        throw new Exception("Facet implementation for facet " + string + " not found");
    }

    private int getTypeNumber(String string) throws Exception {
        Integer n = (Integer)HASH_TYPES.get(string);
        if (n == null) {
            throw new Exception("Facet checking failed, not a valid type '" + string + "'");
        }
        return n;
    }

    static {
        HASH_TYPES.put("boolean", new Integer(1));
        HASH_TYPES.put("byte", new Integer(2));
        HASH_TYPES.put("short", new Integer(3));
        HASH_TYPES.put("int", new Integer(4));
        HASH_TYPES.put("long", new Integer(5));
        HASH_TYPES.put("float", new Integer(6));
        HASH_TYPES.put("double", new Integer(7));
        HASH_TYPES.put("integer", new Integer(8));
        HASH_TYPES.put("decimal", new Integer(9));
        HASH_TYPES.put("string", new Integer(10));
        HASH_TYPES.put("dateTime", new Integer(11));
        HASH_TYPES.put("base64Binary", new Integer(12));
        HASH_TYPES.put("hexBinary", new Integer(13));
        HASH_TYPES.put("duration", new Integer(14));
        HASH_TYPES.put("time", new Integer(15));
        HASH_TYPES.put("date", new Integer(16));
        HASH_TYPES.put("gYearMonth", new Integer(17));
        HASH_TYPES.put("gYear", new Integer(18));
        HASH_TYPES.put("gMonthDay", new Integer(19));
        HASH_TYPES.put("gDay", new Integer(20));
        HASH_TYPES.put("gMonth", new Integer(21));
        HASH_TYPES.put("anyURI", new Integer(22));
        HASH_TYPES.put("NOTATION", new Integer(23));
        HASH_TYPES.put("token", new Integer(24));
        HASH_TYPES.put("normalizedString", new Integer(25));
        HASH_TYPES.put("language", new Integer(26));
        HASH_TYPES.put("Name", new Integer(27));
        HASH_TYPES.put("NMTOKEN", new Integer(28));
        HASH_TYPES.put("NCName", new Integer(29));
        HASH_TYPES.put("NMTOKENS", new Integer(30));
        HASH_TYPES.put("ID", new Integer(31));
        HASH_TYPES.put("IDREF", new Integer(32));
        HASH_TYPES.put("ENTITY", new Integer(33));
        HASH_TYPES.put("IDREFS", new Integer(34));
        HASH_TYPES.put("ENTITIES", new Integer(35));
        HASH_TYPES.put("nonPositiveInteger", new Integer(36));
        HASH_TYPES.put("nonNegativeInteger", new Integer(37));
        HASH_TYPES.put("negativeInteger", new Integer(38));
        HASH_TYPES.put("unsignedLong", new Integer(39));
        HASH_TYPES.put("positiveInteger", new Integer(40));
        HASH_TYPES.put("unsignedInt", new Integer(41));
        HASH_TYPES.put("unsignedShort", new Integer(42));
        HASH_TYPES.put("unsignedByte", new Integer(43));
        HASH_TYPES.put("Qname", new Integer(44));
    }
}

