/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic;

import com.baan.b3.dom.Element;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.services.guid.Guid;
import com.ssaglobal.bdeimpl.generic.BdeEventManager;
import com.ssaglobal.bdeimpl.generic.BdeImplCommunicationException;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeProxy;
import com.ssaglobal.bdeimpl.generic.Event;
import com.ssaglobal.bdeserver.BdeServerRuntimeException;
import com.ssaglobal.bdeserver.StringResultException;
import com.ssaglobal.bdeserver.configuration.ConfigurationException;
import com.ssaglobal.bdeserver.configuration.ServerConfiguration;
import com.ssaglobal.bdeserver.xml.ElementResultException;

public class ErrorEvent
extends Event {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$bdeimpl$generic$ErrorEvent == null ? (class$com$ssaglobal$bdeimpl$generic$ErrorEvent = ErrorEvent.class$("com.ssaglobal.bdeimpl.generic.ErrorEvent")) : class$com$ssaglobal$bdeimpl$generic$ErrorEvent);
    private static final String LOG_PREFIX = "BDE ErrorEvent: ";
    private static final String SOURCE_CONSUMER = "EventConsumer";
    private static final String SOURCE_PRODUCER = "EventProducer";
    private static final String SOURCE_CONSUMER_IMPL = "EventConsumer Implementation";
    private static final String SOURCE_PRODUCER_IMPL = "EventProducer Implementation";
    private static final String SOURCE_CONSUMER_TRANS = "EventConsumer Transport";
    private static final String SOURCE_PRODUCER_TRANS = "EventProducer Transport";
    private BdeProxy m_Message;
    private BdeProxy m_Event;
    static /* synthetic */ Class class$com$ssaglobal$bdeimpl$generic$ErrorEvent;

    public static void createAndSendErrorEventBasedOnXMLMessageAndStringEvent(String string, Element element, String string2, String string3) {
        try {
            ErrorEvent errorEvent = new ErrorEvent(element, string3, string2);
            errorEvent.send(string);
        }
        catch (Exception exception) {
            LogEvent logEvent = LoggerFactory.createLogEvent(Guid.createGuid());
            logEvent.storeMessage("ErrorEvent logged because ErrorEvent cannot be created (BasedOnXMLMessageAndStringEvent)");
            logEvent.storeMessage("Error/Message structure:");
            logEvent.storeXml(element);
            logEvent.storeMessage("event cousing error:");
            logEvent.storeMessage(string3);
            logEvent.storeMessage("error:");
            logEvent.storeMessage(exception.toString());
            s_logger.errorEvent(logEvent);
            LoggerFactory.removeLogEvent(logEvent);
        }
    }

    public static void createAndSendErrorEventBasedOnMessageAndStringEvent(String string, String string2, String string3, String string4) {
        try {
            ErrorEvent errorEvent = new ErrorEvent(string2, string4, string3);
            errorEvent.send(string);
        }
        catch (Exception exception) {
            LogEvent logEvent = LoggerFactory.createLogEvent(Guid.createGuid());
            logEvent.storeMessage("ErrorEvent logged because ErrorEvent cannot be created (BasedOnMessageAndStringEvent)");
            logEvent.storeMessage("Error/Message structure:");
            logEvent.storeMessage(string2);
            logEvent.storeMessage("event cousing error:");
            logEvent.storeMessage(string4);
            logEvent.storeMessage("error:");
            logEvent.storeMessage(exception.toString());
            s_logger.errorEvent(logEvent);
            LoggerFactory.removeLogEvent(logEvent);
        }
    }

    public static void createAndSendErrorEventBasedOnErrorStringAndStringEvent(String string, String string2, String string3, String string4, String string5) {
        try {
            Element element = XMLNode.FromString2XmlElement(string5);
            ErrorEvent errorEvent = new ErrorEvent(string2, string3, string4, element);
            errorEvent.send(string);
        }
        catch (Exception exception) {
            LogEvent logEvent = LoggerFactory.createLogEvent(Guid.createGuid());
            logEvent.storeMessage("ErrorEvent logged because ErrorEvent cannot be created (BasedOnErrorStringAndStringEvent)");
            logEvent.storeMessage("Error String:");
            logEvent.storeMessage(string2);
            logEvent.storeMessage("event cousing error:");
            logEvent.storeMessage(string5);
            logEvent.storeMessage("error:");
            logEvent.storeMessage(exception.toString());
            s_logger.errorEvent(logEvent);
            LoggerFactory.removeLogEvent(logEvent);
        }
    }

    public static void createAndSendErrorEventBasedOnErrorStringAndEvent(String string, String string2, String string3, String string4, Element element) {
        try {
            ErrorEvent errorEvent = new ErrorEvent(string2, string3, string4, element);
            errorEvent.send(string);
        }
        catch (Exception exception) {
            LogEvent logEvent = LoggerFactory.createLogEvent(Guid.createGuid());
            logEvent.storeMessage("ErrorEvent logged because ErrorEvent cannot be created (BasedOnErrorStringAndEvent)");
            logEvent.storeMessage("Error String:");
            logEvent.storeMessage(string2);
            logEvent.storeMessage("event cousing error:");
            logEvent.storeXml(element);
            logEvent.storeMessage("error:");
            logEvent.storeMessage(exception.toString());
            s_logger.errorEvent(logEvent);
            LoggerFactory.removeLogEvent(logEvent);
        }
    }

    public static Element buildBdeMessage(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        string6 = string5 == null ? "<Message><messageCode>" + string + "</messageCode><messageType>" + string2 + "</messageType><messageText>" + string3 + "</messageText><messageSource>" + string4 + "</messageSource></Message>" : "<Message><messageCode>" + string + "</messageCode><messageType>" + string2 + "</messageType><messageText>" + string3 + "</messageText><messageSource>" + string4 + "</messageSource><messageCorrectiveAction>" + string5 + "</messageCorrectiveAction></Message>";
        return XMLNode.FromString2XmlElement(string6);
    }

    public static void processPublisherEventException(String string, Throwable throwable, Element element) {
        if (throwable instanceof BdeImplCommunicationException) {
            BdeImplCommunicationException bdeImplCommunicationException = (BdeImplCommunicationException)throwable;
            String string2 = bdeImplCommunicationException.getMessage();
            ErrorEvent.createAndSendErrorEventBasedOnErrorStringAndEvent(string, string2, SOURCE_PRODUCER_TRANS, "Check BusComponent configuration, transport or consumer runtime, in context of BusComponent '" + string + "'", element);
        } else if (throwable instanceof BdeImplException) {
            BdeImplException bdeImplException = (BdeImplException)throwable;
            String string3 = bdeImplException.getMessage();
            ErrorEvent.createAndSendErrorEventBasedOnErrorStringAndEvent(string, string3, SOURCE_PRODUCER_IMPL, "Check implementation, installation or classpath", element);
        } else if (throwable instanceof NullPointerException) {
            NullPointerException nullPointerException = (NullPointerException)throwable;
            String string4 = "NullPointerException occured; " + nullPointerException.toString();
            ErrorEvent.createAndSendErrorEventBasedOnErrorStringAndEvent(string, string4, SOURCE_PRODUCER_IMPL, null, element);
        } else if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            String string5 = exception.toString();
            ErrorEvent.createAndSendErrorEventBasedOnErrorStringAndEvent(string, string5, SOURCE_PRODUCER_IMPL, null, element);
        }
    }

    public static void processConsumerEventException(String string, Throwable throwable, String string2) {
        if (throwable instanceof StringResultException) {
            StringResultException stringResultException = (StringResultException)throwable;
            Element element = stringResultException.getBdeMessage();
            ErrorEvent.createAndSendErrorEventBasedOnXMLMessageAndStringEvent(string, element, SOURCE_CONSUMER, string2);
        } else if (throwable instanceof ElementResultException) {
            ElementResultException elementResultException = (ElementResultException)throwable;
            Element element = elementResultException.getStringResultException().getBdeMessage();
            ErrorEvent.createAndSendErrorEventBasedOnXMLMessageAndStringEvent(string, element, SOURCE_CONSUMER, string2);
        } else if (throwable instanceof BdeServerRuntimeException) {
            ErrorEvent.createAndSendErrorEventBasedOnErrorStringAndStringEvent(string, throwable.getMessage(), SOURCE_CONSUMER_IMPL, "Check implementation, installation or classpath", string2);
        } else if (throwable instanceof ThreadDeath) {
            ErrorEvent.createAndSendErrorEventBasedOnErrorStringAndStringEvent(string, "ThreadDeath exception during processing of call: " + throwable.getMessage(), SOURCE_CONSUMER_IMPL, null, string2);
        } else {
            ErrorEvent.createAndSendErrorEventBasedOnErrorStringAndStringEvent(string, "ThreadDeath exception during processing of call: " + throwable.getMessage(), SOURCE_CONSUMER_IMPL, null, string2);
        }
    }

    private ErrorEvent(String string, Event event, String string2) throws BdeImplException {
        this(new BdeProxy(XMLNode.FromString2XmlElement(string)), event, string2);
    }

    private ErrorEvent(String string, String string2, String string3) throws BdeImplException {
        this(XMLNode.FromString2XmlElement(string), XMLNode.FromString2XmlElement(string2), string3);
    }

    private ErrorEvent(Element element, Element element2, String string) throws BdeImplException {
        this(new BdeProxy(element), new Event(element2), string);
    }

    private ErrorEvent(Element element, String string, String string2) throws BdeImplException {
        this(element, XMLNode.FromString2XmlElement(string), string2);
    }

    public ErrorEvent(Event event) {
        this.setControlArea(event.getControlArea());
        this.setDataArea(event.getDataArea());
    }

    private ErrorEvent() throws BdeImplException {
        this.setEntity("Message");
        this.setAction("Create");
        this.setContentType("bde");
        this.setSupplier("GenericBDERuntime");
    }

    private ErrorEvent(String string, String string2, String string3, Element element) throws BdeImplException {
        this();
        Element element2 = ErrorEvent.buildBdeMessage("ERROR001", "error", string, string2, string3);
        BdeProxy bdeProxy = new BdeProxy(element2);
        this.addData(bdeProxy);
        this.m_Message = bdeProxy;
        this.m_Event = new BdeProxy(element);
        BdeProxy bdeProxy2 = new BdeProxy("MessageReference");
        bdeProxy2.setValue("messageReferenceType", "Event");
        BdeProxy bdeProxy3 = new BdeProxy("messageReferenceInfo");
        bdeProxy2.addBde(bdeProxy3);
        bdeProxy3.addBde(this.m_Event);
        bdeProxy.addBde(bdeProxy2);
    }

    private ErrorEvent(BdeProxy bdeProxy, Event event, String string) throws BdeImplException {
        this();
        Element element = ErrorEvent.buildBdeMessage("ERROR001", "error", "Error based on BDE Message (MessageDetails)", string, null);
        BdeProxy bdeProxy2 = new BdeProxy(element);
        BdeProxy bdeProxy3 = new BdeProxy("MessageDetails");
        bdeProxy2.addBde(bdeProxy3);
        String string2 = bdeProxy.getRootName();
        if (!string2.equals("Message")) {
            bdeProxy.setRootName("Message");
        }
        bdeProxy3.addBde(bdeProxy);
        bdeProxy.setAttribute("ID", "0");
        this.m_Message = bdeProxy;
        this.m_Event = event;
        this.addData(bdeProxy2);
        BdeProxy bdeProxy4 = new BdeProxy("MessageReference");
        bdeProxy4.setValue("messageReferenceType", "Event");
        BdeProxy bdeProxy5 = new BdeProxy("messageReferenceInfo");
        bdeProxy4.addBde(bdeProxy5);
        bdeProxy5.addBde(event);
        bdeProxy2.addBde(bdeProxy4);
    }

    public void send(String string) {
        ErrorEventSender errorEventSender = new ErrorEventSender(this, string);
        errorEventSender.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ErrorEventSender
    extends Thread {
        private Event m_errorEvent = null;
        private String m_buscomponentContextID = null;
        private String m_sLogging = null;

        public ErrorEventSender(Event event, String string) {
            this.setName("ErrorEventSender");
            this.m_errorEvent = event;
            this.m_buscomponentContextID = string;
        }

        public void run() {
            String string = null;
            try {
                s_logger.message("BDE ErrorEvent: Trying to send ErrorEvent in context of buscomponent '" + this.m_buscomponentContextID + "'");
                string = ServerConfiguration.getServerConfiguration(this.m_buscomponentContextID).getErrorHandlerBusComponent();
                s_logger.message("BDE ErrorEvent: found ErrorHandler BusComponent '" + string + "', for context '" + this.m_buscomponentContextID + "'");
            }
            catch (ConfigurationException configurationException) {
                s_logger.errorMessage("BDE ErrorEvent: Cannot find ErrorHandler BusComponent for context '" + this.m_buscomponentContextID + "', cannot send Error Event");
                this.logError(configurationException.getMessage());
                return;
            }
            try {
                BdeEventManager bdeEventManager = new BdeEventManager(string);
                bdeEventManager._publishErrorEvent(this.m_errorEvent);
                bdeEventManager.close();
                return;
            }
            catch (BdeImplCommunicationException bdeImplCommunicationException) {
                this.logError(bdeImplCommunicationException.getMessage());
            }
            catch (BdeImplException bdeImplException) {
                this.logError(bdeImplException.getMessage());
            }
        }

        public void logError(String string) {
            LogEvent logEvent = LoggerFactory.createLogEvent(Guid.createGuid());
            logEvent.storeMessage("ErrorEvent logged because ErrorHandler cannot be reached");
            logEvent.storeMessage(string);
            logEvent.storeMessage("Error Event:");
            if (this.m_errorEvent != null) {
                this.m_errorEvent.prepareForSending();
            }
            logEvent.storeXml(this.m_errorEvent.getRoot());
            s_logger.errorEvent(logEvent);
            LoggerFactory.removeLogEvent(logEvent);
        }
    }
}

