/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.Text;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.TextImpl;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.validation.DataValidator;

public class BusinessDataEntityImpl {
    private Element m_root = null;
    private String m_reference = null;
    public static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeimpl.generic", "BusinessDataEntityImpl");
    public static final String LOG_PREFIX = "BDE CLIENT: ";
    protected static final String ATTR_CHANGED = "changed";

    public BusinessDataEntityImpl(String string) {
        this.m_root = new ElementImpl(string);
    }

    public BusinessDataEntityImpl(Element element) {
        this.m_root = element;
    }

    public String getValue(String string) throws BdeImplException {
        if (this.m_root == null) {
            throw new BdeImplException("BDE data object not initialized");
        }
        Element element = (Element)this.m_root.getElementsByTagName(string).item(0);
        if (element == null || element.getFirstChild() == null) {
            throw new BdeImplException("value for '" + string + "' not set");
        }
        return element.getFirstChild().getNodeValue();
    }

    String getValueNoChecks(String string) {
        try {
            return this.getValue(string);
        }
        catch (BdeImplException bdeImplException) {
            return "";
        }
    }

    public void addValue(String string, String string2) {
        Node node = this.m_root.appendChild(new ElementImpl(string));
        node.appendChild(new TextImpl(string2));
    }

    public void setAttribute(String string, String string2) {
        try {
            this.m_root.setAttribute(string, string2);
        }
        catch (Exception exception) {}
    }

    public String getAttribute(String string) {
        try {
            return this.m_root.getAttribute(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setValueandMark(String string, String string2, boolean bl) throws BdeImplException {
        Node node;
        NodeList nodeList = this.m_root.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            String string3 = node.getNodeName();
            if (string3.equalsIgnoreCase(string)) {
                node.removeChild(node.getFirstChild());
                node.appendChild(new TextImpl(string2));
                if (bl) {
                    ((Element)node).setAttribute(ATTR_CHANGED, "true");
                }
                return;
            }
            ++n;
        }
        node = this.m_root.appendChild(new ElementImpl(string));
        node.appendChild(new TextImpl(string2));
        if (bl) {
            ((Element)node).setAttribute(ATTR_CHANGED, "true");
        }
    }

    public void setValue(String string, String string2) throws BdeImplException {
        this.setValueandMark(string, string2, false);
    }

    public void setValue(String string, String string2, String[] stringArray, String string3) throws BdeImplException {
        try {
            DataValidator dataValidator = new DataValidator(string2, stringArray);
            if (dataValidator.hasChangeFacet()) {
                string3 = dataValidator.changeValue(string3);
            }
            dataValidator.checkValue(string3);
        }
        catch (Exception exception) {
            throw new BdeImplException(exception.getMessage());
        }
        this.setValue(string, string3);
    }

    public void unSetValue(String string) {
        NodeList nodeList = this.m_root.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string2 = node.getNodeName();
            if (string2.equalsIgnoreCase(string)) {
                node.removeChild(node.getFirstChild());
                return;
            }
            ++n;
        }
    }

    public boolean hasValue(String string) {
        try {
            this.getValue(string);
        }
        catch (BdeImplException bdeImplException) {
            return false;
        }
        return true;
    }

    public final Element getRoot() {
        return this.m_root;
    }

    public final void setRoot(Element element) {
        this.m_root = element;
    }

    public void addBde(BusinessDataEntityImpl businessDataEntityImpl) {
        this.m_root.appendChild(businessDataEntityImpl.getRoot());
    }

    void setReference(String string) {
        this.m_reference = string;
    }

    String getReference() {
        return this.m_reference;
    }

    public String getRootName() {
        return this.m_root.getNodeName();
    }

    public void setRootName(String string) {
        ElementImpl elementImpl = new ElementImpl(string);
        NodeList nodeList = this.m_root.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            elementImpl.appendChild(nodeList.item(n).cloneNode(true));
            ++n;
        }
        this.m_root = elementImpl;
    }

    public String toString() {
        return this.toString(this.m_root, "");
    }

    public String toString(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + element.getNodeName() + "\n");
        try {
            Node node;
            int n = 1;
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                int n3;
                Node node2 = nodeList.item(n2);
                if (node2 instanceof Element && (n3 = (node = (Element)node2).getNodeName().length()) > n) {
                    n = n3;
                }
                ++n2;
            }
            int n4 = 0;
            while (n4 < nodeList.getLength()) {
                node = nodeList.item(n4);
                if (node instanceof Element) {
                    Element element2 = (Element)node;
                    if (element2.getFirstChild() instanceof Text || element2.getFirstChild() == null) {
                        stringBuffer.append(string + this.printNode(element2, n));
                        stringBuffer.append("\n");
                    } else {
                        stringBuffer.append(this.toString(element2, string + "   "));
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            return super.toString();
        }
        return stringBuffer.toString();
    }

    private String printNode(Element element, int n) {
        String string = element.getNodeName() + "                                                                         ";
        Node node = element.getFirstChild();
        String string2 = node != null ? node.getNodeValue() : "";
        return "- " + (string.substring(0, n) + " = '" + string2 + "'").trim();
    }
}

