/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic;

import com.baan.b3.dom.Element;
import com.ssaglobal.bdeimpl.generic.BdeFilterImpl;
import com.ssaglobal.bdeimpl.generic.BdeImplCommunicationException;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeImplResultException;
import com.ssaglobal.bdeimpl.generic.BdeManager;
import com.ssaglobal.bdeimpl.generic.BdeProxy;
import com.ssaglobal.bdeimpl.generic.BdeSelectionImpl;
import java.util.ArrayList;

public class BdeProxyManager
extends BdeManager {
    private static final String STD_MTD_CREATE = "Create";
    private static final String STD_MTD_CHANGE = "Change";
    private static final String STD_MTD_DELETE = "Delete";
    private static final String STD_MTD_SHOW = "Show";
    private static final String STD_MTD_PUBLISH_LIST = "PublishList";
    private static final String STD_MTD_PUBLISH_CHANGES = "PublishChanges";
    private static final String STD_MTD_UNPUBLISH_CHANGES = "UnpublishChanges";
    private static final String STD_MTD_SUBSCRIBE_EVENT = "SubscribeEvent";
    private static final String STD_MTD_UNSUBSCRIBE_EVENT = "UnSubscribeEvent";
    private BdeFilterImpl m_filter = null;
    private BdeSelectionImpl m_selection = null;
    private String m_primaryKeys = null;
    private String m_bdeName = null;

    public BdeProxyManager(String string, String string2) throws BdeImplCommunicationException {
        this.m_primaryKeys = string;
        this.m_bdeName = string2;
    }

    public final String getBdeName() {
        return this.m_bdeName;
    }

    public final void setSelection(BdeSelectionImpl bdeSelectionImpl) {
        this.m_selection = bdeSelectionImpl;
    }

    public final void setFilter(BdeFilterImpl bdeFilterImpl) {
        this.m_filter = bdeFilterImpl;
    }

    public final BdeSelectionImpl getSelection() {
        return this.m_selection;
    }

    public final BdeFilterImpl getFilter() {
        return this.m_filter;
    }

    public BdeProxy executeShow(BdeProxy bdeProxy) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        if (bdeProxy != null) {
            BdeManager.s_logger.message("Executing Show for '" + this.m_bdeName + "'");
            bdeProxy.stripAllAdministration();
            Element element = this.executeBdeRequest(bdeProxy, this.m_selection, this.m_filter, this.m_bdeName, STD_MTD_SHOW);
            bdeProxy.replaceContent(element);
            return bdeProxy;
        }
        BdeManager.s_logger.errorMessage("Executing Show for null object");
        throw new BdeImplException("Executing Show for null object");
    }

    public void executeCreate(BdeProxy bdeProxy) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        if (bdeProxy == null) {
            BdeManager.s_logger.errorMessage("Executing Create for null object");
            throw new BdeImplException("Executing Create for null object");
        }
        BdeManager.s_logger.message("Executing Create for '" + this.m_bdeName + "'");
        bdeProxy.prepareForCreate();
        Element element = this.executeBdeRequest(bdeProxy, this.m_selection, this.m_filter, this.m_bdeName, STD_MTD_CREATE);
        bdeProxy.replaceContent(element);
    }

    public void executeChange(BdeProxy bdeProxy) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        if (bdeProxy == null) {
            BdeManager.s_logger.errorMessage("Cannot execute Change for null object");
            throw new BdeImplException("Cannot execute Change for null object");
        }
        BdeManager.s_logger.message("Executing Change for '" + this.m_bdeName + "'");
        bdeProxy.prepareForChange(this.m_primaryKeys);
        Element element = this.executeBdeRequest(bdeProxy, this.m_selection, this.m_filter, this.m_bdeName, STD_MTD_CHANGE);
        bdeProxy.replaceContent(element);
    }

    public void executeDelete(BdeProxy bdeProxy) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        if (bdeProxy == null) {
            BdeManager.s_logger.errorMessage("Cannot execute Delete for null object");
            throw new BdeImplException("Cannot execute Delete for null object");
        }
        BdeManager.s_logger.message("Executing Delete for '" + bdeProxy.getRootName() + "'");
        bdeProxy.prepareForDelete(this.m_primaryKeys);
        this.executeBdeRequest(bdeProxy, null, null, this.m_bdeName, STD_MTD_DELETE);
    }

    private void executePublish(BdeProxy bdeProxy, String string) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("eventConsumer");
        if (string.equals(STD_MTD_PUBLISH_CHANGES) || string.equals(STD_MTD_SUBSCRIBE_EVENT)) {
            arrayList.add("destination");
            arrayList.add("eventAction");
            bdeProxy = bdeProxy.prepareForPublish(arrayList);
            this.executeBdeRequest(this.m_bdeName, string, this.m_selection, this.m_filter, bdeProxy);
        }
        if (string.equals(STD_MTD_UNPUBLISH_CHANGES) || string.equals(STD_MTD_UNSUBSCRIBE_EVENT)) {
            bdeProxy = bdeProxy.prepareForPublish(arrayList);
            this.executeBdeRequest(this.m_bdeName, string, null, null, bdeProxy);
        }
        if (string.equals(STD_MTD_PUBLISH_LIST)) {
            arrayList.add("destination");
            arrayList.add("maxNumberOfObjects");
            arrayList.add("eventBatchSize");
            bdeProxy = bdeProxy.prepareForPublish(arrayList);
            this.executeBdeRequest(this.m_bdeName, string, this.m_selection, this.m_filter, bdeProxy);
        }
    }

    public void executeSpecific(BdeProxy bdeProxy, String string) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        if (string != null && string.equals(STD_MTD_PUBLISH_CHANGES) || string.equals(STD_MTD_UNPUBLISH_CHANGES) || string.equals(STD_MTD_PUBLISH_LIST) || string.equals(STD_MTD_SUBSCRIBE_EVENT) || string.equals(STD_MTD_UNSUBSCRIBE_EVENT)) {
            this.executePublish(bdeProxy, string);
            return;
        }
        if (bdeProxy == null) {
            String string2 = "Cannot execute Specific method '" + string + "' on bde '" + this.m_bdeName + "' for null object";
            BdeManager.s_logger.errorMessage(string2);
            throw new BdeImplException(string2);
        }
        BdeManager.s_logger.message("Executing Specific Method '" + string + "' for '" + this.m_bdeName + "'");
        bdeProxy.prepareForSpecific();
        Element element = this.executeBdeRequest(bdeProxy, null, null, this.m_bdeName, string);
        bdeProxy.replaceContent(element);
    }

    public boolean supportsReferentialIntegrity() throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        return super.supportsReferentialIntegrity(this.m_bdeName);
    }

    public boolean supportsProcessingScope(int n) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        return super.supportsProcessingScope(this.m_bdeName, n);
    }
}

