/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.Text;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.TextImpl;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeProxyIterator;
import com.ssaglobal.bdeimpl.generic.BusinessDataEntityImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public class BdeProxy
extends BusinessDataEntityImpl {
    private static final String ATTR_KEY = "key";
    private static final String ATTR_ACTIONTYPE = "actionType";
    private static final String ATTR_VALUE_CHANGE = "change";
    private static final String ATTR_VALUE_CREATE = "create";
    private static final String ATTR_VALUE_DELETE = "delete";

    public BdeProxy(Element element) {
        super(element);
    }

    public BdeProxy(String string) {
        super(string);
    }

    public void createComponent(BdeProxy bdeProxy) throws BdeImplException {
        bdeProxy.searchForActionType(ATTR_VALUE_DELETE, ATTR_VALUE_CREATE);
        this.addBde(bdeProxy);
        bdeProxy.setAttribute(ATTR_ACTIONTYPE, ATTR_VALUE_CREATE);
    }

    public void changeComponent(BdeProxy bdeProxy) throws BdeImplException {
        bdeProxy.searchForActionType(ATTR_VALUE_DELETE, ATTR_VALUE_CHANGE);
        bdeProxy.searchForActionType(ATTR_VALUE_CREATE, ATTR_VALUE_CHANGE);
        this.addBde(bdeProxy);
        bdeProxy.setAttribute(ATTR_ACTIONTYPE, ATTR_VALUE_CHANGE);
    }

    public void deleteComponent(BdeProxy bdeProxy) throws BdeImplException {
        this.addBde(bdeProxy);
        bdeProxy.setAttribute(ATTR_ACTIONTYPE, ATTR_VALUE_DELETE);
    }

    public void deleteExistingComponent(BdeProxy bdeProxy) throws BdeImplException {
        bdeProxy.searchForActionType(ATTR_VALUE_CHANGE, ATTR_VALUE_DELETE);
        bdeProxy.searchForActionType(ATTR_VALUE_CREATE, ATTR_VALUE_DELETE);
        Node node = bdeProxy.getRoot().getParentNode();
        Element element = this.getRoot();
        if (!node.equals(element)) {
            this.addBde(bdeProxy);
        }
        bdeProxy.setAttribute(ATTR_ACTIONTYPE, ATTR_VALUE_DELETE);
    }

    public BdeProxy getComponent(String string) throws BdeImplException {
        NodeList nodeList = this.getRoot().getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0) {
            throw new BdeImplException("No matching component found for tag: " + string);
        }
        return new BdeProxy((Element)nodeList.item(0));
    }

    public String getComponentAsString(String string) throws BdeImplException {
        BdeProxy bdeProxy = this.getComponent(string);
        return XMLNode.FromXmlNode2String(bdeProxy.getRoot());
    }

    public boolean hasComponent(String string) {
        NodeList nodeList = this.getRoot().getElementsByTagName(string);
        int n = nodeList.getLength();
        return n != 0;
    }

    public BdeProxyIterator listComponents(String string) {
        NodeList nodeList = this.getRoot().getElementsByTagName(string);
        return new BdeProxyIterator(nodeList);
    }

    public void setValue(String string, String string2) throws BdeImplException {
        Element element = this.getRoot();
        String string3 = element.getAttribute(ATTR_ACTIONTYPE);
        if (string3.length() == 0) {
            element.setAttribute(ATTR_ACTIONTYPE, ATTR_VALUE_CHANGE);
        }
        super.setValueandMark(string, string2, true);
    }

    private void markPrimaryKeys(String string) {
        Element element = this.getRoot();
        HashSet<Object> hashSet = new HashSet<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            hashSet.add(stringTokenizer.nextElement());
        }
        this.processLayerMarkPrimaryKeys(hashSet, element, element.getNodeName());
    }

    public void prepareForDelete(String string) throws BdeImplException {
        this.markPrimaryKeys(string);
        Element element = this.getRoot();
        NodeList nodeList = element.getChildNodes();
        ElementImpl elementImpl = new ElementImpl(element.getNodeName());
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if (element2.getAttribute(ATTR_KEY).equals("true")) {
                String string2 = element2.getNodeName();
                String string3 = element2.getFirstChild().getNodeValue();
                Node node = elementImpl.appendChild(new ElementImpl(string2));
                node.appendChild(new TextImpl(string3));
            }
            ++n;
        }
        this.replaceContent(elementImpl);
    }

    void prepareForChange(String string) throws BdeImplException {
        this.markPrimaryKeys(string);
        Element element = this.getRoot();
        Element element2 = this.getAllChanges(element, true);
        this.replaceContent(element2);
    }

    void prepareForCreate() throws BdeImplException {
        Element element = this.getRoot();
        this.checkAllComponentsForActionTypeCreate(element);
        this.stripAllAdministration(element, true);
    }

    void prepareForSpecific() {
        this.stripAllAdministration();
    }

    BdeProxy prepareForPublish(ArrayList arrayList) {
        return new BdeProxy(this.getPublishControl(this.getRoot(), arrayList));
    }

    private Element getPublishControl(Element element, ArrayList arrayList) {
        ElementImpl elementImpl = new ElementImpl(element.getNodeName());
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string = element2.getNodeName();
            if (arrayList.contains(string) && (element2.getFirstChild() instanceof Text || element2.getFirstChild() == null)) {
                String string2 = "";
                if (element2.getFirstChild() != null) {
                    string2 = element2.getFirstChild().getNodeValue();
                }
                Node node = elementImpl.appendChild(new ElementImpl(string));
                node.appendChild(new TextImpl(string2));
            }
            ++n;
        }
        return elementImpl;
    }

    private Element getAllChanges(Element element, boolean bl) {
        Object object;
        ElementImpl elementImpl = null;
        if (!bl) {
            object = element.getAttribute(ATTR_ACTIONTYPE);
            if (((String)object).length() == 0) {
                return null;
            }
            elementImpl = new ElementImpl(element.getNodeName());
            elementImpl.setAttribute(ATTR_ACTIONTYPE, (String)object);
        } else {
            elementImpl = new ElementImpl(element.getNodeName());
        }
        object = element.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Object object2;
            Element element2 = (Element)object.item(n);
            if (element2.getFirstChild() instanceof Text || element2.getFirstChild() == null) {
                if (element2.getAttribute("changed").equals("true") || element2.getAttribute(ATTR_KEY).equals("true")) {
                    object2 = element2.getNodeName();
                    String string = "";
                    if (element2.getFirstChild() != null) {
                        string = element2.getFirstChild().getNodeValue();
                    }
                    Node node = elementImpl.appendChild(new ElementImpl((String)object2));
                    node.appendChild(new TextImpl(string));
                }
            } else {
                object2 = this.getAllChanges(element2, false);
                if (object2 != null) {
                    elementImpl.appendChild((Node)object2);
                }
            }
            ++n;
        }
        return elementImpl;
    }

    void replaceContent(Element element) {
        super.setRoot(element);
    }

    void stripAllAdministration() {
        this.stripAllAdministration(this.getRoot(), true);
    }

    private void stripAllAdministration(Element element, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        if (bl) {
            element.removeAttribute(ATTR_ACTIONTYPE);
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if (element2.getFirstChild() instanceof Text || element2.getFirstChild() == null) {
                element2.removeAttribute(ATTR_KEY);
                element2.removeAttribute("changed");
            } else {
                this.stripAllAdministration(element2, bl);
            }
            ++n;
        }
    }

    private void processLayerMarkPrimaryKeys(HashSet hashSet, Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string2 = element2.getNodeName();
            if (element2.getFirstChild() instanceof Text || element2.getFirstChild() == null) {
                if (hashSet.contains(string + "." + string2)) {
                    element2.setAttribute(ATTR_KEY, "true");
                }
            } else {
                this.processLayerMarkPrimaryKeys(hashSet, element2, string + "." + string2);
            }
            ++n;
        }
    }

    private void searchForActionType(String string, String string2) throws BdeImplException {
        Element element = this.getRoot();
        while (element != null) {
            if (element.getAttribute(ATTR_ACTIONTYPE).equals(string)) {
                throw new BdeImplException("Invalid '" + string2 + "' Operation, '" + this.getRootName() + "' is already set to be " + string + "d");
            }
            element = (Element)element.getParentNode();
        }
        Element element2 = this.getRoot();
    }

    private void checkAllComponentsForActionTypeCreate(Element element) throws BdeImplException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if (!(element2.getFirstChild() instanceof Text) && element2.getFirstChild() != null) {
                String string = element2.getAttribute(ATTR_ACTIONTYPE);
                if (!string.equals(ATTR_VALUE_CREATE) && string.length() != 0) {
                    throw new BdeImplException("Cannot Create, a '" + element2.getNodeName() + "' is set to be " + string + "d");
                }
                this.checkAllComponentsForActionTypeCreate(element2);
            }
            ++n;
        }
    }

    public BdeProxy getComplexValue(String string) throws BdeImplException {
        NodeList nodeList = this.getRoot().getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0) {
            throw new BdeImplException("No matching component found for tag: " + string);
        }
        return new BdeProxy((Element)nodeList.item(0));
    }

    public void setComplexValue(String string, BdeProxy bdeProxy) throws BdeImplException {
        try {
            bdeProxy.setRootName(string);
            BdeProxy bdeProxy2 = this.getComplexValue(string);
            bdeProxy2.replaceContent(bdeProxy.getRoot());
        }
        catch (Exception exception) {
            super.addBde(bdeProxy);
        }
    }
}

