/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3impl.boi1.UserSession;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.BusinessElement;
import com.eibus.co.DataSet;
import com.eibus.co.Tuple;
import com.eibus.co.dom.BaanDLLCallImpl;
import com.eibus.exception.BusException;
import com.eibus.xml.dom.ElementImpl;
import com.ssaglobal.bdeimpl.generic.BdeFilterImpl;
import com.ssaglobal.bdeimpl.generic.BdeImplCommunicationException;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeImplResultException;
import com.ssaglobal.bdeimpl.generic.BdeProxy;
import com.ssaglobal.bdeimpl.generic.BdeProxyIterator;
import com.ssaglobal.bdeimpl.generic.BdeSelectionImpl;
import com.ssaglobal.bdeimpl.generic.BusinessDataEntityImpl;
import com.ssaglobal.bdeimpl.generic.impl.BdeReply;
import com.ssaglobal.bdeimpl.generic.impl.BdeRequest;
import com.ssaglobal.bdeimpl.generic.impl.ControlArea;

public class BdeManager {
    protected static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeimpl.generic", "BdeManager");
    private static final String LOG_PREFIX = "BDE CLIENT: ";
    private Element m_information = new ElementImpl("Information");
    private static final String BDE_M_SUPPORTS_REF_INTEGRITY = "SupportsReferentialIntegrity";
    private static final String BDE_M_SUPPORTS_PROC_SCOPE = "SupportsProcessingScope";
    private static final String BDE_M_CREATE_REFERENCE = "CreateRef";
    private static final String BDE_M_DELETE_REFERENCE = "DeleteRef";
    private static final String BDE_CAT_PROCESSING_SCOPE = "processingScope";
    private static final String[] PROCESSING_SCOPE = new String[]{"request", "business_entity", "business_entity_component", "not_applicable"};
    private BusinessDocumentManager m_impl;
    private int m_iteratorFetchSize;
    private int m_processingScope = 0;
    private boolean m_automaticReference = false;
    private static final String TAG_RESULT = "Result";
    private static final String TAG_RESPONSE = "Response";

    public BdeManager() throws BdeImplCommunicationException {
        try {
            s_logger.message("BDE CLIENT: Creating new BDE Manager");
            this.m_impl = new BusinessDocumentManager();
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            this.m_iteratorFetchSize = adapterClientConfiguration.getIteratorSize();
        }
        catch (OWConfigurationException oWConfigurationException) {
            this.m_iteratorFetchSize = 250;
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE CLIENT: Error creating new BDE Menager " + busException.getMessage());
            throw new BdeImplCommunicationException(busException.getMessage());
        }
        s_logger.flowMessage("BDE CLIENT: Default Iterator Fetch size = " + this.m_iteratorFetchSize);
    }

    public void initialize(String string) throws BdeImplCommunicationException {
        try {
            s_logger.message("BDE CLIENT: Initialize BDE Manager with BusComponent '" + string + "'");
            this.m_impl.initialize(string);
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE CLIENT: Error Initialize BDE Manager with BusComponent '" + string + "' :" + busException.getMessage());
            throw new BdeImplCommunicationException(busException.getMessage());
        }
    }

    public void setTimeOut(long l) {
        s_logger.message("BDE CLIENT: Set timeout to " + l + " ms.");
        this.m_impl.setTimeOut(l);
    }

    public final long getTimeOut() {
        return this.m_impl.getTimeOut();
    }

    public void ping() throws BdeImplCommunicationException {
        try {
            s_logger.message("BDE CLIENT: pinging backend");
            this.m_impl.ping();
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE CLIENT: Error pinging backend, " + busException.getMessage());
            throw new BdeImplCommunicationException(busException.getMessage());
        }
    }

    public int getIteratorFetchSize() {
        return this.m_iteratorFetchSize;
    }

    public void setIteratorFetchSize(int n) {
        s_logger.message("BDE CLIENT: Setting BDE Iterator Fetch size to " + n + " ( previous value " + this.m_iteratorFetchSize + ")");
        this.m_iteratorFetchSize = n;
    }

    public void close() throws BdeImplCommunicationException {
        try {
            s_logger.message("BDE CLIENT: Closing BDE Manager");
            this.m_impl.close();
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE CLIENT: Error closing manager, " + busException.getMessage());
            throw new BdeImplCommunicationException(busException.getMessage());
        }
    }

    public void addToUserSession(UserSession userSession) throws BdeImplCommunicationException {
        try {
            this.m_impl.addToUserSession(userSession);
        }
        catch (BusException busException) {
            throw new BdeImplCommunicationException(busException.getMessage());
        }
    }

    BdeReply executeBdeRequest(BdeRequest bdeRequest, boolean bl) throws BdeImplCommunicationException, BdeImplResultException {
        try {
            if (this.m_processingScope != 0 && bl) {
                bdeRequest.setControlAreaTag(BDE_CAT_PROCESSING_SCOPE, PROCESSING_SCOPE[this.m_processingScope]);
            }
            s_logger.message("BDE CLIENT: Execute BDE Request with processingScope '" + PROCESSING_SCOPE[this.m_processingScope] + "'");
            BdeReply bdeReply = new BdeReply(this.m_impl.retrieveData(bdeRequest));
            if (bdeReply.isBdeResult()) {
                s_logger.message("BDE CLIENT: Reply is an BDE Result (fault)");
                throw new BdeImplResultException(new BdeProxy(bdeReply.getResultMessage()));
            }
            s_logger.message("BDE CLIENT: Reply is an BDE Response (ok)");
            this.processInformationArea(bdeReply);
            return bdeReply;
        }
        catch (BusApplicationException busApplicationException) {
            s_logger.errorMessage("BDE CLIENT: Cannot execute BDE Request, " + busApplicationException.toString());
            throw new BdeImplCommunicationException(busApplicationException.toString());
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE CLIENT: Cannot execute BDE Request, " + busException.getMessage());
            throw new BdeImplCommunicationException(busException.getMessage());
        }
    }

    public Element executeBdeRequest(String string, String string2, BdeSelectionImpl bdeSelectionImpl, BdeFilterImpl bdeFilterImpl, BusinessDataEntityImpl businessDataEntityImpl) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        BdeRequest bdeRequest = new BdeRequest(string, string2);
        bdeRequest.setControlAreaTags(businessDataEntityImpl.getRoot());
        bdeRequest.setSelection(bdeSelectionImpl);
        bdeRequest.setFilter(bdeFilterImpl);
        BdeReply bdeReply = null;
        bdeReply = this.executeBdeRequest(bdeRequest, true);
        Element element = bdeReply.getBde();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInformationArea(BdeReply bdeReply) {
        NodeList nodeList = bdeReply.getInformationAreaMessages();
        if (nodeList != null) {
            s_logger.message("BDE CLIENT: Found InformationArea with " + nodeList.getLength() + " Message(s)");
            Element element = this.m_information;
            synchronized (element) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.m_information.appendChild(nodeList.item(n));
                    ++n;
                }
                int n2 = this.m_information.getChildNodes().getLength();
                s_logger.message("BDE CLIENT: Number of information Messages within this BDE Manager is " + n2);
            }
        }
    }

    public Element executeBdeRequest(BusinessDataEntityImpl businessDataEntityImpl, BdeSelectionImpl bdeSelectionImpl, BdeFilterImpl bdeFilterImpl, String string, String string2) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        String string3;
        ControlArea controlArea;
        BdeRequest bdeRequest = new BdeRequest(string, string2);
        BdeReply bdeReply = null;
        bdeRequest.setBde(businessDataEntityImpl.getRoot());
        bdeRequest.setSelection(bdeSelectionImpl);
        bdeRequest.setFilter(bdeFilterImpl);
        if (this.m_automaticReference) {
            bdeRequest.setControlAreaTag("createRef", "true");
        }
        bdeReply = this.executeBdeRequest(bdeRequest, true);
        Element element = bdeReply.getBde();
        if (this.m_automaticReference && (controlArea = bdeReply.getControlArea()) != null && (string3 = controlArea.getControlAreaTagValue("referenceID")) != null && string3.length() > 0) {
            businessDataEntityImpl.setReference(string3);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasInformation() {
        Element element = this.m_information;
        synchronized (element) {
            return this.m_information.hasChildNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BdeProxyIterator getInformation() {
        Element element = this.m_information;
        synchronized (element) {
            NodeList nodeList = this.m_information.getChildNodes();
            return new BdeProxyIterator(nodeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInformation() {
        Element element = this.m_information;
        synchronized (element) {
            this.m_information = new ElementImpl("Information");
        }
    }

    public void setProcessingScope(int n) throws BdeImplException {
        if (0 > n || n > 3) {
            String string = "not a valid processing scope ( 0<" + n + "<3 )";
            s_logger.errorMessage(LOG_PREFIX + string);
            throw new BdeImplException(string);
        }
        s_logger.message("BDE CLIENT: Setting Processingscope from " + PROCESSING_SCOPE[this.m_processingScope] + " to " + PROCESSING_SCOPE[n]);
        this.m_processingScope = n;
    }

    public boolean supportsProcessingScope(String string, int n) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        if (0 > n || n > 3) {
            String string2 = "not a valid processing scope ( 0<" + n + "<3 )";
            s_logger.errorMessage(LOG_PREFIX + string2);
            throw new BdeImplException(string2);
        }
        BdeRequest bdeRequest = new BdeRequest(string, BDE_M_SUPPORTS_PROC_SCOPE);
        bdeRequest.setControlAreaTag(BDE_CAT_PROCESSING_SCOPE, PROCESSING_SCOPE[n]);
        BdeReply bdeReply = null;
        bdeReply = this.executeBdeRequest(bdeRequest, false);
        ControlArea controlArea = bdeReply.getControlArea();
        String string3 = controlArea.getControlAreaTagValue("supported");
        if (string3.equalsIgnoreCase("true")) {
            s_logger.message("BDE CLIENT: Backend supports ProcessingScope '" + PROCESSING_SCOPE[n] + "'");
            return true;
        }
        s_logger.message("BDE CLIENT: Backend does not support ProcessingScope '" + PROCESSING_SCOPE[n] + "'!");
        return false;
    }

    public boolean supportsReferentialIntegrity(String string) throws BdeImplCommunicationException, BdeImplResultException {
        BdeRequest bdeRequest = new BdeRequest(string, BDE_M_SUPPORTS_REF_INTEGRITY);
        BdeReply bdeReply = null;
        bdeReply = this.executeBdeRequest(bdeRequest, false);
        ControlArea controlArea = bdeReply.getControlArea();
        String string2 = controlArea.getControlAreaTagValue("supported");
        if (string2.equalsIgnoreCase("true")) {
            s_logger.message("BDE CLIENT: Backend supports ReferentialIntegrity features");
            return true;
        }
        s_logger.message("BDE CLIENT: Backend does not support ReferentialIntegrity features!");
        return false;
    }

    public void automaticReferences(boolean bl) {
        s_logger.message("BDE CLIENT: Automatic creation of backend references is now " + bl);
        this.m_automaticReference = bl;
    }

    public void createReference(BusinessDataEntityImpl businessDataEntityImpl) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        String string = businessDataEntityImpl.getReference();
        if (string != null) {
            String string2 = "ReferentialIntegrity: Reference for BDE '" + businessDataEntityImpl.getRootName() + "' already exists, delete reference first";
            s_logger.errorMessage(LOG_PREFIX + string2);
            throw new BdeImplException(string2);
        }
        BdeRequest bdeRequest = new BdeRequest(businessDataEntityImpl.getRootName(), BDE_M_CREATE_REFERENCE);
        bdeRequest.setBde(businessDataEntityImpl.getRoot());
        BdeReply bdeReply = null;
        bdeReply = this.executeBdeRequest(bdeRequest, false);
        ControlArea controlArea = bdeReply.getControlArea();
        string = controlArea.getControlAreaTagValue("referenceID");
        s_logger.message("BDE CLIENT: Created backend reference for BDE '" + businessDataEntityImpl.getRootName() + "', ref = '" + string + "'");
        businessDataEntityImpl.setReference(string);
    }

    public void deleteReference(BusinessDataEntityImpl businessDataEntityImpl) throws BdeImplCommunicationException, BdeImplResultException, BdeImplException {
        String string = businessDataEntityImpl.getReference();
        if (string == null) {
            String string2 = "ReferentialIntegrity: Reference for BDE '" + businessDataEntityImpl.getRootName() + "' does not exists.";
            s_logger.errorMessage(LOG_PREFIX + string2);
            throw new BdeImplException(string2);
        }
        s_logger.message("BDE CLIENT: Deleting backend reference for BDE '" + businessDataEntityImpl.getRootName() + "', ref = '" + string + "'");
        BdeRequest bdeRequest = new BdeRequest(businessDataEntityImpl.getRootName(), BDE_M_DELETE_REFERENCE);
        bdeRequest.setControlAreaTag("referenceID", string);
        BdeReply bdeReply = null;
        bdeReply = this.executeBdeRequest(bdeRequest, false);
        businessDataEntityImpl.setReference(null);
    }

    public Element doBdeCall(String string, String string2, Element element) throws Exception {
        BaanDLLCallImpl baanDLLCallImpl = new BaanDLLCallImpl();
        baanDLLCallImpl.setDLL(string);
        baanDLLCallImpl.setMethod(string2, null, "data");
        baanDLLCallImpl.addParameterOWDOMElement(element, "in", null, "elements", null);
        baanDLLCallImpl.addParameter(string2 + TAG_RESPONSE, "out", null, "elements", null, null);
        baanDLLCallImpl.addParameter(TAG_RESULT, "out", null, "elements", null, null);
        DataSet dataSet = null;
        try {
            dataSet = this.m_impl.retrieveData(baanDLLCallImpl);
        }
        catch (Exception exception) {
            throw new Exception("Error occured while processing call BDE='" + string + "' method='" + string2 + "'; " + exception);
        }
        if (dataSet == null) {
            throw new Exception("No reply dataset received from backend");
        }
        Tuple tuple = dataSet.getFirstTuple();
        if (tuple == null) {
            throw new Exception("No 'tuple' found in reply dataset");
        }
        BusinessElement businessElement = tuple.getOriginal();
        if (businessElement == null) {
            throw new Exception("No 'old' element found in tuple in reply dataset");
        }
        String string3 = businessElement.getTagName();
        BusinessElement businessElement2 = (BusinessElement)businessElement.getFirstChild();
        while (businessElement2 != null) {
            if (this.hasChildElements(businessElement2)) {
                return businessElement2;
            }
            businessElement2 = this.nextSibling(businessElement2);
        }
        s_logger.message("BDE CLIENT: No BDE Response or BDE Reply present in Reply busdoc, returning null");
        return null;
    }

    private boolean hasChildElements(BusinessElement businessElement) {
        if (businessElement.hasChildNodes()) {
            NodeList nodeList = businessElement.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n) instanceof BusinessElement) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private BusinessElement nextSibling(BusinessElement businessElement) {
        Node node = businessElement;
        do {
            if (!((node = node.getNextSibling()) instanceof BusinessElement)) continue;
            return node;
        } while (node != null);
        return null;
    }

    static {
        LoggerFactory.setApplicationName("BDE_Client");
    }
}

