/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.NodeList;
import com.ssaglobal.bdeimpl.generic.BdeFilterImpl;
import com.ssaglobal.bdeimpl.generic.BdeImplCommunicationException;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeImplResultException;
import com.ssaglobal.bdeimpl.generic.BdeManager;
import com.ssaglobal.bdeimpl.generic.BdeProxyManager;
import com.ssaglobal.bdeimpl.generic.BdeSelectionImpl;
import com.ssaglobal.bdeimpl.generic.BusinessDataEntityImpl;
import com.ssaglobal.bdeimpl.generic.impl.BdeReply;
import com.ssaglobal.bdeimpl.generic.impl.BdeRequest;
import com.ssaglobal.bdeimpl.generic.impl.ControlArea;
import java.util.Vector;

public class BdeIteratorImpl {
    private static final String STD_MTD_LIST = "List";
    private static final String CONTROL_TAG_MAXNUMBER_OBJECTS = "maxNumberOfObjects";
    private BdeManager m_impl;
    private IBatch m_currentBatch;
    private String m_BdeName;
    private String m_methodName;
    private BdeSelectionImpl m_selection;
    private BdeFilterImpl m_filter;
    private int m_iteratorFetchSize;

    public BdeIteratorImpl(BdeProxyManager bdeProxyManager, int n, String string) throws BdeImplCommunicationException, BdeImplResultException {
        this(bdeProxyManager, n, string, STD_MTD_LIST);
    }

    public BdeIteratorImpl(BdeProxyManager bdeProxyManager, int n, String string, String string2) throws BdeImplCommunicationException, BdeImplResultException {
        this.m_impl = bdeProxyManager;
        this.m_selection = bdeProxyManager.getSelection();
        this.m_filter = bdeProxyManager.getFilter();
        this.m_BdeName = string;
        this.m_methodName = string2;
        this.m_currentBatch = this.doFirstRequest(n);
    }

    public BdeIteratorImpl(NodeList nodeList) {
        this.m_currentBatch = new BatchSimple(nodeList);
    }

    public BdeIteratorImpl(BdeManager bdeManager, BdeSelectionImpl bdeSelectionImpl, BusinessDataEntityImpl businessDataEntityImpl, String string, String string2) throws BdeImplCommunicationException, BdeImplResultException {
        this.m_impl = bdeManager;
        this.m_BdeName = string;
        this.m_methodName = string2;
        this.m_iteratorFetchSize = this.m_impl.getIteratorFetchSize();
        BdeRequest bdeRequest = new BdeRequest(this.m_BdeName, this.m_methodName);
        bdeRequest.setSelection(bdeSelectionImpl);
        if (businessDataEntityImpl != null) {
            bdeRequest.setBde(businessDataEntityImpl.getRoot());
        }
        BdeReply bdeReply = this.m_impl.executeBdeRequest(bdeRequest, true);
        Vector vector = bdeReply.getBdes();
        this.m_currentBatch = new Batch(null, vector);
    }

    public boolean hasMoreElements() {
        boolean bl = this.m_currentBatch.hasMoreBdes();
        boolean bl2 = this.m_currentBatch.isLastBatch();
        return bl || !bl2;
    }

    public Element nextElement() throws BdeImplException, BdeImplCommunicationException, BdeImplResultException {
        if (this.m_currentBatch.hasMoreBdes()) {
            return this.m_currentBatch.getNextBde();
        }
        if (this.m_currentBatch.isLastBatch()) {
            return null;
        }
        this.m_currentBatch = this.doNextRequest((Batch)this.m_currentBatch);
        return this.nextElement();
    }

    private Batch getBatch(BdeRequest bdeRequest) throws BdeImplCommunicationException, BdeImplResultException {
        Object object;
        BdeReply bdeReply = this.m_impl.executeBdeRequest(bdeRequest, true);
        ControlArea controlArea = bdeReply.getControlArea();
        if (controlArea != null && (object = controlArea.getControlAreaTagValue("iteratorFetchSize")) != null) {
            this.m_iteratorFetchSize = Integer.parseInt((String)object);
        }
        object = bdeReply.getBdes();
        return new Batch(controlArea, (Vector)object);
    }

    private Batch doFirstRequest(int n) throws BdeImplCommunicationException, BdeImplResultException {
        this.m_iteratorFetchSize = this.m_impl.getIteratorFetchSize();
        BdeRequest bdeRequest = new BdeRequest(this.m_BdeName, this.m_methodName);
        bdeRequest.setSelection(this.m_selection);
        bdeRequest.setFilter(this.m_filter);
        if (n >= 0) {
            bdeRequest.setControlAreaTag(CONTROL_TAG_MAXNUMBER_OBJECTS, "" + n);
        }
        bdeRequest.setControlAreaTag("iteratorFetchSize", "" + this.m_iteratorFetchSize);
        return this.getBatch(bdeRequest);
    }

    private IBatch doNextRequest(Batch batch) throws BdeImplCommunicationException, BdeImplResultException {
        ControlArea controlArea = batch.m_controlArea;
        controlArea.setControlAreaTag("iteratorFetchSize", "" + this.m_iteratorFetchSize);
        BdeRequest bdeRequest = new BdeRequest(this.m_BdeName, this.m_methodName, controlArea);
        return this.getBatch(bdeRequest);
    }

    private class BatchSimple
    implements IBatch {
        private NodeList m_Data;
        private int counter = 0;

        BatchSimple(NodeList nodeList) {
            this.m_Data = nodeList;
        }

        public Element getNextBde() {
            if (this.counter < this.m_Data.getLength()) {
                ++this.counter;
                return (Element)this.m_Data.item(this.counter - 1);
            }
            return null;
        }

        public boolean isLastBatch() {
            return true;
        }

        public boolean hasMoreBdes() {
            return this.counter < this.m_Data.getLength();
        }
    }

    private class Batch
    implements IBatch {
        public ControlArea m_controlArea;
        private Vector m_Bdes;

        Batch(ControlArea controlArea, Vector vector) {
            this.m_controlArea = controlArea;
            this.m_Bdes = vector;
        }

        public Element getNextBde() {
            Element element = (Element)this.m_Bdes.get(0);
            this.m_Bdes.remove(0);
            return element;
        }

        public boolean isLastBatch() {
            if (this.m_controlArea != null && this.m_controlArea.hasTags()) {
                return this.m_controlArea.getControlAreaTagValue("iteratorID") == null;
            }
            return true;
        }

        public boolean hasMoreBdes() {
            return this.m_Bdes.size() != 0;
        }
    }

    static interface IBatch {
        public Element getNextBde();

        public boolean isLastBatch();

        public boolean hasMoreBdes();
    }
}

