/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.generic;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.exception.BusException;
import com.eibus.services.guid.standard.NearEnoughGuidFactory;
import com.ssaglobal.bdeimpl.generic.BdeImplCommunicationException;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeImplResultException;
import com.ssaglobal.bdeimpl.generic.ErrorEvent;
import com.ssaglobal.bdeimpl.generic.Event;
import com.ssaglobal.bdeimpl.generic.impl.BdeReply;
import com.ssaglobal.bdeimpl.generic.impl.BdeRequest;
import com.ssaglobal.bdeimpl.java.DateParser;
import java.util.Date;

public class BdeEventManager {
    private BusinessDocumentManager m_impl;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeimpl.generic", "BdeEventManager");
    private static final String LOG_PREFIX = "BDE Event Producer: ";
    private String m_BuscomponentId = null;
    private boolean m_initialized = false;

    private BdeEventManager() {
    }

    public BdeEventManager(String string) {
        this.m_BuscomponentId = string;
    }

    public boolean ping() throws BdeImplCommunicationException {
        try {
            this.checkInitialized();
            s_logger.message("BDE Event Producer: pinging backend");
            this.m_impl.ping();
            return true;
        }
        catch (BusException busException) {
            return false;
        }
    }

    public void close() {
        try {
            if (this.m_initialized) {
                s_logger.message("BDE Event Producer: Closing BDE Manager");
                this.m_impl.close();
                this.m_initialized = false;
            }
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE Event Producer: Error closing manager, " + busException.getMessage());
        }
    }

    private void checkInitialized() throws BdeImplCommunicationException {
        if (this.m_initialized) {
            return;
        }
        this.initialize();
        this.m_initialized = true;
    }

    private void initialize() throws BdeImplCommunicationException {
        try {
            s_logger.message("BDE Event Producer: Initialize BDE EventManager with BusComponent '" + this.m_BuscomponentId + "'");
            this.m_impl = new BusinessDocumentManager();
            this.m_impl.initialize(this.m_BuscomponentId);
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE Event Producer: Error Initialize BDE Event Manager with BusComponent '" + this.m_BuscomponentId + "' :" + busException.getMessage());
            throw new BdeImplCommunicationException(busException.getMessage());
        }
    }

    private void prepareEvent(Event event) throws BdeImplException {
        if (event.getContentType().length() == 0) {
            event.setContentType("bde");
        }
        if (event.getRequestID().length() == 0) {
            event.setRequestID(new NearEnoughGuidFactory().createGuidString());
        }
        if (event.getTimeStamp().length() == 0) {
            event.setTimeStamp(DateParser.getIsoDate(new Date()));
        }
        if (event.getConsumer().length() == 0) {
            event.setConsumer(this.m_impl.getCurrentBackend());
        }
    }

    protected void publishErrorEvent(Event event) {
        s_logger.message("BDE Event Producer: Trying to send Error Event in context of BC '" + this.m_BuscomponentId + "'");
        ErrorEvent errorEvent = new ErrorEvent(event);
        errorEvent.send(this.m_BuscomponentId);
    }

    void _publishErrorEvent(Event event) throws BdeImplCommunicationException, BdeImplException {
        this.checkInitialized();
        this.prepareEvent(event);
        event.setEntity("Message");
        event.prepareForSending();
        s_logger.message("BDE Event Producer: Making errorEvent call to Message Bde");
        BdeRequest bdeRequest = new BdeRequest("Message", "onEvent");
        bdeRequest.setControlAreaTags(event.getControlArea());
        bdeRequest.setDataArea(event.getDataArea());
        try {
            event.prepareForSending();
            this.executeBdeRequest(bdeRequest);
        }
        catch (BdeImplResultException bdeImplResultException) {}
    }

    protected void publishEvent(Event event) {
        try {
            this.checkInitialized();
            this.prepareEvent(event);
            event.prepareForSending();
            String string = event.getEntity();
            s_logger.message("BDE Event Producer: Making event call for bde with name '" + string + "'");
            BdeRequest bdeRequest = new BdeRequest(string, "onEvent");
            bdeRequest.setControlAreaTags(event.getControlArea());
            bdeRequest.setDataArea(event.getDataArea());
            this.executeBdeRequest(bdeRequest);
        }
        catch (Exception exception) {
            String string = this.m_impl.getCurrentBackend();
            s_logger.message("BDE Event Producer: Error occured while publishing event to buscomponent '" + string + "'");
            ErrorEvent.processPublisherEventException(string, exception, event.getRoot());
        }
    }

    void executeBdeRequest(BdeRequest bdeRequest) throws BdeImplCommunicationException, BdeImplResultException {
        try {
            s_logger.message("BDE Event Producer: Execute BDE Event Request");
            BdeReply bdeReply = new BdeReply(this.m_impl.retrieveData(bdeRequest));
        }
        catch (BusApplicationException busApplicationException) {
            s_logger.errorMessage("BDE Event Producer: Cannot execute BDE Event Request, " + busApplicationException.toString());
            throw new BdeImplCommunicationException(busApplicationException.toString());
        }
        catch (BusException busException) {
            s_logger.errorMessage("BDE Event Producer: Cannot execute BDE Event Request, " + busException.getMessage());
            throw new BdeImplCommunicationException(busException.getMessage());
        }
    }
}

