/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeimpl.baanerp;

import com.baan.b3.dom.Element;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.eibus.services.datatypes.XMLNode;
import com.ssaglobal.bdeimpl.baanerp.Listener;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.Event;
import java.util.Hashtable;

public class EventManager {
    static final char HEADER_START = 'E';
    private static final String HEADER_E_CREATE_MANAGER = "E.createEventManager";
    private static final String HEADER_E_DESTROY = "E.destroy";
    private static final String HEADER_E_CLOSE = "E.close";
    private static final String HEADER_E_PUBLISH_EVENT = "E.publishEvent";
    private static final String HEADER_E_PUBLISH_ERROR_EVENT = "E.publishErrorEvent";
    private static final String HEADER_E_PING = "E.ping";
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$bdeimpl$baanerp$EventManager == null ? (class$com$ssaglobal$bdeimpl$baanerp$EventManager = EventManager.class$("com.ssaglobal.bdeimpl.baanerp.EventManager")) : class$com$ssaglobal$bdeimpl$baanerp$EventManager);
    private static final String LOG_PREFIX = "BaanERP (java) EventManager: ";
    private static final String SEPARATOR = ";";
    private Hashtable m_EventManagers = null;
    private Listener m_listener;
    private int m_ManagerCounter = 1;
    static /* synthetic */ Class class$com$ssaglobal$bdeimpl$baanerp$EventManager;

    public EventManager(Listener listener) {
        this.m_listener = listener;
        this.m_EventManagers = new Hashtable();
    }

    IBucket dispatch(String string, IBucket iBucket) throws Exception {
        if (string.equals(HEADER_E_CREATE_MANAGER)) {
            return this.createEventManager(iBucket.toString());
        }
        if (string.equals(HEADER_E_CLOSE)) {
            return this.close(iBucket.toString());
        }
        if (string.equals(HEADER_E_DESTROY)) {
            return this.destroy(iBucket.toString());
        }
        if (string.equals(HEADER_E_PING)) {
            return this.ping(iBucket.toString());
        }
        if (string.startsWith(HEADER_E_PUBLISH_EVENT)) {
            String string2 = string.substring(HEADER_E_PUBLISH_EVENT.length());
            return this.publishEvent(string2, iBucket.getBucket());
        }
        if (string.startsWith(HEADER_E_PUBLISH_ERROR_EVENT)) {
            String string3 = string.substring(HEADER_E_PUBLISH_ERROR_EVENT.length());
            return this.publishError(string3, iBucket.getBucket());
        }
        return null;
    }

    private BdeEventManager getBdeEventManager(String string) throws Exception {
        BdeEventManager bdeEventManager = (BdeEventManager)this.m_EventManagers.get(string);
        if (bdeEventManager == null) {
            throw new Exception("invalid BdeEventManager ID '" + string + "'");
        }
        return bdeEventManager;
    }

    private IBucket createEventManager(String string) {
        s_logger.flowMessage("BaanERP (java) EventManager: Make new BdeEventManager with BusComponent '" + string + "'");
        BdeEventManager bdeEventManager = new BdeEventManager(string);
        int n = this.m_ManagerCounter++;
        this.m_EventManagers.put("" + n, bdeEventManager);
        int n2 = this.m_EventManagers.size();
        s_logger.flowMessage("BaanERP (java) EventManager: create new, Id='" + n + "', # event managers " + (n2 - 1) + "->" + n2);
        return BucketUtils.newMessage("" + n);
    }

    private IBucket close(String string) throws Exception {
        s_logger.message("BaanERP (java) EventManager: close Id='" + string + "'");
        BdeEventManager bdeEventManager = this.getBdeEventManager(string);
        bdeEventManager.close();
        return BucketUtils.newMessage("Ok");
    }

    private IBucket destroy(String string) {
        s_logger.message("BaanERP (java) EventManager: destroy removing reference with id '" + string + "', # event managers = " + this.m_EventManagers.size());
        this.m_EventManagers.remove(string);
        s_logger.flowMessage("BaanERP (java) EventManager: destroy #refs after removal = " + this.m_EventManagers.size());
        return BucketUtils.newMessage("ok");
    }

    private IBucket ping(String string) throws Exception {
        s_logger.message("BaanERP (java) EventManager: ping Id='" + string + "'");
        BdeEventManager bdeEventManager = this.getBdeEventManager(string);
        if (bdeEventManager.ping()) {
            return BucketUtils.newMessage("Ok");
        }
        return BucketUtils.newError("Error pinging");
    }

    private IBucket publishEvent(String string, byte[] byArray) throws Exception {
        s_logger.message("BaanERP (java) EventManager: publishEvent Id='" + string + "' size bytes = '" + byArray.length + "'");
        BdeEventManager bdeEventManager = this.getBdeEventManager(string);
        bdeEventManager.publishEvent(byArray);
        return BucketUtils.newMessage("Ok");
    }

    private IBucket publishError(String string, byte[] byArray) throws Exception {
        s_logger.message("BaanERP (java) EventManager: publishError Id='" + string + "' size bytes = '" + byArray.length + "'");
        BdeEventManager bdeEventManager = this.getBdeEventManager(string);
        bdeEventManager.publishErrorEvent(byArray);
        return BucketUtils.newMessage("Ok");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BdeEventManager
    extends com.ssaglobal.bdeimpl.generic.BdeEventManager {
        public BdeEventManager(String string) {
            super(string);
        }

        public void publishEvent(byte[] byArray) {
            Event event = this.ConvertXML(byArray);
            super.publishEvent(event);
        }

        public void publishErrorEvent(byte[] byArray) {
            Event event = this.ConvertXML(byArray);
            super.publishErrorEvent(event);
        }

        private Event ConvertXML(byte[] byArray) {
            s_logger.flowMessage("BaanERP (java) EventManager: Converting xml bytes(baan) to Element");
            Element element = XMLNode.FromByteArray2XmlElement(byArray);
            if (element != null) {
                try {
                    Event event = new Event(element);
                    return event;
                }
                catch (BdeImplException bdeImplException) {
                    s_logger.errorMessage("BaanERP (java) EventManager: Cannot convert xml element(baan) to valid Event, " + bdeImplException.toString());
                    s_logger.flowXml(element);
                }
            } else {
                s_logger.errorMessage("BaanERP (java) EventManager: Cannot convert xml bytes(baan) to Element");
                s_logger.flowBytes(byArray);
            }
            return null;
        }
    }
}

