/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP;

import com.baan.b3.server.DatabaseException;
import com.baan.b3.server.IDBInformation;
import com.baan.b3.server.IDBParameterMetaData;
import com.baan.b3.server.IDBRowSet;
import com.baan.b3.server.IDBRowSetMetaData;
import com.baan.b3.server.IDatabaseInstance;
import com.baan.b3.server.ServerException;
import com.baan.b3.server.ServerRuntimeInstance;
import com.baan.b3.server.ui.BaseServerUI;
import com.baan.owimpl.b3.database.ParameterMetaData;
import com.baan.owimpl.b3.database.ResultSetMetaData;
import com.baan.owimpl.b3.database.RowSet;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.activation.utils.SplitString;
import com.ssa.ow.BaanERP.BaanDBDriverAdapterComponentInfo;
import com.ssa.ow.BaanERP.DBDriver.Driver;
import com.ssa.ow.BaanERP.DBDriver.IConnection;
import com.ssa.ow.BaanERP.DBDriver.IDatabaseInformation;
import com.ssa.ow.BaanERP.DBDriver.IResultSet;
import com.ssa.ow.BaanERP.DBDriver.IResultSetMetaData;
import com.ssa.ow.BaanERP.DBDriver.IStatement;
import com.ssa.ow.BaanERP.DBDriver.SQLException;
import com.ssa.ow.BaanERP.DatabaseInformation;
import com.ssa.ow.BaanERP.DatabaseMetaDataMetaData;
import com.ssa.ow.BaanERP.Datatypes;
import com.ssa.ow.BaanERP.ServerDialog;
import java.util.Enumeration;
import java.util.Hashtable;

public class ServerInstance
extends ServerRuntimeInstance
implements IDatabaseInstance {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssa$ow$BaanERP$ServerInstance == null ? (class$com$ssa$ow$BaanERP$ServerInstance = ServerInstance.class$("com.ssa.ow.BaanERP.ServerInstance")) : class$com$ssa$ow$BaanERP$ServerInstance);
    public static int API_TYPE_ODBC2 = 0;
    public static int API_TYPE_ODBC3 = 1;
    public static int API_TYPE_JDBC = 2;
    public static int API_TYPE_OLEDB = 3;
    private int m_API_TYPE = -1;
    private ServerDialog m_Dialog = null;
    public static final String LOG_PREFIX = "ERP DB: ";
    public static final String FIELD_PREFIX = "_";
    private IConnection m_connection = null;
    private Driver m_driver = null;
    private Hashtable m_hashStements = new Hashtable();
    private static int iStatementCounter = 0;
    public static final Object SyncObject = new Object();
    static /* synthetic */ Class class$com$ssa$ow$BaanERP$ServerInstance;

    public void close() throws ServerException {
        s_logger.message("ERP DB: Close this ServerInstance");
        Enumeration enumeration2 = this.m_hashStements.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            s_logger.flowMessage("ERP DB: Close statement with Id '" + string + "'");
            IStatement iStatement = this.getStatement(string);
            try {
                iStatement.close();
            }
            catch (SQLException sQLException) {
                s_logger.errorMessage("ERP DB: Error closing statement" + sQLException.getReason());
            }
            this.m_hashStements.remove(string);
        }
        try {
            if (this.m_connection != null) {
                s_logger.message("ERP DB: Close the connection with Baan DB");
                this.m_connection.close();
            }
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error closing connection, " + sQLException.getMessage());
        }
    }

    public BaseServerUI getServerDialog() {
        return this.m_Dialog;
    }

    public ServerInstance(ServerDialog serverDialog, Driver driver) {
        this.m_Dialog = serverDialog;
        this.m_driver = driver;
    }

    public void DB_initialize(int n, String string) throws ServerException {
        this.m_API_TYPE = n;
        String string2 = "(?)";
        if (this.m_API_TYPE == API_TYPE_ODBC2) {
            string2 = "(ODBC 2.X)";
        } else if (this.m_API_TYPE == API_TYPE_ODBC3) {
            string2 = "(ODBC 3.X)";
        } else if (this.m_API_TYPE == API_TYPE_JDBC) {
            string2 = "(JDBC)";
        } else if (this.m_API_TYPE == API_TYPE_OLEDB) {
            string2 = "(OLE-DB)";
        }
        s_logger.message("ERP DB: Database Server Instance initialize for API type '" + n + "' " + string2);
        try {
            s_logger.message("ERP DB: Try to connect to Baan DB, with arument '" + string + "'");
            this.m_connection = this.m_driver.connect(string);
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error creating connection, " + sQLException.getMessage());
        }
    }

    public String DB_productName() {
        BaanDBDriverAdapterComponentInfo baanDBDriverAdapterComponentInfo = new BaanDBDriverAdapterComponentInfo();
        String string = baanDBDriverAdapterComponentInfo.getComponentName();
        s_logger.message(LOG_PREFIX + string);
        return string;
    }

    public String DB_productVersion() {
        try {
            BaanDBDriverAdapterComponentInfo baanDBDriverAdapterComponentInfo = new BaanDBDriverAdapterComponentInfo();
            String string = "OW:" + baanDBDriverAdapterComponentInfo.getVersion() + "." + baanDBDriverAdapterComponentInfo.getPatchLevel() + ",DB:" + this.m_driver.getVersion();
            s_logger.message("ERP DB: DB Driver version, " + string);
            return string;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: DB_productVersion, " + sQLException.getMessage());
            return "unknown";
        }
    }

    public IDBInformation DB_getDatabaseInformation() throws ServerException {
        try {
            IDatabaseInformation iDatabaseInformation = this.m_connection.getDatabaseInformation();
            return DatabaseInformation.fillOWDBInformation(iDatabaseInformation);
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error get database Information, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    public String DB_prepareStatement(String string) throws ServerException {
        try {
            s_logger.message("ERP DB: Trying to create new Statement");
            IStatement iStatement = this.m_connection.createStatement();
            s_logger.message("ERP DB: Trying to prepare '" + string + "'");
            iStatement.prepare(string);
            this.m_hashStements.put("" + ++iStatementCounter, iStatement);
            s_logger.message("ERP DB: Create & prepare OK, Return statementID " + iStatementCounter);
            return "" + iStatementCounter;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error creating new statement, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    public String DB_resetStatement(String string) throws ServerException {
        s_logger.message("ERP DB: Trying to reset Statement '" + string + "'");
        IStatement iStatement = this.getStatement(string);
        try {
            IResultSet iResultSet = iStatement.getResultSet();
            iResultSet.close();
            return string + " resetted";
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error resetting statement, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    public String DB_closeStatement(String string) throws ServerException {
        IStatement iStatement = this.getStatement(string);
        try {
            s_logger.message("ERP DB: Trying to close Statement '" + string + "'");
            iStatement.close();
            this.m_hashStements.remove(string);
            return string + " closed";
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error resetting statement, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    public String DB_executeStatement(String string, String[] stringArray) throws ServerException {
        s_logger.message("ERP DB: Trying to execute Statement '" + string + "'");
        try {
            IStatement iStatement = this.getStatement(string);
            if (stringArray != null && stringArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("ERP DB: process Parameters,");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(" " + n + ":'" + stringArray[n] + "'");
                    ++n;
                }
                s_logger.message(stringBuffer.toString());
                int n2 = 0;
                while (n2 < stringArray.length) {
                    s_logger.flowMessage("ERP DB: Binding parameter# " + n2 + ", '" + stringArray[n2] + "'");
                    iStatement.setString(n2 + 1, stringArray[n2]);
                    ++n2;
                }
            }
            iStatement.execute();
            return string + " executed";
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error executing statement, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    public IDBRowSet DB_fetchSet(String string, int n, int n2) throws ServerException {
        if (n2 == 1) {
            s_logger.message("ERP DB: Getting row " + n + " for StatementID " + string);
        } else {
            s_logger.message("ERP DB: Getting next Fetch for StatementID '" + string + "', start " + n + ", size " + n2);
        }
        IStatement iStatement = this.getStatement(string);
        try {
            IResultSet iResultSet = iStatement.getResultSet();
            RowSet rowSet = new RowSet();
            int n3 = iResultSet.getMetaData().numResultCols();
            int n4 = 1;
            while (n4 <= n2) {
                if (!iResultSet.next()) break;
                rowSet.addRow();
                int n5 = 1;
                while (n5 <= n3) {
                    rowSet.addField(FIELD_PREFIX + n5, iResultSet.getString(n5));
                    ++n5;
                }
                ++n4;
            }
            return rowSet;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error fetching data, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private IStatement getStatement(String string) throws ServerException {
        IStatement iStatement = (IStatement)this.m_hashStements.get(string);
        if (iStatement == null) {
            s_logger.errorMessage("ERP DB: Statement '" + string + "' not found");
            throw new ServerException("Statement with ID '" + string + "' Does not exist");
        }
        return iStatement;
    }

    public IDBRowSetMetaData DB_getRowSetMetaData(String string) throws ServerException {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            s_logger.message("ERP DB: Get DatabaseMetadata MetaData for method '" + string + "'");
            return DatabaseMetaDataMetaData.DB_getRowSetMetaData(string, this.m_API_TYPE);
        }
        s_logger.message("ERP DB: Get ResultsetMetadata for StatementID '" + string + "'");
        IStatement iStatement = this.getStatement(string);
        try {
            IResultSet iResultSet = iStatement.getResultSet();
            IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
            ResultSetMetaData resultSetMetaData = new ResultSetMetaData();
            int n2 = 1;
            while (n2 <= iResultSetMetaData.numResultCols()) {
                int n3 = Datatypes.FromBaanDBtoJDBC(iResultSetMetaData.getColumnType(n2));
                int n4 = iResultSetMetaData.getColumnLength(n2);
                resultSetMetaData.addRowFromType(n3, iResultSetMetaData.getColumnName(n2), "", n4, 2);
                ++n2;
            }
            return resultSetMetaData;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error get ResultsetMetadata, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    public IDBRowSet DB_getDataBaseMeta(String string, String[] stringArray) throws ServerException {
        s_logger.message("ERP DB: Get Database MetaData for '" + string + "'");
        if (stringArray != null && stringArray.length != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ERP DB: MetaData Parameters,");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == null) {
                    stringArray[n] = "";
                }
                stringBuffer.append(" " + n + ":'" + stringArray[n] + "'");
                ++n;
            }
            s_logger.message(stringBuffer.toString());
        }
        if (string.equals("@getTables")) {
            return this.getTables(stringArray[0], stringArray[1]);
        }
        if (string.equals("@getColumns")) {
            return this.getColumns(stringArray[0], stringArray[1]);
        }
        if (string.equals("@getSpecialColumns")) {
            return this.getSpecialColumns(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.equals("@getCrossReference")) {
            return this.getCrossReference(stringArray[0], stringArray[1]);
        }
        if (string.equals("@getExportedKeys")) {
            return this.getExportedKeys(stringArray[0]);
        }
        if (string.equals("@getImportedKeys")) {
            return this.getImportedKeys(stringArray[0]);
        }
        if (string.equals("@getPrimaryKeys")) {
            return this.getPrimaryKeys(stringArray[0]);
        }
        if (string.equals("@getIndexInfo")) {
            return this.getIndexInfo(stringArray[0], stringArray[1], stringArray[2]);
        }
        if (string.equals("@getTypeInfo")) {
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.getTypeInfo(n);
        }
        if (string.equals("@getTableTypes")) {
            return this.getTableTypes();
        }
        s_logger.errorMessage("ERP DB: unknown function '" + string + "' in DB_getDataBaseMeta");
        throw new ServerException("unknown function '" + string + "' in DB_getDataBaseMeta");
    }

    public IDBParameterMetaData DB_getParameterMetaData(String string) throws ServerException {
        s_logger.message("ERP DB: getParameterMetaData for statementID " + string);
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        try {
            IStatement iStatement = this.getStatement(string);
            int n = iStatement.numParameters();
            int n2 = 0;
            while (n2 < n) {
                int n3 = iStatement.getParameterType(n2 + 1);
                n3 = Datatypes.FromBaanDBtoJDBC(n3);
                switch (n3) {
                    case 4: {
                        s_logger.flowMessage("ERP DB: adding Type to ParameterMetadata, " + n3 + ", " + "INTEGER");
                        parameterMetaData.addParameterMetaDataRow(1, n3, "INTEGER", 4, 0, 0, true);
                        break;
                    }
                    case 12: {
                        s_logger.flowMessage("ERP DB: adding Type to ParameterMetadata, " + n3 + ", " + "VARCHAR");
                        parameterMetaData.addParameterMetaDataRow(1, n3, "VARCHAR", 3092, 0, 0, false);
                        break;
                    }
                    case 8: {
                        s_logger.flowMessage("ERP DB: adding Type to ParameterMetadata, " + n3 + ", " + "DOUBLE");
                        parameterMetaData.addParameterMetaDataRow(1, n3, "DOUBLE", 8, 0, 0, true);
                        break;
                    }
                    case 91: {
                        if (this.m_API_TYPE == API_TYPE_ODBC2) {
                            n3 = 9;
                        }
                        s_logger.flowMessage("ERP DB: adding Type to ParameterMetadata, " + n3 + ", " + "DATE");
                        parameterMetaData.addParameterMetaDataRow(1, n3, "DATE", 6, 0, 0, false);
                        break;
                    }
                    case 93: {
                        if (this.m_API_TYPE == API_TYPE_ODBC2) {
                            n3 = 11;
                        }
                        s_logger.flowMessage("ERP DB: adding Type to ParameterMetadata, " + n3 + ", " + "TIMESTAMP");
                        parameterMetaData.addParameterMetaDataRow(1, n3, "TIMESTAMP", 16, 0, 0, false);
                    }
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getParameterMetaData, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
        return parameterMetaData;
    }

    private String strip(String string) {
        while (string.endsWith("'") || string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        while (string.startsWith("'") || string.startsWith(" ")) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    private IDBRowSet getTables(String string, String string2) throws ServerException {
        if (string.equals("") && string2.equals("%")) {
            RowSet rowSet = new RowSet();
            if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
                rowSet.addTableRowODBC("", "TABLE", "");
                rowSet.addTableRowODBC("", "SYSTEM TABLE", "");
            }
            if (this.m_API_TYPE == API_TYPE_JDBC) {
                rowSet.addTableRowJDBC("", "TABLE", "");
                rowSet.addTableRowJDBC("", "SYSTEM TABLE", "");
            }
            return rowSet;
        }
        try {
            IResultSet iResultSet;
            Object object;
            if (!string2.equals("")) {
                object = new SplitString(string2, ",");
                String[] stringArray = ((SplitString)object).getParts();
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = this.strip(stringArray[n]);
                    ++n;
                }
                iResultSet = this.m_connection.getDatabaseMetaData().getTables(string, stringArray);
            } else {
                iResultSet = this.m_connection.getDatabaseMetaData().getTables(string);
            }
            object = new RowSet();
            while (iResultSet.next()) {
                if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
                    object.addTableRowODBC(iResultSet.getString(1), iResultSet.getString(2), iResultSet.getString(3));
                }
                if (this.m_API_TYPE != API_TYPE_JDBC) continue;
                object.addTableRowJDBC(iResultSet.getString(1), iResultSet.getString(2), iResultSet.getString(3));
            }
            iResultSet.close();
            return object;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getTables, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private IDBRowSet getTableTypes() throws ServerException {
        RowSet rowSet = new RowSet();
        rowSet.addRow();
        rowSet.addField("TABLE_TYPE", "TABLE");
        rowSet.addRow();
        rowSet.addField("TABLE_TYPE", "SYSTEM TABLE");
        return rowSet;
    }

    private IDBRowSet getColumns(String string, String string2) throws ServerException {
        s_logger.message("ERP DB: getColumns tableNamePattern '" + string + "', columnNamePattern '" + string2 + "'");
        if (string.length() == 0) {
            s_logger.errorMessage("Try to call getColumns without table name '" + string + "'");
            throw new DatabaseException("Invalid use of null pointer (Table name not specified)", "HY009", 0);
        }
        try {
            IResultSet iResultSet = this.m_connection.getDatabaseMetaData().getColumns(string);
            RowSet rowSet = new RowSet();
            while (iResultSet.next()) {
                int n = Integer.parseInt(iResultSet.getString(3));
                String string3 = Datatypes.FromBaanDBtoJDBCString(n);
                n = Datatypes.FromBaanDBtoJDBC(n);
                int n2 = Integer.parseInt(iResultSet.getString(4));
                int n3 = Integer.parseInt(iResultSet.getString(5));
                if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
                    switch (n) {
                        case 4: {
                            rowSet.addColumnRowODBC(null, null, iResultSet.getString(1), iResultSet.getString(2), (short)n, string3, new Integer(10), new Integer(4), new Short(0), new Short(10), (short)0, iResultSet.getString(6), null, (short)n, null, null, n3, "NO");
                            break;
                        }
                        case 12: {
                            rowSet.addColumnRowODBC(null, null, iResultSet.getString(1), iResultSet.getString(2), (short)n, string3, new Integer(n2), new Integer(n2), null, null, (short)0, iResultSet.getString(6), null, (short)n, null, null, n3, "NO");
                            break;
                        }
                        case 8: {
                            rowSet.addColumnRowODBC(null, null, iResultSet.getString(1), iResultSet.getString(2), (short)n, string3, new Integer(15), new Integer(8), null, new Short(2), (short)0, iResultSet.getString(6), null, (short)n, null, null, n3, "NO");
                            break;
                        }
                        case 91: {
                            if (this.m_API_TYPE == API_TYPE_ODBC2) {
                                n = 9;
                            }
                            rowSet.addColumnRowODBC(null, null, iResultSet.getString(1), iResultSet.getString(2), (short)n, string3, new Integer(10), new Integer(6), null, null, (short)0, iResultSet.getString(6), null, (short)n, null, null, n3, "NO");
                            break;
                        }
                        case 93: {
                            if (this.m_API_TYPE == API_TYPE_ODBC2) {
                                n = 11;
                            }
                            rowSet.addColumnRowODBC(null, null, iResultSet.getString(1), iResultSet.getString(2), (short)n, string3, new Integer(19), new Integer(16), null, null, (short)0, iResultSet.getString(6), null, (short)n, null, null, n3, "NO");
                        }
                    }
                }
                if (this.m_API_TYPE != API_TYPE_JDBC) continue;
                switch (n) {
                    case 4: {
                        rowSet.addColumnRowJDBC(null, null, iResultSet.getString(1), iResultSet.getString(2), n, string3, 10, 0, 0, 10, 0, iResultSet.getString(6), null, n, 0, 0, n3, "NO");
                        break;
                    }
                    case 12: {
                        rowSet.addColumnRowJDBC(null, null, iResultSet.getString(1), iResultSet.getString(2), n, string3, n2, 0, 0, 0, 0, iResultSet.getString(6), null, n, 0, 0, n3, "NO");
                        break;
                    }
                    case 8: {
                        rowSet.addColumnRowJDBC(null, null, iResultSet.getString(1), iResultSet.getString(2), n, string3, 15, 0, 0, 2, 0, iResultSet.getString(6), null, n, 0, 0, n3, "NO");
                        break;
                    }
                    case 91: {
                        rowSet.addColumnRowJDBC(null, null, iResultSet.getString(1), iResultSet.getString(2), n, string3, 10, 0, 0, 0, 0, iResultSet.getString(6), null, n, 0, 0, n3, "NO");
                        break;
                    }
                    case 93: {
                        rowSet.addColumnRowJDBC(null, null, iResultSet.getString(1), iResultSet.getString(2), n, string3, 19, 0, 0, 0, 0, iResultSet.getString(6), null, n, 0, 0, n3, "NO");
                    }
                }
            }
            iResultSet.close();
            return rowSet;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getColumns, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private IDBRowSet getSpecialColumns(String string, String string2, String string3, String string4) throws ServerException {
        RowSet rowSet = new RowSet();
        return rowSet;
    }

    private IDBRowSet getPrimaryKeys(String string) throws ServerException {
        s_logger.message("ERP DB: getPrimaryKeys tableName '" + string + "'");
        if (string.length() == 0) {
            s_logger.errorMessage("Try to call getPrimaryKeys without table name '" + string + "'");
            throw new DatabaseException("Invalid use of null pointer (Table name not specified)", "HY009", 0);
        }
        try {
            IResultSet iResultSet = this.m_connection.getDatabaseMetaData().getPrimaryKeys(string);
            RowSet rowSet = new RowSet();
            while (iResultSet.next()) {
                String string2 = iResultSet.getString(3);
                short s = Short.parseShort(string2);
                rowSet.addPrimaryKeyRowODBC(null, null, iResultSet.getString(1), iResultSet.getString(2), s, iResultSet.getString(4));
            }
            iResultSet.close();
            return rowSet;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getPrimaryKeys, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private IDBRowSet getIndexInfo(String string, String string2, String string3) throws ServerException {
        s_logger.message("ERP DB: getPrimaryKeys tableName '" + string + "'");
        if (string.length() == 0) {
            s_logger.errorMessage("Try to call getIndexInfo without table name '" + string + "'");
            throw new DatabaseException("Invalid use of null pointer (Table name not specified)", "HY009", 0);
        }
        try {
            IResultSet iResultSet = this.m_connection.getDatabaseMetaData().getPrimaryKeys(string);
            RowSet rowSet = new RowSet();
            while (iResultSet.next()) {
                String string4 = iResultSet.getString(3);
                Short s = new Short(Short.parseShort(string4));
                String string5 = iResultSet.getString(4);
                int n = string5.indexOf(46);
                if (n > 0) {
                    string5 = string5.substring(n + 1);
                }
                if (this.m_API_TYPE == API_TYPE_JDBC) {
                    rowSet.addIndexInfoRowJDBC(null, null, iResultSet.getString(1), false, null, string5, (short)1, s, iResultSet.getString(2), null, 0, 0, null);
                    continue;
                }
                rowSet.addIndexInfoRowODBC(null, null, iResultSet.getString(1), (short)0, null, string5, (short)1, s, iResultSet.getString(2), null, 0, 0, null);
            }
            iResultSet.close();
            return rowSet;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getIndexInfo, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private IDBRowSet getImportedKeys(String string) throws ServerException {
        s_logger.message("ERP DB: getImportedKeys tableName '" + string + "'");
        if (string.length() == 0) {
            s_logger.errorMessage("Try to call getImportedKeys without table name '" + string + "'");
            throw new DatabaseException("Invalid use of null pointer (Table name not specified)", "HY009", 0);
        }
        try {
            IResultSet iResultSet = this.m_connection.getDatabaseMetaData().getImportedKeys(string);
            RowSet rowSet = new RowSet();
            while (iResultSet.next()) {
                this.addForeignKey(rowSet, iResultSet);
            }
            iResultSet.close();
            return rowSet;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getImportedKeys, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private IDBRowSet getExportedKeys(String string) throws ServerException {
        s_logger.message("ERP DB: getExportedKeys tableName '" + string + "'");
        if (string.length() == 0) {
            s_logger.errorMessage("Try to call getExportedKeys without table name '" + string + "'");
            throw new DatabaseException("Invalid use of null pointer (Table name not specified)", "HY009", 0);
        }
        try {
            IResultSet iResultSet = this.m_connection.getDatabaseMetaData().getExportedKeys(string);
            RowSet rowSet = new RowSet();
            while (iResultSet.next()) {
                this.addForeignKey(rowSet, iResultSet);
            }
            iResultSet.close();
            return rowSet;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getExportedKeys, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private IDBRowSet getCrossReference(String string, String string2) throws ServerException {
        s_logger.message("ERP DB: getCrossReference pkTableName '" + string + "', fkTableName '" + string2 + "'");
        if (string.length() == 0 || string2.length() == 0) {
            s_logger.errorMessage("Try to call getCrossReference without table name '" + string + "', '" + string2 + "'");
            throw new DatabaseException("Invalid use of null pointer (Table name not specified)", "HY009", 0);
        }
        try {
            IResultSet iResultSet = this.m_connection.getDatabaseMetaData().getCrossReference(string, string2);
            RowSet rowSet = new RowSet();
            while (iResultSet.next()) {
                this.addForeignKey(rowSet, iResultSet);
            }
            iResultSet.close();
            return rowSet;
        }
        catch (SQLException sQLException) {
            s_logger.errorMessage("ERP DB: Error getCrossReference, " + sQLException.getMessage());
            throw new DatabaseException(sQLException.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    private void addForeignKey(IDBRowSet iDBRowSet, IResultSet iResultSet) throws SQLException {
        String string = iResultSet.getString(5);
        short s = Short.parseShort(string);
        String string2 = iResultSet.getString(6);
        short s2 = Short.parseShort(string2);
        String string3 = iResultSet.getString(7);
        short s3 = Short.parseShort(string3);
        if (this.m_API_TYPE == API_TYPE_ODBC2) {
            if (s3 == 3) {
                s3 = 1;
            }
            if (s2 == 3) {
                s2 = 1;
            }
        }
        iDBRowSet.addForeignKeyODBC(null, null, iResultSet.getString(1), iResultSet.getString(2), null, null, iResultSet.getString(3), iResultSet.getString(4), s, new Short(s2), new Short(s3), iResultSet.getString(8), iResultSet.getString(9), new Short(7));
    }

    private IDBRowSet getTypeInfo(int n) {
        s_logger.message("ERP DB: getTypeInfo," + n);
        RowSet rowSet = new RowSet();
        switch (n) {
            case 0: {
                this.addType_INTEGER(rowSet);
                this.addType_DOUBLE(rowSet);
                this.addType_VARCHAR(rowSet);
                this.addType_DATE(rowSet);
                this.addType_TIMESTAMP(rowSet);
                break;
            }
            case 4: {
                this.addType_INTEGER(rowSet);
                break;
            }
            case 8: {
                this.addType_DOUBLE(rowSet);
                break;
            }
            case 12: {
                this.addType_VARCHAR(rowSet);
                break;
            }
            case 91: {
                this.addType_DATE(rowSet, (short)91);
                break;
            }
            case 93: {
                this.addType_TIMESTAMP(rowSet, (short)93);
                break;
            }
            case 9: {
                this.addType_TIMESTAMP(rowSet, (short)9);
                break;
            }
            case 11: {
                this.addType_TIMESTAMP(rowSet, (short)11);
            }
        }
        return rowSet;
    }

    private void addType_INTEGER(IDBRowSet iDBRowSet) {
        if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
            iDBRowSet.addTypeRowODBC("INTEGER", (short)4, new Integer(10), null, null, null, (short)0, (short)0, (short)2, new Short(0), (short)0, new Short(0), null, new Short(0), new Short(0), (short)4, null, new Integer(10), null);
        }
        if (this.m_API_TYPE == API_TYPE_JDBC) {
            iDBRowSet.addTypeRowJDBC("INTEGER", 4, 10, null, null, null, (short)0, false, (short)2, false, false, false, null, (short)0, (short)0, 4, null, 10);
        }
    }

    private void addType_DOUBLE(IDBRowSet iDBRowSet) {
        if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
            iDBRowSet.addTypeRowODBC("DOUBLE", (short)8, new Integer(15), null, null, null, (short)0, (short)0, (short)2, new Short(0), (short)0, new Short(0), null, new Short(0), new Short(0), (short)8, null, new Integer(10), null);
        }
        if (this.m_API_TYPE == API_TYPE_JDBC) {
            iDBRowSet.addTypeRowJDBC("DOUBLE", 8, 15, null, null, null, (short)0, false, (short)2, false, false, false, null, (short)0, (short)0, 8, null, 10);
        }
    }

    private void addType_VARCHAR(IDBRowSet iDBRowSet) {
        if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
            iDBRowSet.addTypeRowODBC("VARCHAR", (short)12, new Integer(3092), null, null, null, (short)0, (short)1, (short)3, null, (short)0, null, null, new Short(0), new Short(0), (short)12, null, null, null);
        }
        if (this.m_API_TYPE == API_TYPE_JDBC) {
            iDBRowSet.addTypeRowJDBC("VARCHAR", 12, 3092, null, null, null, (short)0, true, (short)2, false, false, false, null, (short)0, (short)0, 12, null, 0);
        }
    }

    private void addType_DATE(IDBRowSet iDBRowSet) {
        if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
            if (this.m_API_TYPE == API_TYPE_ODBC2) {
                this.addType_DATE(iDBRowSet, (short)9);
            } else {
                this.addType_DATE(iDBRowSet, (short)91);
            }
        }
        if (this.m_API_TYPE == API_TYPE_JDBC) {
            iDBRowSet.addTypeRowJDBC("DATE", 91, 10, "DATE '", "'", null, (short)0, false, (short)2, false, false, false, null, (short)0, (short)0, 91, null, 0);
        }
    }

    private void addType_TIMESTAMP(IDBRowSet iDBRowSet) {
        if (this.m_API_TYPE == API_TYPE_ODBC2 || this.m_API_TYPE == API_TYPE_ODBC3) {
            if (this.m_API_TYPE == API_TYPE_ODBC2) {
                this.addType_TIMESTAMP(iDBRowSet, (short)11);
            } else {
                this.addType_TIMESTAMP(iDBRowSet, (short)93);
            }
        }
        if (this.m_API_TYPE == API_TYPE_JDBC) {
            iDBRowSet.addTypeRowJDBC("TIMESTAMP", 93, 19, "TIMESTAMP '", "'", null, (short)0, false, (short)2, false, false, false, null, (short)0, (short)0, 93, null, 0);
        }
    }

    private void addType_DATE(IDBRowSet iDBRowSet, short s) {
        iDBRowSet.addTypeRowODBC("DATE", s, new Integer(12), "DATE '", "'", null, (short)0, (short)0, (short)2, null, (short)0, null, null, new Short(0), new Short(0), s, null, null, null);
    }

    private void addType_TIMESTAMP(IDBRowSet iDBRowSet, short s) {
        iDBRowSet.addTypeRowODBC("TIMESTAMP", s, new Integer(21), "TIMESTAMP '", "'", null, (short)0, (short)0, (short)2, null, (short)0, null, null, new Short(0), new Short(0), s, null, null, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

