/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP;

import com.baan.b3.server.IServerApplicationCallBack;
import com.baan.b3.server.IServerRuntime;
import com.baan.b3.server.ServerActivationCallBack;
import com.baan.b3.server.ServerLicenseException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.ow.BaanERP.BaanDBDriverAdapterComponentInfo;
import com.ssa.ow.BaanERP.ServerImpl;
import java.io.IOException;

public class Server
implements IServerApplicationCallBack {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssa$ow$BaanERP$Server == null ? (class$com$ssa$ow$BaanERP$Server = Server.class$("com.ssa.ow.BaanERP.Server")) : class$com$ssa$ow$BaanERP$Server);
    public static String ASM_PORT;
    public static String LOG_PREFIX;
    private static String ERROR_PREFIX;
    static /* synthetic */ Class class$com$ssa$ow$BaanERP$Server;

    public Server(String string) {
        IServerRuntime iServerRuntime = null;
        try {
            iServerRuntime = new ServerImpl(this, null);
            iServerRuntime.enableDeactivation();
        }
        catch (ServerLicenseException serverLicenseException) {
            s_logger.message(LOG_PREFIX + "Cannot start, License Error: " + serverLicenseException);
            this.StopAndExit(serverLicenseException.toString());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            iServerRuntime.stopServerRuntime();
            this.StopAndExit(unsatisfiedLinkError.getMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            s_logger.message(LOG_PREFIX + "Cannot start, Dependencies not found: " + noClassDefFoundError);
            this.StopAndExit("Cannot start, Dependencies not found (OW Adapter Java Toolkit), Check your installation");
        }
        catch (Exception exception) {
            s_logger.message(LOG_PREFIX + "Cannot start, Configuration Error: " + exception.getMessage());
            this.StopAndExit(exception.getMessage());
        }
        int n = iServerRuntime.startComponent(string);
        if (n < 0) {
            this.StopAndExit("An error occured while starting BusComponent '" + string + "'");
        }
        try {
            System.out.println("Press any key to stop Server ...");
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        iServerRuntime.stopComponent(n);
        iServerRuntime.stopServerRuntime();
    }

    private void StopAndExit(String string) {
        s_logger.message(LOG_PREFIX + string);
        System.out.println(string);
        System.exit(1);
    }

    public Server(String string, ServerActivationCallBack serverActivationCallBack) {
        ServerImpl serverImpl = null;
        try {
            serverImpl = new ServerImpl(this, null);
        }
        catch (ServerLicenseException serverLicenseException) {
            s_logger.message(LOG_PREFIX + "License error, " + serverLicenseException.toString());
            serverActivationCallBack.setActivationError(ERROR_PREFIX + serverLicenseException.toString());
            serverActivationCallBack.returnActivationError();
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            s_logger.message(LOG_PREFIX + "NoClassDefFoundError error, Check your installation");
            serverActivationCallBack.setActivationError(ERROR_PREFIX + "NoClassDefFoundError error, Check your installation");
            serverActivationCallBack.returnActivationError();
            return;
        }
        catch (Exception exception) {
            s_logger.message(LOG_PREFIX + "Configuration error, " + exception.getMessage());
            serverActivationCallBack.setActivationError(ERROR_PREFIX + exception.getMessage());
            serverActivationCallBack.returnActivationError();
            return;
        }
        serverImpl.startActivationComponent(string, serverActivationCallBack);
    }

    public void output(String string) {
        System.out.println(string);
    }

    public void error(String string) {
        System.out.println(string);
    }

    public static void PrintNameAndVersion() {
        BaanDBDriverAdapterComponentInfo baanDBDriverAdapterComponentInfo = new BaanDBDriverAdapterComponentInfo();
        System.out.println();
        System.out.println("SSA Technology Architecture " + baanDBDriverAdapterComponentInfo.getComponentName());
        System.out.println("Version: " + baanDBDriverAdapterComponentInfo.getVersion() + "." + baanDBDriverAdapterComponentInfo.getPatchLevel());
        System.out.println();
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 1 || stringArray.length != 3) {
            // empty if block
        }
        if (stringArray.length == 1) {
            Server.PrintNameAndVersion();
            string = stringArray[0];
            s_logger.message(LOG_PREFIX + "Starting BC='" + string + "'");
            new Server(string);
        } else if (stringArray.length == 3) {
            String string3 = stringArray[1];
            if (ASM_PORT.equalsIgnoreCase(string3)) {
                string = stringArray[0];
                string2 = stringArray[2];
                s_logger.message(LOG_PREFIX + "Starting with ASM Activation BC='" + string + "' Generated-Port='" + string2 + "'");
                ServerActivationCallBack serverActivationCallBack = ServerActivationCallBack.getActivationCallBackASM();
                int n = Integer.parseInt(string2);
                serverActivationCallBack.setASMPortNr(n);
                new Server(string, serverActivationCallBack);
            } else {
                s_logger.message(LOG_PREFIX + "Wrong arguments passed. expecting '" + ASM_PORT + "'");
                Server.PrintNameAndVersion();
                System.out.println("usage : Server <BusComponentId> [-asmp <Generated Port #>]");
                System.exit(1);
            }
        } else {
            Server.PrintNameAndVersion();
            System.out.println("usage : Server <BusComponentId> [-asmp <Generated Port Nr>]");
            s_logger.message(LOG_PREFIX + "Started with incorrect arguments, showing usage.");
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_BAAN_DB_DRIVER);
        ASM_PORT = "-asmp";
        LOG_PREFIX = "ERP DB: ";
        ERROR_PREFIX = "Error, ";
    }
}

