/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP.DBDriver.test;

import com.ssa.ow.BaanERP.DBDriver.DataType;
import com.ssa.ow.BaanERP.DBDriver.Driver;
import com.ssa.ow.BaanERP.DBDriver.IConnection;
import com.ssa.ow.BaanERP.DBDriver.IDatabaseInformation;
import com.ssa.ow.BaanERP.DBDriver.IDatabaseMetaData;
import com.ssa.ow.BaanERP.DBDriver.IResultSet;
import com.ssa.ow.BaanERP.DBDriver.IResultSetMetaData;
import com.ssa.ow.BaanERP.DBDriver.IStatement;
import com.ssa.ow.BaanERP.DBDriver.SQLException;

public class Test {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0 || stringArray[0].equals("-help")) {
                System.out.println("ODBC DB Driver test");
                System.out.println("Arguments:");
                System.out.println("-help (or no arguments)             : Print usage");
                System.out.println("-all                                : Run default test sequence");
                System.out.println("-query <query> [-compnr <compnr>]   : Execute query");
                System.out.println("-query <query> [-options <options>] : Execute query with options");
                System.out.println("-tables [<pattern>] [-type <type>*] : Get tables");
                System.out.println("-columns <table>                    : Get columns");
            } else if (stringArray[0].equals("-all")) {
                String string = "select * from ttaad200 as set with 5 rows";
                String string2 = "COMPNR=0";
                Test.testQuery(string, string2);
                Test.testTables("ttaa%");
                String string3 = "ttaad200";
                Test.testColumns(string3);
                Test.testDatabaseInformation();
                Test.testPrimaryKeys(string3);
                Test.testImportedKeys(string3);
                Test.testExportedKeys(string3);
                Test.testCrossReference(string3, "ttaad306");
            } else if (stringArray[0].equals("-query") && stringArray.length > 1) {
                String string = stringArray[1];
                String string4 = "";
                if (stringArray.length > 3 && stringArray[2].equals("-compnr")) {
                    string4 = "COMPNR=" + stringArray[3];
                } else if (stringArray.length > 3 && stringArray[2].equals("-options")) {
                    string4 = stringArray[3];
                }
                Test.testQuery(string, string4);
            } else if (stringArray[0].equals("-tables")) {
                boolean bl;
                String string = "";
                int n = 1;
                boolean bl2 = bl = stringArray.length > n && !stringArray[n].equals("-type");
                if (bl) {
                    string = stringArray[1];
                    ++n;
                }
                boolean bl3 = stringArray.length > n && stringArray[n].equals("-type");
                String[] stringArray2 = null;
                if (bl3) {
                    int n2 = stringArray.length - ++n;
                    stringArray2 = new String[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        stringArray2[n3] = stringArray[n++];
                        ++n3;
                    }
                }
                if (stringArray2 == null) {
                    Test.testTables(string);
                } else {
                    Test.testTables(string, stringArray2);
                }
            } else if (stringArray[0].equals("-columns") && stringArray.length > 1) {
                String string = stringArray[1];
                Test.testColumns(string);
            } else {
                System.err.println("Unknown command-line options");
            }
            Test.testVersion();
            Driver.getDriver().close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.toString());
        }
    }

    private static void testVersion() throws SQLException {
        System.out.println();
        Driver driver = Driver.getDriver();
        String string = driver.getVersion();
        System.out.println("Version info: " + string);
    }

    private static void testQuery(String string, String string2) throws SQLException {
        System.out.println();
        System.out.println("Query: " + string);
        System.out.println("Options: " + string2);
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect(string2);
        IStatement iStatement = iConnection.createStatement();
        IResultSetMetaData iResultSetMetaData = iStatement.prepare(string);
        Test.PrintResultSetMetaData(iResultSetMetaData);
        IResultSet iResultSet = iStatement.execute();
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iStatement.close();
        iConnection.close();
    }

    private static void testDatabaseInformation() throws SQLException {
        System.out.println();
        System.out.println("Access database metadata");
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseInformation iDatabaseInformation = iConnection.getDatabaseInformation();
        int n = iDatabaseInformation.getMaxCatalogNameLength();
        System.out.println("Max Catalog Name Length: " + n);
        iConnection.close();
    }

    private static void testTables(String string) throws SQLException {
        System.out.println();
        System.out.println("Table name pattern: " + string);
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
        IResultSet iResultSet = iDatabaseMetaData.getTables(string);
        IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
        Test.PrintResultSetMetaData(iResultSetMetaData);
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iConnection.close();
        System.out.println();
    }

    private static void testTables(String string, String[] stringArray) throws SQLException {
        System.out.println();
        System.out.println("Table name pattern: " + string);
        System.out.print("Types:");
        int n = 0;
        while (n < stringArray.length) {
            System.out.print(" '" + stringArray[n] + "'");
            ++n;
        }
        System.out.println();
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
        IResultSet iResultSet = iDatabaseMetaData.getTables(string, stringArray);
        IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
        Test.PrintResultSetMetaData(iResultSetMetaData);
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iConnection.close();
    }

    private static void testColumns(String string) throws SQLException {
        System.out.println();
        System.out.println("Get column metadata of table: " + string);
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
        IResultSet iResultSet = iDatabaseMetaData.getColumns(string);
        IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
        iResultSetMetaData = iResultSet.getMetaData();
        Test.PrintResultSetMetaData(iResultSetMetaData);
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iConnection.close();
    }

    private static void testPrimaryKeys(String string) throws SQLException {
        System.out.println();
        System.out.println("Get primary keys of table: " + string);
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
        IResultSet iResultSet = iDatabaseMetaData.getPrimaryKeys(string);
        IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
        Test.PrintResultSetMetaData(iResultSetMetaData);
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iConnection.close();
    }

    private static void testCrossReference(String string, String string2) throws SQLException {
        System.out.println();
        System.out.println("Get cross reference of tables: " + string + " and " + string2);
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
        IResultSet iResultSet = iDatabaseMetaData.getCrossReference(string, string2);
        IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
        Test.PrintResultSetMetaData(iResultSetMetaData);
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iConnection.close();
    }

    private static void testImportedKeys(String string) throws SQLException {
        System.out.println();
        System.out.println("Get imported keys of table: " + string);
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
        IResultSet iResultSet = iDatabaseMetaData.getImportedKeys(string);
        IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
        Test.PrintResultSetMetaData(iResultSetMetaData);
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iConnection.close();
    }

    private static void testExportedKeys(String string) throws SQLException {
        System.out.println();
        System.out.println("Get exported keys of table: " + string);
        Driver driver = Driver.getDriver();
        IConnection iConnection = driver.connect("");
        IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
        IResultSet iResultSet = iDatabaseMetaData.getExportedKeys(string);
        IResultSetMetaData iResultSetMetaData = iResultSet.getMetaData();
        Test.PrintResultSetMetaData(iResultSetMetaData);
        Test.PrintResultSet(iResultSet);
        iResultSet.close();
        iConnection.close();
    }

    public static void PrintResultSetMetaData(IResultSetMetaData iResultSetMetaData) throws SQLException {
        int n;
        int n2 = iResultSetMetaData.numResultCols();
        System.out.println("nColumns=" + n2);
        System.out.print("Column names:");
        int n3 = 1;
        while (n3 <= n2) {
            String string = iResultSetMetaData.getColumnName(n3);
            System.out.print(" " + string);
            ++n3;
        }
        System.out.println();
        System.out.print("Column types:");
        int n4 = 1;
        while (n4 <= n2) {
            n = iResultSetMetaData.getColumnType(n4);
            DataType dataType = new DataType(n);
            System.out.print(" " + dataType);
            ++n4;
        }
        System.out.println();
        System.out.print("Column lengths:");
        n = 1;
        while (n <= n2) {
            int n5 = iResultSetMetaData.getColumnLength(n);
            System.out.print(" " + n5);
            ++n;
        }
        System.out.println();
    }

    public static void PrintResultSet(IResultSet iResultSet) throws SQLException {
        int n = iResultSet.getMetaData().numResultCols();
        int n2 = 0;
        while (iResultSet.next()) {
            System.out.print("Row " + ++n2 + ":");
            int n3 = 1;
            while (n3 <= n) {
                String string = iResultSet.getString(n3);
                System.out.print(" (" + string + ")");
                ++n3;
            }
            System.out.println();
        }
    }
}

