/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP.DBDriver.impl;

import com.ssa.ow.BaanERP.DBDriver.SQLException;
import com.ssa.ow.BaanERP.DBDriver.impl.ResultSet;
import com.ssa.ow.BaanERP.DBDriver.jni.Cpp;

public class StatementResultSet
extends ResultSet {
    private int m_StatementId = -1;
    private int m_OriginalNumResultCols;
    private int m_ExposedNumResultCols;
    private int[] m_OriginalColumnDepth = new int[0];
    private int[] m_FromExposedToOriginalColumn = new int[0];
    private int[] m_FromExposedColumnToArrayIndex = new int[0];
    private String[] m_ExposedColumnName = new String[0];
    private int[] m_ExposedColumnType = new int[0];
    private int[] m_ExposedColumnLength = new int[0];

    StatementResultSet(int n) throws SQLException {
        int n2;
        int n3;
        int n4;
        this.m_StatementId = n;
        this.m_OriginalNumResultCols = Cpp.StatementNumResultCols(this.m_StatementId);
        this.m_OriginalColumnDepth = new int[this.m_OriginalNumResultCols];
        int n5 = 0;
        while (n5 < this.m_OriginalNumResultCols) {
            this.m_OriginalColumnDepth[n5] = n4 = Cpp.StatementGetColumnDepth(this.m_StatementId, n5);
            this.m_ExposedNumResultCols += n4;
            ++n5;
        }
        this.m_FromExposedToOriginalColumn = new int[this.m_ExposedNumResultCols];
        this.m_FromExposedColumnToArrayIndex = new int[this.m_ExposedNumResultCols];
        n4 = 0;
        int n6 = 0;
        while (n6 < this.m_OriginalNumResultCols) {
            n3 = this.m_OriginalColumnDepth[n6];
            n2 = 0;
            while (n2 < n3) {
                this.m_FromExposedToOriginalColumn[n4] = n6;
                this.m_FromExposedColumnToArrayIndex[n4] = n3 == 1 ? -1 : n2;
                ++n4;
                ++n2;
            }
            ++n6;
        }
        this.m_ExposedColumnName = new String[this.m_ExposedNumResultCols];
        this.m_ExposedColumnType = new int[this.m_ExposedNumResultCols];
        this.m_ExposedColumnLength = new int[this.m_ExposedNumResultCols];
        n3 = 0;
        while (n3 < this.m_ExposedNumResultCols) {
            n2 = this.m_FromExposedToOriginalColumn[n3];
            String string = Cpp.StatementGetColumnName(this.m_StatementId, n2);
            int n7 = this.m_FromExposedColumnToArrayIndex[n3];
            if (n7 >= 0) {
                int n8 = n7 + 1;
                string = string + "(" + n8 + ")";
            }
            this.m_ExposedColumnName[n3] = string;
            this.m_ExposedColumnType[n3] = Cpp.StatementGetColumnType(this.m_StatementId, n2);
            this.m_ExposedColumnLength[n3] = Cpp.StatementGetColumnLength(this.m_StatementId, n2);
            ++n3;
        }
    }

    public void close() throws SQLException {
        Cpp.StatementBreak(this.m_StatementId);
    }

    public String getString(int n) throws SQLException {
        if (n < 1 || n > this.m_ExposedNumResultCols) {
            throw this.GetException("StatementResultSet.getString() failed, invalid column index: " + n);
        }
        int n2 = this.m_FromExposedToOriginalColumn[--n];
        int n3 = this.m_FromExposedColumnToArrayIndex[n];
        if (n3 < 0) {
            return Cpp.StatementGetValue(this.m_StatementId, n2);
        }
        return Cpp.StatementGetArrayValue(this.m_StatementId, n2, n3);
    }

    public boolean next() throws SQLException {
        return Cpp.StatementFetch(this.m_StatementId);
    }

    public int numResultCols() {
        return this.m_ExposedNumResultCols;
    }

    public String getColumnName(int n) throws SQLException {
        if (n < 1 || n > this.m_ExposedNumResultCols) {
            throw this.GetException("StatementResultSet.getColumnName() failed, invalid column index: " + n);
        }
        return this.m_ExposedColumnName[n - 1];
    }

    public int getColumnLength(int n) throws SQLException {
        if (n < 1 || n > this.m_ExposedNumResultCols) {
            throw this.GetException("StatementResultSet.getColumnLength() failed, invalid column index: " + n);
        }
        return this.m_ExposedColumnLength[n - 1];
    }

    public int getColumnType(int n) throws SQLException {
        if (n < 1 || n > this.m_ExposedNumResultCols) {
            throw this.GetException("StatementResultSet.getColumnType() failed, invalid column index: " + n);
        }
        return this.m_ExposedColumnType[n - 1];
    }
}

