/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP.DBDriver.impl;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.ow.BaanERP.DBDriver.IResultSet;
import com.ssa.ow.BaanERP.DBDriver.IResultSetMetaData;
import com.ssa.ow.BaanERP.DBDriver.IStatement;
import com.ssa.ow.BaanERP.DBDriver.Options;
import com.ssa.ow.BaanERP.DBDriver.SQLException;
import com.ssa.ow.BaanERP.DBDriver.impl.Connection;
import com.ssa.ow.BaanERP.DBDriver.impl.StatementResultSet;
import com.ssa.ow.BaanERP.DBDriver.jni.Cpp;

public class Statement
implements IStatement {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssa$ow$BaanERP$DBDriver$impl$Statement == null ? (class$com$ssa$ow$BaanERP$DBDriver$impl$Statement = Statement.class$("com.ssa.ow.BaanERP.DBDriver.impl.Statement")) : class$com$ssa$ow$BaanERP$DBDriver$impl$Statement);
    private static final String s_prefix = "erpdb - ";
    private Connection m_Connection = null;
    private int m_StatementId = -1;
    private int m_SessionId = -1;
    private IResultSet m_ResultSet = null;
    private Options m_Options = null;
    private boolean m_Closed = true;
    static /* synthetic */ Class class$com$ssa$ow$BaanERP$DBDriver$impl$Statement;

    Statement(Connection connection, int n, Options options) throws SQLException {
        s_logger.flowMessage("erpdb - Statement(sessionId=" + n + ")");
        this.m_Connection = connection;
        this.m_SessionId = n;
        this.m_Options = options;
        this.m_StatementId = Cpp.StatementCreate();
        this.m_Closed = false;
    }

    public void close() throws SQLException {
        s_logger.flowMessage("erpdb - Statement.close()");
        if (!this.m_Closed) {
            int n = this.m_StatementId;
            this.m_StatementId = -1;
            this.m_SessionId = -1;
            this.m_Closed = true;
            Cpp.StatementClose(n);
            this.m_Connection.unregisterStatement(this);
        }
    }

    public IResultSetMetaData prepare(String string) throws SQLException {
        s_logger.flowMessage("erpdb - Statement.prepare()");
        s_logger.flowMessage("erpdb - Query text: " + string);
        this.checkStatus("prepare()");
        Cpp.StatementPrepare(this.m_StatementId, string, this.m_SessionId);
        this.m_ResultSet = new StatementResultSet(this.m_StatementId);
        return this.m_ResultSet.getMetaData();
    }

    public IResultSet execute() throws SQLException {
        s_logger.flowMessage("erpdb - Statement.execute()");
        this.checkStatus("execute()");
        Cpp.StatementExecute(this.m_StatementId, this.m_Options.GetCompany());
        return this.m_ResultSet;
    }

    public void setQueryTimeout(int n) throws SQLException {
        s_logger.flowMessage("erpdb - Statement.setQueryTimeout(seconds=" + n + ")");
        this.checkStatus("setQueryTimeout()");
        Cpp.StatementSetQueryTimeout(this.m_StatementId, n);
    }

    public int numParameters() throws SQLException {
        s_logger.flowMessage("erpdb - Statement.numParameters()");
        this.checkStatus("numParameters()");
        return Cpp.StatementNumParameters(this.m_StatementId);
    }

    public int getParameterType(int n) throws SQLException {
        s_logger.flowMessage("erpdb - Statement.getParameterType(index=" + n + ")");
        this.checkStatus("getParameterType()");
        int n2 = n - 1;
        int n3 = Cpp.StatementGetParameterType(this.m_StatementId, n2);
        s_logger.flowMessage("erpdb - ParameterType for index=" + n + ", = (baan) " + n3);
        return n3;
    }

    public void setString(int n, String string) throws SQLException {
        s_logger.flowMessage("erpdb - Statement.setString(index=" + n + ",value=" + string + ")");
        this.checkStatus("setString()");
        int n2 = n - 1;
        Cpp.StatementBindParameter(this.m_StatementId, n2, string);
    }

    public IResultSet getResultSet() throws SQLException {
        this.checkStatus("getResultSet()");
        return this.m_ResultSet;
    }

    private void checkStatus(String string) throws SQLException {
        if (this.m_Closed) {
            SQLException sQLException = new SQLException(s_prefix + string + " called on closed statement");
            s_logger.errorException(sQLException);
            throw sQLException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

