/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP.DBDriver.impl;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.ow.BaanERP.DBDriver.Driver;
import com.ssa.ow.BaanERP.DBDriver.IConnection;
import com.ssa.ow.BaanERP.DBDriver.IDatabaseInformation;
import com.ssa.ow.BaanERP.DBDriver.IDatabaseMetaData;
import com.ssa.ow.BaanERP.DBDriver.IResultSet;
import com.ssa.ow.BaanERP.DBDriver.IStatement;
import com.ssa.ow.BaanERP.DBDriver.Options;
import com.ssa.ow.BaanERP.DBDriver.SQLException;
import com.ssa.ow.BaanERP.DBDriver.impl.DatabaseInformation;
import com.ssa.ow.BaanERP.DBDriver.impl.DatabaseMetaData;
import com.ssa.ow.BaanERP.DBDriver.impl.Statement;
import com.ssa.ow.BaanERP.DBDriver.jni.Cpp;
import java.util.Hashtable;
import java.util.Vector;

public class Connection
implements IConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssa$ow$BaanERP$DBDriver$impl$Connection == null ? (class$com$ssa$ow$BaanERP$DBDriver$impl$Connection = Connection.class$("com.ssa.ow.BaanERP.DBDriver.impl.Connection")) : class$com$ssa$ow$BaanERP$DBDriver$impl$Connection);
    private static final String s_prefix = "erpdb - ";
    private static final String m_SessionNamePrefix = "jbdb_";
    private static int m_NextSessionId = 1;
    private static Hashtable m_CachePackageVRCs = new Hashtable();
    private String m_PackageComb = null;
    private String m_LanguageCode = null;
    private Driver m_Driver;
    private Options m_Options;
    private String m_SessionName;
    private int m_SessionId = -1;
    private boolean m_Closed = true;
    private boolean m_CompanyMode = false;
    Vector m_AllStatements = new Vector();
    static /* synthetic */ Class class$com$ssa$ow$BaanERP$DBDriver$impl$Connection;

    public Connection(Driver driver, Options options) throws SQLException {
        s_logger.flowMessage("erpdb - Connection()");
        this.m_Driver = driver;
        this.m_Options = options;
        this.m_CompanyMode = this.m_Options.GetSingleCompanyMode();
        this.StartSession(options);
        this.m_Closed = false;
    }

    public void close() throws SQLException {
        s_logger.flowMessage("erpdb - Connection.close()");
        this.closeAllStatements();
        if (!this.m_Closed) {
            this.StopSession();
            this.m_Closed = true;
            this.m_Driver.unregisterConnection(this);
        }
    }

    public String getPackageCombination() throws SQLException {
        if (this.m_PackageComb == null) {
            this.m_PackageComb = Cpp.get_package_combination();
        }
        return this.m_PackageComb;
    }

    public String getLanguage() throws SQLException {
        if (this.m_LanguageCode == null) {
            this.m_LanguageCode = "" + new Character((char)Cpp.get_language());
        }
        return this.m_LanguageCode;
    }

    public String getPackageVRC(String string) throws SQLException {
        String string2 = (String)m_CachePackageVRCs.get(string);
        if (string2 == null) {
            s_logger.message("erpdb - Query for package VRC for package '" + string + "'");
            String string3 = "select (ttadv112.cpac || ttadv112.vers || ttadv112.rele || ttadv112.cust) from ttadv112 where {ttadv112.pacc, ttadv112.cpac, ttadv112.sequ} = {'" + this.getPackageCombination() + "', '" + string + "', 1} and ttadv112.company_nr = 0";
            IStatement iStatement = this.createStatement();
            iStatement.prepare(string3);
            IResultSet iResultSet = iStatement.execute();
            iResultSet.next();
            string2 = iResultSet.getString(1);
            iResultSet.close();
            iStatement.close();
            m_CachePackageVRCs.put(string, string2);
            s_logger.message("erpdb - Found Package VRC for package '" + string + "' = '" + string2 + "'");
        }
        return string2;
    }

    public IStatement createStatement() throws SQLException {
        s_logger.flowMessage("erpdb - Connection.createStatement()");
        this.checkStatus("createStatement()");
        Statement statement = new Statement(this, this.m_SessionId, this.m_Options);
        this.registerStatement(statement);
        return statement;
    }

    public IDatabaseMetaData getDatabaseMetaData() throws SQLException {
        s_logger.flowMessage("erpdb - Connection.getDatabaseMetaData()");
        this.checkStatus("getDatabaseMetaData()");
        return new DatabaseMetaData(this);
    }

    public IDatabaseInformation getDatabaseInformation() throws SQLException {
        s_logger.flowMessage("erpdb - Connection.getDatabaseInformation()");
        this.checkStatus("getDatabaseInformation()");
        return new DatabaseInformation();
    }

    public boolean isClosed() throws SQLException {
        s_logger.flowMessage("erpdb - Connection.isClosed()");
        return this.m_Closed;
    }

    public boolean isReadOnly() throws SQLException {
        s_logger.flowMessage("erpdb - Connection.isReadOnly()");
        this.checkStatus("isReadOnly()");
        return true;
    }

    private void StartSession(Options options) throws SQLException {
        this.m_SessionName = m_SessionNamePrefix + m_NextSessionId++;
        s_logger.flowMessage("erpdb - bdb_start_session(" + this.m_SessionName + ")");
        this.m_SessionId = Cpp.bdb_start_session(this.m_SessionName, options.GetOptions());
    }

    private void StopSession() throws SQLException {
        s_logger.flowMessage("erpdb - bdb_stop_session(" + this.m_SessionId + ")");
        int n = this.m_SessionId;
        this.m_SessionId = -1;
        Cpp.bdb_stop_session(n);
    }

    private void checkStatus(String string) throws SQLException {
        if (this.m_Closed) {
            SQLException sQLException = new SQLException(s_prefix + string + " called on closed connection");
            s_logger.errorException(sQLException);
            throw sQLException;
        }
    }

    private void closeAllStatements() throws SQLException {
        int n = this.m_AllStatements.size();
        s_logger.flowMessage("erpdb - closeAllStatements, count: " + n);
        while (this.m_AllStatements.size() > 0) {
            Statement statement = (Statement)this.m_AllStatements.firstElement();
            statement.close();
        }
    }

    private void registerStatement(Statement statement) {
        this.m_AllStatements.addElement(statement);
        s_logger.flowMessage("erpdb - registerStatement, new count: " + this.m_AllStatements.size());
    }

    public void unregisterStatement(Statement statement) {
        this.m_AllStatements.removeElement(statement);
        s_logger.flowMessage("erpdb - unregisterStatement, new count: " + this.m_AllStatements.size());
    }

    public boolean isSingleCompanyMode() {
        return this.m_CompanyMode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

