/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP.DBDriver;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.ow.BaanERP.DBDriver.IConnection;
import com.ssa.ow.BaanERP.DBDriver.Options;
import com.ssa.ow.BaanERP.DBDriver.SQLException;
import com.ssa.ow.BaanERP.DBDriver.impl.Connection;
import com.ssa.ow.BaanERP.DBDriver.jni.Cpp;
import java.util.Vector;

public class Driver {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssa$ow$BaanERP$DBDriver$Driver == null ? (class$com$ssa$ow$BaanERP$DBDriver$Driver = Driver.class$("com.ssa.ow.BaanERP.DBDriver.Driver")) : class$com$ssa$ow$BaanERP$DBDriver$Driver);
    public static final String s_prefix = "erpdb - ";
    private static final String m_DriverName = "jbdb";
    private static Driver m_Driver = null;
    private boolean m_Closed = true;
    Vector m_AllConnections = new Vector();
    static /* synthetic */ Class class$com$ssa$ow$BaanERP$DBDriver$Driver;

    public static synchronized Driver getDriver() throws SQLException {
        s_logger.flowMessage("erpdb - Driver.getDriver()");
        if (m_Driver == null) {
            try {
                m_Driver = new Driver();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                SQLException sQLException = new SQLException("Jbdb class not found (" + noClassDefFoundError.getMessage() + ")");
                s_logger.errorMessage(s_prefix + sQLException.getMessage());
                throw sQLException;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                SQLException sQLException = new SQLException("Jbdb shared library not found (" + unsatisfiedLinkError.getMessage() + ")");
                s_logger.errorMessage(s_prefix + sQLException.getMessage());
                throw sQLException;
            }
        }
        return m_Driver;
    }

    private Driver() throws SQLException {
        this.Init();
        this.Logon();
        this.m_Closed = false;
    }

    public void close() throws SQLException {
        s_logger.flowMessage("erpdb - Driver.close()");
        this.closeAllConnections();
        this.Logoff();
    }

    public synchronized IConnection connect(String string) throws SQLException {
        s_logger.flowMessage("erpdb - Driver.connect(" + string + ")");
        this.checkStatus("connect()");
        Options options = new Options(string);
        Connection connection = new Connection(this, options);
        this.registerConnection(connection);
        return connection;
    }

    private void Init() throws SQLException {
        s_logger.flowMessage("erpdb - bdb_init_api(jbdb)");
        Cpp.bdb_init_api(m_DriverName);
    }

    private void Logon() throws SQLException {
        String string = System.getProperty("user.name");
        s_logger.flowMessage("erpdb - bdb_logon(" + string + ")");
        Cpp.bdb_logon(string);
    }

    private void Logoff() throws SQLException {
        s_logger.flowMessage("erpdb - bdb_logoff()");
        Cpp.bdb_logoff();
    }

    public String getVersion() throws SQLException {
        s_logger.flowMessage("erpdb - getVersion()");
        this.checkStatus("getVersion()");
        return Cpp.get_version();
    }

    private void checkStatus(String string) throws SQLException {
        if (this.m_Closed) {
            SQLException sQLException = new SQLException(string + " called on closed driver");
            s_logger.errorMessage(s_prefix + sQLException.getMessage());
            throw sQLException;
        }
    }

    private void closeAllConnections() throws SQLException {
        int n = this.m_AllConnections.size();
        s_logger.flowMessage("erpdb - closeAllConnections, count: " + n);
        while (this.m_AllConnections.size() > 0) {
            Connection connection = (Connection)this.m_AllConnections.firstElement();
            connection.close();
        }
    }

    private void registerConnection(Connection connection) {
        this.m_AllConnections.addElement(connection);
        s_logger.flowMessage("erpdb - registerConnection, new count: " + this.m_AllConnections.size());
    }

    public void unregisterConnection(Connection connection) {
        this.m_AllConnections.removeElement(connection);
        s_logger.flowMessage("erpdb - unregisterConnection, new count: " + this.m_AllConnections.size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

