/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.ow.BaanERP.DBDriver;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.ow.BaanERP.DBDriver.Driver;
import com.ssa.ow.BaanERP.DBDriver.IConnection;
import com.ssa.ow.BaanERP.DBDriver.IResultSet;
import com.ssa.ow.BaanERP.DBDriver.IStatement;
import com.ssa.ow.BaanERP.DBDriver.SQLException;
import java.util.Hashtable;

public class Description {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssa$ow$BaanERP$DBDriver$Description == null ? (class$com$ssa$ow$BaanERP$DBDriver$Description = Description.class$("com.ssa.ow.BaanERP.DBDriver.Description")) : class$com$ssa$ow$BaanERP$DBDriver$Description);
    private static final String s_prefix = "erpdb - ";
    private static String s_packageComb = null;
    private static final String LABEL_TYPE_TABLE_DESC = "2";
    private static final String LABEL_TYPE_FIELD_DESC = "1";
    private static final String LABEL_COMPANY_NUMBER = "Company Number";
    private static final String LABEL_REC_LAST_MOD_TIME = "Record Last Modification Time";
    private static boolean s_isRegerUp = true;
    private static IConnection m_Connection = null;
    private static IStatement m_StatementTableDescription = null;
    private static IStatement m_StatementColumnDescription = null;
    private static IStatement m_StatementColumnDescrReference = null;
    private static IStatement m_StatementTableDescrReference = null;
    private static IStatement m_StatementFieldLabelByPackageVRC = null;
    private static IStatement m_StatementTableLabelByPackageVRC = null;
    private static Hashtable m_CacheTableDescription = new Hashtable();
    private static Hashtable m_CacheColumnDescription = new Hashtable();
    static /* synthetic */ Class class$com$ssa$ow$BaanERP$DBDriver$Description;

    private static void Init() throws SQLException {
        if (m_Connection == null) {
            s_logger.flowMessage("erpdb - Create a connection for fetching descriptions");
            m_Connection = Driver.getDriver().connect("COMPNR=0");
            try {
                IStatement iStatement = m_Connection.createStatement();
                iStatement.prepare("Select ttadv420.zb_clab from ttadv420");
                iStatement.close();
            }
            catch (SQLException sQLException) {
                s_isRegerUp = false;
            }
            s_logger.message("Tools version is Reger and higher = " + s_isRegerUp);
            s_packageComb = m_Connection.getPackageCombination();
            s_logger.message("erpdb - Descriptions will be retreived using Package Combination '" + s_packageComb + "'");
        }
    }

    public static synchronized String TableDescription(String string) throws SQLException {
        String string2 = (String)m_CacheTableDescription.get(string);
        if (string2 == null) {
            Description.Init();
            string2 = s_isRegerUp ? Description.QueryTableDescriptionRegerUp(string) : Description.QueryTableDescriptionTillReger(string);
            m_CacheTableDescription.put(string, string2);
        }
        return string2;
    }

    private static String QueryTableDescriptionRegerUp(String string) throws SQLException {
        String string2 = string;
        String string3 = string.substring(0, 2);
        String string4 = m_Connection.getPackageVRC(string3);
        String string5 = Description.QueryTableLabelRefUsingTableFields(string, string4);
        if (string5.length() != 0) {
            s_logger.message("erpdb - Table Description for " + string + ", using reference " + string5);
            string2 = string5;
        } else {
            string2 = string.substring(2, 8);
        }
        String string6 = Description.getTableLabelByPackageVRC(string2, string3, string4);
        if (string6 == null) {
            string6 = string;
            s_logger.message("Could not find table descr for " + string + " for pvrc " + string4);
        }
        return string6;
    }

    public static String getTableLabelByPackageVRC(String string, String string2, String string3) throws SQLException {
        Object object;
        if (m_StatementTableLabelByPackageVRC == null) {
            object = "select ttadv140.desc, ttadv140.leng, ttadv113.pvrc, ttadv113.sequ from ttadv140, ttadv113 where ttadv113.pvrc = :1 and ttadv113.sequ <= 40 and ttadv140.clan = '" + m_Connection.getLanguage() + "' and " + "ttadv140.cpac = :2 and " + "ttadv140.clab = :3 and " + "ttadv140.expi = 2 and " + "ttadv140.zc_cont = " + LABEL_TYPE_TABLE_DESC + " and " + "ttadv140.lhgt = 1 and " + "ttadv140.leng <= 70 and " + "ttadv140.vers = ttadv113.vers and " + "ttadv140.rele = ttadv113.rele and " + "ttadv140.cust = ttadv113.cust " + "order by ttadv113.pvrc, ttadv113.sequ, ttadv140.leng desc";
            s_logger.flowMessage("erpdb - Create statement for fetching labels: " + (String)object);
            m_StatementTableLabelByPackageVRC = m_Connection.createStatement();
            m_StatementTableLabelByPackageVRC.prepare((String)object);
        }
        m_StatementTableLabelByPackageVRC.setString(1, string3);
        m_StatementTableLabelByPackageVRC.setString(2, string2);
        m_StatementTableLabelByPackageVRC.setString(3, string);
        object = m_StatementTableLabelByPackageVRC.execute();
        String string4 = null;
        try {
            if (object.next()) {
                string4 = object.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            s_logger.message("erpdb - Could not retrieve label, reason: " + sQLException);
        }
        object.close();
        return string4;
    }

    private static String QueryTableDescriptionTillReger(String string) throws SQLException {
        String string2;
        if (m_StatementTableDescription == null) {
            string2 = "select ttadv130.desc from ttadv130 where ttadv130.cpac = :1  and ttadv130.rkey = :2";
            s_logger.flowMessage("erpdb - Create statement for fetching table descriptions: " + string2);
            m_StatementTableDescription = m_Connection.createStatement();
            m_StatementTableDescription.prepare(string2);
        }
        string2 = string.substring(0, 2);
        m_StatementTableDescription.setString(1, string2);
        m_StatementTableDescription.setString(2, string.substring(2, 8));
        String string3 = string;
        IResultSet iResultSet = m_StatementTableDescription.execute();
        try {
            if (iResultSet.next()) {
                string3 = iResultSet.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            s_logger.message("erpdb - Could not retrieve table description, reason: " + sQLException);
        }
        iResultSet.close();
        return string3;
    }

    private static String[] split(String string) {
        int n = string.indexOf(40);
        if (n < 0) {
            n = string.indexOf(91);
        }
        String[] stringArray = new String[2];
        if (n < 0) {
            stringArray[0] = string;
            stringArray[1] = "";
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n);
        }
        return stringArray;
    }

    public static synchronized String ColumnDescription(String string, String string2) throws SQLException {
        s_logger.flowMessage("erpdb - ColumnDescription(" + string + ", " + string2 + ")");
        String[] stringArray = Description.split(string2);
        String string3 = string + "." + stringArray[0];
        String string4 = (String)m_CacheColumnDescription.get(string3);
        if (stringArray[0].equals("company_nr")) {
            return LABEL_COMPANY_NUMBER;
        }
        if (stringArray[0].equals("rcd_utc")) {
            return LABEL_REC_LAST_MOD_TIME;
        }
        if (string4 == null) {
            Description.Init();
            s_logger.message("erpdb - Searching description for field " + string3);
            String string5 = string.substring(0, 2);
            String string6 = string + "." + stringArray[0];
            String string7 = null;
            String string8 = null;
            if (s_isRegerUp) {
                string7 = m_Connection.getPackageVRC(string5);
                string8 = Description.QueryColumnLabelRefUsingTableFieldsRegerUp(string, stringArray[0], string7);
            } else {
                string8 = Description.QueryColumnLabelRefUsingTableFieldsTillReger(string, stringArray[0]);
            }
            if (string8 != null && string8.length() != 0) {
                s_logger.message("erpdb - Field Description for " + string3 + ", using reference " + string8);
                string6 = string8;
            }
            if ((string4 = s_isRegerUp ? Description.getFieldLabelByPackageVRCRegerUp(string6, string5, string7) : Description.getFieldLabelByPackageVRCTillReger(string6, string5)) == null) {
                string4 = string6;
                s_logger.message("Could not find field label for '" + string + "." + string2 + "' for pvrc '" + string7 + "'");
            }
            m_CacheColumnDescription.put(string3, string4);
        }
        s_logger.message("erpdb - Description for field " + string3 + " = " + string4);
        return string4 + stringArray[1];
    }

    public static String QueryTableLabelRefUsingTableFields(String string, String string2) throws SQLException {
        String string3;
        s_logger.flowMessage("Retrieve table description Ref for table " + string + ", pvrc " + string2);
        if (m_StatementTableDescrReference == null) {
            string3 = "select ttadv420.zb_clab, ttadv113.pvrc, ttadv113.sequ from ttadv420, ttadv113 where ttadv113.pvrc = :1 and ttadv420.cpac = :2 and ttadv420.cmod = :3 and ttadv420.flno = :4 and ttadv420.vers = ttadv113.vers and ttadv420.rele = ttadv113.rele and ttadv420.cust = ttadv113.cust order by ttadv113.pvrc, ttadv113.sequ, ttadv420.zb_clab";
            s_logger.flowMessage("erpdb - Create statement for fetching table label refs: " + string3);
            m_StatementTableDescrReference = m_Connection.createStatement();
            m_StatementTableDescrReference.prepare(string3);
        }
        string3 = string.substring(0, 2);
        String string4 = string.substring(2, 5);
        String string5 = string.substring(5, 8);
        m_StatementTableDescrReference.setString(1, string2);
        m_StatementTableDescrReference.setString(2, string3);
        m_StatementTableDescrReference.setString(3, string4);
        m_StatementTableDescrReference.setString(4, string5);
        IResultSet iResultSet = m_StatementTableDescrReference.execute();
        String string6 = null;
        try {
            if (iResultSet.next()) {
                string6 = iResultSet.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            s_logger.message("erpdb - Could not retrieve table description Reference, reason: " + sQLException);
        }
        iResultSet.close();
        return string6;
    }

    public static String QueryColumnLabelRefUsingTableFieldsRegerUp(String string, String string2, String string3) throws SQLException {
        String string4;
        s_logger.flowMessage("Retrieve Field description Ref for field " + string + "." + string2 + ", pvrc " + string3);
        if (m_StatementColumnDescrReference == null) {
            string4 = "select ttadv422.clab , ttadv113.pvrc, ttadv113.sequ from ttadv422, ttadv113 where ttadv113.pvrc = :1 and ttadv422.cpac = :2 and ttadv422.cmod = :3 and ttadv422.flno = :4 and ttadv422.fdnm = :5 and ttadv422.vers = ttadv113.vers and ttadv422.rele = ttadv113.rele and ttadv422.cust = ttadv113.cust order by ttadv113.pvrc, ttadv113.sequ, ttadv422.clab";
            s_logger.flowMessage("erpdb - Create statement for fetching field label refs: " + string4);
            m_StatementColumnDescrReference = m_Connection.createStatement();
            m_StatementColumnDescrReference.prepare(string4);
        }
        string4 = string.substring(0, 2);
        String string5 = string.substring(2, 5);
        String string6 = string.substring(5, 8);
        m_StatementColumnDescrReference.setString(1, string3);
        m_StatementColumnDescrReference.setString(2, string4);
        m_StatementColumnDescrReference.setString(3, string5);
        m_StatementColumnDescrReference.setString(4, string6);
        m_StatementColumnDescrReference.setString(5, string2);
        IResultSet iResultSet = m_StatementColumnDescrReference.execute();
        String string7 = null;
        try {
            if (iResultSet.next()) {
                string7 = iResultSet.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            s_logger.message("erpdb - Could not retrieve column description Reference, reason: " + sQLException);
        }
        iResultSet.close();
        return string7;
    }

    public static String getFieldLabelByPackageVRCRegerUp(String string, String string2, String string3) throws SQLException {
        Object object;
        if (m_StatementFieldLabelByPackageVRC == null) {
            object = "select ttadv140.desc, ttadv140.leng, ttadv113.pvrc, ttadv113.sequ from ttadv140, ttadv113 where ttadv113.pvrc = :1 and ttadv113.sequ <= 40 and ttadv140.clan = '" + m_Connection.getLanguage() + "' and " + "ttadv140.cpac = :2 and " + "ttadv140.clab = :3 and " + "ttadv140.expi = 2 and " + "ttadv140.zc_cont = " + LABEL_TYPE_FIELD_DESC + " and " + "ttadv140.lhgt = 1 and " + "ttadv140.leng <= 70 and " + "ttadv140.vers = ttadv113.vers and " + "ttadv140.rele = ttadv113.rele and " + "ttadv140.cust = ttadv113.cust " + "order by ttadv140.leng desc, ttadv113.pvrc, ttadv113.sequ";
            s_logger.flowMessage("erpdb - Create statement for fetching labels: " + (String)object);
            m_StatementFieldLabelByPackageVRC = m_Connection.createStatement();
            m_StatementFieldLabelByPackageVRC.prepare((String)object);
        }
        m_StatementFieldLabelByPackageVRC.setString(1, string3);
        m_StatementFieldLabelByPackageVRC.setString(2, string2);
        m_StatementFieldLabelByPackageVRC.setString(3, string);
        object = m_StatementFieldLabelByPackageVRC.execute();
        String string4 = null;
        try {
            if (object.next()) {
                string4 = object.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            s_logger.message("erpdb - Could not retrieve label, reason: " + sQLException);
        }
        object.close();
        return string4;
    }

    public static String QueryColumnLabelRefUsingTableFieldsTillReger(String string, String string2) throws SQLException {
        String string3;
        s_logger.flowMessage("Retrieve Field description Ref for field " + string + "." + string2 + ", pcomb " + s_packageComb);
        if (m_StatementColumnDescrReference == null) {
            string3 = "select ttadv422.clab, ttadv112.pacc, ttadv112.cpac from ttadv422, ttadv112 where ttadv112.pacc = '" + s_packageComb + "' and " + "ttadv112.cpac = :1 and " + "ttadv422.cpac = :2 and " + "ttadv422.cmod = :3 and " + "ttadv422.flno = :4 and " + "ttadv422.fdnm = :5 and " + "ttadv422.vers = ttadv112.vers and " + "ttadv422.rele = ttadv112.rele and " + "ttadv422.cust = ttadv112.cust " + "order by ttadv112.pacc, ttadv112.cpac, ttadv422.clab";
            s_logger.flowMessage("erpdb - Create statement for fetching field label refs: " + string3);
            m_StatementColumnDescrReference = m_Connection.createStatement();
            m_StatementColumnDescrReference.prepare(string3);
        }
        string3 = string.substring(0, 2);
        String string4 = string.substring(2, 5);
        String string5 = string.substring(5, 8);
        m_StatementColumnDescrReference.setString(1, string3);
        m_StatementColumnDescrReference.setString(2, string3);
        m_StatementColumnDescrReference.setString(3, string4);
        m_StatementColumnDescrReference.setString(4, string5);
        m_StatementColumnDescrReference.setString(5, string2);
        IResultSet iResultSet = m_StatementColumnDescrReference.execute();
        String string6 = null;
        try {
            if (iResultSet.next()) {
                string6 = iResultSet.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            s_logger.message("erpdb - Could not retrieve column description Reference, reason: " + sQLException);
        }
        iResultSet.close();
        return string6;
    }

    public static String getFieldLabelByPackageVRCTillReger(String string, String string2) throws SQLException {
        Object object;
        if (m_StatementFieldLabelByPackageVRC == null) {
            object = "select ttadv140.desc, ttadv140.leng, ttadv112.pacc, ttadv112.cpac from ttadv140, ttadv112 where ttadv112.pacc = '" + s_packageComb + "' and " + "ttadv112.cpac = :1 and " + "ttadv140.clan = '" + m_Connection.getLanguage() + "' and " + "ttadv140.cpac = :2 and " + "ttadv140.clab = :3 and " + "ttadv140.expi = 2 and " + "ttadv140.lhgt = 1 and " + "ttadv140.leng <= 70 and " + "ttadv140.vers = ttadv112.vers and " + "ttadv140.rele = ttadv112.rele and " + "ttadv140.cust = ttadv112.cust " + "order by ttadv140.leng desc, ttadv112.pacc, ttadv112.cpac";
            s_logger.flowMessage("erpdb - Create statement for fetching labels: " + (String)object);
            m_StatementFieldLabelByPackageVRC = m_Connection.createStatement();
            m_StatementFieldLabelByPackageVRC.prepare((String)object);
        }
        m_StatementFieldLabelByPackageVRC.setString(1, string2);
        m_StatementFieldLabelByPackageVRC.setString(2, string2);
        m_StatementFieldLabelByPackageVRC.setString(3, string);
        object = m_StatementFieldLabelByPackageVRC.execute();
        String string3 = null;
        try {
            if (object.next()) {
                string3 = object.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            s_logger.message("erpdb - Could not retrieve label, reason: " + sQLException);
        }
        object.close();
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

