/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.jdbc;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IStatement;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.jdbc.JDBCConnection;
import com.ssa.jdbc.JDBCResultSet;
import com.ssa.jdbc.JDBCSQLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class JDBCStatement
implements Statement {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssa.jdbc", "JDBCStatement");
    JDBCConnection m_connection = null;
    IStatement m_statement = null;
    ResultSet m_resultSet = null;

    JDBCStatement(JDBCConnection jDBCConnection) throws SQLException {
        try {
            this.m_connection = jDBCConnection;
            this.m_statement = this.m_connection.m_connection.createStatement();
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public void close() throws SQLException {
        if (this.m_statement != null) {
            try {
                this.m_statement.close();
            }
            catch (DatabaseException databaseException) {
                throw new JDBCSQLException(databaseException);
            }
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            return this.m_statement.execute(string);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            return new JDBCResultSet(this.m_statement.executeQuery(string));
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.m_statement.getFetchSize();
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public int getMaxRows() throws SQLException {
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        return true;
    }

    public boolean getMoreResults(int n) throws SQLException {
        return true;
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.m_statement.getQueryTimeout();
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            return new JDBCResultSet(this.m_statement.getResultSet());
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public int getResultSetType() throws SQLException {
        return 0;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this.m_statement.setFetchSize(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.m_statement.setQueryTimeout(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int executeUpdate(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getUpdateCount() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setCursorName(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setMaxRows(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void addBatch(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void cancel() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }
}

