/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.jdbc;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IResultSet;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.jdbc.JDBCResultSetMetaData;
import com.ssa.jdbc.JDBCSQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class JDBCResultSet
implements ResultSet {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssa$jdbc$JDBCResultSet == null ? (class$com$ssa$jdbc$JDBCResultSet = JDBCResultSet.class$("com.ssa.jdbc.JDBCResultSet")) : class$com$ssa$jdbc$JDBCResultSet);
    IResultSet m_resultSet = null;
    static /* synthetic */ Class class$com$ssa$jdbc$JDBCResultSet;

    JDBCResultSet(IResultSet iResultSet) {
        this.m_resultSet = iResultSet;
    }

    public boolean absolute(int n) throws SQLException {
        try {
            return this.m_resultSet.absolute(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public boolean first() throws SQLException {
        return false;
    }

    public boolean next() throws SQLException {
        try {
            return this.m_resultSet.next();
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return new JDBCResultSetMetaData(this.m_resultSet.getMetaData());
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public String getString(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        return string;
    }

    private String getStringInternal(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        int n2 = this.getInt(n);
        return n2 != 0;
    }

    public byte getByte(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public short getShort(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getInt(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLong(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public float getFloat(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public double getDouble(int n) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string;
        try {
            string = this.m_resultSet.getRawData(n);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
        try {
            return new BigDecimal(new BigInteger(string), n2);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        s_logger.errorMessage("getBytes() not supported");
        throw new SQLException("getBytes() not supported");
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getStringInternal(n);
        if (!string.startsWith("{d ")) {
            throw new SQLException("Cannot parse Date '" + string + "'");
        }
        string = string.substring(4, string.length() - 2);
        try {
            return Date.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot parse Date '" + string + "', " + exception.getMessage());
        }
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getStringInternal(n);
        if (!string.startsWith("{t ")) {
            throw new SQLException("Cannot parse Time '" + string + "'");
        }
        string = string.substring(4, string.length() - 2);
        try {
            return Time.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot parse Time '" + string + "', " + exception.getMessage());
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getStringInternal(n);
        if (!string.startsWith("{ts ")) {
            throw new SQLException("Cannot parse TimeStamp '" + string + "'");
        }
        string = string.substring(5, string.length() - 2) + ".000000000";
        try {
            return Timestamp.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot parse TimeStamp '" + string + "', " + exception.getMessage());
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        s_logger.errorMessage("getAsciiStream() not supported");
        throw new SQLException("getAsciiStream() not supported");
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        s_logger.errorMessage("getUnicodeStream() not supported");
        throw new SQLException("getUnicodeStream() not supported");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        s_logger.errorMessage("getBinaryStream() not supported");
        throw new SQLException("getBinaryStream() not supported");
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        try {
            return this.m_resultSet.findColumn(string);
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public Object getObject(int n) throws SQLException {
        String string = this.getStringInternal(n);
        if (string == null) {
            return null;
        }
        int n2 = this.getMetaData().getColumnType(n);
        switch (n2) {
            case 16: {
                return new Boolean(this.getBoolean(n));
            }
            case 91: {
                return this.getDate(n);
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case 12: {
                return this.getString(n);
            }
            case 1111: {
                return this.getStringInternal(n);
            }
        }
        throw new SQLException("Unsupported SQL datatype: " + n2);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public void clearWarnings() throws SQLException {
    }

    public void afterLast() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void close() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getConcurrency() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getFetchDirection() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getFetchSize() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Statement getStatement() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getType() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean isFirst() throws SQLException {
        return false;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean relative(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setFetchSize(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean wasNull() throws SQLException {
        throw new SQLException("Not implemented");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

