/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.jdbc;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IConnection;
import com.baan.ow.b3.database.IPreparedStatement;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.jdbc.JDBCConnection;
import com.ssa.jdbc.JDBCParameterMetaData;
import com.ssa.jdbc.JDBCResultSet;
import com.ssa.jdbc.JDBCResultSetMetaData;
import com.ssa.jdbc.JDBCSQLException;
import com.ssa.jdbc.JDBCStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class JDBCPreparedStatement
extends JDBCStatement
implements Statement,
PreparedStatement {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssa.jdbc", "JDBCPreparedStatement");
    IConnection m_connection = null;
    IPreparedStatement m_preparedStatement = null;

    JDBCPreparedStatement(JDBCConnection jDBCConnection, String string) throws SQLException {
        super(jDBCConnection);
        try {
            this.m_preparedStatement = jDBCConnection.m_connection.prepareStatement(string);
            this.m_statement = this.m_preparedStatement;
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public boolean execute() throws SQLException {
        try {
            return this.m_preparedStatement.execute();
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return new JDBCResultSetMetaData(this.m_preparedStatement.getMetaData());
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return new JDBCParameterMetaData(this.m_preparedStatement.getParameterMetaData());
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            return new JDBCResultSet(this.m_preparedStatement.executeQuery());
        }
        catch (DatabaseException databaseException) {
            throw new JDBCSQLException(databaseException);
        }
    }

    public void addBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void addBatch(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void cancel() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void clearParameters() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void clearWarnings() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int executeUpdate() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setByte(int n, byte by) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setCursorName(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setDate(int n, Date date) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setDouble(int n, double d) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setFetchSize(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setFloat(int n, float f) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setInt(int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setLong(int n, long l) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setMaxRows(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setNull(int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setObject(int n, Object object) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setQueryTimeout(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setShort(int n, short s) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setString(int n, String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTime(int n, Time time) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }
}

