/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.jdbc;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IConnection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssa.jdbc.JDBCDatabaseMetaData;
import com.ssa.jdbc.JDBCPreparedStatement;
import com.ssa.jdbc.JDBCSQLException;
import com.ssa.jdbc.JDBCStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

class JDBCConnection
implements Connection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssa.jdbc", "JDBCConnection");
    static final String LOG_PREFIX = "JDBC: ";
    IConnection m_connection = null;
    private boolean m_isClosed = false;

    JDBCConnection(String string, String string2, String string3, String string4) throws SQLException {
        try {
            s_logger.message("JDBC: JDBC API 'com.ssa.jdbc' connecting to Adapter for Baan DB Driver");
            s_logger.message("JDBC: Create new Connection for BusComponent '" + string + "', User '" + string2 + "', Arguments '" + string4 + "'");
            this.m_connection = com.baan.owimpl.b3.database.Connection.createConnection(string, string2, string3, string4, 2);
        }
        catch (DatabaseException databaseException) {
            s_logger.errorException(databaseException);
            throw new JDBCSQLException(databaseException);
        }
    }

    public void close() throws SQLException {
        if (!this.m_isClosed) {
            try {
                this.m_connection.close();
                this.m_isClosed = true;
            }
            catch (DatabaseException databaseException) {
                throw new JDBCSQLException(databaseException);
            }
        }
    }

    public Statement createStatement() throws SQLException {
        return new JDBCStatement(this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return new JDBCPreparedStatement(this, string);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new JDBCDatabaseMetaData(this);
    }

    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    public boolean isReadOnly() throws SQLException {
        return true;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void commit() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean getAutoCommit() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public String getCatalog() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getTransactionIsolation() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public String nativeSQL(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void rollback() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setCatalog(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setHoldability(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setReadOnly(boolean bl) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTransactionIsolation(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not implemented");
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_JDBC);
    }
}

