/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.xml.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class W3CDOMWriter {
    private static final String s_encoding = "UTF8";
    protected BufferedWriter writer;
    OutputStream output;
    private boolean initialized = false;
    private Node root;
    protected static final String COMMENT_START = "<!--";
    protected static final String COMMENT_END = "-->";
    protected static final String HEADER = "<?xml version=\"1.0\"?>";
    protected static final char WHITESPACE = ' ';
    protected static final char EQUALS = '=';
    protected static final char QUOTE = '\"';
    protected static final char START_TAG = '<';
    protected static final char END_TAG = '>';
    protected static final char SLASH = '/';
    protected static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    protected static final char[] LT = new char[]{'&', 'l', 't', ';'};
    protected static final char[] GT = new char[]{'&', 'g', 't', ';'};
    protected static final char[] QUOTE_ENTITY = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    protected static final char[] APOS_ENTITY = new char[]{'&', 'a', 'p', 'o', 's', ';'};

    public W3CDOMWriter() {
    }

    public String writeNode(Node node) {
        try {
            this.root = node;
            this.output = new ByteArrayOutputStream();
            this.initialize();
            return this.toString();
        }
        catch (IOException iOException) {
            return "Could not serialize node";
        }
    }

    public W3CDOMWriter(Node node) {
        this(node, new ByteArrayOutputStream());
    }

    public W3CDOMWriter(Node node, OutputStream outputStream) {
        this.root = node;
        this.output = outputStream;
    }

    protected void initialize() throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(this.output, s_encoding));
        this.write(this.root);
        this.writer.flush();
        this.initialized = true;
    }

    public void flush() {
        try {
            if (!this.initialized) {
                this.initialize();
            }
        }
        catch (IOException iOException) {}
    }

    public String toString() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                if (this.root == null) {
                    return ((ByteArrayOutputStream)this.output).toString(s_encoding);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource dOMSource = new DOMSource(this.root);
                StreamResult streamResult = new StreamResult(this.output);
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", s_encoding);
                transformer.transform(dOMSource, streamResult);
                return ((ByteArrayOutputStream)streamResult.getOutputStream()).toString(s_encoding);
            }
            catch (Exception exception) {
                return super.toString();
            }
        }
        return super.toString();
    }

    public byte[] getBytes() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                if (!this.initialized) {
                    this.initialize();
                }
                return ((ByteArrayOutputStream)this.output).toByteArray();
            }
            catch (IOException iOException) {
                return super.toString().getBytes();
            }
        }
        return super.toString().getBytes();
    }

    protected void write(Node node) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Node node2;
                this.writer.write(60);
                String string = node.getNodeName();
                this.writer.write(string);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n = namedNodeMap.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        this.write(namedNodeMap.item(n2));
                        ++n2;
                    }
                }
                if ((node2 = node.getFirstChild()) == null) {
                    this.writer.write(47);
                    this.writer.write(62);
                    break;
                }
                this.writer.write(62);
                while (node2 != null) {
                    this.write(node2);
                    node2 = node2.getNextSibling();
                }
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(string);
                this.writer.write(62);
                break;
            }
            case 3: {
                String string = node.getNodeValue();
                if (string == null) break;
                int n = string.length();
                int n3 = 0;
                while (n3 < n) {
                    char c = string.charAt(n3);
                    if (c == '<') {
                        this.writer.write(LT);
                    } else if (c == '&') {
                        this.writer.write(AMP);
                    } else if (c == '>') {
                        this.writer.write(GT);
                    } else {
                        this.writer.write(c);
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                this.writer.write(32);
                this.writer.write(node.getNodeName());
                this.writer.write(61);
                this.writer.write(34);
                String string = node.getNodeValue();
                if (string != null) {
                    int n = 0;
                    while (n < string.length()) {
                        char c = string.charAt(n);
                        if (c == '\"') {
                            this.writer.write(QUOTE_ENTITY);
                        } else if (c == '\'') {
                            this.writer.write(APOS_ENTITY);
                        } else if (c == '<') {
                            this.writer.write(LT);
                        } else if (c == '&') {
                            this.writer.write(AMP);
                        } else {
                            this.writer.write(c);
                        }
                        ++n;
                    }
                }
                this.writer.write(34);
                break;
            }
            case 9: {
                this.writer.write(HEADER);
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    this.write(node3);
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 4: {
                this.writeCDATA(node);
                break;
            }
            case 8: {
                this.writer.write(COMMENT_START);
                this.writer.write(node.getNodeValue());
                this.writer.write(COMMENT_END);
                break;
            }
            case 11: {
                this.writeDocumentFragment(node);
                break;
            }
            case 10: {
                this.writeDTD(node);
                break;
            }
            case 6: {
                this.writeEntity(node);
                break;
            }
            case 5: {
                this.writeEntityReference(node);
                break;
            }
            case 12: {
                this.writeNotation(node);
                break;
            }
            case 7: {
                this.writePI(node);
            }
        }
    }

    protected void writePI(Node node) throws IOException {
    }

    protected void writeCDATA(Node node) throws IOException {
    }

    protected void writeNotation(Node node) throws IOException {
    }

    protected void writeEntityReference(Node node) throws IOException {
    }

    protected void writeEntity(Node node) throws IOException {
    }

    protected void writeDocumentFragment(Node node) throws IOException {
    }

    protected void writeDTD(Node node) throws IOException {
    }
}

