/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.xml.util;

import com.baan.b3.dom.NamedNodeMap;
import com.baan.b3.dom.Node;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class DebugDOMWriter {
    private static final String s_encoding = "UTF8";
    protected BufferedWriter writer;
    OutputStream output;
    private boolean initialized = false;
    private Node root;
    private int initialLevel = 0;
    private int initialIndent = 4;
    boolean needsNewLine = true;
    protected static final String COMMENT_START = "<!--";
    protected static final String COMMENT_END = "-->";
    protected static final String HEADER = "<?xml version=\"1.0\"?>";
    protected static final char WHITESPACE = ' ';
    protected static final char EQUALS = '=';
    protected static final char QUOTE = '\"';
    protected static final char START_TAG = '<';
    protected static final char END_TAG = '>';
    protected static final char SLASH = '/';
    protected static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    protected static final char[] LT = new char[]{'&', 'l', 't', ';'};
    protected static final char[] GT = new char[]{'&', 'g', 't', ';'};
    protected static final char[] QUOTE_ENTITY = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    protected static final char[] APOS_ENTITY = new char[]{'&', 'a', 'p', 'o', 's', ';'};

    public DebugDOMWriter() {
    }

    public String writeNode(Node node) {
        try {
            this.root = node;
            this.output = new ByteArrayOutputStream();
            this.initialize();
            return this.toString();
        }
        catch (IOException iOException) {
            return "Could not serialize node";
        }
    }

    public DebugDOMWriter(Node node) {
        this(node, new ByteArrayOutputStream(), 0, 4);
    }

    public DebugDOMWriter(Node node, int n, int n2) {
        this(node, new ByteArrayOutputStream(), n, n2);
    }

    public DebugDOMWriter(Node node, OutputStream outputStream, int n, int n2) {
        this.root = node;
        this.output = outputStream;
        this.initialLevel = n;
        this.initialIndent = n2;
    }

    protected void initialize() throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(this.output, s_encoding));
        this.write(this.root, this.initialLevel, this.initialIndent);
        this.writer.flush();
        this.initialized = true;
    }

    public void flush() {
        try {
            if (!this.initialized) {
                this.initialize();
            }
        }
        catch (IOException iOException) {}
    }

    public String toString() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                if (!this.initialized) {
                    this.initialize();
                }
                return ((ByteArrayOutputStream)this.output).toString(s_encoding);
            }
            catch (IOException iOException) {
                return super.toString();
            }
        }
        return super.toString();
    }

    public byte[] getBytes() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                if (!this.initialized) {
                    this.initialize();
                }
                return ((ByteArrayOutputStream)this.output).toByteArray();
            }
            catch (IOException iOException) {
                return super.toString().getBytes();
            }
        }
        return super.toString().getBytes();
    }

    protected void write(Node node, int n, int n2) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Node node2;
                this.newLine();
                this.indent(n, n2);
                this.writer.write(60);
                String string = node.getNodeName();
                if (string != null) {
                    this.writer.write(string);
                }
                this.writer.write(" Class=\"" + node.getClass().getName() + "\"");
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n3 = namedNodeMap.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        this.write(namedNodeMap.item(n4), n + 1, n2);
                        ++n4;
                    }
                }
                if ((node2 = node.getFirstChild()) == null) {
                    this.writer.write(47);
                    this.writer.write(62);
                    break;
                }
                this.writer.write(62);
                while (node2 != null) {
                    this.write(node2, n + 1, n2);
                    node2 = node2.getNextSibling();
                }
                if (this.needsNewLine) {
                    this.newLine();
                    this.indent(n, n2);
                }
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(string);
                this.writer.write(62);
                this.needsNewLine = true;
                break;
            }
            case 3: {
                String string = node.getNodeValue();
                if (this.isSpace(string)) {
                    this.needsNewLine = true;
                    break;
                }
                this.needsNewLine = false;
                int n5 = string.length();
                int n6 = 0;
                while (n6 < n5) {
                    char c = string.charAt(n6);
                    if (c == '<') {
                        this.writer.write(LT);
                    } else if (c == '&') {
                        this.writer.write(AMP);
                    } else if (c == '>') {
                        this.writer.write(GT);
                    } else {
                        this.writer.write(c);
                    }
                    ++n6;
                }
                break;
            }
            case 2: {
                this.writer.write(32);
                this.writer.write(node.getNodeName());
                this.writer.write(61);
                this.writer.write(34);
                String string = node.getNodeValue();
                if (string != null) {
                    int n7 = 0;
                    while (n7 < string.length()) {
                        char c = string.charAt(n7);
                        if (c == '\"') {
                            this.writer.write(QUOTE_ENTITY);
                        } else if (c == '\'') {
                            this.writer.write(APOS_ENTITY);
                        } else if (c == '<') {
                            this.writer.write(LT);
                        } else if (c == '&') {
                            this.writer.write(AMP);
                        } else {
                            this.writer.write(c);
                        }
                        ++n7;
                    }
                }
                this.writer.write(34);
                break;
            }
            case 4: {
                this.writeCDATA(node);
                break;
            }
            case 8: {
                this.newLine();
                this.indent(n, n2);
                this.writer.write(COMMENT_START);
                this.writer.write(node.getNodeValue());
                this.writer.write(COMMENT_END);
                break;
            }
            case 9: {
                this.writer.write(HEADER);
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    this.write(node3, n, n2);
                    node3 = node3.getNextSibling();
                }
                if (!this.needsNewLine) break;
                this.newLine();
                this.indent(n, n2);
                break;
            }
            case 11: {
                this.writeDocumentFragment(node);
                break;
            }
            case 10: {
                this.writeDTD(node);
                break;
            }
            case 6: {
                this.writeEntity(node);
                break;
            }
            case 5: {
                this.writeEntityReference(node);
                break;
            }
            case 12: {
                this.writeNotation(node);
                break;
            }
            case 7: {
                this.writePI(node);
            }
        }
    }

    protected void newLine() throws IOException {
        this.writer.newLine();
    }

    void indent(int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.writer.write(32);
                ++n4;
            }
            ++n3;
        }
    }

    protected void writePI(Node node) throws IOException {
    }

    protected void writeCDATA(Node node) throws IOException {
    }

    protected void writeNotation(Node node) throws IOException {
    }

    protected void writeEntityReference(Node node) throws IOException {
    }

    protected void writeEntity(Node node) throws IOException {
    }

    protected void writeDocumentFragment(Node node) throws IOException {
    }

    protected void writeDTD(Node node) throws IOException {
    }

    boolean isSpace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

