/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.xml.util;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.TextImpl;
import com.eibus.xml.util.W3CDOMWriter;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMConverter {
    private Document m_document = null;

    public DOMConverter(Document document) {
        this.m_document = document;
    }

    public String w3cElement2String(org.w3c.dom.Element element) {
        return new W3CDOMWriter(element).toString();
    }

    public org.w3c.dom.Element stringToW3cElement(String string) throws Exception {
        if (string == null || string.length() == 0) {
            throw new Exception("parseXML Error, input string is empty");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            return document.getDocumentElement();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Exception("parseXML Error, parser cannot be configured: " + parserConfigurationException.getMessage());
        }
        catch (SAXParseException sAXParseException) {
            int n = sAXParseException.getColumnNumber();
            int n2 = sAXParseException.getLineNumber();
            throw new Exception("parseXML Error on line " + n2 + ", column " + n + " : " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new Exception("parseXML Error: " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new Exception("parseXML Error, IOException while parsing event: " + iOException.getMessage());
        }
    }

    public synchronized org.w3c.dom.Element owElementToW3cElement(Element element, org.w3c.dom.Element element2) throws Exception {
        if (element == null) {
            return null;
        }
        try {
            Object object;
            Object object2;
            org.w3c.dom.Element element3 = null;
            Document document = null;
            if (element2 == null) {
                if (this.m_document == null) {
                    object2 = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                    document = documentBuilder.newDocument();
                } else {
                    document = this.m_document;
                }
                element3 = document.createElementNS(null, element.getNodeName());
            } else {
                document = element2.getOwnerDocument();
                element3 = document.createElementNS(null, element.getNodeName());
                element2.appendChild(element3);
            }
            object2 = element.getAttributes();
            int n = 0;
            while (n < object2.getLength()) {
                object = object2.item(n);
                element3.setAttribute(object.getNodeName(), object.getNodeValue());
                ++n;
            }
            object = element.getChildNodes();
            Node node = null;
            int n2 = object.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Object object3;
                node = object.item(n3);
                if (node instanceof com.baan.b3.dom.Text) {
                    object3 = node.getNodeValue();
                    element3.appendChild(document.createTextNode((String)object3));
                } else {
                    object3 = this.owElementToW3cElement((Element)node, element3);
                    element3.appendChild((org.w3c.dom.Node)object3);
                }
                ++n3;
            }
            return element3;
        }
        catch (Throwable throwable) {
            throw new Exception("Errors during DOM1 -> DOM2 conversion, " + throwable.toString());
        }
    }

    public synchronized Element w3cElementToOwElement(org.w3c.dom.Element element) throws Exception {
        if (element == null) {
            return null;
        }
        try {
            Object object;
            ElementImpl elementImpl = null;
            String string = element.getLocalName();
            if (string == null) {
                string = element.getNodeName();
            }
            elementImpl = new ElementImpl(string);
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                object = namedNodeMap.item(n);
                elementImpl.setAttribute(object.getNodeName(), object.getNodeValue());
                ++n;
            }
            object = element.getChildNodes();
            int n2 = 0;
            while (n2 < object.getLength()) {
                Object object2;
                org.w3c.dom.Node node = object.item(n2);
                if (node instanceof Text) {
                    object2 = node.getNodeValue();
                    if (((String)object2).trim().length() != 0) {
                        elementImpl.appendChild(new TextImpl((String)object2));
                    }
                } else {
                    object2 = this.w3cElementToOwElement((org.w3c.dom.Element)node);
                    elementImpl.appendChild((Node)object2);
                }
                ++n2;
            }
            return elementImpl;
        }
        catch (Throwable throwable) {
            throw new Exception("Errors during DOM2 -> DOM1 conversion, " + throwable.toString());
        }
    }
}

