/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.xml.dom;

import com.baan.b3.dom.Attr;
import com.baan.b3.dom.CDATASection;
import com.baan.b3.dom.Comment;
import com.baan.b3.dom.DOMException;
import com.baan.b3.dom.DOMImplementation;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.DocumentFragment;
import com.baan.b3.dom.DocumentType;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.EntityReference;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.ProcessingInstruction;
import com.baan.b3.dom.Text;
import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.DocumentHandler;
import com.baan.b3.xml.sax.InputSource;
import com.baan.b3.xml.sax.Locator;
import com.baan.b3.xml.sax.Parser;
import com.baan.b3.xml.sax.SAXException;
import com.baan.b3.xml.sax.SAXParseException;
import com.baan.b3.xml.sax.helpers.ParserFactory;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.xml.dom.AttrImpl;
import com.eibus.xml.dom.CDATASectionImpl;
import com.eibus.xml.dom.CommentImpl;
import com.eibus.xml.dom.DOMImplementationImpl;
import com.eibus.xml.dom.DocumentFragmentImpl;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.EntityReferenceImpl;
import com.eibus.xml.dom.NodeImpl;
import com.eibus.xml.dom.ProcessingInstructionImpl;
import com.eibus.xml.dom.TextImpl;
import java.io.InputStream;

public class SAXDocument
extends NodeImpl
implements Document,
DocumentHandler {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.xml.dom", "SAXDocument");
    DocumentType dtd;
    DOMImplementation implementation;
    Element documentElement;
    private static final boolean BUILD_TREE = true;
    private static final boolean BUILD_HETEROGENOUS_TREE = false;
    private static final boolean ELEMENT_START_EVENT = false;
    private static final boolean ELEMENT_END_EVENT = false;
    private static final boolean DOCUMENT_START_EVENT = false;
    private static final boolean DOCUMENT_END_EVENT = false;
    private static final boolean CHARACTERS_EVENT = false;
    private static final boolean PI_EVENT = false;
    private static final boolean ERROR_EVENT = false;
    private static final boolean WARNING_EVENT = false;
    private static final boolean FATAL_ERROR_EVENT = false;
    private static final boolean RESOLVE_ENTITY_EVENT = false;
    private static final boolean NOTATION_DECL_EVENT = false;
    private static final boolean UNPARSED_ENTITY_DECL_EVENT = false;
    private Node parent = null;

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        return this.dtd;
    }

    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    public Node appendChild(Node node) {
        if (node.getNodeType() == 1) {
            if (this.documentElement != null) {
                this.removeChild(this.documentElement);
            }
            this.documentElement = (Element)node;
        }
        return super.appendChild(node);
    }

    public Element createElement(String string) throws DOMException {
        return new ElementImpl(string, this);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl();
    }

    public Text createTextNode(String string) {
        TextImpl textImpl = new TextImpl();
        textImpl.setData(string);
        textImpl.ownerDocument = this;
        return textImpl;
    }

    public Comment createComment(String string) {
        CommentImpl commentImpl = new CommentImpl(string);
        commentImpl.ownerDocument = this;
        return commentImpl;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        CDATASectionImpl cDATASectionImpl = new CDATASectionImpl();
        cDATASectionImpl.setData(string);
        return cDATASectionImpl;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return new ProcessingInstructionImpl(string, string2);
    }

    public Attr createAttribute(String string) throws DOMException {
        return new AttrImpl(string, null);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new EntityReferenceImpl(string);
    }

    public NodeList getElementsByTagName(String string) {
        return null;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.parent = this;
        this.documentElement = null;
        this.dtd = null;
        this.firstChild = null;
        this.implementation = new DOMImplementationImpl();
        this.lastChild = null;
        this.nextSibling = null;
        this.ownerDocument = null;
        this.parentNode = null;
        this.previousSibling = null;
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.parent = this.parent.appendChild(this.createElement(string));
        if (attributeList.getLength() > 0) {
            int n = attributeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2 = attributeList.getName(n2);
                String string3 = attributeList.getValue(n2);
                ((Element)this.parent).setAttribute(string2, string3);
                ++n2;
            }
        }
    }

    public void endElement(String string) throws SAXException {
        this.parent = this.parent.getParentNode();
        if (this.parent == null) {
            throw new SAXException("Illegal endElement: </" + string + ">: Missing (Root) Parent");
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.parent.appendChild(this.createTextNode(new String(cArray, n, n2)));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.appendChild(this.createProcessingInstruction(string, string2));
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return null;
    }

    public void notationDecl(String string, String string2, String string3) {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    public void load(InputStream inputStream) throws SAXParseException, SAXException, Exception {
        InputSource inputSource = new InputSource(inputStream);
        Parser parser = ParserFactory.makeParser();
        parser.setDocumentHandler(this);
        parser.parse(inputSource);
    }
}

