/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.xml.dom;

import com.baan.b3.dom.Attr;
import com.baan.b3.dom.DOMException;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.NamedNodeMap;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.dom.Text;
import com.eibus.xml.dom.AttrImpl;
import com.eibus.xml.dom.NamedNodeMapImpl;
import com.eibus.xml.dom.NodeImpl;
import com.eibus.xml.dom.NodeListImpl;
import java.util.Enumeration;

public class ElementImpl
extends NodeImpl
implements Element {
    NamedNodeMapImpl attributes;
    String tag;

    public ElementImpl() {
    }

    public ElementImpl(String string) {
        this.tag = string;
    }

    public ElementImpl(String string, Document document) {
        this.tag = string;
        this.ownerDocument = document;
    }

    public short getNodeType() {
        return 1;
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl();
        }
        return this.attributes;
    }

    public String getTagName() {
        return this.tag;
    }

    public String getNodeName() {
        return this.tag;
    }

    public String getAttribute(String string) {
        Node node = this.getAttributes().getNamedItem(string);
        return node == null ? "" : node.getNodeValue();
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.setAttributeNode(new AttrImpl(string, string2));
    }

    public void removeAttribute(String string) throws DOMException {
        this.getAttributes().removeNamedItem(string);
    }

    public Attr getAttributeNode(String string) {
        return (Attr)this.getAttributes().getNamedItem(string);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        return (Attr)this.getAttributes().setNamedItem(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        return (Attr)this.getAttributes().removeNamedItem(attr.getNodeName());
    }

    public NodeList getElementsByTagName(String string) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        Node node = this.firstChild;
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNodeName().equals(string)) {
                nodeListImpl.items.addElement(node);
            }
            node = node.getNextSibling();
        }
        return nodeListImpl;
    }

    public void normalize() {
        Node node = this.getFirstChild();
        Text text = null;
        while (node != null) {
            if (node.getNodeType() == 3) {
                if (text != null) {
                    this.removeChild(node);
                    text.appendData(((Text)node).getData());
                } else {
                    text = (Text)node;
                }
            } else {
                text = null;
                if (this.getNodeType() == 1 && node.getNodeType() == 1) {
                    ((Element)node).normalize();
                }
            }
            node = node.getNextSibling();
        }
    }

    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = new ElementImpl(this.tag, null);
        if (bl) {
            this.copyAttributesInto(elementImpl);
            this.copyChildrenInto(elementImpl, bl);
        }
        return elementImpl;
    }

    public void copyAttributesInto(ElementImpl elementImpl) {
        if (this.attributes != null) {
            elementImpl.attributes = new NamedNodeMapImpl();
            Enumeration enumeration2 = this.attributes.items.elements();
            while (enumeration2.hasMoreElements()) {
                Attr attr = (Attr)enumeration2.nextElement();
                elementImpl.attributes.setNamedItem(attr);
            }
        }
    }
}

