/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.version;

import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.b3impl.about.IInstallationComponentInfo;
import com.eibus.version.ProtocolVersion;

public class Version {
    private static final IInstallationComponentInfo INFO = new AdapterComponentInfo();
    private static final String UNKNOWN_STRING = "Unknown";

    public static String getTypeAndVersion(String string) {
        if ("Connector for Java".equalsIgnoreCase(string)) {
            return Version.versionFromClass("com.baan.b3impl.about.AdapterComponentInfo");
        }
        if ("Connector for .Net".equalsIgnoreCase(string)) {
            return Version.versionFromClass("com.baan.owimpl.b3.dotnet.DotNetServerComponentInfo");
        }
        if ("Connector for COM".equalsIgnoreCase(string)) {
            return Version.versionFromClass("com.baan.owimpl.b3.COM.COMServerComponentInfo");
        }
        Class<?> clazz = null;
        IInstallationComponentInfo iInstallationComponentInfo = null;
        try {
            clazz = Class.forName("com.baan.b3impl.about.AdapterComponentInfo");
            iInstallationComponentInfo = (IInstallationComponentInfo)clazz.newInstance();
            String string2 = iInstallationComponentInfo.getVersion();
            String string3 = iInstallationComponentInfo.getPatchLevel();
            string = string + " (" + string2 + "." + string3 + ")";
        }
        catch (Throwable throwable) {}
        return string;
    }

    private static String versionFromClass(String string) {
        Class<?> clazz = null;
        IInstallationComponentInfo iInstallationComponentInfo = null;
        try {
            clazz = Class.forName(string);
            iInstallationComponentInfo = (IInstallationComponentInfo)clazz.newInstance();
            String string2 = iInstallationComponentInfo.getVersion();
            String string3 = iInstallationComponentInfo.getPatchLevel();
            String string4 = iInstallationComponentInfo.getComponentName();
            return string4 + " (" + string2 + "." + string3 + ")";
        }
        catch (Throwable throwable) {
            return "Version Unknown";
        }
    }

    private static String filter(String string) {
        if (string == null) {
            return UNKNOWN_STRING;
        }
        return string;
    }

    public static String getProtocolVersionString() {
        return "" + ProtocolVersion.getVersion();
    }

    public static String getBaanSourceControlString() {
        return null;
    }

    public static String getB3VersionString() {
        return INFO.getVersion();
    }

    public static String getB3PatchLevel() {
        return INFO.getPatchLevel();
    }

    public static String getB3BuildNumber() {
        return INFO.getBuildNumber();
    }

    public static String getB3BuildGuid() {
        return INFO.getBuildGuid();
    }

    public static String getBuildDateString() {
        return INFO.getBuildDateString();
    }

    public static String getClearCaseFileVersionString() {
        return null;
    }

    public static String getClearCaseConfigSpec() {
        return INFO.getSourceControlConfiguration();
    }

    public static String getBaanInfoString() {
        return INFO.getComponentName() + "\n\n" + Version.getCopyright() + "\n" + "\nVersion          : " + Version.filter(Version.getB3VersionString()) + "\nPatch level      : " + Version.filter(Version.getB3PatchLevel()) + "\nProtocol version : " + Version.filter(Version.getProtocolVersionString());
    }

    public static String getAllBaanInfo() {
        return Version.getBaanInfoString() + "\nBuild nr         : " + Version.filter(Version.getB3BuildNumber()) + "\n" + "\nBuild GUID       : " + Version.filter(Version.getB3BuildGuid()) + "\n" + "\nBuild date       : " + Version.filter(Version.getBuildDateString()) + "\n" + "\nConfig spec      : " + Version.filter(Version.getClearCaseConfigSpec()) + "\n\n\n\n" + "\nVersion of com.eibus.version.Version " + Version.filter(Version.getClearCaseFileVersionString());
    }

    public static String getCopyright() {
        return INFO.getCopyrightMessage();
    }

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length > 0) {
            n = stringArray[0].charAt(0);
        }
        switch (n) {
            case 0: {
                System.out.println("\n*** THIS TOOL IS DEPRECATED PLEASE USE THE com.baan.b3tools.info.Installation TOOL ***\n");
                System.out.println(Version.getBaanInfoString());
                System.out.println("Build date       : " + Version.filter(Version.getBuildDateString()));
                break;
            }
            case 65: {
                System.out.println("\n*** THIS TOOL IS DEPRECATED PLEASE USE THE com.baan.b3tools.info.Installation TOOL ***\n");
                System.out.println(Version.getAllBaanInfo());
                break;
            }
            case 66: {
                System.out.println(Version.filter(Version.getB3BuildNumber()));
                break;
            }
            case 99: {
                System.out.println(Version.filter(Version.getClearCaseConfigSpec()));
                break;
            }
            case 100: {
                System.out.println(Version.filter(Version.getBuildDateString()));
                break;
            }
            case 102: {
                System.out.println(Version.filter(Version.getClearCaseFileVersionString()));
                break;
            }
            case 103: {
                System.out.println(Version.filter(Version.getB3BuildGuid()));
                break;
            }
            case 80: {
                System.out.println(Version.filter(Version.getB3PatchLevel()));
                break;
            }
            case 114: {
                System.out.println(Version.filter(Version.getProtocolVersionString()));
                break;
            }
            case 115: {
                System.out.println(Version.filter(Version.getBaanSourceControlString()));
                break;
            }
            case 86: {
                System.out.println(Version.filter(Version.getB3VersionString()));
                break;
            }
            default: {
                System.out.println("\n*** THIS TOOL IS DEPRECATED PLEASE USE THE com.baan.b3tools.info.Installation TOOL ***\n");
                System.out.println("Syntax: java com.eibus.version.Version [h|A|B|c|d|f|g|h|p|P|s|V]");
                System.out.println("\t(no options) - User readable information");
                System.out.println("\t           A - print all version information");
                System.out.println("\t           B - print only the build nr");
                System.out.println("\t           c - print only the clearcase 'config spec'");
                System.out.println("\t           d - print only the build date");
                System.out.println("\t           f - print only the 'Version' source-file version");
                System.out.println("\t           g - print only the build GUID");
                System.out.println("\t           h - print this help");
                System.out.println("\t           P - print only the patch level");
                System.out.println("\t           s - print only the 'source control string'");
                System.out.println("\t           V - print only the version");
                System.out.println("\t           r - print only the protocol-implementation version");
            }
        }
    }

    public String toString() {
        return INFO.getComponentName() + " " + Version.filter(Version.getB3VersionString()) + "." + Version.filter(Version.getB3PatchLevel()) + " Build " + Version.filter(Version.getB3BuildNumber());
    }
}

