/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.util;

public class Queue {
    private Object[] ringBufferArray = new Object[10];
    private int front = 0;
    private int back = 0;
    private int size = 0;
    private boolean queueBlockedForPutting = false;
    private boolean queueBlockedForGetting = false;

    public Queue() {
    }

    public Queue(int n) {
        if (n > 0) {
            this.ringBufferArray = new Object[n];
        }
    }

    public synchronized void put(Object object) {
        try {
            while (this.cannotPut()) {
                this.wait();
            }
            this.back %= this.ringBufferArray.length;
            this.ringBufferArray[this.back] = object;
            ++this.back;
            ++this.size;
            this.notifyAll();
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized Object get() {
        try {
            while (this.cannotGet()) {
                this.wait();
            }
            this.front %= this.ringBufferArray.length;
            Object object = this.ringBufferArray[this.front];
            ++this.front;
            --this.size;
            this.notifyAll();
            return object;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public synchronized void blockForPutting() {
        this.queueBlockedForPutting = true;
    }

    public synchronized void unblockForPutting() {
        this.queueBlockedForPutting = false;
    }

    public synchronized void blockForGetting() {
        this.queueBlockedForGetting = true;
    }

    public synchronized void unblockForGetting() {
        this.queueBlockedForGetting = false;
    }

    public synchronized int size() {
        return this.size;
    }

    private boolean cannotPut() {
        return this.queueBlockedForPutting || this.size == this.ringBufferArray.length;
    }

    private boolean cannotGet() {
        return this.queueBlockedForGetting || this.size == 0;
    }
}

