/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MRUCache
extends Dictionary {
    Entry front;
    Entry back;
    int size = 0;
    int maximumSize = 500;

    public MRUCache(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("MRU Cache must have size >= 0 (specified size: " + n);
        }
        this.maximumSize = n;
    }

    public MRUCache() {
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public synchronized Object remove(Object object) {
        Entry entry = this.front;
        while (entry != null) {
            if (entry.key.equals(object)) {
                this.unlink(entry);
                --this.size;
                return entry.element;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized void removeAll() {
        Entry entry = this.front;
        int n = 0;
        while (n < this.size) {
            if (this.unlink(entry) != null) {
                entry = entry.next;
            }
            ++n;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public synchronized Object get(Object object) {
        Entry entry = this.front;
        while (entry != null) {
            if (entry.key.equals(object)) {
                if (entry != this.front) {
                    this.unlink(entry);
                    this.add(entry);
                }
                return entry.element;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("Null key");
        }
        if (object2 == null) {
            throw new NullPointerException("Null element");
        }
        Entry entry = this.front;
        while (entry != null) {
            if (entry.key.equals(object)) {
                if (entry != this.front) {
                    this.unlink(entry);
                    this.add(entry);
                }
                Object object3 = entry.element;
                entry.element = object2;
                return object3;
            }
            entry = entry.next;
        }
        this.add(new Entry(object, object2));
        if (this.size >= this.maximumSize) {
            return this.unlink((Entry)this.back).element;
        }
        ++this.size;
        return null;
    }

    public Enumeration elements() {
        return new ElementEnum(this.front);
    }

    public Enumeration keys() {
        return new KeyEnum(this.front);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        Entry entry = this.front;
        while (entry != null) {
            if (entry != this.front) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("" + entry.key + "=" + entry.element);
            entry = entry.next;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private Entry unlink(Entry entry) {
        if (entry == null) {
            return entry;
        }
        if (entry == this.back) {
            this.back = this.back.previous;
        } else {
            entry.next.previous = entry.previous;
        }
        if (entry == this.front) {
            this.front = this.front.next;
        } else {
            entry.previous.next = entry.next;
        }
        entry.previous = null;
        entry.next = null;
        return entry;
    }

    private void add(Entry entry) {
        if (this.front == null) {
            this.front = this.back = entry;
            return;
        }
        this.front.previous = entry;
        entry.next = this.front;
        this.front = entry;
    }

    private class ElementEnum
    implements Enumeration {
        Entry current;

        ElementEnum(Entry entry) {
            this.current = entry;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object object = this.current.element;
            this.current = this.current.next;
            return object;
        }
    }

    private class KeyEnum
    implements Enumeration {
        Entry current;

        KeyEnum(Entry entry) {
            this.current = entry;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object object = this.current.element;
            this.current = this.current.next;
            return object;
        }
    }

    private class Entry {
        Object key;
        Object element;
        Entry next;
        Entry previous;

        Entry(Object object, Object object2) {
            this.key = object;
            this.element = object2;
        }
    }
}

