/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.wrapjava;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.tools.cmdline.CommandLine;
import com.eibus.tools.wrapjava.JavaType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class WrapJava {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.tools.wrapjava", "WrapJava");
    private String cppDir;
    private Vector searchPathList;
    private String stdIncludePath;
    private Class c;
    private String javaClassName;
    private String CPPClassName;
    private Class superClass;
    private String javaSuperClassName;
    private String CPPSuperClassName;
    private boolean DLLExport;
    private boolean raw;
    private boolean inheritance;
    private boolean publicOnly;
    private boolean EIBString;
    private boolean verbose;
    private String DLLExportDefineName;
    private Hashtable refClassList;
    private PrintWriter outWriter;
    private int methodNumber;
    private static final String[] CPPKeywordArray;
    private static Hashtable CPPKeywords;
    private static final String EIBSTRING = "EIBString";

    public WrapJava(String string, boolean bl, String string2, String string3, Vector vector, String string4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ClassNotFoundException, IOException {
        this.javaClassName = string;
        this.DLLExport = bl;
        this.DLLExportDefineName = string2;
        this.cppDir = string3;
        this.searchPathList = vector;
        this.stdIncludePath = string4;
        this.raw = bl2;
        this.inheritance = bl3;
        this.publicOnly = bl4;
        this.EIBString = bl5;
        this.verbose = bl6;
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, IOException {
        ILicense iLicense = null;
        try {
            iLicense = LicenseFactory.createStudioLicense();
        }
        catch (LicenseException licenseException) {
            System.err.println("Request license failed: " + licenseException.getMessage());
            return;
        }
        if (iLicense.getDaysLeft() < 0) {
            System.err.println(iLicense.getMessage());
            iLicense.release();
            return;
        }
        WrapJava.execute(stringArray, iLicense);
        iLicense.release();
    }

    public static void execute(String[] stringArray, ILicense iLicense) throws ClassNotFoundException, IOException {
        Object object;
        Hashtable<Class, Class> hashtable = new Hashtable<Class, Class>();
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        boolean bl = false;
        String string = null;
        String string2 = null;
        Vector<String> vector = null;
        String string3 = null;
        String string4 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        CommandLine commandLine = null;
        String[] stringArray2 = new String[6];
        String[] stringArray3 = new String[]{};
        String[] stringArray4 = new String[4];
        stringArray2[0] = "raw";
        stringArray2[1] = "noinheritance";
        stringArray2[2] = "publicOnly";
        stringArray2[3] = "recursive";
        stringArray2[4] = EIBSTRING;
        stringArray2[5] = "verbose";
        stringArray4[0] = "cppdir";
        stringArray4[1] = "stdinclude";
        stringArray4[2] = "search";
        stringArray4[3] = "dllexport";
        try {
            commandLine = new CommandLine(stringArray, stringArray2, stringArray3, stringArray4);
        }
        catch (CommandLine.ParseException parseException) {
            WrapJava.printUsage("invalid arguments");
            return;
        }
        if (commandLine.parseResult().hasOption("raw")) {
            bl2 = true;
        }
        if (commandLine.parseResult().hasOption("noinheritance")) {
            bl3 = false;
        }
        if (commandLine.parseResult().hasOption("publicOnly")) {
            bl4 = true;
        }
        if (commandLine.parseResult().hasOption("recursive")) {
            bl5 = true;
        }
        if (commandLine.parseResult().hasOption(EIBSTRING)) {
            if (bl2) {
                WrapJava.printUsage("-EIBString not allowed in combination with -raw option");
                return;
            }
            bl6 = true;
        }
        if (commandLine.parseResult().hasOption("verbose")) {
            bl7 = true;
        }
        if (commandLine.parseResult().hasOption(stringArray4[0])) {
            string2 = commandLine.parseResult().getOptionArgument(stringArray4[0]);
            object = new File(string2);
            ((File)object).mkdirs();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
        }
        if (commandLine.parseResult().hasOption(stringArray4[1]) && !(string4 = commandLine.parseResult().getOptionArgument(stringArray4[1])).endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        if (commandLine.parseResult().hasOption(stringArray4[2])) {
            vector = new Vector<String>();
            object = new StringTokenizer(commandLine.parseResult().getOptionArgument(stringArray4[2]), ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                vector.addElement(((StringTokenizer)object).nextToken());
            }
        }
        if (commandLine.parseResult().hasOption(stringArray4[3])) {
            bl = true;
            string = commandLine.parseResult().getOptionArgument(stringArray4[3]);
        }
        if (((Vector)(object = commandLine.parseResult().getParameters())).size() != 1) {
            WrapJava.printUsage("no input filename specified");
            return;
        }
        string3 = (String)((Vector)object).elementAt(0);
        int n = 0;
        int n2 = 0;
        while (string3 != null) {
            Object object2;
            WrapJava wrapJava;
            if (bl7) {
                System.err.println("Wrap Class: " + string3);
            }
            if ((wrapJava = new WrapJava(string3, bl, string, string2, vector, string4, bl2, bl3, bl4, bl6, bl7)).run()) {
                ++n;
            } else {
                ++n2;
            }
            if (!bl5) break;
            Class clazz = wrapJava.getWrappedClass();
            hashtable.put(clazz, clazz);
            hashtable2.remove(clazz);
            Enumeration enumeration2 = wrapJava.getRefClassList().elements();
            while (enumeration2.hasMoreElements()) {
                object2 = (Class)enumeration2.nextElement();
                if (hashtable.get(object2) != null || hashtable2.get(object2) != null) continue;
                hashtable2.put(object2, object2);
            }
            object2 = hashtable2.elements();
            string3 = hashtable2.isEmpty() ? null : ((Class)hashtable2.elements().nextElement()).getName();
        }
        if (bl7) {
            System.err.println("Generated " + n + " wrapper" + (n != 1 ? "s" : ""));
            System.err.println("Reused " + n2 + " wrapper" + (n2 != 1 ? "s" : ""));
        }
    }

    private static void printUsage(String string) {
        System.err.println("WrapJava: " + string);
        System.err.println("WrapJava: Usage: WrapJava [-dllexport <define name>] [-cppdir <directory>]");
        System.err.println("\t\t[-stdinclude <directory>] [-search <directory;directory...>]");
        System.err.println("\t\t[-raw]");
        System.err.println("\t\t[-noinheritance]");
        System.err.println("\t\t[-publicOnly]");
        System.err.println("\t\t[-recursive]");
        System.err.println("\t\t[-EIBString]");
        System.err.println("\t\t[-verbose]");
        System.err.println("\t\t{<file>.class | <class>}");
    }

    public boolean run() throws ClassNotFoundException, IOException {
        this.c = Class.forName(this.javaClassName);
        this.CPPClassName = new JavaType(this.c).getCPPName(false);
        this.superClass = this.inheritance ? this.c.getSuperclass() : null;
        if (this.superClass == null) {
            this.javaSuperClassName = "<No super class!!>";
            this.CPPSuperClassName = "WrapperRoot";
        } else {
            this.javaSuperClassName = this.superClass.getName();
            this.CPPSuperClassName = new JavaType(this.superClass).getCPPName(false);
        }
        Class<?>[] classArray = this.c.getInterfaces();
        Field[] fieldArray = this.c.getDeclaredFields();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector<Method> vector4 = new Vector<Method>();
        Vector<Method> vector5 = new Vector<Method>();
        Vector<Method> vector6 = new Vector<Method>();
        Method[] methodArray = this.c.getDeclaredMethods();
        Constructor<?>[] constructorArray = this.c.getDeclaredConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            if (Modifier.isPublic(constructorArray[n].getModifiers())) {
                vector.addElement(constructorArray[n]);
            } else if (Modifier.isProtected(constructorArray[n].getModifiers())) {
                if (!this.publicOnly) {
                    vector2.addElement(constructorArray[n]);
                }
            } else if (Modifier.isPrivate(constructorArray[n].getModifiers())) {
                if (!this.publicOnly) {
                    vector3.addElement(constructorArray[n]);
                }
            } else {
                vector.addElement(constructorArray[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (Modifier.isPublic(methodArray[n2].getModifiers())) {
                vector4.addElement(methodArray[n2]);
            } else if (Modifier.isProtected(methodArray[n2].getModifiers())) {
                if (!this.publicOnly) {
                    vector5.addElement(methodArray[n2]);
                }
            } else if (Modifier.isPrivate(methodArray[n2].getModifiers())) {
                if (!this.publicOnly) {
                    vector6.addElement(methodArray[n2]);
                }
            } else {
                vector4.addElement(methodArray[n2]);
            }
            ++n2;
        }
        Hashtable hashtable = this.determineReferredClasses();
        boolean bl = this.superClass != null && this.javaSuperClassName.equals("java.lang.Object") && classArray.length > 0;
        File file2 = this.fileExistsInStdIncludePathOrSearchList(this.CPPClassName + ".h");
        if (file2 != null) {
            if (this.verbose) {
                System.err.println("\t\t\t\t\tReuse: " + file2.getPath());
            }
            return false;
        }
        this.generateHFile(hashtable, bl, vector, vector2, vector3, vector4, vector5, vector6);
        this.generateCPPFile(hashtable, bl, vector, vector2, vector3, vector4, vector5, vector6);
        return true;
    }

    public Class getWrappedClass() {
        return this.c;
    }

    public Hashtable getRefClassList() {
        if (this.refClassList == null) {
            return new Hashtable();
        }
        return this.refClassList;
    }

    private void generateHFile(Hashtable hashtable, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6) throws IOException {
        File file2 = new File(this.cppDir, this.CPPClassName + ".h");
        this.outWriter = new PrintWriter(new FileOutputStream(file2));
        this.generateFileHeader();
        this.genln("#ifndef _" + this.CPPClassName + "_H_");
        this.genln("#define _" + this.CPPClassName + "_H_\r\n");
        this.genInclude(this.CPPSuperClassName + ".h");
        Class<?>[] classArray = this.c.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            this.genInclude(new JavaType(classArray[n]).getCPPName(false) + ".h");
            ++n;
        }
        this.genln("");
        if (this.superClass == null) {
            this.genln("class WrapperRoot;");
        }
        if (this.EIBString && this.CPPClassName.equals("J_java_lang_String")) {
            this.genln("class EIBString;");
        }
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            this.genln("class " + enumeration2.nextElement() + ";");
        }
        if (this.DLLExport) {
            this.genln("\r\n#ifdef _WIN32");
            this.genln("#ifdef " + this.DLLExportDefineName);
            this.genln("#define JavaDLLExport _declspec (dllexport)");
            this.genln("#else");
            this.genln("#define JavaDLLExport _declspec (dllimport)");
            this.genln("#endif");
            this.genln("#else");
            this.genln("#define JavaDLLExport");
            this.genln("#endif");
        }
        this.genln("");
        this.gen("class ");
        if (this.DLLExport) {
            this.gen("JavaDLLExport ");
        }
        this.gen(this.CPPClassName + ": ");
        if (!bl) {
            this.gen("public ");
            if (this.superClass == null) {
                this.gen("virtual ");
            }
            this.gen(this.CPPSuperClassName);
        }
        int n2 = 0;
        while (n2 < classArray.length) {
            if (n2 > 0 || !bl) {
                this.gen(", ");
            }
            this.gen("public " + new JavaType(classArray[n2]).getCPPName(false));
            ++n2;
        }
        this.genln("\r\n{");
        this.genln("\t// Add friend class for possiblly existing implementation class.");
        this.genln("\tfriend class " + this.CPPClassName + "_impl;\r\n");
        this.generateStandardMethodsH();
        if (!this.raw) {
            this.methodNumber = 0;
            this.generateNewObjectMethodsH(vector);
            this.generateNewObjectMethodsH(vector2);
            this.generateNewObjectMethodsH(vector3);
            this.genln("\tjobject\t\t\tlocal;\t// Only used in constructor to delete local reference of new object");
        }
        this.genln("public:");
        this.genln("\t// Constructors");
        int n3 = vector.size();
        while (n3-- > 0) {
            this.generateConstructorH((Constructor)vector.elementAt(n3));
        }
        this.genln("\r\n\t// Methods");
        int n4 = vector4.size();
        while (n4-- > 0) {
            this.generateMethodH((Method)vector4.elementAt(n4));
        }
        this.genln("\r\nprotected:");
        this.genln("\t// Constructors");
        int n5 = vector2.size();
        while (n5-- > 0) {
            this.generateConstructorH((Constructor)vector2.elementAt(n5));
        }
        this.genln("\r\n\t// Methods");
        int n6 = vector5.size();
        while (n6-- > 0) {
            this.generateMethodH((Method)vector5.elementAt(n6));
        }
        this.genln("\r\nprivate:");
        this.genln("\t// Constructors");
        int n7 = vector3.size();
        while (n7-- > 0) {
            this.generateConstructorH((Constructor)vector3.elementAt(n7));
        }
        this.genln("\r\n\t// Methods");
        int n8 = vector6.size();
        while (n8-- > 0) {
            this.generateMethodH((Method)vector6.elementAt(n8));
        }
        this.genln("};");
        if (this.DLLExport) {
            this.genln("\r\n#undef JavaDLLExport");
        }
        this.genln("#endif /* _" + this.CPPClassName + "_H_ */");
        this.outWriter.close();
        this.outWriter = null;
    }

    private void generateStandardMethodsH() {
        this.genln("public:");
        this.genln("\t// Constructor for wrapping an existing Java object");
        if (!this.raw) {
            this.genln("\t" + this.CPPClassName + "(jobject jThis);");
            this.genln("");
            this.genln("\t// Copy constructor");
            this.genln("\t" + this.CPPClassName + "(const " + this.CPPClassName + "& iOriginal);");
            this.genln("");
            this.genln("\t// Assignment operator");
            this.genln("\t" + this.CPPClassName + "& operator= (const " + this.CPPClassName + "& iSource);");
            this.genln("");
            this.genln("\t// Conversion operator (This is only required to circumvent a MSVC++ bug)");
            this.genln("\tvirtual operator jobject () const;\r\n");
            this.genln("private:");
            this.genln("\tstatic jclass\tjavaClass;");
            this.genln("\tstatic jclass\tgetJavaClass (JNIEnv* env);");
        } else {
            this.genln("\t" + this.CPPClassName + "(HObject* jThis, boolean iDisableGarbageCollection = true);\r\n");
            this.genln("\t// Copy constructor");
            this.genln("\t" + this.CPPClassName + "(const " + this.CPPClassName + "& iOriginal);\r\n");
            this.genln("\t// Assignement operator");
            this.genln("\t" + this.CPPClassName + "& operator= (const " + this.CPPClassName + "& iSource);\r\n");
            this.genln("\t// Conversion operator (This is only required to circumvent a MSVC++ bug)");
            this.genln("\tvirtual operator HObject* () const;\r\n");
            this.genln("private:");
            this.genln("\tstatic ClassClass*\tjavaClassBlock;");
            this.genln("\tstatic ClassClass*\tgetJavaClassBlock (void);\r\n");
        }
    }

    private void generateNewObjectMethodsH(Vector vector) {
        int n = vector.size();
        while (n-- > 0) {
            Constructor constructor = (Constructor)vector.elementAt(n);
            Class<?>[] classArray = constructor.getParameterTypes();
            this.gen("\tstatic jobject\tnewObject" + new DecimalFormat("000").format(this.methodNumber++) + " (");
            if (classArray.length != 0) {
                int n2 = 0;
                while (n2 < classArray.length) {
                    if (n2 != 0) {
                        this.gen(", ");
                    }
                    this.gen(new JavaType(classArray[n2]).getCPPDecl(this.EIBString) + " p" + n2);
                    ++n2;
                }
            }
            this.genln(");");
        }
    }

    private void generateConstructorH(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        this.gen("\t" + this.CPPClassName + "(");
        if (classArray.length != 0) {
            int n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    this.gen(", ");
                }
                this.gen(new JavaType(classArray[n]).getCPPDecl(this.EIBString) + " p" + n);
                ++n;
            }
            if (classArray.length == 1 && classArray[0].getName().equals(this.javaClassName)) {
                this.gen(", const void *toMakeThisConstructorNotACPPCopyConstructor");
            }
        } else {
            this.gen("void");
        }
        this.genln(");");
    }

    private void generateMethodH(Method method) {
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        if (Modifier.isStatic(method.getModifiers())) {
            this.gen("\tstatic ");
        } else {
            this.gen("\tvirtual ");
        }
        this.gen(new JavaType(clazz).getCPPName(this.EIBString) + " " + this.methodNameCPP(method.getName()) + "(");
        if (classArray.length != 0) {
            int n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    this.gen(", ");
                }
                this.gen(new JavaType(classArray[n]).getCPPDecl(this.EIBString) + " p" + n);
                ++n;
            }
        } else {
            this.gen("void");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            this.genln(");");
        } else {
            this.genln(") const;");
        }
    }

    private void generateCPPFile(Hashtable hashtable, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6) throws IOException {
        File file2 = new File(this.cppDir, this.CPPClassName + ".cpp");
        this.outWriter = new PrintWriter(new FileOutputStream(file2));
        this.generateFileHeader();
        if (!this.raw) {
            this.genInclude("Environment.h");
            this.genln("");
        }
        this.genInclude(this.CPPClassName + ".h");
        if (this.EIBString && this.CPPClassName.equals("J_java_lang_String")) {
            this.genInclude("EIBString.h");
        }
        if (this.superClass == null) {
            this.genInclude("WrapperRoot.h");
        }
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            this.genInclude(enumeration2.nextElement() + ".h");
        }
        this.genln("");
        this.generateStandardMethodsCPP(bl);
        this.methodNumber = 0;
        this.genln("\r\n// Public constructors");
        int n = vector.size();
        while (n-- > 0) {
            this.generateConstructorCPP(bl, (Constructor)vector.elementAt(n));
        }
        this.genln("\r\n// Public methods");
        int n2 = vector4.size();
        while (n2-- > 0) {
            this.generateMethodCPP((Method)vector4.elementAt(n2));
        }
        this.genln("\r\n// Protected constructors");
        int n3 = vector2.size();
        while (n3-- > 0) {
            this.generateConstructorCPP(bl, (Constructor)vector2.elementAt(n3));
        }
        this.genln("\r\n// Protected methods");
        int n4 = vector5.size();
        while (n4-- > 0) {
            this.generateMethodCPP((Method)vector5.elementAt(n4));
        }
        this.genln("\r\n// Private constructors");
        int n5 = vector3.size();
        while (n5-- > 0) {
            this.generateConstructorCPP(bl, (Constructor)vector3.elementAt(n5));
        }
        this.genln("\r\n// Private methods");
        int n6 = vector6.size();
        while (n6-- > 0) {
            this.generateMethodCPP((Method)vector6.elementAt(n6));
        }
        this.outWriter.close();
        this.outWriter = null;
    }

    private void generateStandardMethodsCPP(boolean bl) {
        if (!this.raw) {
            this.genln("// Constructor for wrapping an existing Java object");
            this.gen(this.CPPClassName + "::" + this.CPPClassName);
            this.gen("(jobject jThis) : WrapperRoot (jThis)");
            this.generateBaseClassConstructorCalls(bl);
            this.genln("");
            this.genln("{");
            this.genln("}");
            this.genln("");
            this.genln("// Copy constructor");
            this.gen(this.CPPClassName + "::" + this.CPPClassName + "(const " + this.CPPClassName + "& iOriginal)");
            this.gen(": WrapperRoot (iOriginal)");
            this.generateBaseClassConstructorCalls(bl);
            this.genln("");
            this.genln("{");
            this.genln("}");
            this.genln("");
            this.genln("// Conversion operator (This is only required to circumvent a MSVC++ bug)");
            this.gen(this.CPPClassName + ":: operator jobject () const\r\n");
            this.genln("{");
            this.genln("\treturn (this->WrapperRoot::operator jobject());");
            this.genln("}");
            this.genln("");
            this.genln("// Assignment operator");
            this.gen(this.CPPClassName + "& " + this.CPPClassName + ":: operator= (const ");
            this.genln(this.CPPClassName + "& iSource)");
            this.genln("{");
            this.genln("\tthis->WrapperRoot::operator= (iSource);");
            this.genln("\treturn (*this);");
            this.genln("}");
            this.genln("");
            this.genln("jclass\t" + this.CPPClassName + "::javaClass = 0;");
            this.genln("jclass\t" + this.CPPClassName + "::getJavaClass (JNIEnv* env)");
            this.genln("{");
            this.genln("\tif (javaClass == 0)");
            this.genln("\t{");
            this.genln("\t\tjavaClass = WrapperRoot::getJavaClass (env, \"" + this.javaClassName.replace('.', '/') + "\");");
            this.genln("\t}");
            this.genln("\treturn (javaClass);");
            this.genln("}");
        } else {
            this.genln("// Constructor for wrapping an existing Java object");
            this.gen(this.CPPClassName + "::" + this.CPPClassName);
            this.gen("(HObject* jThis, boolean iDisableGarbageCollection) : WrapperRoot (jThis, iDisableGarbageCollection)");
            this.generateBaseClassConstructorCalls(bl);
            this.genln("\r\n{");
            this.genln("}\r\n");
            this.genln("// Copy constructor");
            this.gen(this.CPPClassName + "::" + this.CPPClassName + "(const " + this.CPPClassName + "& iOriginal)");
            this.gen(": WrapperRoot (iOriginal)");
            this.generateBaseClassConstructorCalls(bl);
            this.genln("\r\n{");
            this.genln("}");
            this.genln("// Conversion operator (This is only required to circumvent a MSVC++ bug)");
            this.gen(this.CPPClassName + ":: operator HObject* () const\r\n");
            this.genln("{");
            this.genln("\treturn (this->WrapperRoot::operator HObject*());");
            this.genln("}");
            this.genln("// Assignement operator");
            this.gen(this.CPPClassName + "& " + this.CPPClassName + ":: operator= (const ");
            this.genln(this.CPPClassName + "& iSource)");
            this.genln("{");
            this.genln("\tthis->WrapperRoot::operator= (iSource);");
            this.genln("\treturn (*this);");
            this.genln("}");
            this.genln("ClassClass*\t" + this.CPPClassName + "::javaClassBlock = 0;");
            this.genln("ClassClass* " + this.CPPClassName + "::getJavaClassBlock (void)");
            this.genln("{");
            this.genln("\tif (javaClassBlock == 0)");
            this.genln("\t{");
            this.genln("\t\tjavaClassBlock = WrapperRoot::getJavaClassBlock (\"" + this.javaClassName.replace('.', '/') + "\");\r\n");
            this.genln("\t}");
            this.genln("\treturn (javaClassBlock);");
            this.genln("}\r\n");
        }
    }

    private void generateConstructorCPP(boolean bl, Constructor constructor) {
        int n;
        Class<?>[] classArray = constructor.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.raw) {
            stringBuffer.append("");
            this.gen("jobject " + this.CPPClassName + "::newObject" + new DecimalFormat("000").format(this.methodNumber) + " (");
            if (classArray.length != 0) {
                n = 0;
                while (n < classArray.length) {
                    if (n != 0) {
                        this.gen(", ");
                    }
                    this.gen(new JavaType(classArray[n]).getCPPDecl(this.EIBString) + " p" + n);
                    stringBuffer.append(new JavaType(classArray[n]).getSignatureString());
                    ++n;
                }
            }
            this.genln(")");
            this.genln("{");
            this.genln("\tstatic jmethodID methodID = 0;");
            this.genln("\tJNIEnv* env = Environment::getEnvironment();");
            this.genln("");
            this.genln("\tif (!methodID)");
            this.genln("\t{");
            this.genln("\t\tmethodID = env->GetMethodID (getJavaClass (env), \"<init>\", \"(" + stringBuffer + ")V\");");
            this.genln("");
            this.genln("\t\tWrapperRoot::checkExceptions (env);");
            this.genln("\t}");
            this.gen("\tjobject obj = env->NewObject(getJavaClass(env), methodID");
            n = 0;
            while (n < classArray.length) {
                if (!classArray[n].isPrimitive() && !classArray[n].isArray()) {
                    if (new JavaType(classArray[n]).getCPPName(this.EIBString).equals(EIBSTRING)) {
                        this.gen(", (jobject) (p" + n + ".getJstring())");
                    } else {
                        this.gen(", (jobject) p" + n);
                    }
                } else {
                    this.gen(", p" + n);
                }
                ++n;
            }
            this.genln(");");
            this.genln("");
            this.genln("\tWrapperRoot::checkExceptions(env);");
            this.genln("");
            this.genln("\treturn obj;");
            this.genln("}");
        }
        stringBuffer = new StringBuffer("(");
        this.gen(this.CPPClassName + "::" + this.CPPClassName + "(");
        if (classArray.length != 0) {
            n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    this.gen(", ");
                }
                this.gen(new JavaType(classArray[n]).getCPPDecl(this.EIBString) + " p" + n);
                stringBuffer.append(new JavaType(classArray[n]).getSignatureString());
                ++n;
            }
            if (classArray.length == 1 && classArray[0].getName().equals(this.javaClassName)) {
                this.gen(", const void *toMakeThisConstructorNotACPPCopyConstructor");
            }
        } else {
            this.gen("void");
        }
        stringBuffer.append(")");
        if (!this.raw) {
            this.gen("): WrapperRoot (local = newObject" + new DecimalFormat("000").format(this.methodNumber++) + " (");
            n = 0;
            while (n < classArray.length) {
                if (n == 0) {
                    this.gen("p" + n);
                } else {
                    this.gen(", p" + n);
                }
                ++n;
            }
            this.gen("))");
            this.generateBaseClassConstructorCalls(bl);
            this.genln("");
            this.genln("{");
            this.genln("\tJNIEnv* env = Environment::getEnvironment();");
            this.genln("");
            this.genln("\tenv->DeleteLocalRef(local);");
            this.genln("\tWrapperRoot::checkExceptions (env);");
        } else {
            this.gen("): WrapperRoot (execute_java_constructor (0, 0, getJavaClassBlock (), \"" + stringBuffer + "\"");
            n = 0;
            while (n < classArray.length) {
                if (!classArray[n].isPrimitive() && !classArray[n].isArray()) {
                    this.gen(", (HObject*) p" + n);
                } else {
                    this.gen(", p" + n);
                }
                ++n;
            }
            this.gen("))");
            this.generateBaseClassConstructorCalls(bl);
            this.genln("");
            this.genln("{");
            this.genln("\tExecEnv*\tee = EE();");
            this.genln("");
            this.genln("\tWrapperRoot::checkExceptions (ee);");
        }
        this.genln("}");
        this.genln("");
    }

    private void generateBaseClassConstructorCalls(boolean bl) {
        Class<?>[] classArray = this.c.getInterfaces();
        if (this.superClass != null && !bl) {
            if (!this.raw) {
                this.gen(", " + this.CPPSuperClassName + " ((jobject) 0)");
            } else {
                this.gen(", " + this.CPPSuperClassName + " ((HObject*) 0)");
            }
        }
        int n = 0;
        while (n < classArray.length) {
            if (!this.raw) {
                this.gen(", " + new JavaType(classArray[n]).getCPPName(false) + " ((jobject) 0)");
            } else {
                this.gen(", " + new JavaType(classArray[n]).getCPPName(false) + " ((HObject*) 0)");
            }
            ++n;
        }
    }

    private void generateMethodCPP(Method method) {
        Class<?> clazz = method.getReturnType();
        JavaType javaType = new JavaType(clazz);
        Class<?>[] classArray = method.getParameterTypes();
        JavaType[] javaTypeArray = new JavaType[classArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        this.gen(javaType.getCPPName(this.EIBString) + " " + this.CPPClassName + "::" + this.methodNameCPP(method.getName()) + "(");
        if (classArray.length != 0) {
            int n = 0;
            while (n < classArray.length) {
                javaTypeArray[n] = new JavaType(classArray[n]);
                if (n != 0) {
                    this.gen(", ");
                }
                this.gen(javaTypeArray[n].getCPPDecl(this.EIBString) + " p" + n);
                stringBuffer.append(javaTypeArray[n].getSignatureString());
                ++n;
            }
        } else {
            this.gen("void");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            this.genln(")");
        } else {
            this.genln(") const");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!this.raw) {
            this.genln("{");
            this.genln("\tstatic jmethodID methodID = 0;");
            this.genln("\tJNIEnv* env = Environment::getEnvironment();");
            this.genln("\tif (!methodID)");
            this.genln("\t{");
            if (Modifier.isStatic(method.getModifiers())) {
                this.genln("\t\tmethodID = env->GetStaticMethodID (getJavaClass (env), \"" + this.methodNameCPP(method.getName()) + "\", \"(" + stringBuffer + ")" + javaType.getSignatureString() + "\");");
            } else {
                this.genln("\t\tmethodID = env->GetMethodID (getJavaClass (env), \"" + this.methodNameCPP(method.getName()) + "\", \"(" + stringBuffer + ")" + javaType.getSignatureString() + "\");");
            }
            this.genln("\t\tWrapperRoot::checkExceptions (env);");
            this.genln("\t}");
            if (clazz == Void.TYPE) {
                this.gen("\t");
            } else if (clazz.isPrimitive() && !clazz.isArray()) {
                this.gen("\t" + javaType.getCPPName(this.EIBString) + " retVal = ");
            } else {
                this.gen("\tjobject retVal = ");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                this.gen("env->" + javaType.getJNIStaticMethodName() + " (getJavaClass (env), methodID");
            } else {
                this.gen("env->" + javaType.getJNIMethodName() + "(*this, methodID");
            }
            int n = 0;
            while (n < classArray.length) {
                if (!classArray[n].isPrimitive() && !classArray[n].isArray()) {
                    if (javaTypeArray[n].getCPPName(this.EIBString).equals(EIBSTRING)) {
                        this.gen(", (jobject) (p" + n + ".getJstring())");
                    } else {
                        this.gen(", (jobject) p" + n);
                    }
                } else {
                    this.gen(", p" + n);
                }
                ++n;
            }
            this.genln(");");
            this.genln("");
            this.genln("\tWrapperRoot::checkExceptions (env);");
            if (clazz != Void.TYPE) {
                this.genln("");
                if (clazz.isArray()) {
                    this.genln("\treturn ((" + javaType.getCPPName(this.EIBString) + ") retVal);");
                } else if (clazz.isPrimitive()) {
                    this.genln("\treturn (retVal);");
                } else {
                    this.genln("\t" + javaType.getCPPName(this.EIBString) + " result(retVal);");
                    this.genln("\tenv->DeleteLocalRef(retVal);");
                    this.genln("\treturn (result);");
                }
            }
        } else {
            int n = 0;
            while (n < classArray.length) {
                if (!classArray[n].isPrimitive() && !classArray[n].isArray()) {
                    stringBuffer2.append(", (HObject*) p" + n);
                } else {
                    stringBuffer2.append(", p" + n);
                }
                ++n;
            }
            this.genln("{");
            this.genln("\tExecEnv*\tee = EE();");
            if (Modifier.isStatic(method.getModifiers())) {
                this.gen("\tlong\t\tretVal = execute_java_static_method (ee, getJavaClassBlock (), ");
            } else {
                this.gen("\tlong\t\tretVal = execute_java_dynamic_method (ee, *this, ");
            }
            this.gen("\"" + method.getName() + "\", \"(" + stringBuffer + ")");
            this.gen(javaType.getSignatureString() + "\"" + stringBuffer2 + ");\r\n");
            this.genln("");
            this.genln("\tWrapperRoot::checkExceptions (ee);");
            if (!clazz.isPrimitive() && !clazz.isArray()) {
                this.genln("\r\n\treturn (" + javaType.getCPPName(this.EIBString) + "((HObject *) retVal));");
            } else if (clazz.equals(Float.TYPE) && !clazz.isArray()) {
                this.genln("\r\n\t// Interpret the return value as a float (don't cast! casting implies conversion).");
                this.genln("\r\n\treturn (((stack_item*) &retVal)->f);");
            } else if (!clazz.equals(Void.TYPE)) {
                if (clazz.equals(Double.TYPE) || clazz.equals(Long.TYPE)) {
                    System.out.println("Warning: Due to an ommision in the current Java Virtual Machine implementation,\r\nC++ wrappers for Java methods returning 64-bit values return incorrect results.");
                }
                this.genln("\r\n\treturn ((" + javaType.getCPPName(this.EIBString) + ") retVal);");
            }
        }
        this.genln("}");
        this.genln("");
    }

    private void gen(String string) {
        this.outWriter.print(string);
    }

    private void genln(String string) {
        this.outWriter.println(string);
    }

    private void generateFileHeader() {
        Date date = new Date();
        this.genln("/*");
        this.genln("\tWarning: This is generated code. Do not update it manually!!");
        this.genln("");
        this.genln("\tCopyright (c) SSA Global Technologies, Inc. 2003. All rights reserved.");
        this.genln("");
        this.genln("\tGenerated by: " + System.getProperty("user.name") + " at " + new SimpleDateFormat("dd MMMMM yyyy - hh:mm:ss z", Locale.ENGLISH).format(date));
        this.genln("*/");
        this.genln("");
    }

    private Hashtable determineReferredClasses() {
        Object object;
        int n;
        GenericDeclaration[] genericDeclarationArray;
        this.refClassList = new Hashtable();
        if (this.superClass != null) {
            this.refClassList.put(this.superClass, this.superClass);
        }
        Constructor<?>[] constructorArray = this.c.getDeclaredConstructors();
        int n2 = 0;
        while (n2 < constructorArray.length) {
            genericDeclarationArray = constructorArray[n2].getParameterTypes();
            n = 0;
            while (n < genericDeclarationArray.length) {
                if (!((Class)genericDeclarationArray[n]).isPrimitive() && !((Class)genericDeclarationArray[n]).isArray()) {
                    this.refClassList.put(genericDeclarationArray[n], genericDeclarationArray[n]);
                }
                ++n;
            }
            ++n2;
        }
        genericDeclarationArray = this.c.getDeclaredMethods();
        n = 0;
        while (n < genericDeclarationArray.length) {
            object = ((Method)genericDeclarationArray[n]).getReturnType();
            if (!((Class)object).isPrimitive() && !((Class)object).isArray()) {
                this.refClassList.put(object, object);
            }
            Class<?>[] classArray = ((Method)genericDeclarationArray[n]).getParameterTypes();
            int n3 = 0;
            while (n3 < classArray.length) {
                if (!classArray[n3].isPrimitive() && !classArray[n3].isArray()) {
                    this.refClassList.put(classArray[n3], classArray[n3]);
                }
                ++n3;
            }
            ++n;
        }
        object = this.c.getInterfaces();
        int n4 = 0;
        while (n4 < ((Object)object).length) {
            this.refClassList.put(object[n4], object[n4]);
            ++n4;
        }
        this.refClassList.remove(this.c);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration2 = this.refClassList.elements();
        while (enumeration2.hasMoreElements()) {
            Class clazz = (Class)enumeration2.nextElement();
            if (this.verbose) {
                System.err.println("\t\tuses: " + clazz.getName());
            }
            String string = new JavaType(clazz).getCPPName(this.EIBString);
            hashtable.put(string, string);
        }
        return hashtable;
    }

    private String methodNameCPP(String string) {
        if (CPPKeywords.get(string) != null) {
            return "_" + string;
        }
        return string;
    }

    private File fileExistsInStdIncludePathOrSearchList(String string) {
        File file2;
        if (this.stdIncludePath != null && (file2 = new File(this.stdIncludePath, string)).isFile()) {
            return file2;
        }
        if (this.searchPathList != null) {
            int n = 0;
            while (n < this.searchPathList.size()) {
                file2 = new File((String)this.searchPathList.elementAt(n), string);
                if (file2.isFile()) {
                    return file2;
                }
                ++n;
            }
        }
        return null;
    }

    private void genInclude(String string) {
        String string2;
        Object var2_2 = null;
        File file2 = this.fileExistsInStdIncludePathOrSearchList(string);
        if (file2 == null) {
            file2 = new File(this.cppDir, string);
        }
        String string3 = file2.getAbsolutePath();
        boolean bl = false;
        if (this.stdIncludePath != null && !bl) {
            string2 = new File(this.stdIncludePath).getAbsolutePath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (string3.startsWith(string2)) {
                string3 = string3.substring(string2.length());
                bl = true;
            }
        }
        if (this.cppDir != null && !bl) {
            string2 = new File(this.cppDir).getAbsolutePath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (string3.startsWith(string2)) {
                string3 = string3.substring(string2.length());
                bl = true;
            }
        }
        if (!bl) {
            string3 = file2.getPath();
        }
        if (string3.charAt(1) == ':') {
            string3 = string3.substring(2);
        }
        this.genln("#include \"" + string3 + "\"");
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_CPP_WRAPPER);
        CPPKeywordArray = new String[]{"asm", "continue", "float", "new", "signed", "try", "auto", "default", "for", "operator", "sizeof", "typedef", "break", "delete", "friend", "private", "static", "union", "case", "do", "goto", "protected", "struct", "unsigned", "catch", "double", "if", "public", "switch", "virtual", "char", "else", "inline", "register", "template", "void", "class", "enum", "int", "return", "this", "volatile", "const", "extern", "long", "short", "throw", "while"};
        CPPKeywords = new Hashtable();
        int n = 0;
        while (n < CPPKeywordArray.length) {
            CPPKeywords.put(CPPKeywordArray[n], CPPKeywordArray[n]);
            ++n;
        }
        CPPKeywords.put("min", "min");
        CPPKeywords.put("max", "max");
    }
}

