/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.wrapjava;

public class JavaType {
    private String javaName;
    private String cppName;
    private String structField;
    private String signatureString;
    private String JNIMethodName;
    private String JNIStaticMethodName;
    private int numOfStackItems;
    private int numOfIndexes = 0;
    private int javaType;
    private static final String EIBSTRING = "EIBString";
    private static final String JSTRING = "J_java_lang_String";
    private static final int JT_PRIMITIVE_TYPE = 16;
    private static final int JT_ARRAY_TYPE = 32;
    public static final int JT_CLASS = 1;
    public static final int JT_BOOLEAN = 18;
    public static final int JT_CHAR = 19;
    public static final int JT_BYTE = 20;
    public static final int JT_SHORT = 21;
    public static final int JT_INT = 22;
    public static final int JT_FLOAT = 23;
    public static final int JT_LONG = 24;
    public static final int JT_DOUBLE = 25;
    public static final int JT_VOID = 26;
    private static final int JT_ARRAY_OF_CLASS = 33;
    private static final int JT_ARRAY_OF_BOOLEAN = 50;
    private static final int JT_ARRAY_OF_CHAR = 51;
    private static final int JT_ARRAY_OF_BYTE = 52;
    private static final int JT_ARRAY_OF_SHORT = 53;
    private static final int JT_ARRAY_OF_INT = 54;
    private static final int JT_ARRAY_OF_FLOAT = 55;
    private static final int JT_ARRAY_OF_LONG = 56;
    private static final int JT_ARRAY_OF_DOUBLE = 57;
    static final char SIGNATURE_ANY_CHAR = 'A';
    static final char SIGNATURE_ARRAY_CHAR = '[';
    static final char SIGNATURE_BYTE_CHAR = 'B';
    static final char SIGNATURE_CHAR_CHAR = 'C';
    static final char SIGNATURE_CLASS_CHAR = 'L';
    static final char SIGNATURE_ENDCLASS_CHAR = ';';
    static final char SIGNATURE_ENUM_CHAR = 'E';
    static final char SIGNATURE_FLOAT_CHAR = 'F';
    static final char SIGNATURE_DOUBLE_CHAR = 'D';
    static final char SIGNATURE_FUNC_CHAR = '(';
    static final char SIGNATURE_ENDFUNC_CHAR = ')';
    static final char SIGNATURE_INT_CHAR = 'I';
    static final char SIGNATURE_LONG_CHAR = 'J';
    static final char SIGNATURE_SHORT_CHAR = 'S';
    static final char SIGNATURE_VOID_CHAR = 'V';
    static final char SIGNATURE_BOOLEAN_CHAR = 'Z';

    public JavaType(int n, String string, int n2) {
        this.javaType = n;
        this.javaName = string;
        this.numOfIndexes = n2;
        if (n2 > 0) {
            this.javaType |= 0x20;
        }
        this.determineDerivedValues();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JavaType(Class clazz) {
        this.numOfIndexes = 0;
        while (clazz.isArray()) {
            ++this.numOfIndexes;
            clazz = clazz.getComponentType();
        }
        int n = this.javaType = this.numOfIndexes > 0 ? 32 : 0;
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                this.javaType |= 0x12;
            } else if (clazz.equals(Character.TYPE)) {
                this.javaType |= 0x13;
            } else if (clazz.equals(Byte.TYPE)) {
                this.javaType |= 0x14;
            } else if (clazz.equals(Short.TYPE)) {
                this.javaType |= 0x15;
            } else if (clazz.equals(Integer.TYPE)) {
                this.javaType |= 0x16;
            } else if (clazz.equals(Float.TYPE)) {
                this.javaType |= 0x17;
            } else if (clazz.equals(Long.TYPE)) {
                this.javaType |= 0x18;
            } else if (clazz.equals(Double.TYPE)) {
                this.javaType |= 0x19;
            } else {
                if (!clazz.equals(Void.TYPE)) throw new InternalError("Unknown Java type: " + clazz);
                this.javaType |= 0x1A;
            }
        } else {
            this.javaType |= 1;
            this.javaName = clazz.getName();
        }
        this.determineDerivedValues();
    }

    public String getCPPName(boolean bl) {
        if (bl && this.cppName.equals(JSTRING)) {
            return EIBSTRING;
        }
        return this.cppName;
    }

    public String getCPPDecl(boolean bl) {
        String string = bl && this.cppName.equals(JSTRING) ? EIBSTRING : this.cppName;
        if (this.javaType == 1) {
            return "const " + string + "&";
        }
        return "const " + string;
    }

    public String getStructField() {
        return this.structField;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public int getNumOfStackItems() {
        return this.numOfStackItems;
    }

    public int getJavaType() {
        return this.javaType;
    }

    public int getJavaComponentType() {
        return this.javaType & 0xFFFFFFDF;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public boolean isPrimitive() {
        return (this.javaType & 0x10) != 0;
    }

    public boolean isArray() {
        return (this.javaType & 0x20) != 0;
    }

    public String getToObjectExpression(String string) {
        if ((this.javaType & 0x20) != 0) {
            return string;
        }
        switch (this.javaType) {
            case 18: {
                return "new java.lang.Boolean (" + string + ")";
            }
            case 19: {
                return "new java.lang.Character (" + string + ")";
            }
            case 20: {
                return "new java.lang.Byte (" + string + ")";
            }
            case 21: {
                return "new java.lang.Short (" + string + ")";
            }
            case 22: {
                return "new java.lang.Integer (" + string + ")";
            }
            case 23: {
                return "new java.lang.Float (" + string + ")";
            }
            case 24: {
                return "new java.lang.Long (" + string + ")";
            }
            case 25: {
                return "new java.lang.Double (" + string + ")";
            }
            case 1: {
                return string;
            }
        }
        throw new InternalError("Unknown Java type: " + this.javaType + " with name: " + string);
    }

    public String getJNIMethodName() {
        return this.JNIMethodName;
    }

    public String getJNIStaticMethodName() {
        return this.JNIStaticMethodName;
    }

    private void determineDerivedValues() {
        switch (this.javaType & 0xFFFFFFDF) {
            case 18: {
                this.javaName = "boolean";
                this.cppName = "jboolean";
                this.numOfStackItems = 1;
                this.structField = "i";
                this.signatureString = String.valueOf('Z');
                this.JNIMethodName = "CallBooleanMethod";
                this.JNIStaticMethodName = "CallStaticBooleanMethod";
                break;
            }
            case 19: {
                this.javaName = "char";
                this.cppName = "jchar";
                this.numOfStackItems = 1;
                this.structField = "i";
                this.signatureString = String.valueOf('C');
                this.JNIMethodName = "CallCharMethod";
                this.JNIStaticMethodName = "CallStaticCharMethod";
                break;
            }
            case 20: {
                this.javaName = "byte";
                this.cppName = "jbyte";
                this.numOfStackItems = 1;
                this.structField = "i";
                this.signatureString = String.valueOf('B');
                this.JNIMethodName = "CallByteMethod";
                this.JNIStaticMethodName = "CallStaticByteMethod";
                break;
            }
            case 21: {
                this.javaName = "short";
                this.cppName = "jshort";
                this.numOfStackItems = 1;
                this.structField = "i";
                this.signatureString = String.valueOf('S');
                this.JNIMethodName = "CallShortMethod";
                this.JNIStaticMethodName = "CallStaticShortMethod";
                break;
            }
            case 22: {
                this.javaName = "int";
                this.cppName = "jint";
                this.structField = "i";
                this.numOfStackItems = 1;
                this.signatureString = String.valueOf('I');
                this.JNIMethodName = "CallIntMethod";
                this.JNIStaticMethodName = "CallStaticIntMethod";
                break;
            }
            case 23: {
                this.javaName = "float";
                this.cppName = "jfloat";
                this.structField = "f";
                this.numOfStackItems = 1;
                this.signatureString = String.valueOf('F');
                this.JNIMethodName = "CallFloatMethod";
                this.JNIStaticMethodName = "CallStaticFloatMethod";
                break;
            }
            case 24: {
                this.javaName = "long";
                this.cppName = "jlong";
                this.structField = "<should not be generated> Java Long";
                this.numOfStackItems = 2;
                this.signatureString = String.valueOf('J');
                this.JNIMethodName = "CallLongMethod";
                this.JNIStaticMethodName = "CallStaticLongMethod";
                break;
            }
            case 25: {
                this.javaName = "double";
                this.cppName = "jdouble";
                this.structField = "<should not be generated> Java Double";
                this.numOfStackItems = 2;
                this.signatureString = String.valueOf('D');
                this.JNIMethodName = "CallDoubleMethod";
                this.JNIStaticMethodName = "CallStaticDoubleMethod";
                break;
            }
            case 26: {
                this.javaName = "void";
                this.cppName = "void";
                this.structField = "<should not be generated> Java void";
                this.numOfStackItems = 0;
                this.signatureString = String.valueOf('V');
                this.JNIMethodName = "CallVoidMethod";
                this.JNIStaticMethodName = "CallStaticVoidMethod";
                break;
            }
            case 1: {
                this.cppName = "J_" + this.javaName.replace('.', '_');
                this.numOfStackItems = 1;
                this.structField = "h";
                this.signatureString = String.valueOf('L') + this.javaName.replace('.', '/') + String.valueOf(';');
                this.JNIMethodName = "CallObjectMethod";
                this.JNIStaticMethodName = "CallStaticObjectMethod";
                break;
            }
            default: {
                throw new InternalError("Unknown Java type: " + this.javaType + " javaName= " + this.javaName);
            }
        }
        if ((this.javaType & 0x20) != 0) {
            this.structField = "h";
            this.numOfStackItems = 1;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.numOfIndexes) {
                stringBuffer.append('[');
                ++n;
            }
            this.signatureString = stringBuffer + this.signatureString;
            this.JNIMethodName = "CallObjectMethod";
            this.JNIStaticMethodName = "CallStaticObjectMethod";
            n = 0;
            while (n < this.numOfIndexes) {
                this.javaName = this.javaName + "[]";
                ++n;
            }
            if (this.numOfIndexes > 1) {
                this.cppName = "jarray";
            } else {
                switch (this.javaType) {
                    case 50: {
                        this.cppName = "jbooleanArray";
                        break;
                    }
                    case 51: {
                        this.cppName = "jcharArray";
                        break;
                    }
                    case 52: {
                        this.cppName = "jbyteArray";
                        break;
                    }
                    case 53: {
                        this.cppName = "jshortArray";
                        break;
                    }
                    case 54: {
                        this.cppName = "jintArray";
                        break;
                    }
                    case 55: {
                        this.cppName = "jfloatArray";
                        break;
                    }
                    case 56: {
                        this.cppName = "jlongArray";
                        break;
                    }
                    case 57: {
                        this.cppName = "jdoubleArray";
                        break;
                    }
                    case 33: {
                        this.cppName = "jobjectArray";
                        break;
                    }
                    default: {
                        throw new InternalError("Unknown Java type: " + this.javaType + " javaName= " + this.javaName);
                    }
                }
            }
        }
    }
}

