/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger.java;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.IManager;
import com.eibus.tools.tiger.Tiger;
import com.eibus.tools.tiger.java.JavaGen;
import com.eibus.tools.tiger.java.TigerDataType;
import com.eibus.tools.tiger.java.TigerElement;
import com.eibus.xml.util.DOMUtils;
import com.eibus.xml.util.ElementEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class TigerManager
extends ClassGen
implements IManager {
    int m_methodCount = 0;
    int m_managedTypeCount = 0;
    Vector m_metadataInit = new Vector();
    String m_elementName;
    String m_typeName;
    String m_idName;
    Hashtable m_bsqDefs = new Hashtable();
    JavaGen javaGen;
    private static char s_QUOTE = (char)34;
    private static char s_SLASH = (char)92;

    public TigerManager(Element element, Tiger tiger) throws GeneratorException {
        super(element, tiger);
        this.m_idName = ClassGen.getIdName(element);
        this.m_typeName = ClassGen.getTypeName(element);
        this.javaGen = new JavaGen(element, tiger);
        this.javaGen.checkValidIdentifier(this.m_idName);
        this.setOutputFile(this.javaGen.openJavaFile());
    }

    private String getQualifiedClassName(String string) {
        String string2 = this.javaGen.getNamespace();
        String string3 = string2 != null && string2.length() > 0 && string.indexOf(46) == -1 ? string2 + "." + string : string;
        return string3;
    }

    public void initialize() {
        this.javaGen.GenerateHeader(this);
        String string = this.javaGen.getNamespace();
        if (!string.equals("")) {
            this.println("package " + string + ";");
            this.println();
        }
        this.println("import java.math.BigDecimal;");
        this.println("import java.math.BigInteger;");
        this.println("import java.util.Date;");
        this.println("import com.baan.b3.boi1.BoiApplicationException;");
        this.println("import com.baan.b3.boi1.BoiException;");
        this.println("import com.baan.b3.boi1.BoiSynchronizationException;");
        this.println("import com.baan.b3.boi1.BusinessObject;");
        this.println("import com.baan.b3.boi1.BusinessObjectManager;");
        this.println("import com.baan.b3.boi1.Iterator;");
        this.println("import com.baan.b3.boi1.metadata.IManagerMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IMetadataFactory;");
        this.println("import com.baan.b3.boi1.metadata.IMethodImplementationAdapter;");
        this.println("import com.baan.b3.boi1.metadata.IMethodMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IObjectMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IParameterMetadata;");
        this.println();
        this.println("public class " + this.m_idName + " extends BusinessObjectManager");
        this.println("{");
        this.IncrementIndentation();
        this.println("public " + this.m_idName + "() throws BoiException");
        this.println("{");
        this.println("\tsuper();");
        if (this.javaGen.getContentLicense() != null) {
            this.println("\tsetContentLicense(\"" + this.javaGen.getContentLicense() + "\");");
        }
        this.println("}");
        this.println();
        this.println();
        this.println("public " + this.m_idName + "(String p_componentId, String p_primaryBackendComponent) throws BoiException");
        this.println("{");
        this.println("\tsuper(p_componentId, p_primaryBackendComponent);");
        if (this.javaGen.getContentLicense() != null) {
            this.println("\tsetContentLicense(\"" + this.javaGen.getContentLicense() + "\");");
        }
        this.println("}");
    }

    public void queryMethodModel(String string, String string2, String string3, boolean bl, boolean bl2, Element element, String string4, Element element2, String string5, String string6, Element element3, boolean bl3, boolean bl4) throws GeneratorException {
        this.javaGen.checkValidIdentifier(string2);
        if (string5 != null) {
            this.javaGen.checkValidClass(string5);
        }
        if (string.equals("BaanDLL")) {
            this.generateBaanDllMethod(string2, bl, element, string4, element2, string5, string6);
        } else if (string.equals("BaanSQL")) {
            if (bl3) {
                this.generateBaanSqlConstructor(string2, string3, element, element3, bl4);
            } else {
                this.generateBaanSqlMethod(string2, string3, bl2, element, string5, string6);
            }
        } else if (string.equals("QueryByDLL")) {
            if (!bl3) {
                this.generateQueryByDllMethod(string2, bl2, element, string4, element2, string5, string6);
            }
        } else {
            throw new GeneratorException("Unrecognised model name: \"" + string + "\"; cannot generate code.");
        }
    }

    private void generateBaanDllMethod(String string, boolean bl, Element element, String string2, Element element2, String string3, String string4) throws GeneratorException {
        String string5;
        String string6;
        String string7;
        String string8;
        Object object;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        this.println();
        this.println();
        this.print("\tpublic ");
        this.print(string4 + " " + string + "(");
        this.generateQueryParameters(element);
        this.print(")");
        this.println();
        this.println("\tthrows BoiException, BoiApplicationException");
        this.println("{");
        this.IncrementIndentation();
        String string9 = DOMUtils.getTextValue(element2).trim();
        String string10 = null;
        String string11 = null;
        Element element3 = this.frontend.getElementDef(string9);
        String string12 = element3 != null ? ClassGen.getIdName(element3) : string9;
        String string13 = element3 != null ? ClassGen.getDCDType(element3) : string9;
        String string14 = ClassGen.getDataType(element3, string9, new TigerDataType());
        String string15 = element2.getAttribute("Scope");
        if (!string15.equals("")) {
            if (string15.equals("Out")) {
                if (!TigerElement.isPrimalType(string14)) {
                    string10 = "null";
                    string11 = "\"elements\"";
                } else {
                    string10 = "\"" + string13 + "\"";
                    string11 = "null";
                }
            } else {
                throw new GeneratorException("Only Scope=\"Out\" allowed for  <Method> " + string9);
            }
        }
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        Vector<String> vector3 = new Vector<String>();
        int n3 = 0;
        Vector<String> vector4 = new Vector<String>();
        int n4 = 0;
        String string16 = string + "_parameters";
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element4;
                Element element5 = (Element)elementEnumeration.nextElement();
                object = DOMUtils.getTextValue(element5).trim();
                string8 = element5.getAttribute("Scope");
                if (string8.equals("")) {
                    string8 = "In";
                }
                string7 = (element4 = this.frontend.getElementDef((String)object)) != null ? ClassGen.getIdName(element4) : object;
                string6 = element4 != null ? ClassGen.getTypeName(element4) : object;
                string5 = element4 != null ? ClassGen.getDCDType(element4) : object;
                String string17 = element4 != null ? this.getLength(element4) : "";
                String string18 = ClassGen.getDataType(element4, (String)object, new TigerDataType());
                if (!string7.equals("")) {
                    String string19;
                    String string20 = string18.equals("java.util.Date") ? " date2String(p_" + string7 + ") " : (string18.equals("org.w3c.dom.Node") ? " XMLNode2String(p_" + string7 + ") " : (string18.equals("byte[]") ? " ByteArray2String(p_" + string7 + ") " : (string18.equals("boolean") ? " (p_" + string7 + " ? \"1\" : \"0\") " : " String.valueOf(p_" + string7 + ") ")));
                    if (string17.equals("")) {
                        string19 = "null";
                    } else {
                        if (!string5.equals("string")) {
                            throw new GeneratorException("Parameter '" + string6 + "' is not valid.\nLength attribute is not allowed for Datatype '" + string5 + "', only Datatype 'string' can have the Length attribute.");
                        }
                        string19 = "\"" + string17 + "\"";
                    }
                    boolean bl2 = string18.equals(string7);
                    String string21 = "BaanDllCallParameterSpec.BDCP_SCOPE_" + string8.toUpperCase();
                    if (!string8.equals("Out")) {
                        if (string18.equals(string7)) {
                            vector4.addElement("businessObjectParameterValues[" + n4++ + "] = p_" + string7 + ";");
                        } else {
                            vector3.addElement("parameterValues[" + n3++ + "] = " + string20 + ";");
                        }
                    }
                    vector2.addElement(string16 + "[" + n2++ + "] = new BaanDllCallParameterSpec(" + bl2 + ", " + string21 + ", \"" + string6 + "\", \"" + string5 + "\", " + string19 + ");");
                    String string22 = "IParameterMetadata.SCOPE_" + string8.toUpperCase();
                    if (string8.equals("Out")) continue;
                    if (string18.equals(string7)) {
                        String string23 = element4 != null ? element4.getAttribute("JavaPackage") : element5.getAttribute("JavaPackage");
                        String string24 = string23.equals("") ? this.getQualifiedClassName(string18) : string23 + "." + string18;
                        vector.addElement("tmpParamMetadata[" + n++ + "] = factory.createParameterMetadata(" + string22 + ", \"" + string7 + "\", \"" + string24 + "\", null);");
                        continue;
                    }
                    vector.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string18 + "\", \"" + string5 + "\", null);");
                    vector.addElement("tmpParamMetadata[" + n++ + "] = factory.createParameterMetadata(" + string22 + ", \"" + string7 + "\", tmpObjectMetadata, null);");
                    continue;
                }
                throw new GeneratorException("Invalid <Element> tag");
            }
            vector2.insertElementAt("BaanDllCallParameterSpec[] " + string16 + " = new BaanDllCallParameterSpec[" + n2 + "];", 0);
        }
        vector3.insertElementAt("String[] parameterValues = new String[" + n3 + "];", 0);
        this.printVector(vector3);
        vector4.insertElementAt("BusinessObject[] businessObjectParameterValues = new BusinessObject[" + n4 + "];", 0);
        this.printVector(vector4);
        if (bl) {
            this.println("return baanDllCallVector(s_bdc_" + string + ", parameterValues, businessObjectParameterValues);");
        } else {
            this.println("return (" + string3 + ") baanDllCallBusinessObject(s_bdc_" + string + ", parameterValues, businessObjectParameterValues);");
        }
        this.DecrementIndentation();
        this.println("}");
        if (vector2.size() == 0) {
            string16 = null;
        }
        this.println();
        this.println();
        this.println("private static final BaanDllCallSpec s_bdc_" + string + ";");
        this.println();
        this.println("static");
        this.println("{");
        this.IncrementIndentation();
        this.println("s_bdc_" + string + " = new BaanDllCallSpec(\"" + string2 + "\", \"" + string9 + "\", " + string10 + ", " + string11 + ", " + string3 + ".class );");
        this.printVector(vector2);
        this.println("s_bdc_" + string + ".setParameters(" + string16 + ");");
        this.DecrementIndentation();
        this.println("}");
        vector.insertElementAt("tmpParamMetadata = new IParameterMetadata[" + n + "];", 0);
        this.addLinesToVectorEnd(vector, this.m_metadataInit);
        object = this.frontend.getElementDef(string3);
        string8 = ClassGen.getDataType((Element)object, string3, new TigerDataType());
        string7 = object != null ? ClassGen.getIdName((Element)object) : string3;
        string6 = string4;
        if (string8.equals(string7)) {
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string7 + "\", \"" + this.getQualifiedClassName(string8) + "\", null);");
        } else {
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string8 + "\", \"" + string6 + "\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string7 + "\", tmpObjectMetadata, null);");
        }
        string5 = bl ? "BDC_MNR_VECTOR" : "BDC_MNR_BUSINESSOBJECT";
        this.m_metadataInit.addElement("tmpMethodAdapter = createBdcMethodAdapter(" + string5 + ", s_bdc_" + string + ", " + this.m_idName + ".class, tmpParamMetadata, tmpReturnTypeMetadata, " + n3 + ", " + n4 + ");");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"" + string + "\", tmpParamMetadata, tmpReturnTypeMetadata, tmpMethodAdapter, null);");
    }

    private void generateBaanSqlMethod(String string, String string2, boolean bl, Element element, String string3, String string4) throws GeneratorException {
        String string5;
        Object object;
        String string6;
        String string7;
        Element element2;
        this.println();
        this.println();
        this.print("\tpublic ");
        this.print(string4 + " " + string + "(");
        BaanSqlQueryDef baanSqlQueryDef = (BaanSqlQueryDef)this.m_bsqDefs.get(string);
        if (baanSqlQueryDef == null) {
            baanSqlQueryDef = new BaanSqlQueryDef(string);
            this.m_bsqDefs.put(string, baanSqlQueryDef);
        }
        baanSqlQueryDef.setReturnClassName(string3);
        this.generateQueryParameters(element);
        this.print(")");
        this.println();
        if (bl) {
            this.println("\tthrows BoiException");
            this.println("{");
            this.generateSqlConvertParameters(element);
            this.println("\treturn baanSqlQueryIterator(s_bsq_" + string + ", parameterValues);");
        } else {
            this.println("\tthrows BoiException, BoiApplicationException");
            this.println("{");
            this.generateSqlConvertParameters(element);
            this.println("\treturn (" + string3 + ") baanSqlQueryBusinessObject(s_bsq_" + string + ", parameterValues);");
        }
        this.println("}");
        this.println();
        this.println();
        this.print("\tpublic void add" + ClassGen.capitalise(string) + "(");
        this.generateQueryParameters(element);
        this.print(")");
        this.println();
        this.println("\tthrows IllegalStateException");
        this.println("{");
        this.generateSqlConvertParameters(element);
        this.println("\taddBaanSqlQuery(s_bsq_" + string + ", parameterValues);");
        this.println("}");
        Vector<String> vector = new Vector<String>();
        int n = 0;
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                element2 = (Element)elementEnumeration.nextElement();
                string7 = DOMUtils.getTextValue(element2).trim();
                string6 = element2.getAttribute("Scope");
                if (string6.length() == 0) {
                    string6 = "In";
                }
                string5 = (object = this.frontend.getElementDef(string7)) != null ? ClassGen.getIdName((Element)object) : string7;
                String string8 = object != null ? ClassGen.getDCDType((Element)object) : string7;
                String string9 = ClassGen.getDataType((Element)object, string7, new TigerDataType());
                String string10 = "IParameterMetadata.SCOPE_" + string6.toUpperCase();
                if (string6.equals("Out")) continue;
                if (string9.equals(string5)) {
                    vector.addElement("tmpParamMetadata[" + n++ + "] = factory.createParameterMetadata(" + string10 + ", \"" + string5 + "\", \"" + this.getQualifiedClassName(string9) + "\", null);");
                    continue;
                }
                vector.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string9 + "\", \"" + string8 + "\", null);");
                vector.addElement("tmpParamMetadata[" + n++ + "] = factory.createParameterMetadata(" + string10 + ", \"" + string5 + "\", tmpObjectMetadata, null);");
            }
        }
        vector.insertElementAt("tmpParamMetadata = new IParameterMetadata[" + n + "];", 0);
        this.addLinesToVectorEnd(vector, this.m_metadataInit);
        element2 = this.frontend.getElementDef(string3);
        string7 = ClassGen.getDataType(element2, string3, new TigerDataType());
        string6 = element2 != null ? ClassGen.getIdName(element2) : string3;
        object = string4;
        if (bl) {
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createIteratorMetadata(\"" + this.getQualifiedClassName(string7) + "\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string6 + "\", tmpObjectMetadata, null);");
        } else if (string7.equals(string6)) {
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string6 + "\", \"" + this.getQualifiedClassName(string7) + "\", null);");
        } else {
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string7 + "\", \"" + (String)object + "\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string6 + "\", tmpObjectMetadata, null);");
        }
        string5 = bl ? "BSQ_MNR_ITERATOR" : "BSQ_MNR_BUSINESSOBJECT";
        this.m_metadataInit.addElement("tmpMethodAdapter = createBsqMethodAdapter(" + string5 + ", s_bsq_" + string + ", " + this.m_idName + ".class, tmpParamMetadata, tmpReturnTypeMetadata, " + n + ");");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"" + string + "\", tmpParamMetadata, tmpReturnTypeMetadata, tmpMethodAdapter, null);");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBsqMethodAdapter(BSQ_MNR_ADD, s_bsq_" + string + ", " + this.m_idName + ".class, tmpParamMetadata, tmpReturnTypeMetadata, " + n + ");");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"add" + ClassGen.capitalise(string) + "\", tmpParamMetadata, null, tmpMethodAdapter, null);");
    }

    private void generateBaanSqlConstructor(String string, String string2, Element element, Element element2, boolean bl) throws GeneratorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        BaanSqlQueryDef baanSqlQueryDef = (BaanSqlQueryDef)this.m_bsqDefs.get(string);
        if (baanSqlQueryDef == null) {
            baanSqlQueryDef = new BaanSqlQueryDef(string, string2);
            this.m_bsqDefs.put(string, baanSqlQueryDef);
        } else {
            baanSqlQueryDef.setQueryText(string2);
        }
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element3 = (Element)elementEnumeration.nextElement();
                object6 = DOMUtils.getTextValue(element3).trim();
                this.javaGen.checkValidIdentifier((String)object6);
                object5 = element3.getAttribute("Scope");
                Element element4 = this.frontend.getElementDef((String)object6);
                object4 = element4 != null ? ClassGen.getIdName(element4) : object6;
                object3 = element4 != null ? ClassGen.getTypeName(element4) : object6;
                object2 = element4 != null ? ClassGen.getDCDType(element4) : object6;
                object = element4 != null ? ClassGen.getRelatedColumn(element4) : "";
                String string3 = ClassGen.getDataType(element4, (String)object6, new TigerDataType());
                if (!((String)object4).equals("")) {
                    if (((String)object5).equals("") || ((String)object5).equals("In")) {
                        if (((String)object).equals("")) {
                            baanSqlQueryDef.addParameter((String)object3, (String)object2, null);
                            continue;
                        }
                        baanSqlQueryDef.addParameter((String)object3, (String)object2, (String)object);
                        continue;
                    }
                    throw new GeneratorException("Illegal Scope=\"" + (String)object5 + "\" for parameter '" + (String)object4 + "' in BaanSQL <QueryDef>; Only Scope=\"In\" is allowed which is also the default.");
                }
                throw new GeneratorException("Invalid <Element> tag");
            }
        }
        if (element2 != null) {
            ClassGen.checkAttributes(element2, null);
            object6 = new Hashtable();
            object5 = new Hashtable();
            ((Hashtable)object6).put(string, string);
            object4 = baanSqlQueryDef.addLayout(ClassGen.getTypeName(element2), false);
            object3 = this.findNextValidLayoutChild(element2.getFirstChild(), element2);
            if (object3 != null) {
                object2 = new Stack();
                object = new Stack();
                boolean bl2 = false;
                Stack<Object> stack = new Stack<Object>();
                stack.push(object4);
                ((Stack)object2).push(object3);
                ((Stack)object).push(element2);
                while (!((Stack)object2).empty()) {
                    Object object7;
                    Element element5 = (Element)((Stack)object2).peek();
                    Element element6 = (Element)((Stack)object).peek();
                    object4 = (BaanSqlQueryLayoutDef)stack.peek();
                    if (!bl2) {
                        Element element7;
                        boolean bl3;
                        Object object8;
                        ((Hashtable)object5).put(element6, element6);
                        ClassGen.checkAttributes(element5, null);
                        object7 = DOMUtils.getTextValue(element5).trim();
                        String string4 = element5.getAttribute("Reference");
                        if (!(string4.equals("True") || string4.equals("False") || string4.equals(""))) {
                            throw new GeneratorException("Illegal attribute: Reference=\"" + string4 + "\" in <Layout>" + (String)object7 + "</Layout> in  <LayoutDef Type=\"" + ClassGen.getTypeName(element6) + "\">. Expected Reference=\"True\" or Reference=\"False\"");
                        }
                        Element element8 = this.frontend.getLayoutDef((String)object7);
                        if (element8 == null) {
                            throw new GeneratorException("Reference to unknown <Layout>" + (String)object7 + "</Layout> in  <LayoutDef Type=\"" + ClassGen.getTypeName(element6) + "\">");
                        }
                        boolean bl4 = string4.equals("True");
                        boolean bl5 = !ClassGen.getRelatedColumn(element8).equals("");
                        String string5 = element5.getAttribute("Query").trim();
                        if (string5.equals("")) {
                            string5 = null;
                        }
                        String string6 = ClassGen.getIdName(element8);
                        String string7 = ClassGen.getTypeName(element8);
                        ClassGen.checkAttributes(element8, null);
                        boolean bl6 = false;
                        if (string5 != null) {
                            Element element9 = this.frontend.getQueryDef(string5);
                            if (element9 == null) {
                                throw new GeneratorException("Reference to unknown 'Query=" + string5 + "' in  <Layout>" + string6 + "</Layout>");
                            }
                            if (this.frontend.getQueryDef(element9) == null) {
                                this.frontend.putQueryDef(element9);
                            }
                            object8 = ClassGen.getIdName(element9);
                            this.frontend.setQueryDef((String)object8, 1);
                            boolean bl7 = bl6 = ((Hashtable)object6).get(string5) == null;
                            if (bl6) {
                                ((Hashtable)object6).put(string5, string5);
                            }
                        }
                        boolean bl8 = bl3 = ((Hashtable)object5).get(element8) == null;
                        if (string5 == null) {
                            object8 = null;
                        } else {
                            object8 = (BaanSqlQueryDef)this.m_bsqDefs.get(string5);
                            if (object8 == null) {
                                object8 = new BaanSqlQueryDef(string5);
                                this.m_bsqDefs.put(string5, object8);
                            }
                        }
                        BaanSqlQueryLayoutDef baanSqlQueryLayoutDef = new BaanSqlQueryLayoutDef(string7, bl5);
                        BaanSqlQuerySubLayoutDef baanSqlQuerySubLayoutDef = ((BaanSqlQueryLayoutDef)object4).addSubLayout(baanSqlQueryLayoutDef, bl4, (BaanSqlQueryDef)object8, bl6, bl3);
                        if (bl3 && (element7 = this.findNextValidLayoutChild(element8.getFirstChild(), element8)) != null) {
                            ((Stack)object2).push(element7);
                            ((Stack)object).push(element8);
                            stack.push(baanSqlQueryLayoutDef);
                            continue;
                        }
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    ((Stack)object2).pop();
                    object7 = this.findNextValidLayoutChild(element5.getNextSibling(), element6);
                    if (object7 != null) {
                        bl2 = false;
                        ((Stack)object2).push(object7);
                        continue;
                    }
                    ((Stack)object).pop();
                    stack.pop();
                }
            }
        }
        if (string2.indexOf(36) != -1 && !bl) {
            throw new GeneratorException("Use of Client Side Query Parameters ($param) not allowed in nested Query <QueryDef Type=\"" + string + "\" Nested=\"True\">");
        }
    }

    private void generateQueryByDllMethod(String string, boolean bl, Element element, String string2, Element element2, String string3, String string4) throws GeneratorException {
        String string5;
        String string6;
        String string7;
        Object object;
        Object object2;
        String string8;
        Object object3;
        Element element3;
        Object object4;
        Element element4;
        this.println("");
        this.println("");
        this.print("\tpublic ");
        this.print(string4 + " " + string + "(");
        this.generateQueryParameters(element);
        this.print(")");
        this.println();
        if (bl) {
            this.println("\tthrows BoiException");
        } else {
            this.println("\tthrows BoiException, BoiApplicationException");
        }
        this.println("{");
        this.IncrementIndentation();
        String string9 = DOMUtils.getTextValue(element2).trim();
        String string10 = null;
        String string11 = null;
        Element element5 = this.frontend.getElementDef(string9);
        String string12 = element5 != null ? ClassGen.getIdName(element5) : string9;
        String string13 = element5 != null ? ClassGen.getDCDType(element5) : string9;
        String string14 = ClassGen.getDataType(element5, string9, new TigerDataType());
        String string15 = element2.getAttribute("Scope");
        if (!string15.equals("")) {
            if (string15.equals("Out")) {
                if (!TigerElement.isPrimalType(string14)) {
                    string10 = "null";
                    string11 = "\"elements\"";
                } else {
                    string10 = "\"" + string13 + "\"";
                    string11 = "null";
                }
            } else {
                throw new GeneratorException("Only Scope=\"Out\" allowed for  <Method> " + string9);
            }
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        Vector<String> vector3 = new Vector<String>();
        int n3 = 0;
        String string16 = string + "_parameters";
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                element4 = (Element)elementEnumeration.nextElement();
                object4 = DOMUtils.getTextValue(element4).trim();
                String string17 = element4.getAttribute("Scope");
                element3 = this.frontend.getElementDef((String)object4);
                object3 = element3 != null ? ClassGen.getIdName(element3) : object4;
                string8 = element3 != null ? ClassGen.getTypeName(element3) : object4;
                object2 = element3 != null ? ClassGen.getDCDType(element3) : object4;
                object = element3 != null ? this.getLength(element3) : "";
                string7 = ClassGen.getDataType(element3, (String)object4, new TigerDataType());
                if (!((String)object3).equals("")) {
                    string6 = string7.equals("java.util.Date") ? " date2String(p_" + (String)object3 + ") " : (string7.equals("byte[]") ? " ByteArray2String(p_" + (String)object3 + ") " : (string7.equals("org.w3c.dom.Node") ? " XMLNode2String(p_" + (String)object3 + ") " : (string7.equals("boolean") ? " (p_" + (String)object3 + " ? \"1\" : \"0\") " : " String.valueOf(p_" + (String)object3 + ") ")));
                    if (((String)object).equals("")) {
                        string5 = "null";
                    } else {
                        if (!((String)object2).equals("string")) {
                            throw new GeneratorException("Parameter '" + string8 + "' is not valid.\nLength attribute is not allowed for Datatype '" + (String)object2 + "', only Datatype 'string' can have the Length attribute.");
                        }
                        string5 = "\"" + (String)object + "\"";
                    }
                    boolean bl2 = string7.equals(object3);
                    String string18 = "QueryByDllParameterSpec.QBDP_SCOPE_" + string17.toUpperCase();
                    if (!string17.equals("Out")) {
                        if (string7.equals(object3)) {
                            vector3.addElement("businessObjectParameterValues[" + n3++ + "] = p_" + (String)object3 + ";");
                        } else {
                            vector2.addElement("parameterValues[" + n2++ + "] = " + string6 + ";");
                        }
                    }
                    vector.addElement(string16 + "[" + n++ + "] = new QueryByDllParameterSpec(" + bl2 + ", " + string18 + ", \"" + string8 + "\", \"" + (String)object2 + "\", " + string5 + ");");
                    continue;
                }
                throw new GeneratorException("Invalid <Element> tag");
            }
            vector.insertElementAt("QueryByDllParameterSpec[] " + string16 + " = new QueryByDllParameterSpec[" + n + "];", 0);
        }
        vector2.insertElementAt("String[] parameterValues = new String[" + n2 + "];", 0);
        this.printVector(vector2);
        vector3.insertElementAt("BusinessObject[] businessObjectParameterValues = new BusinessObject[" + n3 + "];", 0);
        this.printVector(vector3);
        if (bl) {
            this.println("return queryByDllIterator(s_qbd_" + string + ", parameterValues, businessObjectParameterValues);");
        } else {
            this.println("return (" + string3 + ") queryByDllBusinessObject(s_qbd_" + string + ", parameterValues, businessObjectParameterValues);");
        }
        this.DecrementIndentation();
        this.println("}");
        if (vector.size() == 0) {
            string16 = null;
        }
        this.println();
        this.println();
        this.println("private static final QueryByDllSpec s_qbd_" + string + ";");
        this.println();
        this.println("static");
        this.println("{");
        this.IncrementIndentation();
        this.println("s_qbd_" + string + " = new QueryByDllSpec(\"" + string + "\", \"" + string2 + "\", \"" + string9 + "\", " + string10 + ", " + string11 + ", " + string3 + ".class );");
        this.printVector(vector);
        this.println("s_qbd_" + string + ".setParameters(" + string16 + ");");
        this.DecrementIndentation();
        this.println("}");
        object4 = new Vector();
        int n4 = 0;
        elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                element4 = (Element)elementEnumeration.nextElement();
                object3 = DOMUtils.getTextValue(element4).trim();
                string8 = element4.getAttribute("Scope");
                if (string8.length() == 0) {
                    string8 = "In";
                }
                object2 = (element3 = this.frontend.getElementDef((String)object3)) != null ? ClassGen.getIdName(element3) : object3;
                object = element3 != null ? ClassGen.getDCDType(element3) : object3;
                string7 = ClassGen.getDataType(element3, (String)object3, new TigerDataType());
                string6 = "IParameterMetadata.SCOPE_" + string8.toUpperCase();
                if (string8.equals("Out")) continue;
                if (string7.equals(object2)) {
                    string5 = element3 != null ? element3.getAttribute("JavaPackage") : element4.getAttribute("JavaPackage");
                    String string19 = string5.equals("") ? this.getQualifiedClassName(string7) : string5 + "." + string7;
                    ((Vector)object4).addElement("tmpParamMetadata[" + n4++ + "] = factory.createParameterMetadata(" + string6 + ", \"" + (String)object2 + "\", \"" + string19 + "\", null);");
                    continue;
                }
                ((Vector)object4).addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string7 + "\", \"" + (String)object + "\", null);");
                ((Vector)object4).addElement("tmpParamMetadata[" + n4++ + "] = factory.createParameterMetadata(" + string6 + ", \"" + (String)object2 + "\", tmpObjectMetadata, null);");
            }
        }
        ((Vector)object4).insertElementAt("tmpParamMetadata = new IParameterMetadata[" + n4 + "];", 0);
        this.addLinesToVectorEnd((Vector)object4, this.m_metadataInit);
        object3 = this.frontend.getElementDef(string3);
        string8 = ClassGen.getDataType((Element)object3, string3, new TigerDataType());
        object2 = object3 != null ? ClassGen.getIdName((Element)object3) : string3;
        object = string4;
        if (bl) {
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createIteratorMetadata(\"" + this.getQualifiedClassName(string8) + "\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + (String)object2 + "\", tmpObjectMetadata, null);");
        } else if (string8.equals(object2)) {
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + (String)object2 + "\", \"" + this.getQualifiedClassName(string8) + "\", null);");
        } else {
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string8 + "\", \"" + (String)object + "\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + (String)object2 + "\", tmpObjectMetadata, null);");
        }
        string7 = bl ? "QBD_MNR_ITERATOR" : "QBD_MNR_BUSINESSOBJECT";
        this.m_metadataInit.addElement("tmpMethodAdapter = createQbdMethodAdapter(" + string7 + ", s_qbd_" + string + ", " + this.m_idName + ".class, tmpParamMetadata, tmpReturnTypeMetadata, " + n2 + ", " + n3 + ");");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"" + string + "\", tmpParamMetadata, tmpReturnTypeMetadata, tmpMethodAdapter, null);");
    }

    public void initializeRegistry(Hashtable hashtable, Vector vector) {
        String string;
        Object object;
        this.println();
        this.println("private static final Class[] s_businessObjectClasses =");
        this.println("{");
        this.IncrementIndentation();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            object = (String)enumeration2.nextElement();
            string = (String)object + ".class";
            if (enumeration2.hasMoreElements()) {
                string = string + ",";
            }
            this.println(string);
        }
        this.DecrementIndentation();
        this.println("};");
        this.println();
        this.println("protected final Class[] getBusinessObjectClasses()");
        this.println("{");
        this.IncrementIndentation();
        enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            this.println((String)enumeration2.nextElement() + ".initializeClass();");
        }
        this.println("return s_businessObjectClasses;");
        this.DecrementIndentation();
        this.println("}");
        object = vector.elements();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            this.m_metadataInit.addElement("managedTypes[" + this.m_managedTypeCount++ + "] = \"" + this.getQualifiedClassName(string) + "\";");
        }
    }

    private String toStringLiteral(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(s_QUOTE + string + s_QUOTE);
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) == s_QUOTE || string.charAt(n) == s_SLASH) {
                stringBuffer.insert(n + 1, s_SLASH);
            }
            --n;
        }
        return stringBuffer.toString();
    }

    public void finish() {
        Object[] objectArray;
        Object object;
        this.println();
        this.println();
        Enumeration enumeration2 = this.m_bsqDefs.keys();
        while (enumeration2.hasMoreElements()) {
            object = (BaanSqlQueryDef)this.m_bsqDefs.get(enumeration2.nextElement());
            this.println("private static final BaanSqlQuerySpec s_bsq_" + ((BaanSqlQueryDef)object).idName + ";");
        }
        this.println();
        this.println();
        this.println("static");
        this.println("{");
        this.IncrementIndentation();
        this.println("BaanSqlQueryParameterSpec[] bsqParametersTmp = null;");
        this.println("BaanSqlQueryReturnTypeSpec bsqReturnTypeTmp = null;");
        this.println("BaanSqlQueryLayoutSpec bsqLayoutTmp = null;");
        this.println();
        enumeration2 = this.m_bsqDefs.keys();
        while (enumeration2.hasMoreElements()) {
            object = (BaanSqlQueryDef)this.m_bsqDefs.get(enumeration2.nextElement());
            if (((BaanSqlQueryDef)object).returnType == null) {
                this.println("bsqReturnTypeTmp = null;");
            } else {
                this.println("bsqReturnTypeTmp = new BaanSqlQueryReturnTypeSpec(" + ((BaanSqlQueryDef)object).returnType.returnClassName + ".class);");
            }
            if (((BaanSqlQueryDef)object).layoutDef == null) {
                this.println("bsqLayoutTmp = null;");
            } else {
                this.println("bsqLayoutTmp = new BaanSqlQueryLayoutSpec(\"" + ((BaanSqlQueryDef)object).layoutDef.typeName + "\", " + ((BaanSqlQueryDef)object).layoutDef.isAlias + ");");
            }
            this.println("s_bsq_" + ((BaanSqlQueryDef)object).idName + " = new BaanSqlQuerySpec(" + this.toStringLiteral(((BaanSqlQueryDef)object).queryText) + ", \"" + ((BaanSqlQueryDef)object).idName + "\", bsqLayoutTmp, bsqReturnTypeTmp);");
            objectArray = ((BaanSqlQueryDef)object).getParameters();
            if (objectArray.length != 0) {
                this.println("bsqParametersTmp = new BaanSqlQueryParameterSpec[" + objectArray.length + "];");
                int n = 0;
                while (n < objectArray.length) {
                    Object object2 = objectArray[n];
                    this.println("bsqParametersTmp[" + n + "] = new BaanSqlQueryParameterSpec(\"" + ((BaanSqlQueryParameterDef)object2).typeName + "\", \"" + ((BaanSqlQueryParameterDef)object2).dcdType + "\", " + (((BaanSqlQueryParameterDef)object2).relatedColumn == null ? "null" : "\"" + ((BaanSqlQueryParameterDef)object2).relatedColumn + "\"") + ");");
                    ++n;
                }
                this.println("s_bsq_" + ((BaanSqlQueryDef)object).idName + ".setParameters(bsqParametersTmp);");
            }
            this.println();
        }
        enumeration2 = this.m_bsqDefs.keys();
        while (enumeration2.hasMoreElements()) {
            object = (BaanSqlQueryDef)this.m_bsqDefs.get(enumeration2.nextElement());
            if (((BaanSqlQueryDef)object).layoutDef == null) continue;
            objectArray = ((BaanSqlQueryDef)object).layoutDef.getSubLayouts();
            String string = "bsqsl_" + ((BaanSqlQueryDef)object).idName;
            this.generateAddSubLayouts(string, (BaanSqlQuerySubLayoutDef[])objectArray);
            this.println("s_bsq_" + ((BaanSqlQueryDef)object).idName + ".layoutDef.setSubLayouts(" + string + ");");
            this.println();
        }
        this.DecrementIndentation();
        this.println("}");
        this.println();
        this.println();
        this.println("private static IManagerMetadata s_metadata = null;");
        this.println();
        this.println();
        this.println("public static IManagerMetadata retrieveMetadata()");
        this.println("{");
        this.IncrementIndentation();
        this.println("if (s_metadata == null)");
        this.println("{");
        this.IncrementIndentation();
        this.println("IMethodMetadata[] methodMetadata = new IMethodMetadata[" + this.m_methodCount + "];");
        this.println("String[] managedTypes = new String[" + this.m_managedTypeCount + "];");
        this.println("IMetadataFactory factory = getMetadataFactory();");
        this.println("IParameterMetadata tmpReturnTypeMetadata = null;");
        this.println("IParameterMetadata[] tmpParamMetadata = null;");
        this.println("IObjectMetadata tmpObjectMetadata = null;");
        this.println("IMethodImplementationAdapter tmpMethodAdapter = null;");
        this.printVector(this.m_metadataInit);
        object = this.getQualifiedClassName(this.m_idName);
        this.println("s_metadata = factory.createManagerMetadata(\"" + (String)object + "\", methodMetadata, managedTypes, null);");
        this.DecrementIndentation();
        this.println("}");
        this.println("return s_metadata;");
        this.DecrementIndentation();
        this.println("}");
        this.println();
        this.println("private static int s_DomainProductId = " + this.frontend.getDomainProductId() + ";");
        this.println();
        this.println("public static int getDomainProductId()");
        this.println("{");
        this.IncrementIndentation();
        this.println("return s_DomainProductId;");
        this.DecrementIndentation();
        this.println("}");
        this.println();
        this.println("private static String s_DomainName = \"" + this.frontend.getDomainName() + "\";");
        this.println();
        this.println("public static String getDomainName()");
        this.println("{");
        this.IncrementIndentation();
        this.println("return s_DomainName;");
        this.DecrementIndentation();
        this.println("}");
        this.DecrementIndentation();
        this.println("}");
        this.closeOutputFile();
    }

    public void abort() throws GeneratorException {
        this.closeOutputFile();
        this.javaGen.deleteJavaFile();
    }

    private void generateAddSubLayouts(String string, BaanSqlQuerySubLayoutDef[] baanSqlQuerySubLayoutDefArray) {
        int n = baanSqlQuerySubLayoutDefArray.length;
        this.println("BaanSqlQuerySubLayoutSpec[] " + string + " = new BaanSqlQuerySubLayoutSpec[" + n + "];");
        int n2 = 0;
        while (n2 < n) {
            BaanSqlQuerySubLayoutDef baanSqlQuerySubLayoutDef = baanSqlQuerySubLayoutDefArray[n2];
            BaanSqlQueryLayoutDef baanSqlQueryLayoutDef = baanSqlQuerySubLayoutDef.layoutDef;
            this.println("bsqLayoutTmp = new BaanSqlQueryLayoutSpec(\"" + baanSqlQueryLayoutDef.typeName + "\", " + baanSqlQueryLayoutDef.isAlias + ");");
            this.println(string + "[" + n2 + "] = new BaanSqlQuerySubLayoutSpec(bsqLayoutTmp, " + baanSqlQuerySubLayoutDef.isReference + ", " + (baanSqlQuerySubLayoutDef.queryDef == null ? "null" : "s_bsq_" + baanSqlQuerySubLayoutDef.queryDef.idName) + ", " + baanSqlQuerySubLayoutDef.shouldAppendConstructor + ", " + baanSqlQuerySubLayoutDef.shouldProcessLayoutDef + ");");
            BaanSqlQuerySubLayoutDef[] baanSqlQuerySubLayoutDefArray2 = baanSqlQueryLayoutDef.getSubLayouts();
            if (baanSqlQuerySubLayoutDefArray2.length != 0) {
                String string2 = string + "_" + n2;
                this.generateAddSubLayouts(string2, baanSqlQuerySubLayoutDefArray2);
                this.println(string + "[" + n2 + "].layoutDef.setSubLayouts(" + string2 + ");");
            }
            ++n2;
        }
    }

    private Element findNextValidLayoutChild(Node node, Element element) throws GeneratorException {
        Node node2 = node;
        while (node2 != null) {
            short s = node2.getNodeType();
            if (s == 1) {
                Element element2 = (Element)node2;
                String string = element2.getTagName();
                if (string.equals("Layout")) {
                    return element2;
                }
                throw new GeneratorException("Illegal tag name '" + string + "' in <Layout> in <LayoutDef Type=\"" + ClassGen.getTypeName(element) + "\">");
            }
            if (s != 3 && s != 8) {
                throw new GeneratorException("Illegal element '" + node2.getNodeName() + "'  <LayouttDef Type=\"" + ClassGen.getTypeName(element) + "\">");
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    private void generateSqlConvertParameters(Element element) throws GeneratorException {
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element2 = (Element)elementEnumeration.nextElement();
                String string = DOMUtils.getTextValue(element2).trim();
                String string2 = element2.getAttribute("Scope");
                Element element3 = this.frontend.getElementDef(string);
                String string3 = element3 != null ? ClassGen.getIdName(element3) : string;
                String string4 = ClassGen.getDataType(element3, string, new TigerDataType());
                if (!string3.equals("")) {
                    if (string4.equals("java.util.Date")) {
                        vector.addElement("\tparameterValues[" + n + "] = date2String(p_" + string3 + ");");
                    } else if (string4.equals("org.w3c.dom.Node")) {
                        vector.addElement("\tparameterValues[" + n + "] = XMLNode2String(p_" + string3 + ");");
                    } else if (string4.equals("byte[]")) {
                        vector.addElement("\tparameterValues[" + n + "] = ByteArray2String(p_" + string3 + ");");
                    } else if (string4.equals("boolean")) {
                        vector.addElement("\tparameterValues[" + n + "] = p_" + string3 + " ? \"1\" : \"0\";");
                    } else {
                        vector.addElement("\tparameterValues[" + n + "] = String.valueOf(p_" + string3 + ");");
                    }
                    if (!string2.equals("") && !string2.equals("In")) {
                        throw new GeneratorException("Illegal Scope=\"" + string2 + "\" for parameter '" + string3 + "' in BaanSQL <QueryDef>; Only Scope=\"In\" is allowed" + " which is also the default.");
                    }
                } else {
                    throw new GeneratorException("Invalid <Element> tag");
                }
                ++n;
            }
        }
        this.println("\tString[] parameterValues = new String[" + n + "];");
        this.printVector(vector);
    }

    private void generateQueryParameters(Element element) throws GeneratorException {
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            boolean bl = true;
            while (elementEnumeration.hasMoreElements()) {
                Element element2 = (Element)elementEnumeration.nextElement();
                ClassGen.checkAttributes(element2, null);
                String string = DOMUtils.getTextValue(element2).trim();
                String string2 = element2.getAttribute("Scope");
                if (string2.equals("") || string2.equals("In") || string2.equals("InOut")) {
                    Element element3 = this.frontend.getElementDef(string);
                    if (!bl) {
                        this.print(", ");
                    } else {
                        bl = false;
                    }
                    String string3 = element3 != null ? ClassGen.getIdName(element3) : string;
                    String string4 = ClassGen.getDataType(element3, string, new TigerDataType());
                    String string5 = element2.getAttribute("JavaPackage");
                    if (!string5.equals("")) {
                        string4 = string5 + "." + string4;
                    }
                    ClassGen.checkAttributes(element3, null);
                    if (!string3.equals("")) {
                        this.print(string4 + " p_" + string3);
                        continue;
                    }
                    throw new GeneratorException("Invalid <Element> tag");
                }
                if (string2.equals("Out")) continue;
                throw new GeneratorException("Illegal Scope=\"" + string2 + "\" in <QueryDef Type=\"" + this.m_typeName + "\">  in <Element>" + string + ". Legal scope values are: In/InOut/Out");
            }
        }
    }

    private class BaanSqlQuerySubLayoutDef {
        public final BaanSqlQueryLayoutDef layoutDef;
        public final boolean isReference;
        public final BaanSqlQueryDef queryDef;
        public final boolean shouldAppendConstructor;
        public final boolean shouldProcessLayoutDef;

        public BaanSqlQuerySubLayoutDef(BaanSqlQueryLayoutDef baanSqlQueryLayoutDef, boolean bl, BaanSqlQueryDef baanSqlQueryDef, boolean bl2, boolean bl3) throws NullPointerException {
            if (baanSqlQueryLayoutDef == null) {
                throw new NullPointerException("p_layoutDef must not be null");
            }
            this.layoutDef = baanSqlQueryLayoutDef;
            this.isReference = bl;
            this.queryDef = baanSqlQueryDef;
            this.shouldAppendConstructor = bl2;
            this.shouldProcessLayoutDef = bl3;
        }
    }

    private class BaanSqlQueryLayoutDef {
        private Vector m_subLayouts = new Vector();
        private BaanSqlQuerySubLayoutDef[] m_subLayoutsCache = null;
        public final String typeName;
        public final boolean isAlias;

        public BaanSqlQueryLayoutDef(String string, boolean bl) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            this.typeName = string;
            this.isAlias = bl;
        }

        public BaanSqlQuerySubLayoutDef addSubLayout(BaanSqlQueryLayoutDef baanSqlQueryLayoutDef, boolean bl, BaanSqlQueryDef baanSqlQueryDef, boolean bl2, boolean bl3) throws NullPointerException {
            BaanSqlQuerySubLayoutDef baanSqlQuerySubLayoutDef = new BaanSqlQuerySubLayoutDef(baanSqlQueryLayoutDef, bl, baanSqlQueryDef, bl2, bl3);
            this.m_subLayouts.addElement(baanSqlQuerySubLayoutDef);
            return baanSqlQuerySubLayoutDef;
        }

        public BaanSqlQuerySubLayoutDef[] getSubLayouts() {
            if (this.m_subLayoutsCache == null) {
                this.m_subLayoutsCache = new BaanSqlQuerySubLayoutDef[this.m_subLayouts.size()];
                int n = 0;
                while (n < this.m_subLayoutsCache.length) {
                    this.m_subLayoutsCache[n] = (BaanSqlQuerySubLayoutDef)this.m_subLayouts.elementAt(n);
                    ++n;
                }
            }
            return this.m_subLayoutsCache;
        }
    }

    private class BaanSqlQueryReturnTypeDef {
        public final String returnClassName;

        public BaanSqlQueryReturnTypeDef(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_returnClassName must not be null");
            }
            this.returnClassName = string;
        }
    }

    private class BaanSqlQueryParameterDef {
        public final String typeName;
        public final String dcdType;
        public final String relatedColumn;

        public BaanSqlQueryParameterDef(String string, String string2, String string3) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            if (string2 == null) {
                throw new NullPointerException("p_dcdType must not be null");
            }
            this.typeName = string;
            this.dcdType = string2;
            this.relatedColumn = string3;
        }
    }

    private class BaanSqlQueryDef {
        private Vector m_parameters = new Vector();
        private BaanSqlQueryParameterDef[] m_parametersCache = null;
        public String queryText;
        public final String idName;
        public BaanSqlQueryLayoutDef layoutDef;
        public BaanSqlQueryReturnTypeDef returnType;

        public BaanSqlQueryDef(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_idName must not be null");
            }
            this.idName = string;
            this.queryText = null;
            this.layoutDef = null;
            this.returnType = null;
        }

        BaanSqlQueryDef(String string, String string2) throws NullPointerException {
            this(string);
            if (string2 == null) {
                throw new NullPointerException("p_idName must not be null");
            }
            this.queryText = string2;
        }

        public BaanSqlQueryLayoutDef addLayout(String string, boolean bl) throws NullPointerException {
            this.layoutDef = new BaanSqlQueryLayoutDef(string, bl);
            return this.layoutDef;
        }

        public void addParameter(String string, String string2, String string3) throws NullPointerException {
            this.m_parameters.addElement(new BaanSqlQueryParameterDef(string, string2, string3));
        }

        public BaanSqlQueryParameterDef[] getParameters() {
            if (this.m_parametersCache == null) {
                this.m_parametersCache = new BaanSqlQueryParameterDef[this.m_parameters.size()];
                int n = 0;
                while (n < this.m_parametersCache.length) {
                    this.m_parametersCache[n] = (BaanSqlQueryParameterDef)this.m_parameters.elementAt(n);
                    ++n;
                }
            }
            return this.m_parametersCache;
        }

        public void setQueryText(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_queryText must not be null");
            }
            this.queryText = string;
        }

        public void setReturnClassName(String string) {
            this.returnType = new BaanSqlQueryReturnTypeDef(string);
        }
    }
}

