/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger.java;

import com.baan.b3.dom.Element;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.IElement;
import com.eibus.tools.tiger.Symbol;
import com.eibus.tools.tiger.Tiger;
import com.eibus.tools.tiger.java.JavaGen;
import java.util.Enumeration;
import java.util.Vector;

public class TigerElement
extends ClassGen
implements IElement {
    private static final String[] PRIMAL_TYPES = new String[14];
    private String packagePrefix;
    private boolean packageDefinedinDefinition;
    private String typeName;
    private String idName;
    private String modelName;
    private boolean readOnly;
    private int m_methodCount = 0;
    private int m_memberCount = 0;
    private Vector m_metadataInit = new Vector();
    private Vector m_symbolTable = null;
    private JavaGen javaGen;

    public TigerElement(Element element, Tiger tiger) throws GeneratorException {
        super(element, tiger);
        this.javaGen = new JavaGen(element, tiger);
        this.idName = ClassGen.getIdName(element);
        this.javaGen.checkValidIdentifier(this.idName);
        this.typeName = ClassGen.getTypeName(element);
        this.modelName = ClassGen.getModelName(element);
        this.readOnly = this.getReadOnly(element).equals("True");
        this.setOutputFile(this.javaGen.openJavaFile());
    }

    private static int primalType(String string) {
        int n = 0;
        while (n < PRIMAL_TYPES.length) {
            if (PRIMAL_TYPES[n].equals(string)) {
                return n;
            }
            ++n;
        }
        RuntimeException runtimeException = new RuntimeException("com.eibus.tools.tiger.java.TigerElement.primalType: Unknown type '" + string + "'.");
        runtimeException.printStackTrace();
        throw runtimeException;
    }

    public static boolean isPrimalType(String string) {
        int n = 0;
        while (n < PRIMAL_TYPES.length) {
            if (PRIMAL_TYPES[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String getPrimalGetMethod(String string) {
        String string2 = string.equals("java.lang.String") ? "String" : (string.equals("java.math.BigDecimal") ? "BigDecimal" : (string.equals("java.math.BigInteger") ? "BigInteger" : (string.equals("java.util.Date") ? "Date" : (string.equals("org.w3c.dom.Node") ? "XMLNode" : (string.equals("byte[]") ? "ByteArray" : ClassGen.capitalise(string).toString())))));
        return ".get" + string2 + "()";
    }

    private String getQualifiedClassName(String string, String string2) {
        String string3 = this.javaGen.getNamespace();
        String string4 = string3 != null && string3.length() > 0 && string == string2 ? string3 + "." + string : string;
        return string4;
    }

    public void initialize() throws GeneratorException {
        this.packagePrefix = this.javaGen.getNamespace();
        this.packageDefinedinDefinition = this.javaGen.isNamespaceInDefinition();
        this.packagePrefix = this.packagePrefix != null && this.packagePrefix.length() > 0 ? this.packagePrefix + "." : "";
        this.javaGen.GenerateHeader(this);
        String string = this.javaGen.getNamespace();
        if (string != null && !string.equals("")) {
            this.println("package " + string + ";");
            this.println();
        }
        this.println("import com.baan.b3.boi1.BusinessObject;");
        this.println("import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IMemberAccessor;");
        this.println("import com.baan.b3.boi1.metadata.IMemberMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IMetadataFactory;");
        this.println("import com.baan.b3.boi1.metadata.IMethodImplementationAdapter;");
        this.println("import com.baan.b3.boi1.metadata.IMethodMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IObjectMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IParameterMetadata;");
        this.println("import com.baan.b3.boi1.metadata.IPrimalMemberAccessor;");
        this.println("import com.baan.b3.boi1.metadata.IPrimalObjectMetadata;");
        this.println("import java.util.Date;");
        this.println("import java.util.Dictionary;");
        this.println("import java.util.Hashtable;");
        this.println();
        this.println("public class " + this.idName + " extends BusinessObject");
        this.println("{");
        this.IncrementIndentation();
        if (this.packageDefinedinDefinition) {
            this.println("public static final String _TAG_NAME = \"" + this.typeName + "\";");
        } else {
            this.println("static final String _TAG_NAME = \"" + this.typeName + "\";");
            this.println("//package private");
        }
        this.println();
        this.println("public " + this.idName + "()");
        this.println("{");
        this.println("\tsuper(_TAG_NAME, s_memberCount, s_vectorCount, s_classElements, s_elementsByTagName, " + this.readOnly + ");");
        this.println("}");
    }

    public void idMethod() {
    }

    public void typeMethod() {
    }

    public void elementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        this.println();
        this.println("public " + string + " get" + ClassGen.capitalise(string2) + "At(int i)");
        this.println("\tthrows IndexOutOfBoundsException");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\treturn (" + string + ") vectorElementsAtReference(v_" + string2 + ", i);");
            } else {
                this.println("\treturn (" + string + ") vectorElementsAt(v_" + string2 + ", i);");
            }
        } else {
            this.println("\treturn vectorElementsAtPrimal(v_" + string2 + ", i, " + TigerElement.primalType(string) + ")" + TigerElement.getPrimalGetMethod(string) + ";");
        }
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[1];");
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"int\", \"ui2\", new String[] {\"Unsigned, 2 byte integer\"});");
        this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"i\", tmpObjectMetadata, new String[] {\"Array index\"});");
        int n = 0;
        String string5 = null;
        if (!TigerElement.isPrimalType(string)) {
            string4 = bl ? "BO_MNR_VECTORELEMENTSATREFERENCE" : "BO_MNR_VECTORELEMENTSAT";
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string2 + "\", \"" + this.getQualifiedClassName(string, string2) + "\", null);");
            string5 = this.getQualifiedClassName(string, string2) + ".class";
        } else {
            string4 = "BO_MNR_VECTORELEMENTSATPRIMAL";
            n = TigerElement.primalType(string);
            Element element = this.frontend.getElementDef(string2);
            String string6 = ClassGen.getDCDType(element);
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string6 + "\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string2 + "\", tmpObjectMetadata, null);");
        }
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter(" + this.idName + ".class, " + string4 + ", new int[] {v_" + string2 + ", " + n + "}, null, " + string5 + " );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"get" + ClassGen.capitalise(string2) + "At\", tmpParamMetadata, " + "tmpReturnTypeMetadata, tmpMethodAdapter, null);");
    }

    public void addElementMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        this.println();
        this.println("public void add" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\taddMemberBusinessElementReference(m_" + string2 + ", p_" + string2 + ", v_" + string2 + ");");
            } else {
                this.println("\taddMemberBusinessElement(m_" + string2 + ", p_" + string2 + ", v_" + string2 + ");");
            }
        } else {
            this.println("\taddMemberBusinessElementPrimal(m_" + string2 + ", PrimalVal.getInstance(p_" + string2 + "), TAG_" + string2 + ", v_" + string2 + ");");
        }
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[1];");
        String string5 = null;
        int n = 0;
        String string6 = null;
        if (!TigerElement.isPrimalType(string)) {
            string4 = bl ? "BO_MNR_ADDMEMBERBUSINESSELEMENTREFERENCE" : "BO_MNR_ADDMEMBERBUSINESSELEMENT";
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", \"" + this.getQualifiedClassName(string, string2) + "\", null);");
            string6 = this.getQualifiedClassName(string, string2) + ".class";
        } else {
            string4 = "BO_MNR_ADDMEMBERBUSINESSELEMENTPRIMAL";
            Element element = this.frontend.getElementDef(string2);
            String string7 = ClassGen.getDCDType(element);
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string7 + "\", null);");
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", tmpObjectMetadata, null);");
            n = TigerElement.primalType(string);
            string5 = "new String[] {TAG_" + string2 + "}";
        }
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter(" + this.idName + ".class, " + string4 + ", new int[] {m_" + string2 + ", v_" + string2 + ", " + n + "}, " + string5 + ", " + string6 + " );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"add" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "null, tmpMethodAdapter, null);");
    }

    public void setElementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        this.println();
        this.println("public void set" + ClassGen.capitalise(string2) + "At(" + string + " p_" + string2 + ", int i)");
        this.println("\tthrows IndexOutOfBoundsException");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\tsetMemberBusinessElementAtReference(m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", i);");
            } else {
                this.println("\tsetMemberBusinessElementAt(m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", i);");
            }
        } else {
            this.println("\tsetMemberBusinessElementAtPrimal(m_" + string2 + ", PrimalVal.getInstance(p_" + string2 + ") , TAG_" + string2 + ", v_" + string2 + ", i);");
        }
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[2];");
        String string5 = null;
        int n = 0;
        String string6 = null;
        if (!TigerElement.isPrimalType(string)) {
            string4 = bl ? "BO_MNR_SETMEMBERBUSINESSELEMENTATREFERENCE" : "BO_MNR_SETMEMBERBUSINESSELEMENTAT";
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", \"" + this.getQualifiedClassName(string, string2) + "\", null);");
            string6 = this.getQualifiedClassName(string, string2) + ".class";
        } else {
            string4 = "BO_MNR_SETMEMBERBUSINESSELEMENTATPRIMAL";
            Element element = this.frontend.getElementDef(string2);
            String string7 = ClassGen.getDCDType(element);
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string7 + "\", null);");
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", tmpObjectMetadata, null);");
            n = TigerElement.primalType(string);
            string5 = "new String[] {TAG_" + string2 + "}";
        }
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"int\", \"ui2\", new String[] {\"Unsigned, 2 byte integer\"});");
        this.m_metadataInit.addElement("tmpParamMetadata[1] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"i\", tmpObjectMetadata, new String[] {\"Array index\"});");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter(" + this.idName + ".class, " + string4 + ", new int[] {m_" + string2 + ", v_" + string2 + ", " + n + "}, " + string5 + ", " + string6 + " );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"set" + ClassGen.capitalise(string2) + "At\", tmpParamMetadata, " + "null, tmpMethodAdapter, null);");
    }

    public void insertElementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        this.println();
        this.println("public void insert" + ClassGen.capitalise(string2) + "At(" + string + " p_" + string2 + ", int i)");
        this.println("\tthrows IndexOutOfBoundsException");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\tinsertMemberBusinessElementAtReference(m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", i);");
            } else {
                this.println("\tinsertMemberBusinessElementAt(m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", i);");
            }
        } else {
            this.println("\tinsertMemberBusinessElementAtPrimal(m_" + string2 + ", PrimalVal.getInstance(p_" + string2 + "), TAG_" + string2 + ", v_" + string2 + ", i);");
        }
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[2];");
        String string5 = null;
        int n = 0;
        String string6 = null;
        if (!TigerElement.isPrimalType(string)) {
            string4 = bl ? "BO_MNR_INSERTMEMBERBUSINESSELEMENTATREFERENCE" : "BO_MNR_INSERTMEMBERBUSINESSELEMENTAT";
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", \"" + this.getQualifiedClassName(string, string2) + "\", null);");
            string6 = this.getQualifiedClassName(string, string2) + ".class";
        } else {
            string4 = "BO_MNR_INSERTMEMBERBUSINESSELEMENTATPRIMAL";
            Element element = this.frontend.getElementDef(string2);
            String string7 = ClassGen.getDCDType(element);
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string7 + "\", null);");
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", tmpObjectMetadata, null);");
            n = TigerElement.primalType(string);
            string5 = "new String[] {TAG_" + string2 + "}";
        }
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"int\", \"ui2\", new String[] {\"Unsigned, 2 byte integer\"});");
        this.m_metadataInit.addElement("tmpParamMetadata[1] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"i\", tmpObjectMetadata, new String[] {\"Array index\"});");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter(" + this.idName + ".class, " + string4 + ", new int[] {m_" + string2 + ", v_" + string2 + ", " + n + "}, " + string5 + ", " + string6 + " );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"insert" + ClassGen.capitalise(string2) + "At\", tmpParamMetadata, " + "null, tmpMethodAdapter, null);");
    }

    public void removeAllElementsMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("public void removeAll" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.println("\tremoveAllMemberBusinessElement(m_" + string2 + ", v_" + string2 + ");");
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[0];");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter( " + this.idName + ".class, " + "BO_MNR_REMOVEALLMEMBERBUSINESSELEMENT," + " new int[] {m_" + string2 + ", v_" + string2 + "}, null, null );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"removeAll" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "null, tmpMethodAdapter, null);");
    }

    public void removeElementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("public void remove" + ClassGen.capitalise(string2) + "At(int i)");
        this.println("\tthrows IndexOutOfBoundsException");
        this.println("{");
        this.println("\tremoveMemberBusinessElementAt(m_" + string2 + ", v_" + string2 + ", i, \"v_" + string2 + "\");");
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[1];");
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"int\", \"ui2\", new String[] {\"Unsigned, 2 byte integer\"});");
        this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"i\", tmpObjectMetadata, new String[] {\"Array index\"});");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter( " + this.idName + ".class, " + "BO_MNR_REMOVEMEMBERBUSINESSELEMENTAT," + " new int[] {m_" + string2 + ", v_" + string2 + "}, new String[] {\"v_" + string2 + "\"}, null );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"remove" + ClassGen.capitalise(string2) + "At\", tmpParamMetadata, " + "null, tmpMethodAdapter, null);");
    }

    public void removeElementMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (!TigerElement.isPrimalType(string)) {
            this.println();
            this.println("public boolean remove" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
            this.println("\tthrows IndexOutOfBoundsException");
            this.println("{");
            this.println("\treturn removeMemberBusinessElement(m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", \"v_" + string2 + "\");");
            this.println("}");
            this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[1];");
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", \"" + this.getQualifiedClassName(string, string2) + "\", null);");
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"boolean\", \"boolean\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"removed\", tmpObjectMetadata, null);");
            this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter( " + this.idName + ".class, " + "BO_MNR_REMOVEMEMBERBUSINESSELEMENT," + " new int[] {m_" + string2 + ", v_" + string2 + "}, new String[] {\"v_" + string2 + "\"}, null );");
            this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"remove" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "tmpReturnTypeMetadata, tmpMethodAdapter, null);");
        }
    }

    public void sizeMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("public int size" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.println("\treturn sizeVectorElements(v_" + string2 + ");");
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[0];");
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"int\", \"ui2\", new String[] {\"Unsigned, 2 byte integer\"});");
        this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"size\", tmpObjectMetadata, null);");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter( " + this.idName + ".class, " + "BO_MNR_SIZEVECTORELEMENTS," + " new int[] {v_" + string2 + "}, null, null );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"size" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "tmpReturnTypeMetadata, tmpMethodAdapter, null);");
    }

    public void getArrayMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
    }

    public void setArrayMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
    }

    public void getMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        this.println();
        this.println("public " + string + " get" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\treturn (" + string + ") getMemberElementReference(m_" + string2 + ");");
            } else {
                this.println("\treturn (" + string + ") getMemberElement(m_" + string2 + ");");
            }
        } else {
            this.println("\treturn getMemberElementPrimal(m_" + string2 + ", " + TigerElement.primalType(string) + ")" + TigerElement.getPrimalGetMethod(string) + ";");
        }
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[0];");
        int n = 0;
        String string5 = null;
        if (!TigerElement.isPrimalType(string)) {
            string4 = bl ? "BO_MNR_GETMEMBERELEMENTREFERENCE" : "BO_MNR_GETMEMBERELEMENT";
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string2 + "\", \"" + this.getQualifiedClassName(string, string2) + "\", null);");
            string5 = this.getQualifiedClassName(string, string2) + ".class";
        } else {
            string4 = "BO_MNR_GETMEMBERELEMENTPRIMAL";
            n = TigerElement.primalType(string);
            Element element = this.frontend.getElementDef(string2);
            String string6 = ClassGen.getDCDType(element);
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string6 + "\", null);");
            this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string2 + "\", tmpObjectMetadata, null);");
        }
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter(" + this.idName + ".class, " + string4 + ", new int[] {m_" + string2 + ", " + n + "}, null, " + string5 + " );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"get" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "tmpReturnTypeMetadata, tmpMethodAdapter, null);");
    }

    public void hasMethod(String string, String string2) {
        this.println();
        this.println("public boolean has" + ClassGen.capitalise(string) + "()");
        this.println("{");
        this.IncrementIndentation();
        this.println("return hasMethod(m_" + string + ");");
        this.DecrementIndentation();
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[0];");
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"boolean\", \"boolean\", null);");
        this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"has" + ClassGen.capitalise(string) + "\", tmpObjectMetadata, null);");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter( " + this.idName + ".class, " + "BO_MNR_HASMETHOD," + " new int[] {m_" + string + "}, null, null );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"has" + ClassGen.capitalise(string) + "\", tmpParamMetadata, " + "tmpReturnTypeMetadata, tmpMethodAdapter, null);");
    }

    public void setMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        this.println();
        this.println("public void set" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\tsetMemberBusinessElementReference(m_" + string2 + ", p_" + string2 + ");");
            } else {
                this.println("\tsetMemberBusinessElement(m_" + string2 + ", p_" + string2 + ");");
            }
        } else {
            this.println("\tsetMemberBusinessElementPrimal(m_" + string2 + ", PrimalVal.getInstance(p_" + string2 + "), TAG_" + string2 + ");");
        }
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[1];");
        String string5 = null;
        int n = 0;
        String string6 = null;
        if (!TigerElement.isPrimalType(string)) {
            string4 = bl ? "BO_MNR_SETMEMBERBUSINESSELEMENTREFERENCE" : "BO_MNR_SETMEMBERBUSINESSELEMENT";
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", \"" + this.getQualifiedClassName(string, string2) + "\", null);");
            string6 = this.getQualifiedClassName(string, string2) + ".class";
        } else {
            string4 = "BO_MNR_SETMEMBERBUSINESSELEMENTPRIMAL";
            Element element = this.frontend.getElementDef(string2);
            String string7 = ClassGen.getDCDType(element);
            this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string7 + "\", null);");
            this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", tmpObjectMetadata, null);");
            n = TigerElement.primalType(string);
            string5 = "new String[] {TAG_" + string2 + "}";
        }
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter(" + this.idName + ".class, " + string4 + ", new int[] {m_" + string2 + ", " + n + "}, " + string5 + ", " + string6 + " );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"set" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "null, tmpMethodAdapter, null);");
    }

    public void attributeHasMethod(String string, String string2, String string3) {
        this.println();
        this.println("public boolean has" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.IncrementIndentation();
        this.println("return hasAttribute(\"" + string3 + "\");");
        this.DecrementIndentation();
        this.println("}");
    }

    public void attributeGetMethod(String string, String string2, String string3) {
        this.println();
        this.println("public " + string + " get" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.println("\treturn attributeToPrimalVal(\"" + string3 + "\", " + TigerElement.primalType(string) + ")" + TigerElement.getPrimalGetMethod(string) + ";");
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[0];");
        int n = TigerElement.primalType(string);
        Element element = this.frontend.getAttributeDef(string2);
        String string4 = ClassGen.getDCDType(element);
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string4 + "\", null);");
        this.m_metadataInit.addElement("tmpReturnTypeMetadata = factory.createParameterMetadata(IParameterMetadata.SCOPE_OUT, \"" + string2 + "\", tmpObjectMetadata, null);");
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter( " + this.idName + ".class, " + "BO_MNR_ATTRIBUTETOPRIMALVAL, " + "new int[] {" + n + "}, new String[] {\"" + string3 + "\"}, null );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"get" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "tmpReturnTypeMetadata, tmpMethodAdapter, null);");
    }

    public void attributeSetMethod(String string, String string2, String string3) {
        this.println();
        this.println("public void set" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
        this.println("{");
        this.println("\tprimalValToAttribute( PrimalVal.getInstance(p_" + string2 + "), \"" + string3 + "\");");
        this.println("}");
        this.m_metadataInit.addElement("tmpParamMetadata = new IParameterMetadata[1];");
        Element element = this.frontend.getAttributeDef(string2);
        String string4 = ClassGen.getDCDType(element);
        this.m_metadataInit.addElement("tmpObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string4 + "\", null);");
        this.m_metadataInit.addElement("tmpParamMetadata[0] = factory.createParameterMetadata(IParameterMetadata.SCOPE_IN, \"" + string2 + "\", tmpObjectMetadata, null);");
        int n = TigerElement.primalType(string);
        this.m_metadataInit.addElement("tmpMethodAdapter = createBoMethodAdapter( " + this.idName + ".class, " + "BO_MNR_PRIMALVALTOATTRIBUTE, " + "new int[] {" + n + "}, new String[] {\"" + string3 + "\"}, null );");
        this.m_metadataInit.addElement("methodMetadata[" + this.m_methodCount++ + "] = factory.createMethodMetadata(\"set" + ClassGen.capitalise(string2) + "\", tmpParamMetadata, " + "null, tmpMethodAdapter, null);");
    }

    public void initializeRegistryMethod(Vector vector) {
        String string = this.javaGen.getNamespace();
        string = string != null && string.length() > 0 ? string + "." : "";
        this.println();
        this.println();
        this.println("static");
        this.println("{");
        this.IncrementIndentation();
        this.println("String[] names = new String[3];");
        this.println("names[0] = _TAG_NAME;");
        this.println("names[1] = \"" + this.idName + "\";");
        this.println("names[2] = \"" + string + this.idName + "\";");
        Enumeration enumeration2 = vector.elements();
        if (enumeration2 != null) {
            Vector<String> vector2 = new Vector<String>();
            int n = 0;
            while (enumeration2.hasMoreElements()) {
                Symbol symbol = (Symbol)enumeration2.nextElement();
                if (TigerElement.isPrimalType(symbol.getBackendType())) continue;
                vector2.addElement("dependencies[" + n++ + "] = " + symbol.getBackendType() + ".class;");
                vector2.addElement(symbol.getBackendType() + ".initializeClass();");
            }
            vector2.insertElementAt("Class[] dependencies = new Class[" + n + "];", 0);
            this.printVector(vector2);
            this.println("putBusinessObjectInfo(" + this.idName + ".class, names, dependencies);");
        } else {
            this.println("putBusinessObjectInfo(" + this.idName + ".class, names, null);");
        }
        this.DecrementIndentation();
        this.println("}");
    }

    public void validate(Vector vector) throws GeneratorException {
        Enumeration enumeration2 = vector.elements();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                Symbol symbol = (Symbol)enumeration2.nextElement();
                String string = symbol.getIdName();
                this.javaGen.checkValidIdentifier(string);
            }
        }
    }

    public void instanceInitializer(Vector vector) {
        Symbol symbol;
        Enumeration enumeration2 = vector.elements();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (enumeration2 != null) {
            this.println();
            while (enumeration2.hasMoreElements()) {
                symbol = (Symbol)enumeration2.nextElement();
                String string = symbol.getIdName();
                if (symbol.getElementDef() == null) {
                    this.println("private static final String TAG_" + string + " = " + symbol.getBackendType() + "._TAG_NAME;");
                    continue;
                }
                this.println("private static final String TAG_" + string + " = \"" + symbol.getTypeName() + "\";");
            }
        }
        if ((enumeration2 = vector.elements()) != null) {
            this.println();
            while (enumeration2.hasMoreElements()) {
                symbol = (Symbol)enumeration2.nextElement();
                this.println("private static final int m_" + symbol.getIdName() + " = " + n++ + ";");
                if (symbol.isVector()) {
                    this.println("private static final int v_" + symbol.getIdName() + " = " + n2++ + ";");
                }
                if (TigerElement.isPrimalType(symbol.getBackendType())) continue;
                this.println("private static final int c_" + symbol.getIdName() + " = " + n3++ + ";");
            }
        }
        this.staticInitializer(vector, n, n3, n2);
    }

    private void staticInitializer(Vector vector, int n, int n2, int n3) {
        this.m_symbolTable = (Vector)vector.clone();
        Enumeration enumeration2 = vector.elements();
        this.println();
        this.println("private static final int s_memberCount = " + n + ";");
        this.println("private static final int s_vectorCount = " + n3 + ";");
        if (n != 0) {
            this.println("private static final Dictionary s_elementsByTagName = new Hashtable(" + n + ");");
            this.println("private static final Class[] s_classElements = new Class[" + n2 + "];");
        } else {
            this.println("");
            this.println("private static final Dictionary s_elementsByTagName = null;");
            this.println("private static final Class[] s_classElements = null;");
        }
        this.println();
        this.println("static");
        this.println("{");
        this.println("\t// static class initializer");
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                Symbol symbol = (Symbol)enumeration2.nextElement();
                this.println("\ts_elementsByTagName.put(TAG_" + symbol.getIdName() + ", new int[] {" + "m_" + symbol.getIdName() + "," + (symbol.isVector() ? "v_" + symbol.getIdName() : "-1") + "," + (!TigerElement.isPrimalType(symbol.getBackendType()) ? "c_" + symbol.getIdName() : "-1") + "} );");
                if (TigerElement.isPrimalType(symbol.getBackendType())) continue;
                this.println("\ts_classElements[c_" + symbol.getIdName() + "] = " + symbol.getBackendType() + ".class;");
            }
        }
        this.println("}");
    }

    public void finish() {
        Object object;
        this.println();
        this.println();
        if (this.packageDefinedinDefinition) {
            this.println("public static void initializeClass()");
        } else {
            this.println("static void initializeClass()");
            this.println("//package private");
        }
        this.println("{");
        this.IncrementIndentation();
        this.println("//Intentionally blank");
        this.DecrementIndentation();
        this.println("}");
        Enumeration enumeration2 = this.m_symbolTable.elements();
        while (enumeration2.hasMoreElements()) {
            Object object2;
            String string;
            String string2;
            object = (Symbol)enumeration2.nextElement();
            String string3 = ((Symbol)object).getIdName();
            switch (((Symbol)object).getCard()) {
                case '?': {
                    string2 = "0, 1";
                    break;
                }
                case '1': {
                    string2 = "1, 1";
                    break;
                }
                case '*': {
                    string2 = "0, IMemberMetadata.INFINITE_CARDINALITY";
                    break;
                }
                case '+': {
                    string2 = "1, IMemberMetadata.INFINITE_CARDINALITY";
                    break;
                }
                default: {
                    throw new RuntimeException("bad cardinality (" + ((Symbol)object).getCard() + ") in Symbol");
                }
            }
            String string4 = "-1";
            if (((Symbol)object).isVector()) {
                string4 = "v_" + string3;
            }
            if (TigerElement.isPrimalType(string = ((Symbol)object).getBackendType())) {
                String string5;
                if (((Symbol)object).getType() == 'e') {
                    object2 = this.frontend.getElementDef(string3);
                    string5 = ClassGen.getDCDType((Element)object2);
                    this.m_metadataInit.addElement("tmpPrimalObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string5 + "\", null);");
                    this.m_metadataInit.addElement("tmpPrimalMemberAccessor = createPrimalMemberAccessor(" + this.idName + ".class, tmpPrimalObjectMetadata, " + TigerElement.primalType(string) + ", " + string2 + ", m_" + string3 + ", " + string4 + ", TAG_" + string3 + ");");
                } else {
                    object2 = this.frontend.getAttributeDef(string3);
                    string5 = ClassGen.getDCDType((Element)object2);
                    String string6 = ClassGen.getTypeName((Element)object2);
                    this.m_metadataInit.addElement("tmpPrimalObjectMetadata = factory.createPrimalObjectMetadata(\"" + string + "\", \"" + string5 + "\", null);");
                    this.m_metadataInit.addElement("tmpPrimalMemberAccessor = createAttributeMemberAccessor(" + this.idName + ".class, tmpPrimalObjectMetadata, " + TigerElement.primalType(string) + ", " + string2 + ", \"" + string6 + "\");");
                }
                this.m_metadataInit.addElement("memberMetadata[" + this.m_memberCount++ + "] = factory.createPrimalMemberMetadata(\"" + string3 + "\", tmpPrimalObjectMetadata, " + string2 + ", tmpPrimalMemberAccessor, null, " + ((Symbol)object).isReadOnly() + ", " + (((Symbol)object).getType() == 'a') + ");");
                continue;
            }
            object2 = "\"" + this.getQualifiedClassName(string, string3) + "\"";
            this.m_metadataInit.addElement("tmpMemberAccessor = createBoMemberAccessor(" + this.idName + ".class, " + (String)object2 + ", " + string2 + ", m_" + string3 + ", " + string4 + ", " + ((Symbol)object).isReference() + ");");
            this.m_metadataInit.addElement("memberMetadata[" + this.m_memberCount++ + "] = factory.createMemberMetadata(\"" + string3 + "\", " + (String)object2 + ", " + string2 + ", tmpMemberAccessor, null, " + ((Symbol)object).isReadOnly() + ");");
        }
        this.println();
        this.println();
        this.println("private static IBusinessObjectMetadata s_metadata = null;");
        this.println();
        this.println();
        this.println("public static IBusinessObjectMetadata retrieveMetadata()");
        this.println("{");
        this.IncrementIndentation();
        this.println("if (s_metadata == null)");
        this.println("{");
        this.IncrementIndentation();
        this.println("IMethodMetadata[] methodMetadata = new IMethodMetadata[" + this.m_methodCount + "];");
        this.println("IMemberMetadata[] memberMetadata = new IMemberMetadata[" + this.m_memberCount + "];");
        this.println("IMetadataFactory factory = getMetadataFactory();");
        this.println("IParameterMetadata tmpReturnTypeMetadata = null;");
        this.println("IParameterMetadata[] tmpParamMetadata = null;");
        this.println("IObjectMetadata tmpObjectMetadata = null;");
        this.println("IPrimalObjectMetadata tmpPrimalObjectMetadata = null;");
        this.println("IMethodImplementationAdapter tmpMethodAdapter = null;");
        this.println("IMemberAccessor tmpMemberAccessor = null;");
        this.println("IPrimalMemberAccessor tmpPrimalMemberAccessor = null;");
        this.printVector(this.m_metadataInit);
        object = this.getQualifiedClassName(this.idName, this.idName);
        this.println("s_metadata = factory.createBusinessObjectMetadata(\"" + (String)object + "\", \"" + this.idName + "\", methodMetadata, memberMetadata, null, " + this.readOnly + ");");
        this.DecrementIndentation();
        this.println("}");
        this.println("return s_metadata;");
        this.DecrementIndentation();
        this.println("}");
        this.DecrementIndentation();
        this.println("}");
        this.closeOutputFile();
    }

    public void abort() throws GeneratorException {
        this.closeOutputFile();
        this.javaGen.deleteJavaFile();
    }

    static {
        TigerElement.PRIMAL_TYPES[0] = "boolean";
        TigerElement.PRIMAL_TYPES[1] = "byte";
        TigerElement.PRIMAL_TYPES[2] = "short";
        TigerElement.PRIMAL_TYPES[3] = "int";
        TigerElement.PRIMAL_TYPES[4] = "long";
        TigerElement.PRIMAL_TYPES[5] = "float";
        TigerElement.PRIMAL_TYPES[6] = "double";
        TigerElement.PRIMAL_TYPES[7] = "java.lang.String";
        TigerElement.PRIMAL_TYPES[8] = "java.math.BigInteger";
        TigerElement.PRIMAL_TYPES[9] = "java.math.BigDecimal";
        TigerElement.PRIMAL_TYPES[10] = "java.util.Date";
        TigerElement.PRIMAL_TYPES[11] = "byte[]";
        TigerElement.PRIMAL_TYPES[12] = "org.w3c.dom.Node";
        TigerElement.PRIMAL_TYPES[13] = "char";
    }
}

