/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger.dotnet;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.IManager;
import com.eibus.tools.tiger.Tiger;
import com.eibus.tools.tiger.dotnet.DotnetGen;
import com.eibus.tools.tiger.dotnet.TigerDataType;
import com.eibus.tools.tiger.dotnet.TigerElement;
import com.eibus.tools.tiger.dotnet.TigerIterator;
import com.eibus.xml.util.DOMUtils;
import com.eibus.xml.util.ElementEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class TigerManager
extends ClassGen
implements IManager {
    private String m_nameSpace;
    int m_methodCount = 0;
    int m_managedTypeCount = 0;
    String m_elementName;
    String m_typeName;
    String m_idName;
    Hashtable m_bsqDefs = new Hashtable();
    private Vector m_Iterators = new Vector();
    private DotnetGen m_dotnetGen;
    private Vector m_staticConstructor = new Vector();
    private Element m_sourceElement;
    private Tiger m_frontend;
    private static final char s_QUOTE = '\"';
    private static final char s_SLASH = '\\';
    private static final int MAX_LINE_LEN = 1024;

    public TigerManager(Element element, Tiger tiger) throws GeneratorException {
        super(element, tiger);
        this.m_sourceElement = element;
        this.m_frontend = tiger;
        this.m_idName = ClassGen.getIdName(element);
        this.m_typeName = ClassGen.getTypeName(element);
        this.m_dotnetGen = new DotnetGen(element, tiger);
        this.m_dotnetGen.checkValidIdentifier(this.m_idName);
        this.setOutputFile(this.m_dotnetGen.openFile(null));
    }

    private String getQualifiedClassName(String string) {
        String string2 = this.m_dotnetGen.getNamespace();
        String string3 = string2 != null && string2.length() > 0 && string.indexOf(46) == -1 ? string2 + "." + string : string;
        return string3;
    }

    private void generateInternalComment() {
        this.println("/// <summary>");
        this.println("/// -- Internal --");
        this.println("/// </summary>");
    }

    public void initialize() {
        this.m_nameSpace = this.m_dotnetGen.getNamespace();
        if (this.m_nameSpace == null) {
            this.m_nameSpace = "";
        }
        this.m_dotnetGen.GenerateHeader(this);
        this.println();
        this.println("using System;");
        this.println("using System.Collections;");
        this.println("using System.Runtime.InteropServices;");
        this.println("using OpenWorld.Adapter.Boi;");
        this.println();
        if (!this.m_nameSpace.equals("")) {
            this.println("namespace " + this.m_nameSpace);
            this.println("{");
            this.IncrementIndentation();
        }
        this.println("/// <remarks>");
        this.println("/// Class " + this.m_idName);
        this.println("/// </remarks>");
        this.println("[ClassInterface(ClassInterfaceType.AutoDual)]");
        this.println("public class " + this.m_idName + " : BusinessObjectManager");
        this.println("{");
        this.IncrementIndentation();
        this.println("/// <summary>");
        this.println("/// Create a " + this.m_idName);
        this.println("/// </summary>");
        this.println("public " + this.m_idName + "()");
        this.println("{");
        if (this.m_dotnetGen.getContentLicense() != null) {
            this.println("\tthis.setContentLicense(\"" + this.m_dotnetGen.getContentLicense() + "\");");
        }
        this.println("}");
    }

    public void queryMethodModel(String string, String string2, String string3, boolean bl, boolean bl2, Element element, String string4, Element element2, String string5, String string6, Element element3, boolean bl3, boolean bl4) throws GeneratorException {
        this.m_dotnetGen.checkValidIdentifier(string2);
        if (string5 != null) {
            this.m_dotnetGen.checkValidClass(string5);
        }
        if (string.equals("BaanDLL")) {
            this.generateBaanDllMethod(string2, bl, element, string4, element2, string5, string6);
        } else if (string.equals("BaanSQL")) {
            if (bl3) {
                this.generateBaanSqlConstructor(string2, string3, element, element3, bl4);
            } else {
                this.generateBaanSqlMethod(string2, string3, bl2, element, string5, string6);
            }
        } else if (string.equals("QueryByDLL")) {
            if (!bl3) {
                this.generateQueryByDllMethod(string2, bl2, element, string4, element2, string5, string6);
            }
        } else {
            throw new GeneratorException("Unrecognised model name: \"" + string + "\"; cannot generate code.");
        }
    }

    private void generateBaanDllMethod(String string, boolean bl, Element element, String string2, Element element2, String string3, String string4) throws GeneratorException {
        Object object;
        this.println();
        this.println("/// <summary>");
        this.println("/// Function " + string + " (Function Model)");
        this.println("/// </summary>");
        this.generateQueryParametersComments(element);
        this.println("/// <returns>" + string4 + "</returns>");
        this.print(this.getIndentation() + "public " + string4 + " " + string + "(");
        this.generateQueryParameters(element);
        this.print(")");
        this.println();
        this.println("{");
        this.IncrementIndentation();
        String string5 = DOMUtils.getTextValue(element2).trim();
        String string6 = null;
        String string7 = null;
        Element element3 = this.frontend.getElementDef(string5);
        String string8 = element3 != null ? ClassGen.getIdName(element3) : string5;
        String string9 = element3 != null ? ClassGen.getDCDType(element3) : string5;
        String string10 = ClassGen.getDataType(element3, string5, new TigerDataType());
        String string11 = element2.getAttribute("Scope");
        if (!string11.equals("")) {
            if (string11.equals("Out")) {
                if (!TigerElement.isPrimalType(string10)) {
                    string6 = "null";
                    string7 = "\"elements\"";
                } else {
                    string6 = "\"" + string9 + "\"";
                    string7 = "null";
                }
            } else {
                throw new GeneratorException("Only Scope=\"Out\" allowed for  <Method> " + string5);
            }
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        Vector<String> vector3 = new Vector<String>();
        int n3 = 0;
        String string12 = string + "_parameters";
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element4;
                Element element5 = (Element)elementEnumeration.nextElement();
                object = DOMUtils.getTextValue(element5).trim();
                String string13 = element5.getAttribute("Scope");
                if (string13.equals("")) {
                    string13 = "In";
                }
                String string14 = (element4 = this.frontend.getElementDef((String)object)) != null ? ClassGen.getIdName(element4) : object;
                String string15 = element4 != null ? ClassGen.getTypeName(element4) : object;
                String string16 = element4 != null ? ClassGen.getDCDType(element4) : object;
                String string17 = element4 != null ? this.getLength(element4) : "";
                String string18 = ClassGen.getDataType(element4, (String)object, new TigerDataType());
                if (!string14.equals("")) {
                    String string19;
                    String string20 = string18.equals("string") ? "p_" + string14 : (string18.equals("DateTime") ? "DateTime2String(p_" + string14 + ")" : (string18.equals("System.Xml.XmlDocument") ? "XMLNode2String(p_" + string14 + ")" : (string18.equals("byte[]") ? "ByteArray2String(p_" + string14 + ")" : (string18.equals("bool") ? "(p_" + string14 + " ? \"1\" : \"0\")" : (string18.equals("float") || string18.equals("double") ? "p_" + string14 + ".ToString(System.Globalization.NumberFormatInfo.InvariantInfo)" : "p_" + string14 + ".ToString()")))));
                    if (string17.equals("")) {
                        string19 = "null";
                    } else {
                        if (!string16.equals("string")) {
                            throw new GeneratorException("Parameter '" + string15 + "' is not valid.\nLength attribute is not allowed for Datatype '" + string16 + "', only Datatype 'string' can have the Length attribute.");
                        }
                        string19 = "\"" + string17 + "\"";
                    }
                    boolean bl2 = string18.equals(string14);
                    String string21 = "ScopeValue." + string13;
                    if (!string13.equals("Out")) {
                        if (string18.equals(string14)) {
                            vector3.addElement("businessObjectParameterValues[" + n3++ + "] = p_" + string14 + ";");
                        } else {
                            vector2.addElement("parameterValues[" + n2++ + "] = " + string20 + ";");
                        }
                    }
                    vector.addElement(string12 + "[" + n++ + "] = new BaanDllCallParameterSpec(" + bl2 + ", " + string21 + ", \"" + string15 + "\", \"" + string16 + "\", " + string19 + ");");
                    continue;
                }
                throw new GeneratorException("Invalid <Element> tag");
            }
            vector.insertElementAt("BaanDllCallParameterSpec[] " + string12 + " = new BaanDllCallParameterSpec[" + n + "];", 0);
        }
        vector2.insertElementAt("string[] parameterValues = new string[" + n2 + "];", 0);
        this.printVector(vector2);
        vector3.insertElementAt("BusinessObject[] businessObjectParameterValues = new BusinessObject[" + n3 + "];", 0);
        this.printVector(vector3);
        if (bl) {
            this.println("return baanDllCallVector(s_bdc_" + string + ", parameterValues, businessObjectParameterValues);");
        } else {
            this.println("BusinessObject bo = baanDllCallBusinessObject(s_bdc_" + string + ", parameterValues, businessObjectParameterValues);");
            this.println("return (bo != null) ? new " + string3 + "(bo) : null;");
        }
        this.DecrementIndentation();
        this.println("}");
        if (vector.size() == 0) {
            string12 = null;
        }
        this.println();
        this.generateInternalComment();
        this.println("private static BaanDllCallSpec s_bdc_" + string + ";");
        this.m_staticConstructor.addElement("");
        if (!this.m_nameSpace.equals("")) {
            string3 = this.m_nameSpace + "." + string3;
        }
        this.m_staticConstructor.addElement("s_bdc_" + string + " = new BaanDllCallSpec(\"" + string2 + "\", \"" + string5 + "\", " + string6 + ", " + string7 + ", Type.GetType(\"" + string3 + "\") );");
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.m_staticConstructor.addElement(object.nextElement());
        }
        this.m_staticConstructor.addElement("s_bdc_" + string + ".setParameters(" + string12 + ");");
    }

    private void generateBaanSqlMethod(String string, String string2, boolean bl, Element element, String string3, String string4) throws GeneratorException {
        this.println();
        this.println();
        BaanSqlQueryDef baanSqlQueryDef = (BaanSqlQueryDef)this.m_bsqDefs.get(string);
        if (baanSqlQueryDef == null) {
            baanSqlQueryDef = new BaanSqlQueryDef(string);
            this.m_bsqDefs.put(string, baanSqlQueryDef);
        }
        baanSqlQueryDef.setReturnClassName(string3);
        if (bl) {
            this.println();
            this.println("/// <summary>");
            this.println("/// Function " + string + " (Data Model)");
            this.println("/// </summary>");
            this.generateQueryParametersComments(element);
            this.println("/// <returns>Iterator " + string3 + string4 + " for " + string3 + "</returns>");
            this.print(this.getIndentation() + "public " + string3 + string4 + " " + string + "(");
            this.generateQueryParameters(element);
            this.print(")");
            this.println();
            this.println("{");
            this.generateSqlConvertParameters(element);
            this.println("\treturn new " + string3 + "Iterator(baanSqlQueryIterator(s_bsq_" + string + ", parameterValues));");
            this.m_Iterators.addElement(string3);
        } else {
            this.println();
            this.println("/// <summary>");
            this.println("/// Function " + string + " (Data Model)");
            this.println("/// </summary>");
            this.generateQueryParametersComments(element);
            this.println("/// <returns>" + string3 + string4 + "</returns>");
            this.print(this.getIndentation() + "public " + string4 + " " + string + "(");
            this.generateQueryParameters(element);
            this.print(")");
            this.println();
            this.println("{");
            this.generateSqlConvertParameters(element);
            this.println("\tBusinessObject bo = baanSqlQueryBusinessObject(s_bsq_" + string + ", parameterValues);");
            this.println("\treturn (bo != null) ? new " + string3 + "(bo) : null;");
        }
        this.println("}");
        this.println();
        this.println("/// <summary>");
        this.println("/// Function add" + ClassGen.capitalise(string) + " (Data Model, Parameter array functionality)");
        this.println("/// </summary>");
        this.generateQueryParametersComments(element);
        this.print(this.getIndentation() + "public void add" + ClassGen.capitalise(string) + "(");
        this.generateQueryParameters(element);
        this.print(")");
        this.println();
        this.println("{");
        this.generateSqlConvertParameters(element);
        this.println("\taddBaanSqlQuery(s_bsq_" + string + ", parameterValues);");
        this.println("}");
    }

    private void generateBaanSqlConstructor(String string, String string2, Element element, Element element2, boolean bl) throws GeneratorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        BaanSqlQueryDef baanSqlQueryDef = (BaanSqlQueryDef)this.m_bsqDefs.get(string);
        if (baanSqlQueryDef == null) {
            baanSqlQueryDef = new BaanSqlQueryDef(string, string2);
            this.m_bsqDefs.put(string, baanSqlQueryDef);
        } else {
            baanSqlQueryDef.setQueryText(string2);
        }
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element3 = (Element)elementEnumeration.nextElement();
                object6 = DOMUtils.getTextValue(element3).trim();
                this.m_dotnetGen.checkValidIdentifier((String)object6);
                object5 = element3.getAttribute("Scope");
                Element element4 = this.frontend.getElementDef((String)object6);
                object4 = element4 != null ? ClassGen.getIdName(element4) : object6;
                object3 = element4 != null ? ClassGen.getTypeName(element4) : object6;
                object2 = element4 != null ? ClassGen.getDCDType(element4) : object6;
                Object object7 = object = element4 != null ? ClassGen.getRelatedColumn(element4) : "";
                if (!((String)object4).equals("")) {
                    if (((String)object5).equals("") || ((String)object5).equals("In")) {
                        if (((String)object).equals("")) {
                            baanSqlQueryDef.addParameter((String)object3, (String)object2, null);
                            continue;
                        }
                        baanSqlQueryDef.addParameter((String)object3, (String)object2, (String)object);
                        continue;
                    }
                    throw new GeneratorException("Illegal Scope=\"" + (String)object5 + "\" for parameter '" + (String)object4 + "' in BaanSQL <QueryDef>; Only Scope=\"In\" is allowed which is also the default.");
                }
                throw new GeneratorException("Invalid <Element> tag");
            }
        }
        if (element2 != null) {
            ClassGen.checkAttributes(element2, null);
            object6 = new Hashtable();
            object5 = new Hashtable();
            ((Hashtable)object6).put(string, string);
            object4 = baanSqlQueryDef.addLayout(ClassGen.getTypeName(element2), false);
            object3 = this.findNextValidLayoutChild(element2.getFirstChild(), element2);
            if (object3 != null) {
                object2 = new Stack();
                object = new Stack();
                boolean bl2 = false;
                Stack<Object> stack = new Stack<Object>();
                stack.push(object4);
                ((Stack)object2).push(object3);
                ((Stack)object).push(element2);
                while (!((Stack)object2).empty()) {
                    Object object8;
                    Element element5 = (Element)((Stack)object2).peek();
                    Element element6 = (Element)((Stack)object).peek();
                    object4 = (BaanSqlQueryLayoutDef)stack.peek();
                    if (!bl2) {
                        Element element7;
                        boolean bl3;
                        Object object9;
                        ((Hashtable)object5).put(element6, element6);
                        ClassGen.checkAttributes(element5, null);
                        object8 = DOMUtils.getTextValue(element5).trim();
                        String string3 = element5.getAttribute("Reference");
                        if (!(string3.equals("True") || string3.equals("False") || string3.equals(""))) {
                            throw new GeneratorException("Illegal attribute: Reference=\"" + string3 + "\" in <Layout>" + (String)object8 + "</Layout> in  <LayoutDef Type=\"" + ClassGen.getTypeName(element6) + "\">. Expected Reference=\"True\" or Reference=\"False\"");
                        }
                        Element element8 = this.frontend.getLayoutDef((String)object8);
                        if (element8 == null) {
                            throw new GeneratorException("Reference to unknown <Layout>" + (String)object8 + "</Layout> in  <LayoutDef Type=\"" + ClassGen.getTypeName(element6) + "\">");
                        }
                        boolean bl4 = string3.equals("True");
                        boolean bl5 = !ClassGen.getRelatedColumn(element8).equals("");
                        String string4 = element5.getAttribute("Query").trim();
                        if (string4.equals("")) {
                            string4 = null;
                        }
                        String string5 = ClassGen.getIdName(element8);
                        String string6 = ClassGen.getTypeName(element8);
                        ClassGen.checkAttributes(element8, null);
                        boolean bl6 = false;
                        if (string4 != null) {
                            Element element9 = this.frontend.getQueryDef(string4);
                            if (element9 == null) {
                                throw new GeneratorException("Reference to unknown 'Query=" + string4 + "' in  <Layout>" + string5 + "</Layout>");
                            }
                            if (this.frontend.getQueryDef(element9) == null) {
                                this.frontend.putQueryDef(element9);
                            }
                            object9 = ClassGen.getIdName(element9);
                            this.frontend.setQueryDef((String)object9, 1);
                            boolean bl7 = bl6 = ((Hashtable)object6).get(string4) == null;
                            if (bl6) {
                                ((Hashtable)object6).put(string4, string4);
                            }
                        }
                        boolean bl8 = bl3 = ((Hashtable)object5).get(element8) == null;
                        if (string4 == null) {
                            object9 = null;
                        } else {
                            object9 = (BaanSqlQueryDef)this.m_bsqDefs.get(string4);
                            if (object9 == null) {
                                object9 = new BaanSqlQueryDef(string4);
                                this.m_bsqDefs.put(string4, object9);
                            }
                        }
                        BaanSqlQueryLayoutDef baanSqlQueryLayoutDef = new BaanSqlQueryLayoutDef(string6, bl5);
                        BaanSqlQuerySubLayoutDef baanSqlQuerySubLayoutDef = ((BaanSqlQueryLayoutDef)object4).addSubLayout(baanSqlQueryLayoutDef, bl4, (BaanSqlQueryDef)object9, bl6, bl3);
                        if (bl3 && (element7 = this.findNextValidLayoutChild(element8.getFirstChild(), element8)) != null) {
                            ((Stack)object2).push(element7);
                            ((Stack)object).push(element8);
                            stack.push(baanSqlQueryLayoutDef);
                            continue;
                        }
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    ((Stack)object2).pop();
                    object8 = this.findNextValidLayoutChild(element5.getNextSibling(), element6);
                    if (object8 != null) {
                        bl2 = false;
                        ((Stack)object2).push(object8);
                        continue;
                    }
                    ((Stack)object).pop();
                    stack.pop();
                }
            }
        }
        if (string2.indexOf(36) != -1 && !bl) {
            throw new GeneratorException("Use of Client Side Query Parameters ($param) not allowed in nested Query <QueryDef Type=\"" + string + "\" Nested=\"True\">");
        }
    }

    private void generateQueryByDllMethod(String string, boolean bl, Element element, String string2, Element element2, String string3, String string4) throws GeneratorException {
        Object object;
        this.println("");
        this.println("");
        if (bl) {
            this.println("/// <summary>");
            this.println("/// Function " + string + " (QueryByDLL Model)");
            this.println("/// </summary>");
            this.generateQueryParametersComments(element);
            this.println("/// <returns>Iterator " + string3 + string4 + " for " + string3 + "</returns>");
            this.print(this.getIndentation() + "public " + string3 + string4 + " " + string + "(");
        } else {
            this.println("/// <summary>");
            this.println("/// Function " + string + " (QueryByDLL Model)");
            this.println("/// </summary>");
            this.generateQueryParametersComments(element);
            this.println("/// <returns>" + string4 + "</returns>");
            this.print(this.getIndentation() + "public " + string4 + " " + string + "(");
        }
        this.generateQueryParameters(element);
        this.print(")");
        this.println();
        this.println("{");
        this.IncrementIndentation();
        String string5 = DOMUtils.getTextValue(element2).trim();
        String string6 = null;
        String string7 = null;
        Element element3 = this.frontend.getElementDef(string5);
        String string8 = element3 != null ? ClassGen.getIdName(element3) : string5;
        String string9 = element3 != null ? ClassGen.getDCDType(element3) : string5;
        String string10 = ClassGen.getDataType(element3, string5, new TigerDataType());
        String string11 = element2.getAttribute("Scope");
        if (!string11.equals("")) {
            if (string11.equals("Out")) {
                if (!TigerElement.isPrimalType(string10)) {
                    string6 = "null";
                    string7 = "\"elements\"";
                } else {
                    string6 = "\"" + string9 + "\"";
                    string7 = "null";
                }
            } else {
                throw new GeneratorException("Only Scope=\"Out\" allowed for  <Method> " + string5);
            }
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        Vector<String> vector3 = new Vector<String>();
        int n3 = 0;
        String string12 = string + "_parameters";
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element4 = (Element)elementEnumeration.nextElement();
                object = DOMUtils.getTextValue(element4).trim();
                String string13 = element4.getAttribute("Scope");
                Element element5 = this.frontend.getElementDef((String)object);
                String string14 = element5 != null ? ClassGen.getIdName(element5) : object;
                String string15 = element5 != null ? ClassGen.getTypeName(element5) : object;
                String string16 = element5 != null ? ClassGen.getDCDType(element5) : object;
                String string17 = element5 != null ? this.getLength(element5) : "";
                String string18 = ClassGen.getDataType(element5, (String)object, new TigerDataType());
                if (!string14.equals("")) {
                    String string19;
                    String string20 = string18.equals("string") ? "p_" + string14 : (string18.equals("DateTime") ? "DateTime2String(p_" + string14 + ")" : (string18.equals("byte[]") ? "ByteArray2String(p_" + string14 + ")" : (string18.equals("System.Xml.XmlDocument") ? "XMLNode2String(p_" + string14 + ")" : (string18.equals("bool") ? "(p_" + string14 + " ? \"1\" : \"0\")" : (string18.equals("float") || string18.equals("double") ? "p_" + string14 + ".ToString(System.Globalization.NumberFormatInfo.InvariantInfo)" : "p_" + string14 + ".ToString()")))));
                    if (string17.equals("")) {
                        string19 = "null";
                    } else {
                        if (!string16.equals("string")) {
                            throw new GeneratorException("Parameter '" + string15 + "' is not valid.\nLength attribute is not allowed for Datatype '" + string16 + "', only Datatype 'string' can have the Length attribute.");
                        }
                        string19 = "\"" + string17 + "\"";
                    }
                    boolean bl2 = string18.equals(string14);
                    String string21 = "ScopeValue." + string13;
                    if (!string13.equals("Out")) {
                        if (string18.equals(string14)) {
                            vector3.addElement("businessObjectParameterValues[" + n3++ + "] = p_" + string14 + ";");
                        } else {
                            vector2.addElement("parameterValues[" + n2++ + "] = " + string20 + ";");
                        }
                    }
                    vector.addElement(string12 + "[" + n++ + "] = new QueryByDllParameterSpec(" + bl2 + ", " + string21 + ", \"" + string15 + "\", \"" + string16 + "\", " + string19 + ");");
                    continue;
                }
                throw new GeneratorException("Invalid <Element> tag");
            }
            vector.insertElementAt("QueryByDllParameterSpec[] " + string12 + " = new QueryByDllParameterSpec[" + n + "];", 0);
        }
        vector2.insertElementAt("string[] parameterValues = new string[" + n2 + "];", 0);
        this.printVector(vector2);
        vector3.insertElementAt("BusinessObject[] businessObjectParameterValues = new BusinessObject[" + n3 + "];", 0);
        this.printVector(vector3);
        if (bl) {
            this.println("return new " + string3 + "Iterator(queryByDllIterator(s_qbd_" + string + ", parameterValues, businessObjectParameterValues));");
            this.m_Iterators.addElement(string3);
        } else {
            this.println("BusinessObject bo = queryByDllBusinessObject(s_qbd_" + string + ", parameterValues, businessObjectParameterValues);");
            this.println("return (bo != null) ? new " + string3 + "(bo) : null;");
        }
        this.DecrementIndentation();
        this.println("}");
        if (vector.size() == 0) {
            string12 = null;
        }
        this.println();
        this.println("private static QueryByDllSpec s_qbd_" + string + ";");
        this.m_staticConstructor.addElement("");
        if (!this.m_nameSpace.equals("")) {
            string3 = this.m_nameSpace + "." + string3;
        }
        this.m_staticConstructor.addElement("s_qbd_" + string + " = new QueryByDllSpec(\"" + string + "\", \"" + string2 + "\", \"" + string5 + "\", " + string6 + ", " + string7 + ", Type.GetType(\"" + string3 + "\") );");
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.m_staticConstructor.addElement(object.nextElement());
        }
        this.m_staticConstructor.addElement("s_qbd_" + string + ".setParameters(" + string12 + ");");
    }

    public void initializeRegistry(Hashtable hashtable, Vector vector) {
        String string;
        this.println();
        this.generateInternalComment();
        this.println("private static Type[] s_businessObjectTypes =");
        this.println("{");
        this.IncrementIndentation();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            if (!this.m_nameSpace.equals("")) {
                string = this.m_nameSpace + "." + string;
            }
            String string2 = "Type.GetType(\"" + string + "\")";
            if (enumeration2.hasMoreElements()) {
                string2 = string2 + ",";
            }
            this.println(string2);
        }
        this.DecrementIndentation();
        this.println("};");
        this.println();
        this.generateInternalComment();
        this.println("protected override Type[] getBusinessObjectTypes()");
        this.println("{");
        this.IncrementIndentation();
        enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            if (!this.m_nameSpace.equals("")) {
                string = this.m_nameSpace + "." + string;
            }
            this.println(string + ".initializeClass();");
        }
        this.println("return s_businessObjectTypes;");
        this.DecrementIndentation();
        this.println("}");
    }

    private String toStringLiteral(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            if (n % 1024 == 0 && n < string.length() - 10) {
                stringBuffer.append("\" +\n\t\t\t\"");
            }
            ++n;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public void finish() {
        BaanSqlQueryParameterDef[] baanSqlQueryParameterDefArray;
        Object object;
        BaanSqlQueryDef baanSqlQueryDef;
        this.println();
        this.println();
        Enumeration enumeration2 = this.m_bsqDefs.keys();
        while (enumeration2.hasMoreElements()) {
            BaanSqlQueryDef baanSqlQueryDef2 = (BaanSqlQueryDef)this.m_bsqDefs.get(enumeration2.nextElement());
            this.generateInternalComment();
            this.println("private static BaanSqlQuerySpec s_bsq_" + baanSqlQueryDef2.idName + ";");
        }
        this.println();
        this.println("// static constructor to initialize static members");
        this.generateInternalComment();
        this.println("static " + this.m_idName + "()");
        this.println("{");
        this.IncrementIndentation();
        boolean bl = false;
        boolean bl2 = false;
        enumeration2 = this.m_bsqDefs.keys();
        while (enumeration2.hasMoreElements()) {
            baanSqlQueryDef = (BaanSqlQueryDef)this.m_bsqDefs.get(enumeration2.nextElement());
            object = baanSqlQueryDef.returnType == null ? "null" : (!this.m_nameSpace.equals("") ? "Type.GetType(\"" + this.m_nameSpace + "." + baanSqlQueryDef.returnType + "\")" : "Type.GetType(\"" + baanSqlQueryDef.returnType + "\")");
            if (!bl2) {
                this.println("BaanSqlQueryLayoutSpec bsqLayoutTmp;");
                bl2 = true;
            }
            if (baanSqlQueryDef.layoutDef == null) {
                this.println("bsqLayoutTmp = null;");
            } else {
                this.println("bsqLayoutTmp = new BaanSqlQueryLayoutSpec(\"" + baanSqlQueryDef.layoutDef.typeName + "\", " + baanSqlQueryDef.layoutDef.isAlias + ");");
            }
            this.println("s_bsq_" + baanSqlQueryDef.idName + " = new BaanSqlQuerySpec(" + this.toStringLiteral(baanSqlQueryDef.queryText) + ",\n\t\t\t\"" + baanSqlQueryDef.idName + "\", bsqLayoutTmp, " + (String)object + ");");
            baanSqlQueryParameterDefArray = baanSqlQueryDef.getParameters();
            if (baanSqlQueryParameterDefArray.length != 0) {
                if (!bl) {
                    this.println("BaanSqlQueryParameterSpec[] bsqParametersTmp;");
                    bl = true;
                }
                this.println("bsqParametersTmp = new BaanSqlQueryParameterSpec[" + baanSqlQueryParameterDefArray.length + "];");
                int n = 0;
                while (n < baanSqlQueryParameterDefArray.length) {
                    BaanSqlQueryParameterDef baanSqlQueryParameterDef = baanSqlQueryParameterDefArray[n];
                    this.println("bsqParametersTmp[" + n + "] = new BaanSqlQueryParameterSpec(\"" + baanSqlQueryParameterDef.typeName + "\", \"" + baanSqlQueryParameterDef.dcdType + "\", " + (baanSqlQueryParameterDef.relatedColumn == null ? "null" : "\"" + baanSqlQueryParameterDef.relatedColumn + "\"") + ");");
                    ++n;
                }
                this.println("s_bsq_" + baanSqlQueryDef.idName + ".setParameters(bsqParametersTmp);");
            }
            this.println();
        }
        enumeration2 = this.m_bsqDefs.keys();
        while (enumeration2.hasMoreElements()) {
            baanSqlQueryDef = (BaanSqlQueryDef)this.m_bsqDefs.get(enumeration2.nextElement());
            if (baanSqlQueryDef.layoutDef == null) continue;
            object = baanSqlQueryDef.layoutDef.getSubLayouts();
            baanSqlQueryParameterDefArray = "bsqsl_" + baanSqlQueryDef.idName;
            this.generateAddSubLayouts((String)baanSqlQueryParameterDefArray, (BaanSqlQuerySubLayoutDef[])object);
            this.println("s_bsq_" + baanSqlQueryDef.idName + ".layoutDef.setSubLayouts(" + (String)baanSqlQueryParameterDefArray + ");");
            this.println();
        }
        this.printVector(this.m_staticConstructor);
        this.DecrementIndentation();
        this.println("}");
        this.DecrementIndentation();
        this.println("}");
        if (!this.m_nameSpace.equals("")) {
            this.DecrementIndentation();
            this.println("}");
        }
        this.closeOutputFile();
        try {
            int n = 0;
            while (n < this.m_Iterators.size()) {
                object = (String)this.m_Iterators.elementAt(n);
                baanSqlQueryParameterDefArray = new TigerIterator((String)object, this.m_sourceElement, this.m_frontend);
                baanSqlQueryParameterDefArray.createFile();
                baanSqlQueryParameterDefArray.generateIterator();
                baanSqlQueryParameterDefArray.closeFile();
                ++n;
            }
        }
        catch (GeneratorException generatorException) {}
    }

    public void abort() throws GeneratorException {
        this.closeOutputFile();
        this.m_dotnetGen.deleteFile();
    }

    private void generateAddSubLayouts(String string, BaanSqlQuerySubLayoutDef[] baanSqlQuerySubLayoutDefArray) {
        int n = baanSqlQuerySubLayoutDefArray.length;
        this.println("BaanSqlQuerySubLayoutSpec[] " + string + " = new BaanSqlQuerySubLayoutSpec[" + n + "];");
        int n2 = 0;
        while (n2 < n) {
            BaanSqlQuerySubLayoutDef baanSqlQuerySubLayoutDef = baanSqlQuerySubLayoutDefArray[n2];
            BaanSqlQueryLayoutDef baanSqlQueryLayoutDef = baanSqlQuerySubLayoutDef.layoutDef;
            this.println("bsqLayoutTmp = new BaanSqlQueryLayoutSpec(\"" + baanSqlQueryLayoutDef.typeName + "\", " + baanSqlQueryLayoutDef.isAlias + ");");
            this.println(string + "[" + n2 + "] = new BaanSqlQuerySubLayoutSpec(bsqLayoutTmp, " + baanSqlQuerySubLayoutDef.isReference + ", " + (baanSqlQuerySubLayoutDef.queryDef == null ? "null" : "s_bsq_" + baanSqlQuerySubLayoutDef.queryDef.idName) + ", " + baanSqlQuerySubLayoutDef.shouldAppendConstructor + ", " + baanSqlQuerySubLayoutDef.shouldProcessLayoutDef + ");");
            BaanSqlQuerySubLayoutDef[] baanSqlQuerySubLayoutDefArray2 = baanSqlQueryLayoutDef.getSubLayouts();
            if (baanSqlQuerySubLayoutDefArray2.length != 0) {
                String string2 = string + "_" + n2;
                this.generateAddSubLayouts(string2, baanSqlQuerySubLayoutDefArray2);
                this.println(string + "[" + n2 + "].layoutDef.setSubLayouts(" + string2 + ");");
            }
            ++n2;
        }
    }

    private Element findNextValidLayoutChild(Node node, Element element) throws GeneratorException {
        Node node2 = node;
        while (node2 != null) {
            short s = node2.getNodeType();
            if (s == 1) {
                Element element2 = (Element)node2;
                String string = element2.getTagName();
                if (string.equals("Layout")) {
                    return element2;
                }
                throw new GeneratorException("Illegal tag name '" + string + "' in <Layout> in <LayoutDef Type=\"" + ClassGen.getTypeName(element) + "\">");
            }
            if (s != 3 && s != 8) {
                throw new GeneratorException("Illegal element '" + node2.getNodeName() + "'  <LayouttDef Type=\"" + ClassGen.getTypeName(element) + "\">");
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    private void generateSqlConvertParameters(Element element) throws GeneratorException {
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element2 = (Element)elementEnumeration.nextElement();
                String string = DOMUtils.getTextValue(element2).trim();
                String string2 = element2.getAttribute("Scope");
                Element element3 = this.frontend.getElementDef(string);
                String string3 = element3 != null ? ClassGen.getIdName(element3) : string;
                String string4 = ClassGen.getDataType(element3, string, new TigerDataType());
                if (!string3.equals("")) {
                    if (string4.equals("string")) {
                        vector.addElement("\tparameterValues[" + n + "] = p_" + string3 + ";");
                    } else if (string4.equals("DateTime")) {
                        vector.addElement("\tparameterValues[" + n + "] = DateTime2String(p_" + string3 + ");");
                    } else if (string4.equals("System.Xml.XmlDocument")) {
                        vector.addElement("\tparameterValues[" + n + "] = XMLNode2String(p_" + string3 + ");");
                    } else if (string4.equals("byte[]")) {
                        vector.addElement("\tparameterValues[" + n + "] = ByteArray2String(p_" + string3 + ");");
                    } else if (string4.equals("bool")) {
                        vector.addElement("\tparameterValues[" + n + "] = p_" + string3 + " ? \"1\" : \"0\";");
                    } else if (string4.equals("float") || string4.equals("double")) {
                        vector.addElement("\tparameterValues[" + n + "] = p_" + string3 + ".ToString(System.Globalization.NumberFormatInfo.InvariantInfo);");
                    } else {
                        vector.addElement("\tparameterValues[" + n + "] = p_" + string3 + ".ToString();");
                    }
                    if (!string2.equals("") && !string2.equals("In")) {
                        throw new GeneratorException("Illegal Scope=\"" + string2 + "\" for parameter '" + string3 + "' in BaanSQL <QueryDef>; Only Scope=\"In\" is allowed" + " which is also the default.");
                    }
                } else {
                    throw new GeneratorException("Invalid <Element> tag");
                }
                ++n;
            }
        }
        this.println("\tString[] parameterValues = new String[" + n + "];");
        this.printVector(vector);
    }

    private void generateQueryParametersComments(Element element) {
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            boolean bl = true;
            while (elementEnumeration.hasMoreElements()) {
                String string;
                Element element2 = (Element)elementEnumeration.nextElement();
                String string2 = DOMUtils.getTextValue(element2).trim();
                String string3 = element2.getAttribute("Scope");
                if (!string3.equals("") && !string3.equals("In") && !string3.equals("InOut")) continue;
                Element element3 = this.frontend.getElementDef(string2);
                String string4 = string = element3 != null ? ClassGen.getIdName(element3) : string2;
                if (string.equals("")) continue;
                this.println("/// <param name=\"p_" + string + "\"></param>");
            }
        }
    }

    private void generateQueryParameters(Element element) throws GeneratorException {
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            boolean bl = true;
            while (elementEnumeration.hasMoreElements()) {
                Element element2 = (Element)elementEnumeration.nextElement();
                ClassGen.checkAttributes(element2, null);
                String string = DOMUtils.getTextValue(element2).trim();
                String string2 = element2.getAttribute("Scope");
                if (string2.equals("") || string2.equals("In") || string2.equals("InOut")) {
                    Element element3 = this.frontend.getElementDef(string);
                    if (!bl) {
                        this.print(", ");
                    } else {
                        bl = false;
                    }
                    String string3 = element3 != null ? ClassGen.getIdName(element3) : string;
                    String string4 = ClassGen.getDataType(element3, string, new TigerDataType());
                    String string5 = element2.getAttribute("Namespace");
                    if (!string5.equals("")) {
                        string4 = string5 + "." + string4;
                    }
                    ClassGen.checkAttributes(element3, null);
                    if (!string3.equals("")) {
                        this.print(string4 + " p_" + string3);
                        continue;
                    }
                    throw new GeneratorException("Invalid <Element> tag");
                }
                if (string2.equals("Out")) continue;
                throw new GeneratorException("Illegal Scope=\"" + string2 + "\" in <QueryDef Type=\"" + this.m_typeName + "\">  in <Element>" + string + ". Legal scope values are: In/InOut/Out");
            }
        }
    }

    private class BaanSqlQuerySubLayoutDef {
        public final BaanSqlQueryLayoutDef layoutDef;
        public final boolean isReference;
        public final BaanSqlQueryDef queryDef;
        public final boolean shouldAppendConstructor;
        public final boolean shouldProcessLayoutDef;

        public BaanSqlQuerySubLayoutDef(BaanSqlQueryLayoutDef baanSqlQueryLayoutDef, boolean bl, BaanSqlQueryDef baanSqlQueryDef, boolean bl2, boolean bl3) throws NullPointerException {
            if (baanSqlQueryLayoutDef == null) {
                throw new NullPointerException("p_layoutDef must not be null");
            }
            this.layoutDef = baanSqlQueryLayoutDef;
            this.isReference = bl;
            this.queryDef = baanSqlQueryDef;
            this.shouldAppendConstructor = bl2;
            this.shouldProcessLayoutDef = bl3;
        }
    }

    private class BaanSqlQueryLayoutDef {
        private Vector m_subLayouts = new Vector();
        private BaanSqlQuerySubLayoutDef[] m_subLayoutsCache = null;
        public final String typeName;
        public final boolean isAlias;

        public BaanSqlQueryLayoutDef(String string, boolean bl) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            this.typeName = string;
            this.isAlias = bl;
        }

        public BaanSqlQuerySubLayoutDef addSubLayout(BaanSqlQueryLayoutDef baanSqlQueryLayoutDef, boolean bl, BaanSqlQueryDef baanSqlQueryDef, boolean bl2, boolean bl3) throws NullPointerException {
            BaanSqlQuerySubLayoutDef baanSqlQuerySubLayoutDef = new BaanSqlQuerySubLayoutDef(baanSqlQueryLayoutDef, bl, baanSqlQueryDef, bl2, bl3);
            this.m_subLayouts.addElement(baanSqlQuerySubLayoutDef);
            return baanSqlQuerySubLayoutDef;
        }

        public BaanSqlQuerySubLayoutDef[] getSubLayouts() {
            if (this.m_subLayoutsCache == null) {
                this.m_subLayoutsCache = new BaanSqlQuerySubLayoutDef[this.m_subLayouts.size()];
                int n = 0;
                while (n < this.m_subLayoutsCache.length) {
                    this.m_subLayoutsCache[n] = (BaanSqlQuerySubLayoutDef)this.m_subLayouts.elementAt(n);
                    ++n;
                }
            }
            return this.m_subLayoutsCache;
        }
    }

    private class BaanSqlQueryParameterDef {
        public final String typeName;
        public final String dcdType;
        public final String relatedColumn;

        public BaanSqlQueryParameterDef(String string, String string2, String string3) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            if (string2 == null) {
                throw new NullPointerException("p_dcdType must not be null");
            }
            this.typeName = string;
            this.dcdType = string2;
            this.relatedColumn = string3;
        }
    }

    private class BaanSqlQueryDef {
        private Vector m_parameters = new Vector();
        private BaanSqlQueryParameterDef[] m_parametersCache = null;
        public String queryText;
        public final String idName;
        public BaanSqlQueryLayoutDef layoutDef;
        public String returnType;

        public BaanSqlQueryDef(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_idName must not be null");
            }
            this.idName = string;
            this.queryText = null;
            this.layoutDef = null;
            this.returnType = null;
        }

        BaanSqlQueryDef(String string, String string2) throws NullPointerException {
            this(string);
            if (string2 == null) {
                throw new NullPointerException("p_idName must not be null");
            }
            this.queryText = string2;
        }

        public BaanSqlQueryLayoutDef addLayout(String string, boolean bl) throws NullPointerException {
            this.layoutDef = new BaanSqlQueryLayoutDef(string, bl);
            return this.layoutDef;
        }

        public void addParameter(String string, String string2, String string3) throws NullPointerException {
            this.m_parameters.addElement(new BaanSqlQueryParameterDef(string, string2, string3));
        }

        public BaanSqlQueryParameterDef[] getParameters() {
            if (this.m_parametersCache == null) {
                this.m_parametersCache = new BaanSqlQueryParameterDef[this.m_parameters.size()];
                int n = 0;
                while (n < this.m_parametersCache.length) {
                    this.m_parametersCache[n] = (BaanSqlQueryParameterDef)this.m_parameters.elementAt(n);
                    ++n;
                }
            }
            return this.m_parametersCache;
        }

        public void setQueryText(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_queryText must not be null");
            }
            this.queryText = string;
        }

        public void setReturnClassName(String string) {
            this.returnType = string;
        }
    }
}

