/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger.dotnet;

import com.baan.b3.dom.Element;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.IElement;
import com.eibus.tools.tiger.Symbol;
import com.eibus.tools.tiger.Tiger;
import com.eibus.tools.tiger.dotnet.DotnetGen;
import com.eibus.tools.tiger.dotnet.TigerDataType;
import java.util.Enumeration;
import java.util.Vector;

public class TigerElement
extends ClassGen
implements IElement {
    private String m_nameSpace;
    private String typeName;
    private String idName;
    private String modelName;
    private boolean readOnly;
    private int m_methodCount = 0;
    private int m_memberCount = 0;
    private Vector m_metadataInit = new Vector();
    private Vector m_symbolTable = null;
    private DotnetGen m_DotnetGen;
    private TigerDataType m_tigerDT = new TigerDataType();
    private Vector m_staticConstructor1 = new Vector();
    private Vector m_staticConstructor2 = new Vector();

    public static boolean isPrimalType(String string) {
        int n = 0;
        while (n < TigerDataType.DataTypeMappingTable.length) {
            if (TigerDataType.DataTypeMappingTable[n][1].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public TigerElement(Element element, Tiger tiger) throws GeneratorException {
        super(element, tiger);
        this.m_DotnetGen = new DotnetGen(element, tiger);
        this.idName = ClassGen.getIdName(element);
        this.m_DotnetGen.checkValidIdentifier(this.idName);
        this.typeName = ClassGen.getTypeName(element);
        this.modelName = ClassGen.getModelName(element);
        this.readOnly = this.getReadOnly(element).equals("True");
        this.setOutputFile(this.m_DotnetGen.openFile(null));
    }

    private String getQualifiedClassName(String string, String string2) {
        String string3 = this.m_DotnetGen.getNamespace();
        String string4 = string3 != null && string3.length() > 0 && string == string2 ? string3 + "." + string : string;
        return string4;
    }

    private void generateInternalComment() {
        this.println("/// <summary>");
        this.println("/// -- Internal --");
        this.println("/// </summary>");
    }

    public void initialize() {
        this.m_nameSpace = this.m_DotnetGen.getNamespace();
        if (this.m_nameSpace == null) {
            this.m_nameSpace = "";
        }
        this.m_DotnetGen.GenerateHeader(this);
        this.println();
        this.println("using System;");
        this.println("using System.Collections;");
        this.println("using System.Runtime.InteropServices;");
        this.println("using OpenWorld.Adapter.Boi;");
        this.println();
        if (!this.m_nameSpace.equals("")) {
            this.println("namespace " + this.m_nameSpace);
            this.println("{");
            this.IncrementIndentation();
        }
        this.println();
        this.println("/// <remarks>");
        this.println("/// Class " + this.idName + " (" + this.typeName + ")");
        this.println("/// </remarks>");
        this.println("[ClassInterface(ClassInterfaceType.AutoDual)]");
        this.println("public class " + this.idName + " : BusinessObject");
        this.println("{");
        this.IncrementIndentation();
        this.generateInternalComment();
        this.println("public static string _TAG_NAME = \"" + this.typeName + "\";");
        this.println();
        this.generateInternalComment();
        if (this.m_nameSpace.length() == 0) {
            this.println("private static string _TYPE_NAME = Type.GetType(\"" + this.idName + "\").AssemblyQualifiedName;");
        } else {
            this.println("private static string _TYPE_NAME = Type.GetType(\"" + this.m_nameSpace + "." + this.idName + "\").AssemblyQualifiedName;");
        }
        this.println();
        this.println("/// <summary>");
        this.println("/// Creates a " + this.idName + " (" + this.typeName + ")");
        this.println("/// </summary>");
        this.println("public " + this.idName + "() : base( _TYPE_NAME )");
        this.println("{");
        this.println("}");
        this.println();
        this.println("/// <summary>");
        this.println("/// Creates a " + this.idName + " (" + this.typeName + ")");
        this.println("/// </summary>");
        this.println("public " + this.idName + "(BusinessObject bo) : base( bo )");
        this.println("{");
        this.println("}");
    }

    public void idMethod() {
    }

    public void typeMethod() {
    }

    public void elementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Gets " + string2 + " from location.");
        this.println("/// </summary>");
        this.println("/// <param name=\"index\">index</param>");
        this.println("/// <returns>" + string + "</returns>");
        this.println("public " + string + " get" + ClassGen.capitalise(string2) + "At(int index)");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\treturn new " + string + "(getMemberBusinessElementAtReference( v_" + string2 + ", index ));");
            } else {
                this.println("\treturn new " + string + "(getMemberBusinessElementAt( v_" + string2 + ", index ));");
            }
        } else {
            this.println("\treturn (" + string + ") getPrimalMemberAt( " + this.m_tigerDT.getCSharpTypeCode(string) + ", v_" + string2 + ", index );");
        }
        this.println("}");
    }

    public void addElementMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Adds " + string2 + ".");
        this.println("/// </summary>");
        this.println("/// <param name=\"p_" + string2 + "\">" + string2 + " (" + string3 + ")</param>");
        this.println("public void add" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\taddMemberBusinessElementReference( m_" + string2 + ", p_" + string2 + ", v_" + string2 + " );");
            } else {
                this.println("\taddMemberBusinessElement( m_" + string2 + ", p_" + string2 + ", v_" + string2 + " );");
            }
        } else {
            this.println("\taddPrimalMember( " + this.m_tigerDT.getCSharpTypeCode(string) + ", m_" + string2 + ", p_" + string2 + ", TAG_" + string2 + ", v_" + string2 + " );");
        }
        this.println("}");
    }

    public void setElementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Sets " + string2 + " at location.");
        this.println("/// </summary>");
        this.println("/// <param name=\"p_" + string2 + "\">" + string2 + " (" + string3 + ")</param>");
        this.println("/// <param name=\"index\">index</param>");
        this.println("public void set" + ClassGen.capitalise(string2) + "At(" + string + " p_" + string2 + ", int index)");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\tsetMemberBusinessElementAtReference( m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", index );");
            } else {
                this.println("\tsetMemberBusinessElementAt( m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", index );");
            }
        } else {
            this.println("\tsetPrimalMemberAt( " + this.m_tigerDT.getCSharpTypeCode(string) + ", m_" + string2 + ", p_" + string2 + " , TAG_" + string2 + ", v_" + string2 + ", index );");
        }
        this.println("}");
    }

    public void insertElementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Inserts " + string2 + " at location.");
        this.println("/// </summary>");
        this.println("/// <param name=\"p_" + string2 + "\">" + string2 + " (" + string3 + ")</param>");
        this.println("/// <param name=\"index\">index</param>");
        this.println("public void insert" + ClassGen.capitalise(string2) + "At(" + string + " p_" + string2 + ", int index )");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\tinsertMemberBusinessElementAtReference( m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", index );");
            } else {
                this.println("\tinsertMemberBusinessElementAt( m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", index );");
            }
        } else {
            this.println("\tinsertPrimalMemberAt( " + this.m_tigerDT.getCSharpTypeCode(string) + ", m_" + string2 + ", p_" + string2 + ", TAG_" + string2 + ", v_" + string2 + ", index );");
        }
        this.println("}");
    }

    public void removeAllElementsMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println();
        this.println("/// <summary>");
        this.println("/// Remove all " + string2 + ".");
        this.println("/// </summary>");
        this.println("public void removeAll" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.println("\tremoveAllMemberBusinessElement( m_" + string2 + ", v_" + string2 + " );");
        this.println("}");
    }

    public void removeElementAtMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Remove " + string2 + " from location.");
        this.println("/// </summary>");
        this.println("/// <param name=\"index\">index</param>");
        this.println("public void remove" + ClassGen.capitalise(string2) + "At(int index)");
        this.println("{");
        this.println("\tremoveMemberBusinessElementAt( m_" + string2 + ", v_" + string2 + ", index, \"v_" + string2 + "\" );");
        this.println("}");
    }

    public void removeElementMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (!TigerElement.isPrimalType(string)) {
            this.println();
            this.println("/// <summary>");
            this.println("/// Removes one " + string2 + ".");
            this.println("/// </summary>");
            this.println("/// <param name=\"p_" + string2 + "\">" + string2 + " to Remove (" + string3 + ")</param>");
            this.println("public bool remove" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
            this.println("{");
            this.println("\treturn removeMemberBusinessElement( m_" + string2 + ", p_" + string2 + ", v_" + string2 + ", \"v_" + string2 + "\" );");
            this.println("}");
        }
    }

    public void sizeMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Give number of " + string2 + " (" + string3 + ").");
        this.println("/// </summary>");
        this.println("public int size" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.println("\treturn sizeVectorElements( v_" + string2 + " );");
        this.println("}");
    }

    public void getArrayMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
    }

    public void setArrayMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
    }

    public void getMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Get value of " + string2 + " (" + string3 + ").");
        this.println("/// </summary>");
        this.println("/// <returns>" + string + "</returns>");
        this.println("public " + string + " get" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\tBusinessObject bo = getMemberElementReference( m_" + string2 + " );");
            } else {
                this.println("\tBusinessObject bo = getMemberElement( m_" + string2 + " );");
            }
            this.println("\tif (bo != null)");
            this.println("\t\treturn new " + string + "( bo );");
            this.println("\telse");
            this.println("\t\treturn null;");
        } else {
            this.println("\treturn (" + string + ") getPrimalMember( " + this.m_tigerDT.getCSharpTypeCode(string) + ", m_" + string2 + ", null, true );");
        }
        this.println("}");
    }

    public void hasMethod(String string, String string2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Checks if value for " + string + " (" + string2 + ") is set.");
        this.println("/// </summary>");
        this.println("public bool has" + ClassGen.capitalise(string) + "()");
        this.println("{");
        this.println("\treturn hasMember( m_" + string + " );");
        this.println("}");
    }

    public void setMethod(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Set value of " + string2 + " (" + string3 + ")");
        this.println("/// </summary>");
        this.println("/// <param name=\"p_" + string2 + "\">" + string2 + " (" + string3 + ")</param>");
        this.println("public void set" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
        this.println("{");
        if (!TigerElement.isPrimalType(string)) {
            if (bl) {
                this.println("\tsetMemberBusinessElementReference( m_" + string2 + ", p_" + string2 + " );");
            } else {
                this.println("\tsetMemberBusinessElement( m_" + string2 + ", p_" + string2 + " );");
            }
        } else {
            this.println("\tsetPrimalMember( " + this.m_tigerDT.getCSharpTypeCode(string) + ", m_" + string2 + ", p_" + string2 + ", TAG_" + string2 + ", true );");
        }
        this.println("}");
    }

    public void attributeGetMethod(String string, String string2, String string3) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Get value of " + string2 + " (" + string3 + ").");
        this.println("/// </summary>");
        this.println("/// <returns>" + string + "</returns>");
        this.println("public " + string + " get" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.println("\treturn (" + string + ") getPrimalMember( " + this.m_tigerDT.getCSharpTypeCode(string) + ", m_" + string2 + ", TAG_" + string2 + ", false );");
        this.println("}");
    }

    public void attributeHasMethod(String string, String string2, String string3) {
        this.println();
        this.println("/// <summary>");
        this.println("/// Checks if value for " + string2 + " (" + string3 + ") is set.");
        this.println("/// </summary>");
        this.println("public bool has" + ClassGen.capitalise(string2) + "()");
        this.println("{");
        this.println("   return hasAttribute( TAG_" + string2 + ");");
        this.println("}");
    }

    public void attributeSetMethod(String string, String string2, String string3) {
        this.println();
        this.println();
        this.println("/// <summary>");
        this.println("/// Set value of " + string2 + " (" + string3 + ").");
        this.println("/// </summary>");
        this.println("/// <param name=\"p_" + string2 + "\">" + string2 + " (" + string3 + ")</param>");
        this.println("public void set" + ClassGen.capitalise(string2) + "(" + string + " p_" + string2 + ")");
        this.println("{");
        this.println("\tsetPrimalMember( " + this.m_tigerDT.getCSharpTypeCode(string) + ", m_" + string2 + ", p_" + string2 + ", TAG_" + string2 + ", false );");
        this.println("}");
    }

    public void initializeRegistryMethod(Vector vector) {
    }

    public void validate(Vector vector) throws GeneratorException {
        Enumeration enumeration2 = vector.elements();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                Symbol symbol = (Symbol)enumeration2.nextElement();
                String string = symbol.getIdName();
                this.m_DotnetGen.checkValidIdentifier(string);
            }
        }
    }

    public void instanceInitializer(Vector vector) {
        Symbol symbol;
        Enumeration enumeration2 = vector.elements();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (enumeration2 != null) {
            this.println();
            while (enumeration2.hasMoreElements()) {
                symbol = (Symbol)enumeration2.nextElement();
                String string = symbol.getIdName();
                this.generateInternalComment();
                if (symbol.getElementDef() == null) {
                    this.println("private static string TAG_" + string + " = " + symbol.getBackendType() + "._TAG_NAME;");
                    continue;
                }
                this.println("private static string TAG_" + string + " = \"" + symbol.getTypeName() + "\";");
            }
        }
        if ((enumeration2 = vector.elements()) != null) {
            this.println();
            while (enumeration2.hasMoreElements()) {
                symbol = (Symbol)enumeration2.nextElement();
                this.generateInternalComment();
                this.println("private static int m_" + symbol.getIdName() + " = " + n++ + ";");
                if (symbol.isVector()) {
                    this.generateInternalComment();
                    this.println("private static int v_" + symbol.getIdName() + " = " + n2++ + ";");
                }
                if (TigerElement.isPrimalType(symbol.getBackendType())) continue;
                this.generateInternalComment();
                this.println("private static int c_" + symbol.getIdName() + " = " + n3++ + ";");
            }
        }
        this.staticInitializer(vector, n, n3, n2);
    }

    private void staticInitializer(Vector vector, int n, int n2, int n3) {
        Symbol symbol;
        this.m_symbolTable = (Vector)vector.clone();
        Enumeration enumeration2 = vector.elements();
        this.println();
        this.generateInternalComment();
        this.println("private static int s_memberCount = " + n + ";");
        this.generateInternalComment();
        this.println("private static int s_vectorCount = " + n3 + ";");
        this.generateInternalComment();
        this.println("private static int s_typeCount = " + n2 + ";");
        this.generateInternalComment();
        this.println("private static Type[] s_typeElements = new Type[s_typeCount];");
        this.println();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                symbol = (Symbol)enumeration2.nextElement();
                this.m_staticConstructor2.addElement("registerTagName( _TYPE_NAME, TAG_" + symbol.getIdName() + ", m_" + symbol.getIdName() + ", " + (symbol.isVector() ? "v_" + symbol.getIdName() : "-1") + ", " + (!TigerElement.isPrimalType(symbol.getBackendType()) ? "c_" + symbol.getIdName() : "-1") + ");");
            }
        }
        this.IncrementIndentation();
        enumeration2 = vector.elements();
        if (enumeration2 != null) {
            int n4 = 0;
            while (enumeration2.hasMoreElements()) {
                symbol = (Symbol)enumeration2.nextElement();
                if (TigerElement.isPrimalType(symbol.getBackendType())) continue;
                String string = symbol.getBackendType();
                if (string.equals(symbol.getIdName()) && !this.m_nameSpace.equals("")) {
                    string = this.m_nameSpace + "." + string;
                }
                this.m_staticConstructor1.addElement("s_typeElements[" + n4++ + "] = " + string + ".initializeClass();");
            }
        }
        this.DecrementIndentation();
    }

    public void finish() {
        this.println();
        this.generateInternalComment();
        this.println("public static Type initializeClass()");
        this.println("{");
        this.IncrementIndentation();
        this.println("return Type.GetType(_TYPE_NAME);");
        this.DecrementIndentation();
        this.println("}");
        this.println();
        this.println("/// <summary>");
        this.println("/// Static constructor to initialize static members");
        this.println("/// </summary>");
        this.println("static " + this.idName + "()");
        this.println("{");
        this.IncrementIndentation();
        this.printVector(this.m_staticConstructor1);
        this.println();
        this.println("setNames(Type.GetType( _TYPE_NAME ), new string[] { _TAG_NAME, \"" + this.idName + "\" } );");
        this.println("setDependencies(Type.GetType( _TYPE_NAME ), s_typeElements);");
        this.println();
        this.println("initializeTypeInfo( _TYPE_NAME, _TAG_NAME, s_memberCount, s_vectorCount, s_typeElements, " + this.readOnly + " );");
        this.printVector(this.m_staticConstructor2);
        this.DecrementIndentation();
        this.println("}");
        this.DecrementIndentation();
        this.println("}");
        if (!this.m_nameSpace.equals("")) {
            this.DecrementIndentation();
            this.println("}");
        }
        this.closeOutputFile();
    }

    public void abort() throws GeneratorException {
        this.closeOutputFile();
        this.m_DotnetGen.deleteFile();
    }
}

