/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger.dotnet;

import com.baan.b3.dom.Element;
import com.baan.b3impl.studio.about.StudioComponentInfo;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.Tiger;
import com.eibus.tools.tiger.dotnet.Keywords;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DotnetGen {
    private Element m_sourceElement;
    private Tiger m_frontend;
    private String m_fileName;

    public DotnetGen(Element element, Tiger tiger) {
        this.m_sourceElement = element;
        this.m_frontend = tiger;
        this.m_fileName = null;
    }

    public void GenerateHeader(ClassGen classGen) {
        StudioComponentInfo studioComponentInfo = new StudioComponentInfo();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
        Date date = new Date();
        int n = Calendar.getInstance().get(1);
        String string = simpleDateFormat.format(date);
        String string2 = studioComponentInfo.getVersion();
        String string3 = studioComponentInfo.getBuildNumber();
        String string4 = studioComponentInfo.getPatchLevel();
        String string5 = System.getProperty("com.eibus.tools.tiger.ClassGen.nodate", "false");
        if (string5.equals("true")) {
            string = "an unknown date";
            string2 = "xx";
            string3 = "xx";
            string4 = "xx";
        }
        classGen.println("/*");
        classGen.println("\tCopyright SSA Global Technologies, Inc. 2000-" + n + ".");
        classGen.println("\tAll rights reserved.");
        classGen.println();
        classGen.println("\tGenerated by Tiger " + string2 + " patchlevel " + string4);
        classGen.println("\ton " + string + ". Please DO NOT EDIT.");
        classGen.println();
        classGen.println("\tBuild number: " + string3);
        classGen.println("*/");
        classGen.println("");
    }

    public String getContentLicense() {
        String string = this.m_frontend.getContentLicense();
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    public String getNamespace() {
        String string = this.m_frontend.getNamespace();
        if (string.equals("")) {
            string = this.m_sourceElement.getAttribute("Namespace");
        }
        return string;
    }

    public PrintWriter openFile(String string) throws GeneratorException {
        Object object;
        if (this.m_frontend.getOutputDirectory() == null) {
            return null;
        }
        String string2 = this.getNamespace();
        String string3 = this.m_frontend.getOutputDirectory();
        if (string == null) {
            object = ClassGen.getIdName(this.m_sourceElement) + ".cs";
            this.m_fileName = string3 + File.separatorChar + (String)object;
        } else {
            object = string + ".cs";
            this.m_fileName = string3 + File.separatorChar + (String)object;
        }
        try {
            object = new File(this.m_fileName);
            ((File)object).delete();
        }
        catch (Exception exception) {
            throw new GeneratorException("Unable to delete old file '" + this.m_fileName + "': " + exception);
        }
        try {
            return new PrintWriter(new FileWriter(this.m_fileName));
        }
        catch (Exception exception) {
            throw new GeneratorException("Unable to open output file '" + this.m_fileName + "': " + exception);
        }
    }

    public void deleteFile() throws GeneratorException {
        if (this.m_fileName != null) {
            try {
                File file2 = new File(this.m_fileName);
                file2.delete();
            }
            catch (Exception exception) {
                throw new GeneratorException("Unable to delete file '" + this.m_fileName + "': " + exception);
            }
        }
    }

    public void checkValidIdentifier(String string) throws GeneratorException {
        boolean bl = true;
        if (string == null) {
            throw new GeneratorException("Internal error: checkValidIdentier() called with null parameter.");
        }
        if (string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            bl = false;
        } else {
            int n = 1;
            while (n < string.length()) {
                if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                    bl = false;
                }
                ++n;
            }
        }
        if (!bl) {
            throw new GeneratorException("\"" + string + "\" is not a valid Java identifier, change it into another one.");
        }
        Keywords.checkdotnetReservedWord(string);
    }

    public void checkValidClass(String string) throws GeneratorException {
        if (string == null) {
            throw new GeneratorException("Internal error: checkValidClass() called with null parameter.");
        }
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(n + 1) : string;
        this.checkValidIdentifier(string2);
    }
}

