/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger.baanc;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.IManager;
import com.eibus.tools.tiger.Tiger;
import com.eibus.tools.tiger.baanc.BaancGen;
import com.eibus.tools.tiger.baanc.TigerDataType;
import com.eibus.xml.util.DOMUtils;
import com.eibus.xml.util.ElementEnumeration;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class TigerManager
extends ClassGen
implements IManager {
    static final String XML_NODE = "xmlNode";
    static final String XML_DATE = "xmlDate";
    static final String XML_DATETIME = "xmlDateTime";
    static final String XML_BIN_BASE64 = "xmlBinBase64";
    static final String XML_NODE_PRIMAL = "xmlNodePrimal";
    String elementName;
    String typeName;
    String idName;
    BaancGen m_generator;
    String m_fileName;

    public TigerManager(Element element, Tiger tiger) throws GeneratorException {
        super(element, tiger);
        this.idName = ClassGen.getIdName(element);
        this.typeName = ClassGen.getTypeName(element);
        this.m_generator = new BaancGen(element, tiger);
        this.m_generator.checkValidIdentifier(this.idName);
        if (tiger.getOutputDirectory() != null) {
            this.m_fileName = tiger.getOutputDirectory() + "i" + this.m_generator.getNamespace() + this.idName + "0";
            try {
                this.setOutputFile(new PrintWriter(new FileWriter(this.m_fileName)));
            }
            catch (Exception exception) {
                this.closeOutputFile();
                throw new GeneratorException("Unable to open output file '" + this.m_fileName + "': " + exception);
            }
        } else {
            this.m_fileName = null;
            this.setOutputFile(null);
        }
    }

    public void initialize() {
        this.m_generator.GenerateHeader(this);
        this.println("#include <bic_tmboa>");
        this.println();
        this.println("function extern");
        this.println("long " + this.m_generator.getModulePrefix() + this.idName + ".Create()");
        this.println("{");
        this.IncrementIndentation();
        if (this.m_generator.getContentLicense() == null) {
            this.println("return (Manager.Create())");
        } else {
            this.println("long man");
            this.println("man = Manager.Create()");
            this.println("Manager.setContentLicense(man, \"" + this.m_generator.getContentLicense() + "\")");
            this.println("return (man)");
        }
        this.DecrementIndentation();
        this.println("}");
    }

    public void finish() {
        this.closeOutputFile();
    }

    public void abort() throws GeneratorException {
        this.closeOutputFile();
        if (this.m_fileName != null) {
            try {
                File file2 = new File(this.m_fileName);
                file2.delete();
            }
            catch (Exception exception) {
                throw new GeneratorException("Unable to delete file '" + this.m_fileName + "': " + exception);
            }
        }
    }

    public void generateQueryParameters(Element element) throws GeneratorException {
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            while (elementEnumeration.hasMoreElements()) {
                Element element2 = (Element)elementEnumeration.nextElement();
                ClassGen.checkAttributes(element2, null);
                String string = DOMUtils.getTextValue(element2).trim();
                this.m_generator.checkValidIdentifier(string);
                String string2 = element2.getAttribute("Scope");
                if (string2.equals("") || string2.equals("In") || string2.equals("InOut")) {
                    Element element3 = this.frontend.getElementDef(string);
                    this.println(",");
                    this.print("\t");
                    this.generateQueryParameter(element3, string);
                    continue;
                }
                if (string2.equals("Out")) continue;
                throw new GeneratorException("Illegal Scope=\"" + string2 + "\" in <QueryDef Type=\"" + this.typeName + "\">  in <Element>" + string + ". Legal scope values are: In/InOut/Out");
            }
        }
    }

    private void generateQueryParameter(Element element, String string) throws GeneratorException {
        String string2 = element != null ? ClassGen.getIdName(element) : string;
        String string3 = ClassGen.getDataType(element, string, new TigerDataType());
        String string4 = string3;
        if (string4.equals("string")) {
            string4 = "const string";
        }
        if (string4.equals(XML_BIN_BASE64)) {
            string4 = "const string";
        }
        if (string4.equals(XML_NODE_PRIMAL)) {
            string4 = "const xmlNode";
        }
        ClassGen.checkAttributes(element, null);
        if (string2.equals("")) {
            throw new GeneratorException("Invalid <Element> tag");
        }
        this.print(string4 + " a_" + string2);
    }

    private void generateAddQueryParameters(Element element, boolean bl, boolean bl2) throws GeneratorException {
        ElementEnumeration elementEnumeration = DOMUtils.findSiblings(element, "Element");
        if (elementEnumeration != null) {
            if (bl2) {
                this.println("if (createParameters = true) then");
                this.IncrementIndentation();
            }
            while (elementEnumeration.hasMoreElements()) {
                String string;
                Element element2 = (Element)elementEnumeration.nextElement();
                String string2 = DOMUtils.getTextValue(element2).trim();
                String string3 = element2.getAttribute("Scope");
                Element element3 = this.frontend.getElementDef(string2);
                String string4 = ClassGen.getDataType(element3, string2, new TigerDataType());
                if (string4.equals(XML_NODE_PRIMAL) && !string3.equals("Out")) {
                    string = element3 != null ? ClassGen.getIdName(element3) : string2;
                    this.println("string _a_" + string + "(1) based");
                    this.println("long r");
                    this.println("r = XMLNode.FromNodetoString(a_" + string + ", _a_" + string + ")");
                    this.generateAddQueryParameter(element3, string2, string3, bl, bl2);
                    continue;
                }
                if (string4.equals(XML_BIN_BASE64) && !string3.equals("Out")) {
                    string = element3 != null ? ClassGen.getIdName(element3) : string2;
                    this.println("string _a_" + string + "(1) based");
                    this.println("long r");
                    this.println("r = ByteArray.Base64StringFromByteArray(a_" + string + ", _a_" + string + ")");
                    this.generateAddQueryParameter(element3, string2, string3, bl, bl2);
                    continue;
                }
                this.generateAddQueryParameter(element3, string2, string3, bl, bl2);
            }
            if (bl2) {
                this.DecrementIndentation();
                this.println("endif");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateAddQueryParameter(Element element, String string, String string2, boolean bl, boolean bl2) throws GeneratorException {
        String string3 = element != null ? ClassGen.getIdName(element) : string;
        String string4 = element != null ? ClassGen.getTypeName(element) : string;
        String string5 = element != null ? ClassGen.getDCDType(element) : string;
        String string6 = element != null ? ClassGen.getRelatedColumn(element) : "";
        String string7 = element != null ? this.getLength(element) : "";
        String string8 = ClassGen.getDataType(element, string, new TigerDataType());
        String string9 = string8;
        if (string9.equals("string")) {
            string9 = "const string";
        }
        if (string3.equals("")) throw new GeneratorException("Invalid <Element> tag");
        String string10 = bl2 ? "\"\"" : (string8.equals(XML_DATETIME) ? "BusinessElement.utc2xmlDateTime(a_" + string3 + ")" : (string8.equals(XML_DATE) ? "BusinessElement.numdays2xmlDate(a_" + string3 + ")" : (string8.equals("string") ? "a_" + string3 : (string8.equals(XML_BIN_BASE64) || string8.equals(XML_NODE_PRIMAL) ? "_a_" + string3 : "str$(a_" + string3 + ")"))));
        if (bl) {
            if (!string2.equals("") && !string2.equals("In")) throw new GeneratorException("Illegal Scope=\"" + string2 + "\" for parameter '" + string3 + "' in BaanSQL <QueryDef>; Only Scope=\"In\" is allowed which is also the default.");
            if (string8.equals(XML_NODE)) {
                this.println("BaanSQLQuery.addParameter(query, a_" + string3 + ");");
                return;
            } else if (string6.equals("")) {
                this.println("BaanSQLQuery.addParameter(query, \"" + string4 + "\", " + string10 + ", \"" + string5 + "\", \"\")");
                return;
            } else {
                this.println("BaanSQLQuery.addParameter(query, \"" + string4 + "\", " + string10 + ", \"" + string5 + "\", \"" + string6 + "\")");
            }
            return;
        } else {
            String string11 = string7.equals("") ? "\"\"" : "\"" + string7 + "\"";
            if (string2.equals("Out")) {
                if (string8.equals(XML_NODE)) {
                    this.println("BaanDLLCall.addParameter(query, \"" + string4 + "\", \"" + string2.toLowerCase() + "\"" + ", \"\", \"elements\", \"\", \"\")");
                    return;
                } else {
                    this.println("BaanDLLCall.addParameter(query, \"" + string4 + "\", \"" + string2.toLowerCase() + "\"" + ", \"" + string5 + "\", \"\", " + string11 + ", \"\") ");
                }
                return;
            } else if (string8.equals(XML_NODE)) {
                this.println("BaanDLLCall.addParameterElement(query, a_" + string3 + ", \"" + string2.toLowerCase() + "\", \"\", \"elements\", \"\")");
                return;
            } else {
                this.println("BaanDLLCall.addParameter(query, \"" + string4 + "\", \"" + string2.toLowerCase() + "\", \"" + string5 + "\", \"\", " + string11 + ", " + string10 + ")");
            }
        }
    }

    private void generateBaanDLLCallSetMethod(Element element, String string) throws GeneratorException {
        String string2 = DOMUtils.getTextValue(element).trim();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Element element2 = this.frontend.getElementDef(string2);
        String string6 = element2 != null ? ClassGen.getIdName(element2) : string2;
        String string7 = element2 != null ? ClassGen.getTypeName(element2) : string2;
        String string8 = element2 != null ? ClassGen.getDCDType(element2) : string2;
        String string9 = ClassGen.getDataType(element2, string6, new TigerDataType());
        String string10 = element.getAttribute("Scope");
        if (!string10.equals("")) {
            if (string10.equals("Out")) {
                if (string9.equals(XML_NODE)) {
                    string4 = "elements";
                    string5 = string;
                } else {
                    string3 = string8;
                }
            } else {
                throw new GeneratorException("Only Scope=\"Out\" allowed for <Method> " + string2);
            }
        }
        if (string5.equals("")) {
            this.println("BaanDLLCall.setMethod(query, \"" + string2 + "\", \"" + string3 + "\", \"" + string4 + "\")");
        } else {
            this.println("BaanDLLCall.setMethod(query, \"" + string2 + "\", \"" + string3 + "\", \"" + string4 + "\", " + string5 + ")");
        }
    }

    public void queryMethodModel(String string, String string2, String string3, boolean bl, boolean bl2, Element element, String string4, Element element2, String string5, String string6, Element element3, boolean bl3, boolean bl4) throws GeneratorException {
        this.m_generator.checkValidIdentifier(string2);
        if (string5 != null) {
            this.m_generator.checkValidIdentifier(string5);
        }
        if (string.equals("BaanDLL") || string.equals("BaanSQL")) {
            this.queryMethod(string2, string3, bl, bl2, element, string4, element2, string5, string6, element3, bl3, bl4);
        } else {
            if (string.equals("QueryByDLL")) {
                this.println("");
                this.println("function extern");
                this.print("xmlNode " + this.m_generator.getModulePrefix() + string2 + "." + string2 + "(" + XML_NODE + " " + string2);
                this.generateQueryParameters(element);
                this.println(")");
                this.println("{");
                this.IncrementIndentation();
                if (bl) {
                    this.println("long result = Vector.create();");
                }
                this.println("long query");
                this.println("query = QueryByDLL.createQueryByDLL()");
                this.println("QueryByDLL.setDLL(query, \"" + string4 + "\")");
                this.generateBaanDLLCallSetMethod(element2, "\"\"");
                this.println("BaanSQLQuery.setId(query, \"" + string2 + "\")");
                this.generateAddQueryParameters(element, string3 != null, bl3);
                if (bl2) {
                    this.println("long iterator");
                    this.println("iterator = Iterator.Create(query, " + string2 + ", Manager.getPrimaryBackend(" + string2 + "), " + this.getInstanceOfName(string5) + ")");
                    this.println("return (iterator)");
                } else {
                    this.println("long dataset");
                    this.println("dataset = Manager.retrieveData(" + string2.toLowerCase() + ", query)");
                    this.println("long tuple");
                    this.println("tuple = dataset.getFirstTuple(dataset)");
                    this.println("long original");
                    this.println("while (tuple)");
                    this.IncrementIndentation();
                    this.println("original = tuple.getOriginal(tuple)");
                    this.println("if (BusinessElement.instanceof(original, " + this.getInstanceOfName(string5) + ") = True) then");
                    if (bl) {
                        this.println("\tVector.addElement(result,original);");
                    } else {
                        this.println("\treturn (original)");
                    }
                    this.println("endif");
                    this.println("tuple = tuple.getNextTuple(tuple)");
                    this.DecrementIndentation();
                    this.println("endwhile");
                    if (bl) {
                        this.println("return (result)");
                    } else {
                        this.println("return (0)");
                    }
                }
                this.DecrementIndentation();
                this.println("}");
            }
            this.println("");
            this.println("");
        }
    }

    public void queryMethod(String string, String string2, boolean bl, boolean bl2, Element element, String string3, Element element2, String string4, String string5, Element element3, boolean bl3, boolean bl4) throws GeneratorException {
        this.println();
        if (bl3) {
            this.println("function");
            this.println("xmlNode " + this.m_generator.getModulePrefix() + this.idName + "." + string + "_CreateConstructor(long createParameters)");
        } else {
            this.println("function extern");
            this.print("xmlNode " + this.m_generator.getModulePrefix() + this.idName + "." + string + "(" + XML_NODE + " " + this.idName);
            this.generateQueryParameters(element);
            this.println(")");
        }
        this.println("{");
        this.IncrementIndentation();
        if (!bl3 && bl) {
            this.println("long result = Vector.create();");
        }
        if (string3 != null) {
            this.println("long query");
            this.println("query = BaanDLLCall.createBaanDLLCall()");
            this.println("BaanDLLCall.setDLL(query, \"" + string3 + "\")");
            this.generateBaanDLLCallSetMethod(element2, this.getInstanceOfName(string4));
        }
        if (string2 != null) {
            if (bl3) {
                this.println("long query");
                this.println("query = BaanSQLQuery.createBaanSQLQuery()");
                int n = 180;
                if (string2.length() > n) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    while (n2 < string2.length()) {
                        if (n2 % n == n - 1) {
                            stringBuffer.append("\" &\n\t\"");
                        }
                        stringBuffer.append(string2.charAt(n2));
                        ++n2;
                    }
                    string2 = stringBuffer.toString();
                }
                this.println("BaanSQLQuery.setQueryText(query, \"" + string2 + "\")");
            } else {
                this.println("long query");
                this.println("query = " + this.m_generator.getModulePrefix() + this.idName + "." + string + "_CreateConstructor(false)");
            }
        }
        if (bl3) {
            this.println("BaanSQLQuery.setId(query, \"" + string + "\")");
        }
        this.generateAddQueryParameters(element, string2 != null, bl3);
        if (element3 != null && bl3) {
            this.generateLayout(element3, false, false, this.idName, null, null);
        }
        if (string2 != null && string2.indexOf(36) != -1) {
            if (bl3) {
                if (!bl4) {
                    throw new GeneratorException("Use of Client Side Query Paramenters ($param) not allowed in nested Query <QueryDef Type=\"" + this.idName + "\" Nested=\"True\">");
                }
            } else {
                this.println("BaanSQLquery.processClientSideParameters(query)");
            }
        }
        if (!bl3 && bl2) {
            this.println("long iterator");
            this.println("iterator = Iterator.Create(query, " + this.idName + ", Manager.getPrimaryBackend(" + this.idName + "), " + this.getInstanceOfName(string4) + ")");
            this.println("return (iterator)");
        } else if (!bl3) {
            this.println("long dataset");
            this.println("dataset = Manager.retrieveData(" + this.idName.toLowerCase() + ", query)");
            this.println("long tuple");
            this.println("tuple = dataset.getFirstTuple(dataset)");
            this.println("long original");
            this.println("while (tuple)");
            this.IncrementIndentation();
            this.println("original = tuple.getOriginal(tuple)");
            this.println("if (BusinessElement.instanceof(original, " + this.getInstanceOfName(string4) + ") = True) then");
            if (bl) {
                this.println("\tVector.addElement(result,original);");
            } else {
                this.println("\treturn (original)");
            }
            this.println("endif");
            this.println("tuple = tuple.getNextTuple(tuple)");
            this.DecrementIndentation();
            this.println("endwhile");
            if (bl) {
                this.println("return (result)");
            } else {
                this.println("return (0)");
            }
        } else {
            this.println("return (query)");
        }
        this.DecrementIndentation();
        this.println("}");
    }

    private String getInstanceOfName(String string) {
        boolean bl;
        Element element = this.frontend.getElementDef(string);
        String string2 = element != null ? ClassGen.getIdName(element) : string;
        String string3 = element != null ? ClassGen.getTypeName(element) : string;
        boolean bl2 = bl = element == null;
        if (bl) {
            return this.m_generator.getModulePrefix() + string2 + ".type()";
        }
        return "\"" + string3 + "\"";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateLayout(Element element, boolean bl, boolean bl2, String string, Hashtable hashtable, Hashtable hashtable2) throws GeneratorException {
        boolean bl3;
        String string2 = ClassGen.getIdName(element);
        String string3 = ClassGen.getTypeName(element);
        ClassGen.checkAttributes(element, null);
        if (hashtable == null) {
            hashtable = new Hashtable();
            hashtable2 = new Hashtable();
            hashtable.put(string, string);
            string = null;
            this.println("long layout");
            this.println("long rootLayout");
            this.println("layout = BaanSQLQuery.createLayout(query)");
            this.println("rootLayout = layout");
        } else {
            this.println("rootLayout = layout");
        }
        this.generateLayoutDetails(string2, string3, bl, bl2, string, hashtable);
        if (hashtable2.get(element) == null) {
            bl3 = true;
            hashtable2.put(element, element);
        } else {
            bl3 = false;
        }
        if (bl3) {
            Node node = element.getFirstChild();
            while (node != null) {
                short s = node.getNodeType();
                if (s == 1) {
                    Element element2 = (Element)node;
                    String string4 = element2.getTagName();
                    if (!string4.equals("Layout")) throw new GeneratorException("Illegal tag name '" + string4 + "' in <Layout> in <LayoutDef Type=\"" + string3 + "\">");
                    ClassGen.checkAttributes(element2, null);
                    String string5 = DOMUtils.getTextValue(element2).trim();
                    String string6 = element2.getAttribute("Reference");
                    if (!(string6.equals("True") || string6.equals("False") || string6.equals(""))) {
                        throw new GeneratorException("Illegal attribute: Reference=\"" + string6 + "\" in <Layout>" + string5 + "</Layout> in  <LayoutDef Type=\"" + string3 + "\">. Expected Reference=\"True\" or Reference=\"False\"");
                    }
                    Element element3 = this.frontend.getLayoutDef(string5);
                    if (element3 == null) {
                        throw new GeneratorException("Reference to unknown <Layout>" + string5 + "</Layout> in  <LayoutDef Type=\"" + string3 + "\">");
                    }
                    boolean bl4 = string6.equals("True");
                    boolean bl5 = !ClassGen.getRelatedColumn(element3).equals("");
                    String string7 = element2.getAttribute("Query").trim();
                    if (string7.equals("")) {
                        string7 = null;
                    }
                    this.println("{");
                    this.IncrementIndentation();
                    this.generateLayout(element3, bl4, bl5, string7, hashtable, hashtable2);
                    this.DecrementIndentation();
                    this.println("}");
                } else if (s != 3 && s != 8) {
                    throw new GeneratorException("Illegal element '" + node.getNodeName() + "'  <LayouttDef Type=\"" + string3 + "\">");
                }
                node = node.getNextSibling();
            }
        }
        this.println("layout = layout.getParentLayout(layout)");
    }

    public void generateLayoutDetails(String string, String string2, boolean bl, boolean bl2, String string3, Hashtable hashtable) throws GeneratorException {
        this.println("layout = layout.createLayout(rootLayout, \"" + string2 + "\")");
        if (bl) {
            this.println("layout.setReference(layout, true)");
        }
        if (bl2) {
            this.println("layout.setAlias(layout, true)");
        }
        if (string3 != null) {
            Element element = this.frontend.getQueryDef(string3);
            if (element == null) {
                throw new GeneratorException("Reference to unknown 'Query=" + string3 + "' in  <Layout>" + string + "</Layout>");
            }
            this.addCandidateQuery(element);
            this.println("layout.setConstructor(layout, \"#" + string3 + "\")");
            if (hashtable.get(string3) == null) {
                hashtable.put(string3, string3);
                this.println("BaanSQLQuery.appendConstructor(query, " + this.m_generator.getModulePrefix() + this.idName + "." + string3 + "_CreateConstructor(true))");
            }
        }
    }

    public void initializeRegistry(Hashtable hashtable, Vector vector) {
    }

    private void addCandidateQuery(Element element) throws GeneratorException {
        if (this.frontend.getQueryDef(element) == null) {
            this.frontend.putQueryDef(element);
        }
        String string = ClassGen.getIdName(element);
        this.frontend.setQueryDef(string, 1);
    }
}

