/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger.baanc;

import com.baan.b3.dom.Element;
import com.baan.b3impl.studio.about.StudioComponentInfo;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.Tiger;
import com.eibus.tools.tiger.baanc.Keywords;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class BaancGen {
    private Element m_sourceElement;
    private Tiger m_frontend;

    public BaancGen(Element element, Tiger tiger) {
        this.m_sourceElement = element;
        this.m_frontend = tiger;
    }

    public void GenerateHeader(ClassGen classGen) {
        StudioComponentInfo studioComponentInfo = new StudioComponentInfo();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
        Date date = new Date();
        int n = Calendar.getInstance().get(1);
        String string = simpleDateFormat.format(date);
        String string2 = studioComponentInfo.getVersion();
        String string3 = studioComponentInfo.getBuildNumber();
        String string4 = studioComponentInfo.getPatchLevel();
        String string5 = System.getProperty("com.eibus.tools.tiger.ClassGen.nodate", "false");
        if (string5.equals("true")) {
            string = "an unknown date";
            string2 = "xx";
            string3 = "xx";
            string4 = "xx";
        }
        classGen.println("|");
        classGen.println("|\tCopyright SSA Global Technologies, Inc. 2000-" + n + ".");
        classGen.println("|\tAll rights reserved.");
        classGen.println("|");
        classGen.println("|\tGenerated by Tiger " + string2 + " patchlevel " + string4);
        classGen.println("|\ton " + string + ". Please DO NOT EDIT.");
        classGen.println("|");
        classGen.println("|\tBuild number: " + string3);
        classGen.println("|");
        classGen.println("");
    }

    public String getNamespace() {
        String string = this.m_frontend.getNamespace();
        if (string.equals("")) {
            string = this.m_sourceElement.getAttribute("BaanModule");
        }
        return string;
    }

    public String getModulePrefix() {
        String string = this.getNamespace();
        if (string.equals("")) {
            return "";
        }
        return string + ".";
    }

    public String getContentLicense() {
        String string = this.m_frontend.getContentLicense();
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    public void checkValidIdentifier(String string) throws GeneratorException {
        boolean bl = true;
        if (string == null) {
            throw new GeneratorException("Internal error: checkValidIdentier() called with null parameter.");
        }
        if (string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            bl = false;
        } else {
            int n = 1;
            while (n < string.length()) {
                if (!Character.isJavaIdentifierPart(string.charAt(n)) && string.charAt(n) != '.') {
                    bl = false;
                }
                ++n;
            }
        }
        if (!bl) {
            throw new GeneratorException("\"" + string + "\" is not a valid Baan 3GL identifier, change it into another one.");
        }
        Keywords.checkBaanCReservedWord(string);
    }
}

