/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger;

import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseEvent;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.services.licensing.LicenseListener;
import com.eibus.tools.tiger.About;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.Tiger;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;

public class TigerDialog
extends JFrame
implements LicenseListener {
    private ILicense m_license;
    private static String sImageIcon = "/com/eibus/tools/tiger/icon16.gif";
    private static String sTigerImage = "/com/eibus/tools/tiger/tiger.gif";
    private static String BackendJava = "com.eibus.tools.tiger.java";
    private static String BackendNet = "com.eibus.tools.tiger.dotnet";
    private static String BackendBaan = "com.eibus.tools.tiger.baanc";
    private static String BackendCheck = "com.eibus.tools.tiger.analyze";
    private ButtonGroup m_radioGroup;
    private JButton ButtonAbout;
    private JButton ButtonBrowseDirectory;
    private JButton ButtonBrowseFiles;
    private JButton ButtonClose;
    private JButton ButtonGenerate;
    private JButton ButtonHelp;
    private JCheckBox CheckGroup;
    private JCheckBox CheckLicense;
    private JCheckBox CheckNoOutput;
    private JTextField EditFiles;
    private JTextField EditLicense;
    private JTextField EditOutput;
    private JTextField EditPackage;
    private JLabel PictureLabel;
    private JRadioButton RadioBaan;
    private JRadioButton RadioJava;
    private JRadioButton RadioNet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;

    public TigerDialog() {
        this.initComponents();
        try {
            ((Frame)this).setIconImage(new ImageIcon(this.getClass().getResource(sImageIcon)).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(sTigerImage));
            this.PictureLabel.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            this.PictureLabel.setIcon(imageIcon);
        }
        catch (Exception exception) {
            this.PictureLabel.setText("Error Loading image");
        }
        this.m_radioGroup = new ButtonGroup();
        this.RadioJava.setActionCommand(BackendJava);
        this.RadioNet.setActionCommand(BackendNet);
        this.RadioBaan.setActionCommand(BackendBaan);
        this.m_radioGroup.add(this.RadioJava);
        this.m_radioGroup.add(this.RadioNet);
        this.m_radioGroup.add(this.RadioBaan);
        this.RadioJava.setSelected(true);
        ((Component)this).setSize(508, 310);
    }

    private void setLicense(ILicense iLicense) {
        this.m_license = iLicense;
        this.m_license.addLicenseListener(this);
        this.ButtonGenerate.setEnabled(this.m_license.getDaysLeft() >= 0);
    }

    public void licenseChanged(LicenseEvent licenseEvent) {
        ILicense iLicense = licenseEvent.getLicense();
        String string = licenseEvent.getMessage();
        switch (licenseEvent.getReason()) {
            case 1: 
            case 4: {
                this.ButtonGenerate.setEnabled(false);
                JOptionPane.showMessageDialog(this, string, "License Error", 0);
                break;
            }
            case 2: {
                this.ButtonGenerate.setEnabled(true);
                JOptionPane.showMessageDialog(this, string, "License Information", 0);
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this, string, "License Warning", 2);
            }
        }
    }

    private void initComponents() {
        this.ButtonAbout = new JButton();
        this.ButtonHelp = new JButton();
        this.ButtonClose = new JButton();
        this.ButtonGenerate = new JButton();
        this.RadioJava = new JRadioButton();
        this.RadioBaan = new JRadioButton();
        this.RadioNet = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.EditFiles = new JTextField();
        this.EditOutput = new JTextField();
        this.EditPackage = new JTextField();
        this.jLabel5 = new JLabel();
        this.CheckGroup = new JCheckBox();
        this.CheckNoOutput = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.CheckLicense = new JCheckBox();
        this.EditLicense = new JTextField();
        this.ButtonBrowseFiles = new JButton();
        this.ButtonBrowseDirectory = new JButton();
        this.PictureLabel = new JLabel();
        this.getContentPane().setLayout(null);
        this.setTitle("BOI Compiler");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TigerDialog.this.exitForm(windowEvent);
            }
        });
        this.ButtonAbout.setFont(new Font("Dialog", 0, 12));
        this.ButtonAbout.setText("About");
        this.ButtonAbout.setBorder(new BevelBorder(0));
        this.ButtonAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TigerDialog.this.ButtonAboutActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonAbout);
        this.ButtonAbout.setBounds(180, 249, 70, 20);
        this.ButtonHelp.setFont(new Font("Dialog", 0, 12));
        this.ButtonHelp.setText("Help");
        this.ButtonHelp.setBorder(new BevelBorder(0));
        this.getContentPane().add(this.ButtonHelp);
        this.ButtonHelp.setBounds(420, 249, 70, 20);
        this.ButtonClose.setFont(new Font("Dialog", 0, 12));
        this.ButtonClose.setText("Close");
        this.ButtonClose.setBorder(new BevelBorder(0));
        this.ButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TigerDialog.this.ButtonCloseActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonClose);
        this.ButtonClose.setBounds(340, 249, 70, 20);
        this.ButtonGenerate.setFont(new Font("Dialog", 0, 12));
        this.ButtonGenerate.setText("Generate");
        this.ButtonGenerate.setBorder(new BevelBorder(0));
        this.ButtonGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TigerDialog.this.ButtonGenerateActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonGenerate);
        this.ButtonGenerate.setBounds(260, 249, 70, 20);
        this.RadioJava.setFont(new Font("Dialog", 0, 12));
        this.RadioJava.setText("Java");
        this.getContentPane().add(this.RadioJava);
        this.RadioJava.setBounds(140, 7, 104, 24);
        this.RadioBaan.setFont(new Font("Dialog", 0, 12));
        this.RadioBaan.setText("Baan 3GL");
        this.getContentPane().add(this.RadioBaan);
        this.RadioBaan.setBounds(140, 29, 104, 24);
        this.RadioNet.setFont(new Font("Dialog", 0, 12));
        this.RadioNet.setText(".NET (C#)");
        this.getContentPane().add(this.RadioNet);
        this.RadioNet.setBounds(140, 51, 104, 24);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Generate:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(10, 11, 120, 16);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setText("DCD/QCD File:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 91, 120, 16);
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        this.jLabel3.setText("Output Directory:");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(10, 161, 120, 16);
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        this.jLabel4.setText("Java Package Name:");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(10, 191, 120, 16);
        this.EditFiles.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.EditFiles);
        this.EditFiles.setBounds(140, 89, 320, 20);
        this.EditOutput.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.EditOutput);
        this.EditOutput.setBounds(140, 159, 320, 20);
        this.EditPackage.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.EditPackage);
        this.EditPackage.setBounds(140, 189, 320, 20);
        this.jLabel5.setFont(new Font("Dialog", 2, 12));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("TIGER Typesafe Interface Generator");
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(280, 1, 210, 16);
        this.CheckGroup.setFont(new Font("Dialog", 0, 12));
        this.CheckGroup.setText("Group DCD/QCD Files");
        this.getContentPane().add(this.CheckGroup);
        this.CheckGroup.setBounds(140, 109, 200, 24);
        this.CheckNoOutput.setFont(new Font("Dialog", 0, 12));
        this.CheckNoOutput.setText("Do not generate output files (only check QCD/DCD)");
        this.getContentPane().add(this.CheckNoOutput);
        this.CheckNoOutput.setBounds(140, 129, 350, 24);
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        this.jLabel6.setText("Product Id:");
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(290, 221, 120, 16);
        this.CheckLicense.setFont(new Font("Dialog", 0, 12));
        this.CheckLicense.setText("Content Licensing");
        this.getContentPane().add(this.CheckLicense);
        this.CheckLicense.setBounds(140, 216, 150, 24);
        this.EditLicense.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.EditLicense);
        this.EditLicense.setBounds(370, 219, 90, 20);
        this.ButtonBrowseFiles.setFont(new Font("Dialog", 0, 12));
        this.ButtonBrowseFiles.setText("...");
        this.ButtonBrowseFiles.setBorder(new BevelBorder(0));
        this.ButtonBrowseFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TigerDialog.this.ButtonBrowseFilesActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonBrowseFiles);
        this.ButtonBrowseFiles.setBounds(470, 89, 20, 20);
        this.ButtonBrowseDirectory.setFont(new Font("Dialog", 0, 12));
        this.ButtonBrowseDirectory.setText("...");
        this.ButtonBrowseDirectory.setBorder(new BevelBorder(0));
        this.ButtonBrowseDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TigerDialog.this.ButtonBrowseDirectoryActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonBrowseDirectory);
        this.ButtonBrowseDirectory.setBounds(470, 159, 20, 20);
        this.PictureLabel.setFont(new Font("Dialog", 0, 12));
        this.PictureLabel.setHorizontalAlignment(0);
        this.getContentPane().add(this.PictureLabel);
        this.PictureLabel.setBounds(310, 19, 150, 65);
    }

    private void ButtonCloseActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void ButtonAboutActionPerformed(ActionEvent actionEvent) {
        About about = new About((Frame)this, true, sTigerImage, this.m_license);
        about.show();
    }

    private void ButtonGenerateActionPerformed(ActionEvent actionEvent) {
        String string = "";
        String string2 = this.m_radioGroup.getSelection().getActionCommand();
        String string3 = "";
        if (this.CheckLicense.isSelected()) {
            string3 = this.EditLicense.getText();
            long l = 0L;
            try {
                l = Long.parseLong(string3.trim());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Product Id:\nValue cannot be alphanumeric or negative.\nOnly positive numeric values greater than zero are permitted.", "Input Error", 0);
                return;
            }
            if (l <= 0L) {
                JOptionPane.showMessageDialog(this, "Product Id:\nValue cannot be alphanumeric or negative.\nOnly positive numeric values greater than zero are permitted.", "Input Error", 0);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean bl = this.CheckGroup.isSelected();
            boolean bl2 = this.CheckNoOutput.isSelected();
            String string4 = bl2 ? null : this.EditOutput.getText();
            Tiger tiger = new Tiger(string2, string4, this.EditPackage.getText(), bl, 0, "", string3);
            StringTokenizer stringTokenizer = new StringTokenizer(this.EditFiles.getText(), ",;");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                tiger.parse(string);
                if (bl) continue;
                tiger.generate();
            }
            if (bl) {
                tiger.generate();
            }
        }
        catch (GeneratorException generatorException) {
            JOptionPane.showMessageDialog(this, generatorException.toString(), "Error in file: " + string, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception.toString(), "Error in file: " + string, 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void ButtonBrowseDirectoryActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.EditOutput.getText());
        jFileChooser.addChoosableFileFilter(new DirectoryFilter());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Select Directory");
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.EditOutput.setText(file2.getAbsolutePath());
        }
    }

    private String getFolder(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(92)) != -1) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private void ButtonBrowseFilesActionPerformed(ActionEvent actionEvent) {
        String string = this.getFolder(this.EditFiles.getText());
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.addChoosableFileFilter(new QcdDcdFilter());
        int n = jFileChooser.showDialog(this, "Select QCD/DCd file");
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            string = "";
            int n2 = 0;
            while (n2 < fileArray.length) {
                fileArray[n2].getAbsolutePath();
                string = string + fileArray[n2].getAbsolutePath();
                if (n2 < fileArray.length - 1) {
                    string = string + ";";
                }
                ++n2;
            }
            this.EditFiles.setText(string);
            if (this.EditOutput.getText().length() == 0) {
                this.EditOutput.setText(this.getFolder(string));
            }
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        ILicense iLicense;
        System.setProperty("swing.noxp", "true");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TigerDialog tigerDialog = new TigerDialog();
        try {
            iLicense = LicenseFactory.createStudioLicense();
        }
        catch (LicenseException licenseException) {
            JOptionPane.showMessageDialog(tigerDialog, "Request license failed: " + licenseException.getMessage(), "License Error", 0);
            return;
        }
        if (iLicense.getDaysLeft() < 0) {
            JOptionPane.showMessageDialog(tigerDialog, iLicense.getMessage() + "\rSome product features are disabled.", "License Error", 0);
        } else if (iLicense.getDaysLeft() < 14) {
            JOptionPane.showMessageDialog(tigerDialog, iLicense.getMessage(), "License Error", 2);
        }
        tigerDialog.setLicense(iLicense);
        tigerDialog.show();
        iLicense.release();
    }

    private class QcdDcdFilter
    extends FileFilter {
        public static final String QCD = "qcd";
        public static final String DCD = "qcd";

        private QcdDcdFilter() {
        }

        public boolean accept(File file2) {
            if (file2.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file2);
            return string != null && (string.equals("qcd") || string.equals("qcd"));
        }

        public String getExtension(File file2) {
            String string = null;
            String string2 = file2.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        public String getDescription() {
            return "Content Description files";
        }
    }

    private class DirectoryFilter
    extends FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file2) {
            return file2.isDirectory();
        }

        public String getDescription() {
            return "Directories";
        }
    }
}

