/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.xml.sax.SAXException;
import com.baan.b3.xml.sax.SAXParseException;
import com.baan.b3impl.studio.about.StudioComponentInfo;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.tools.cmdline.CommandLine;
import com.eibus.tools.tiger.ClassGen;
import com.eibus.tools.tiger.ElementParse;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.ManagerParse;
import com.eibus.tools.tiger.ParseXML;
import com.eibus.xml.dom.SAXDocument;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Tiger {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.tools.tiger", "Tiger");
    private Document m_dcdDocument;
    private String m_backendPackage;
    private String m_namespace;
    private String m_outputDirectory;
    private Hashtable m_elementDefs;
    private Hashtable m_attributeDefs;
    private Hashtable m_queryDefs;
    private Hashtable m_managerDefs;
    private Hashtable m_layoutDefs;
    private boolean m_group;
    private int m_domainProductId;
    private String m_domainName;
    private String m_contentLicense;
    public static final int ADDED = 0;
    public static final int CANDIDATE = 1;
    public static final int GENERATED = 2;
    public static Dictionary backends;
    static /* synthetic */ Class class$com$eibus$tools$tiger$Tiger;

    public Tiger(String string, String string2, String string3, boolean bl, int n, String string4, String string5) {
        this.m_backendPackage = string;
        this.m_namespace = string3;
        this.m_outputDirectory = string2;
        this.m_elementDefs = new Hashtable();
        this.m_attributeDefs = new Hashtable();
        this.m_queryDefs = new Hashtable();
        this.m_managerDefs = new Hashtable();
        this.m_layoutDefs = new Hashtable();
        this.m_group = bl;
        this.m_domainProductId = n;
        this.m_domainName = string4;
        this.m_contentLicense = string5;
    }

    public void parse(String string) throws GeneratorException {
        Object object;
        if (!this.m_group) {
            this.m_elementDefs = new Hashtable();
            this.m_attributeDefs = new Hashtable();
            this.m_queryDefs = new Hashtable();
            this.m_managerDefs = new Hashtable();
            this.m_layoutDefs = new Hashtable();
        }
        try {
            object = new BufferedInputStream(new FileInputStream(string));
            SAXDocument sAXDocument = new SAXDocument();
            sAXDocument.load((InputStream)object);
            this.m_dcdDocument = sAXDocument;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GeneratorException(fileNotFoundException.toString());
        }
        catch (SAXParseException sAXParseException) {
            String string2 = sAXParseException.toString() + " at line: " + sAXParseException.getLineNumber() + " col: " + sAXParseException.getColumnNumber();
            throw new GeneratorException(string2);
        }
        catch (SAXException sAXException) {
            throw new GeneratorException(sAXException.toString());
        }
        catch (Exception exception) {
            throw new GeneratorException(exception.toString());
        }
        if (this.m_dcdDocument != null) {
            object = new ParseXML(this.m_dcdDocument.getDocumentElement(), this);
            ((ParseXML)object).parse();
        }
    }

    public void generate() throws GeneratorException {
        Object object;
        Object object2;
        Enumeration enumeration2 = this.m_elementDefs.elements();
        while (enumeration2.hasMoreElements()) {
            object2 = (Element)enumeration2.nextElement();
            object = new ElementParse((Element)object2, this);
            ((ElementParse)object).generate();
        }
        object2 = this.m_managerDefs.elements();
        while (object2.hasMoreElements()) {
            object = (Element)object2.nextElement();
            ManagerParse managerParse = new ManagerParse((Element)object, this);
            managerParse.generate();
        }
    }

    public Element getElementDef(String string) {
        return (Element)this.m_elementDefs.get(string);
    }

    public Element getElementDef(Element element) {
        if (element != null) {
            return (Element)this.m_elementDefs.get(ClassGen.getIdName(element));
        }
        return null;
    }

    public void putElementDef(Element element) throws GeneratorException {
        if (element != null) {
            String string = ClassGen.getIdName(element);
            if (this.m_elementDefs.get(string) != null) {
                throw new GeneratorException("ElementDef '" + string + "' already exists");
            }
            this.m_elementDefs.put(string, element);
        }
    }

    public Element getAttributeDef(String string) {
        return (Element)this.m_attributeDefs.get(string);
    }

    public Element getAttributeDef(Element element) {
        if (element != null) {
            return (Element)this.m_attributeDefs.get(ClassGen.getIdName(element));
        }
        return null;
    }

    public void putAttributeDef(Element element) throws GeneratorException {
        if (element != null) {
            String string = ClassGen.getIdName(element);
            if (this.m_attributeDefs.get(string) != null) {
                throw new GeneratorException("AttributeDef '" + string + "' already exists");
            }
            this.m_attributeDefs.put(string, element);
        }
    }

    public void setQueryDef(String string, int n) {
        QueryDefEx queryDefEx = (QueryDefEx)this.m_queryDefs.get(string);
        if (n > queryDefEx.state) {
            queryDefEx.state = n;
            this.m_queryDefs.put(string, queryDefEx);
        }
    }

    public Element getQueryDef(String string) {
        QueryDefEx queryDefEx = (QueryDefEx)this.m_queryDefs.get(string);
        if (queryDefEx != null) {
            return queryDefEx.queryDef;
        }
        return null;
    }

    public void removeQueryDef(String string) {
        this.m_queryDefs.remove(string);
    }

    public Element nextQueryDef(int n) {
        Enumeration enumeration2 = this.m_queryDefs.elements();
        while (enumeration2.hasMoreElements()) {
            QueryDefEx queryDefEx = (QueryDefEx)enumeration2.nextElement();
            if (queryDefEx.state != n) continue;
            return queryDefEx.queryDef;
        }
        return null;
    }

    public Element getQueryDef(Element element) {
        if (element != null) {
            return this.getQueryDef(ClassGen.getIdName(element));
        }
        return null;
    }

    public void putQueryDef(Element element) throws GeneratorException {
        if (element != null) {
            String string = ClassGen.getIdName(element);
            if (this.m_queryDefs.get(string) != null) {
                throw new GeneratorException("QueryDef '" + string + "' already exists");
            }
            QueryDefEx queryDefEx = new QueryDefEx(element, 0);
            this.m_queryDefs.put(string, queryDefEx);
        }
    }

    public Element getManagerDef(String string) {
        return (Element)this.m_managerDefs.get(string);
    }

    public Element getManagerDef(Element element) {
        if (element != null) {
            return (Element)this.m_managerDefs.get(ClassGen.getIdName(element));
        }
        return null;
    }

    public void putManagerDef(Element element) throws GeneratorException {
        if (element != null) {
            String string = ClassGen.getIdName(element);
            if (this.m_managerDefs.get(string) != null) {
                throw new GeneratorException("ManagerDef '" + string + "' already exists");
            }
            this.m_managerDefs.put(string, element);
        }
    }

    public Element getLayoutDef(String string) {
        return (Element)this.m_layoutDefs.get(string);
    }

    public Element getLayoutDef(Element element) {
        if (element != null) {
            return (Element)this.m_layoutDefs.get(ClassGen.getIdName(element));
        }
        return null;
    }

    public void putLayoutDef(Element element) throws GeneratorException {
        if (element != null) {
            String string = ClassGen.getIdName(element);
            if (this.m_layoutDefs.get(string) != null) {
                throw new GeneratorException("LayoutDef '" + string + "' already exists");
            }
            this.m_layoutDefs.put(string, element);
        }
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getBackendPackage() {
        return this.m_backendPackage;
    }

    public String getOutputDirectory() {
        if (this.m_outputDirectory != null && !this.m_outputDirectory.endsWith(File.separator)) {
            this.m_outputDirectory = this.m_outputDirectory + File.separator;
        }
        return this.m_outputDirectory;
    }

    public String getDomainName() {
        return this.m_domainName;
    }

    public int getDomainProductId() {
        return this.m_domainProductId;
    }

    public String getContentLicense() {
        return this.m_contentLicense;
    }

    public static void main(String[] stringArray) {
        Vector vector;
        int n;
        System.out.println("Tiger - Typesafe Interface Generator");
        System.out.println(new StudioComponentInfo().getCopyrightMessage());
        System.out.println();
        ILicense iLicense = null;
        CommandLine commandLine = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        String[] stringArray2 = new String[]{"group"};
        String[] stringArray3 = new String[]{};
        String[] stringArray4 = new String[]{"backend", "source", "dest", "name", "contentLicense"};
        CommandLine.ParseResult parseResult = null;
        try {
            commandLine = new CommandLine(stringArray, stringArray2, stringArray3, stringArray4);
            parseResult = commandLine.parseResult();
            iLicense = LicenseFactory.createStudioLicense();
        }
        catch (CommandLine.ParseException parseException) {
            Tiger.Usage("invalid argument(s): " + parseException);
            System.exit(-1);
        }
        catch (LicenseException licenseException) {
            System.err.println("Request license failed: " + licenseException.getMessage());
            System.exit(-1);
        }
        if (iLicense.getDaysLeft() < 0) {
            System.err.println(iLicense.getMessage());
            System.exit(-1);
        }
        if (parseResult.hasOption(stringArray4[0])) {
            string = parseResult.getOptionArgument(stringArray4[0]);
        } else {
            Tiger.Usage("argument -backend is missing");
            iLicense.release();
            System.exit(-1);
        }
        if (parseResult.hasOption(stringArray4[1])) {
            string2 = parseResult.getOptionArgument(stringArray4[1]);
        }
        string3 = parseResult.hasOption(stringArray4[2]) ? parseResult.getOptionArgument(stringArray4[2]) : null;
        if (parseResult.hasOption(stringArray4[3])) {
            string4 = parseResult.getOptionArgument(stringArray4[3]);
        }
        if (parseResult.hasOption(stringArray2[0])) {
            bl = true;
        }
        if (parseResult.hasOption(stringArray4[4])) {
            string5 = parseResult.getOptionArgument(stringArray4[4]);
        }
        if ((n = (vector = parseResult.getParameters()).size() + (string2.equals("") ? 0 : 1)) == 0) {
            Tiger.Usage("no input files specified");
            iLicense.release();
            System.exit(-1);
        }
        String[] stringArray5 = new String[n];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray5[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        if (!string2.equals("")) {
            stringArray5[n2++] = string2;
        }
        try {
            Tiger tiger = new Tiger(string, string3, string4, bl, 0, "", string5);
            n2 = 0;
            while (n2 < stringArray5.length) {
                tiger.parse(stringArray5[n2]);
                if (!bl) {
                    tiger.generate();
                }
                ++n2;
            }
            if (bl) {
                tiger.generate();
            }
        }
        catch (GeneratorException generatorException) {
            System.err.println(generatorException.toString());
            iLicense.release();
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.toString());
            iLicense.release();
            System.exit(-1);
        }
        iLicense.release();
        System.exit(0);
    }

    private static void Usage(String string) {
        System.err.println("Tiger: " + string);
        System.err.println("Usage: java " + (class$com$eibus$tools$tiger$Tiger == null ? (class$com$eibus$tools$tiger$Tiger = Tiger.class$("com.eibus.tools.tiger.Tiger")) : class$com$eibus$tools$tiger$Tiger).getName() + " -backend <package name> [-source <file>] [-dest <directory>] [-group] [-contentLicense <product-id>] [-name <package, namespace or module name>] <files>");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_TIGER);
        backends = new Hashtable();
    }

    private class QueryDefEx {
        Element queryDef;
        int state;

        QueryDefEx(Element element, int n) {
            this.queryDef = element;
            this.state = n;
        }
    }
}

