/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.tiger;

import com.baan.b3.dom.Attr;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.NamedNodeMap;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.tools.tiger.GeneratorException;
import com.eibus.tools.tiger.IDataType;
import com.eibus.tools.tiger.Tiger;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class ClassGen {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.tools.tiger", "ClassGen");
    public static final String tDCD = "DCD";
    public static final String tQCD = "QCD";
    public static final String tELEMENT = "Element";
    public static final String tELEMENTDEF = "ElementDef";
    public static final String tATTRIBUTE = "Attribute";
    public static final String tATTRIBUTEDEF = "AttributeDef";
    public static final String tQUERY = "Query";
    public static final String tQUERYDEF = "QueryDef";
    public static final String tMANAGERDEF = "ManagerDef";
    public static final String tGROUP = "Group";
    public static final String tDLL = "DLL";
    public static final String tMETHOD = "Method";
    public static final String tQUERYTEXT = "QueryText";
    public static final String tPARAMETERS = "Parameters";
    public static final String tRETURN = "Return";
    public static final String tLAYOUT = "Layout";
    public static final String tLAYOUTDEF = "LayoutDef";
    public static final String COMMENT_INTERNAL = "-- Internal --";
    private static Object[][] attributeTable = new Object[][]{{"DCD"}, {"QCD"}, {"Element", "Scope", "Occurs", "Reference", "Description", "UMLPackage", "JavaPackage", "Namespace"}, {"ElementDef", "Type", "Id", "Model", "Root", "Datatype", "JavaPackage", "BaanModule", "Namespace", "UMLPackage", "RelatedColumn", "RelatedTable", "ReadOnly", "Mapping", "Description", "Length", "ImplType", "ImplPolicy"}, {"Attribute"}, {"AttributeDef", "Name", "Id", "Datatype", "Description", "ReadOnly"}, {"Query", "Description"}, {"QueryDef", "Type", "Id", "Language", "Description"}, {"ManagerDef", "Type", "Id", "JavaPackage", "BaanModule", "Namespace", "UMLPackage", "UMLClass", "Mapping", "Description"}, {"Group", "Occurs", "RDF:Order"}, {"DLL"}, {"Method", "Scope"}, {"QueryText"}, {"Parameters"}, {"Return"}, {"Layout", "Reference", "Query"}, {"LayoutDef", "Type", "Id", "RelatedTable", "RelatedColumn"}};
    protected Element sourceElement;
    protected Tiger frontend;
    private int indent;
    private PrintWriter outputFile;

    public ClassGen(Element element, Tiger tiger) {
        this.sourceElement = element;
        this.frontend = tiger;
    }

    public void println(String string) {
        if (this.outputFile != null) {
            int n = 0;
            while (n < this.indent) {
                this.outputFile.print("\t");
                ++n;
            }
            this.outputFile.println(string);
        }
    }

    public void println() {
        if (this.outputFile != null) {
            this.outputFile.println();
        }
    }

    public void print(String string) {
        if (this.outputFile != null) {
            this.outputFile.print(string);
        }
    }

    protected void setOutputFile(PrintWriter printWriter) {
        this.outputFile = printWriter;
    }

    protected void closeOutputFile() {
        if (this.outputFile != null) {
            this.outputFile.close();
        }
    }

    protected void removeOutputFile() {
        if (this.outputFile != null) {
            // empty if block
        }
    }

    protected void IncrementIndentation() {
        ++this.indent;
    }

    protected void DecrementIndentation() {
        --this.indent;
    }

    protected String getIndentation() {
        String string = "";
        int n = 0;
        while (n < this.indent) {
            string = string + "\t";
            ++n;
        }
        return string;
    }

    protected void printVector(Vector vector) {
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            this.println(string);
        }
    }

    protected void addLinesToVectorEnd(Vector vector, Vector vector2) {
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            Object e = enumeration2.nextElement();
            vector2.addElement(e);
        }
    }

    protected static StringBuffer capitalise(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return stringBuffer;
    }

    public static String getIdName(Element element) {
        if (element == null) {
            return "";
        }
        String string = element.getAttribute("Id");
        if (string.equals("")) {
            string = ClassGen.getTypeName(element);
        }
        return string;
    }

    public static String getTypeName(Element element) {
        if (element == null) {
            return "";
        }
        if (element.getTagName().equals(tATTRIBUTEDEF)) {
            return element.getAttribute("Name");
        }
        return element.getAttribute("Type");
    }

    public static String getModelName(Element element) {
        return element == null ? "" : element.getAttribute("Model");
    }

    public String getReadOnly(Element element) {
        return element == null ? "" : element.getAttribute("ReadOnly");
    }

    public String getLength(Element element) {
        return element == null ? "" : element.getAttribute("Length");
    }

    public static String getAttributeType(boolean bl) {
        if (bl) {
            return "Vector";
        }
        return tELEMENT;
    }

    public static String getDataType(Element element, String string, IDataType iDataType) {
        if (element == null) {
            return iDataType.getMappedElementType(string);
        }
        String string2 = ClassGen.getModelName(element);
        if (string2.equals("Elements")) {
            String string3 = ClassGen.getIdName(element);
            return iDataType.getMappedElementType(string3);
        }
        String string4 = element.getAttribute("Datatype");
        if (string4.equals("")) {
            string4 = "string";
        }
        return iDataType.getMappedPrimitiveDataType(string4);
    }

    public static String getDCDType(Element element) {
        String string = ClassGen.getModelName(element);
        if (string.equals("Elements")) {
            return ClassGen.getIdName(element);
        }
        String string2 = element.getAttribute("Datatype");
        if (string2.equals("")) {
            return "string";
        }
        return string2;
    }

    public static String getRelatedColumn(Element element) {
        String string = element.getAttribute("RelatedTable").trim();
        String string2 = element.getAttribute("RelatedColumn").trim();
        if (!string.equals("")) {
            return string + "." + string2;
        }
        return string2;
    }

    public static void checkAttributes(Element element, Element element2) throws GeneratorException {
        if (element != null) {
            String string = element.getTagName();
            int n = attributeTable.length;
            int n2 = 0;
            while (n2 < n) {
                if (attributeTable[n2][0].equals(string)) {
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n3 = 0;
                    while (n3 < namedNodeMap.getLength()) {
                        String string2;
                        Attr attr = (Attr)namedNodeMap.item(n3);
                        String string3 = attr.getName();
                        boolean bl = false;
                        int n4 = attributeTable[n2].length;
                        int n5 = 1;
                        while (n5 < n4) {
                            string2 = (String)attributeTable[n2][n5];
                            if (string3.equals(string2)) {
                                bl = true;
                                break;
                            }
                            ++n5;
                        }
                        if (!bl) {
                            string2 = element2 != null ? " in <" + element2.getTagName() + ">" : "";
                            throw new GeneratorException("Illegal attribute '" + string3 + "' in <" + string + ">" + string2);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    }
}

