/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.rtf;

public class Rtf {
    private static int COLOR = 100;
    public static int COLOR_BLACK = COLOR + 0;
    public static int COLOR_WHITE = COLOR + 1;
    public static int COLOR_RED = COLOR + 2;
    public static int COLOR_GREEN = COLOR + 3;
    public static int COLOR_BLUE = COLOR + 4;
    public static int COLOR_YELLOW = COLOR + 5;
    public static int COLOR_CYAN = COLOR + 6;
    public static int COLOR_MAGENTA = COLOR + 7;
    public static int COLOR_GRAY = COLOR + 8;
    private static String COLOR_DEF = "{\\colortbl\\red0\\green0\\blue0;\\red255\\green255\\blue255;\\red255\\green0\\blue0;\\red0\\green255\\blue0;\\red0\\green0\\blue255;\\red240\\green240\\blue0;\\red0\\green240\\blue240;\\red240\\green0\\blue240;\\red120\\green120\\blue120;}";
    private static int FONT = 200;
    public static int FONT_MS_SANS_SERIF = FONT + 0;
    public static int FONT_TIMES_NEW_ROMAN = FONT + 1;
    public static int FONT_ARIAL = FONT + 2;
    public static int FONT_ARIAL_NARROW = FONT + 3;
    private static String FONT_MS_SANS_SERIF_S = "{\\f0\\fswiss MS Sans Serif;}";
    private static String FONT_TIMES_NEW_ROMAN_S = "{\\f1\\froman Times New Roman;}";
    private static String FONT_ARIAL_S = "{\\f2\\fswiss\\fprq2\\fcharset238 Arial;}";
    private static String FONT_ARIAL_NARROW_S = "{\\f3\\fswiss\\fprq2\\fcharset238 Arial Narrow;}";
    private static String FONT_DEF = "{\\fonttbl" + FONT_MS_SANS_SERIF_S + FONT_TIMES_NEW_ROMAN_S + FONT_ARIAL_S + FONT_ARIAL_NARROW_S + "}";
    private static String C_NEWLINE = "\\par ";
    private static String C_TAB = "\\tab ";
    private static String C_BULLET = "\\pard\\li500\\fi-400{\\pn\\pnlvlblt\\pnindent360{\\pntxtb\\'b7}}";
    private static String C_NUMBER = "\\pard\\li500\\fi-400 ";
    private static String C_PLAIN = "\\plain ";
    private static String C_BOLD = "\\b ";
    private static String C_ITALIC = "\\i ";
    private static String C_LEFT_ALIGNED = "\\ql ";
    private static String C_CENTERED = "\\qc ";
    private static String RTF_START = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deftab720";
    private static String RTF_END = "}";
    StringBuffer m_buffer = new StringBuffer(5000);
    StringBuffer DefaultSettings = new StringBuffer(200);
    int m_listNumber = 1;

    public Rtf(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.m_buffer.append(RTF_START);
        this.m_buffer.append(FONT_DEF);
        this.m_buffer.append(COLOR_DEF);
        this.DefaultSettings.append("\\pard");
        if (n >= 0) {
            this.DefaultSettings.append("\\f" + (n - FONT) + " ");
        }
        if (n2 >= 0) {
            this.DefaultSettings.append("\\fs" + n2 + " ");
        }
        if (n3 >= 0) {
            this.DefaultSettings.append("\\cf" + (n3 - COLOR) + " ");
        }
        if (bl) {
            this.DefaultSettings.append(C_BOLD);
        }
        if (bl2) {
            this.DefaultSettings.append(C_ITALIC);
        }
        this.m_buffer.append((Object)this.DefaultSettings);
    }

    public void setFontSize(int n) {
        this.m_buffer.append("\\fs" + n + " ");
    }

    public void addText(String string) {
        this.m_buffer.append(string);
    }

    public void addTextNewLine(String string) {
        this.addText(string + C_NEWLINE);
    }

    public void addTextNewLineCentered(String string) {
        this.addText(C_CENTERED + string + C_NEWLINE + C_LEFT_ALIGNED);
    }

    public void addPropertyValue(String string, String string2) {
        this.addText(string + ":" + C_TAB + string2 + C_NEWLINE);
    }

    public void addBulletListItem(String string) {
        this.addText(C_BULLET + "\\tx2160 " + string + C_NEWLINE);
    }

    public void addBulletListItem(String string, String string2) {
        this.addBulletListItem(string + C_TAB + string2);
    }

    public void addNumberListItem(String string) {
        this.addText(C_NUMBER + "\\tx2160 " + this.m_listNumber + C_TAB + string + C_NEWLINE);
        ++this.m_listNumber;
    }

    public void addNumberListItem(String string, String string2) {
        this.addNumberListItem(string + C_TAB + string2);
    }

    public void setFontColor(int n) {
        this.m_buffer.append("\\cf" + (n - COLOR) + " ");
    }

    public void setFont(int n) {
        this.m_buffer.append("\\f" + (n - FONT) + " ");
    }

    public void setBold() {
        this.m_buffer.append(C_BOLD);
    }

    public void setPlain() {
        this.m_buffer.append(C_PLAIN);
        this.m_buffer.append((Object)this.DefaultSettings);
        this.m_listNumber = 1;
    }

    public void setItalic() {
        this.m_buffer.append(C_ITALIC);
    }

    public void setIndent(int n, int n2) {
        this.m_buffer.append("\\pard\\li" + n2 + "\\fi" + (n - n2));
    }

    public void setIndent(int n) {
        this.setIndent(0, n);
    }

    public String getRtf() {
        this.m_buffer.append(RTF_END);
        return this.m_buffer.toString();
    }
}

